<!DOCTYPE html>
<html lang="en" dir="<?php echo e(env('SITE_RTL') == 'on' ? 'rtl' : ''); ?>">
<?php
$userstore = \App\Models\UserStore::where('store_id', $store->id)->first();
$setting = \DB::table('settings')
->where('name', 'company_favicon')
->where('created_by', $store->id)
->first();
$settings = Utility::settings();
$getStoreThemeSetting = Utility::getStoreThemeSetting($store->id, $store->theme_dir);
$getStoreThemeSetting1 = [];

if (!empty($getStoreThemeSetting['dashboard'])) {
$getStoreThemeSetting = json_decode($getStoreThemeSetting['dashboard'], true);
$getStoreThemeSetting1 = Utility::getStoreThemeSetting($store->id, $store->theme_dir);
}

if (empty($getStoreThemeSetting)) {
$path = storage_path() . '/uploads/' . $store->theme_dir . '/' . $store->theme_dir . '.json';
$getStoreThemeSetting = json_decode(file_get_contents($path), true);
}



// store RTL

$data = DB::table('settings');

$data = $data
->where('created_by', '>', 1)
->where('store_id', $store->id)
->where('name', 'SITE_RTL')
->first();

$imgpath=\App\Models\Utility::get_file('uploads/');
$s_logo = \App\Models\Utility::get_file('uploads/store_logo/');

$parts = collect($getStoreThemeSetting);
$logo = $parts->where('section_name','Home-Brand-Logo')->first();

?>

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="<?php echo e(ucfirst(env('APP_NAME'))); ?> - <?php echo e(ucfirst($store->tagline)); ?>">
    <meta name="keywords" content="<?php echo e($store->metakeyword); ?>">
    <meta name="description" content="<?php echo e($store->metadesc); ?>">

    <title><?php echo $__env->yieldContent('page-title'); ?> - <?php echo e($store->tagline ? $store->tagline : config('APP_NAME', ucfirst($store->name))); ?>

    </title>
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <link rel="icon" href="<?php echo e(asset(Storage::url('uploads/logo/') . (!empty($setting->value) ? $setting->value : 'favicon.png'))); ?>"type="image/png">


    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/theme/vendor/slick/slick.min.css')); ?>" />
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/theme/vendor/slick/slick-theme.min.css')); ?>" />
    <link href="<?php echo e(asset('assets/theme/vendor/icons/icofont.min.css')); ?>" rel="stylesheet" type="text/css">
    <link href="<?php echo e(asset('assets/theme/vendor/bootstrap/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/theme/vendor/sidebar/demo.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('assets/theme/css/' . (!empty($store->store_theme) ? $store->store_theme : 'green-color.css'))); ?>">


    <link rel="stylesheet" href="<?php echo e(asset('custom/css/custom.css')); ?>">
    <?php if(isset($data->value) && $data->value == 'on'): ?>
    <link rel="stylesheet" href="<?php echo e(asset('css/bootstrap-rtl.css')); ?>">
    <?php endif; ?>

    <?php echo $__env->yieldPushContent('css-page'); ?>
</head>

<body class="fixed-bottom-padding">
    <?php
    if (!empty(session()->get('lang'))) {
    $currantLang = session()->get('lang');
    } else {
    $currantLang = $store->lang;
    }

    $languages = \App\Models\Utility::languages();

    $storethemesetting = \App\Models\Utility::demoStoreThemeSetting($store->id, $store->theme_dir);

    ?>
<div class="border-bottom p-3 d-none mobile-nav">
    <div class="title d-flex align-items-center">
        <a href="<?php echo e(url('/')); ?>" class="text-decoration-none text-dark d-flex align-items-center">
            <?php if(isset($logo['inner-list'])): ?>
            <img class="osahan-logo mr-2" src="<?php echo e(Utility::get_file('uploads/'.$logo['inner-list'][0]['field_default_text'])); ?>">
            <?php else: ?>
            <img class="osahan-logo mr-2" src="<?php echo e($s_logo . (!empty($store->logo) ? $store->logo : 'logo.png')); ?>">
            <?php endif; ?>
        </a>
        <p class="ml-auto m-0">
            <a href="<?php echo e(route('store.cart', $store->slug)); ?>"
                class="ml-2 text-dark bg-light rounded-pill p-2 icofont-size border shadow-sm">
                <i class="icofont-shopping-cart"></i>
                <span class="count shoping_counts"
                    id="shoping_counts"><?php echo e(!empty($total_item) ? $total_item : '0'); ?></span>
            </a>
        </p>
        <a class="toggle ml-3 " href="#" style="font-size: 24px">
            <i class="icofont-navigation-menu text-dark"></i>
        </a>
    </div>

    <a href="javascript:;" class="text-decoration-none">
        <form action="<?php echo e(url('store.categorie.product')); ?>" method="GET">
            <div class="input-group mt-3 rounded shadow-sm overflow-hidden bg-white">
                <div class="input-group-prepend">
                    <button type="submit" class="border-0 btn btn-outline-secondary text-success bg-white"><i
                            class="icofont-search"></i></button>
                </div>
                <input type="text" class="shadow-none border-0 form-control pl-0" placeholder="Search for Products.."
                    aria-label="" aria-describedby="basic-addon1" name="search_data">
            </div>
        </form>
    </a>
</div>

 <div class="theme-switch-wrapper">
    <label class="theme-switch" for="checkbox">
       <input type="checkbox" id="checkbox" />
       <div class="slider round"></div>
       <i class="icofont-moon"></i>
    </label>
    <em>Enable Dark Mode!</em>
 </div>

 <div class="bg-white shadow-sm osahan-main-nav">
    <nav class="navbar navbar-expand-lg navbar-light bg-white osahan-header py-0 container">
        <a class="navbar-brand mr-0" href="<?php echo e(url('/')); ?>">
                <?php if(isset($logo['inner-list'])): ?>
                <img class="img-fluid logo-img border shadow-sm" src="<?php echo e(Utility::get_file('uploads/'.$logo['inner-list'][0]['field_default_text'])); ?>">
                <?php else: ?>
                <img class="img-fluid logo-img border shadow-sm" src="<?php echo e($s_logo . (!empty($store->logo) ? $store->logo : 'logo.png')); ?>">
                <?php endif; ?>
        </a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent"
            aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="ml-3 d-flex align-items-center justify-content-center" style="width: 100%">

            <form action="<?php echo e(route('store.categorie.product',[$store->slug,'Start shopping'])); ?>" method="GET" class="col-lg-8">
                <div class="input-group mr-sm-2 ">
                    <input type="text" class="form-control" id="inlineFormInputGroupUsername2"
                        placeholder="Search for Products.." name="search_data">
                    <div class="input-group-prepend">
                        <button class="btn btn-success rounded-right"><i class="icofont-search"></i></button>
                    </div>
                </div>
            </form>
        </div>
        <div class="ml-auto d-flex align-items-center">

            <?php if(Utility::CustomerAuthCheck($store->slug) == true): ?>
            <div class="dropdown mr-5">
                <a href="#" class="dropdown-toggle text-dark" id="dropdownMenuButton" data-toggle="dropdown"
                    aria-haspopup="true" aria-expanded="false">

                    <img src="<?php echo e(Utility::get_file('uploads/customerprofile/'.Auth::guard('customers')->user()->avatar)); ?>" class="img-fluid rounded-circle header-user mr-2">
                     Hi <?php echo e(ucFirst(Auth::guard('customers')->user()->name)); ?>

                </a>
                <div class="dropdown-menu dropdown-menu-right top-profile-drop" aria-labelledby="dropdownMenuButton">
                    <a class="dropdown-item" href="<?php echo e(route('customer.profile', [$store->slug, \Illuminate\Support\Facades\Crypt::encrypt(Auth::guard('customers')->user()->id)])); ?>">My Account</a>
                    <a class="dropdown-item" href="<?php echo e(route('customer.home', $store->slug)); ?>">My Orders</a>
                    <a class="dropdown-item" href="#"  onclick="event.preventDefault(); document.getElementById('customer-frm-logout').submit();">Logout</a>

                    <form id="customer-frm-logout"
                        action="<?php echo e(route('customer.logout', $store->slug)); ?>"
                        method="POST" class="d-none">
                            <?php echo e(csrf_field()); ?>

                    </form>
                </div>
            </div>
            <?php else: ?>
            <a href="#" data-toggle="modal" data-target="#login"
                class="mr-2 text-dark bg-light rounded-pill p-2 icofont-size border shadow-sm">
                <i class="icofont-login"></i>
            </a>
            <?php endif; ?>

            <a href="<?php echo e(route('store.cart',$store->slug)); ?>" class="ml-2 text-dark bg-light rounded-pill p-2 icofont-size border shadow-sm">
                <i class="icofont-shopping-cart"></i>
                <span class="count shoping_counts" id="shoping_counts"><?php echo e(!empty($total_item) ? $total_item : '0'); ?></span>
            </a>
        </div>
    </nav>
    <div class="bg-color-head">
        <div class="container menu-bar d-flex align-items-center justify-content-center">
            <ul class="list-unstyled form-inline mb-0">
                <li class="nav-item active">
                    <a class="nav-link text-white pl-0" href="<?php echo e(url('store/'.$store->slug)); ?>">Home <span
                            class="sr-only">(current)</span></a>
                </li>
                <li class="nav-item active">
                    <a class="nav-link text-white pl-0" href="<?php echo e(route('store.categorie.product',[$store->slug,'Start%20shopping'])); ?>">Products </a>
                </li>
                <?php if(!empty($page_slug_urls)): ?>
                        <?php $__currentLoopData = $page_slug_urls; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $page_slug_url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($page_slug_url->enable_page_header == 'on'): ?>
                            <li class="nav-item">
                                <a class="nav-link text-white pl-0" href="<?php echo e(url('/') . '/page/' . $page_slug_url->slug); ?>"><?php echo e(ucfirst($page_slug_url->name)); ?></a>
                            </li>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php endif; ?>
            </ul>

        </div>
    </div>
</div>
<nav id="main-nav">
    <ul class="second-nav">

        <li><a class="dropdown-item" href="<?php echo e(url('store/'.$store->slug)); ?>">Home</a></li>
        <li><a class="dropdown-item" href="<?php echo e(route('store.categorie.product',[$store->slug,'Start%20shopping'])); ?>">Products</a></li>
        <?php if(!empty($page_slug_urls)): ?>
        <?php $__currentLoopData = $page_slug_urls; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $page_slug_url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if($page_slug_url->enable_page_header == 'on'): ?>
            <li><a class="dropdown-item" href="<?php echo e(url('/') . '/page/' . $page_slug_url->slug); ?>"><?php echo e(ucfirst($page_slug_url->name)); ?></a></li>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
    </ul>

</nav>

        <?php echo $__env->yieldContent('content'); ?>

    <footer class="section-footer border-top bg-white">
        <?php
            $footer1  = $parts->where('section_name','Home-Email-Subscriber')->first();
            // dd($footer1);
            $SubscribeButton_key = array_search('Subscribe Button Text', array_column($footer1['inner-list'], 'field_name'));
            $SubscribeButton = $footer1['inner-list'][$SubscribeButton_key]['field_default_text'];
        ?>
        <?php if(count($footer1) > 0  && $footer1['section_enable'] == 'on'): ?>
        <section class="footer-top py-4">
           <div class="container">
              <div class="row">
                 <div class="col-md-4">
                    <div class="form-inline">
                        <div class="dropdown">
                            <button class="btn btn-secondary dropdown-toggle" type="button" id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <?php echo e(Str::upper($currantLang)); ?>

                            </button>
                            <div class="dropdown-menu" aria-labelledby="dropdownMenuButton" style="max-height: 372px;
                            overflow: auto;">
                                <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a class="dropdown-item " href="<?php echo e(route('change.languagestore', [$store->slug, $language])); ?>"><?php echo e(Str::upper($language)); ?></a>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                          </div>
                    </div>
                 </div>
                 <div class="col-md-4">
                    <?php echo e(Form::open(['route' => ['subscriptions.store_email', $store->id], 'method' => 'POST'])); ?>

                       <div class="input-group">
                          <input type="text" placeholder="Email" class="form-control" name="email">
                          <span class="input-group-append">
                          <button type="submit" class="btn btn-success"> <?php echo e($SubscribeButton); ?></button>
                          </span>
                       </div>
                    <?php echo e(Form::close()); ?>

                 </div>
                 <div class="col-md-4 text-md-right">
                    <?php
                        $footer2  = $parts->where('section_name','Home-Email-Subscriber')->toArray();
                        $icons = $footer2[6]['homepage-footer-2-social-icon'];
                        $links = $footer2[6]['homepage-footer-2-social-link'];
                    ?>
                    <?php $__currentLoopData = $links; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $l): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a href="<?php echo e($l); ?>" class="btn btn-icon btn-light"><?php echo $icons[$key]; ?></a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                 </div>
              </div>
           </div>
        </section>
        <?php endif; ?>
        <section class="footer-main border-top pt-5 pb-4">
           <div class="container">
              <div class="row">
                 <aside class="col-md">
                    <h6 class="title">Products</h6>
                    <ul class="list-unstyled list-padding">
                       <li> <a href="listing.html" class="text-dark">Listing</a></li>
                       <li> <a href="product_details.html" class="text-dark">Detail</a></li>
                       <li> <a href="picks_today.html" class="text-dark">Trending</a></li>
                       <li> <a href="recommend.html" class="text-dark">Recommended</a></li>
                       <li> <a href="fresh_vegan.html" class="text-dark">Most Popular</a></li>
                    </ul>
                 </aside>
                 <aside class="col-md">
                    <h6 class="title">Checkout Process</h6>
                    <ul class="list-unstyled list-padding">
                       <li> <a href="cart.html" class="text-dark">Cart</a></li>
                       <li> <a href="cart.html" class="text-dark">Order Address</a></li>
                       <li> <a href="cart.html" class="text-dark">Delivery Time</a></li>
                       <li> <a href="cart.html" class="text-dark">Order Payment</a></li>
                       <li> <a href="checkout.html" class="text-dark">Checkout</a></li>
                       <li> <a href="successful.html" class="text-dark">Successful</a></li>
                    </ul>
                 </aside>
                 <aside class="col-md">
                    <h6 class="title">My Order</h6>
                    <ul class="list-unstyled list-padding">
                       <li> <a href="my_order.html" class="text-dark">My order</a></li>
                       <li> <a href="status_complete.html" class="text-dark">Status Complete</a></li>
                       <li> <a href="status_onprocess.html" class="text-dark">Status on Process</a></li>
                       <li> <a href="status_canceled.html" class="text-dark">Status Canceled</a></li>
                       <li> <a href="review.html" class="text-dark">Review</a></li>
                    </ul>
                 </aside>
                 <aside class="col-md">
                    <h6 class="title">My Account</h6>
                    <ul class="list-unstyled list-padding">
                       <li> <a class="text-dark" href="my_account.html"> My account</a></li>
                       <li> <a class="text-dark" href="promos.html"> Promos</a></li>
                       <li> <a class="text-dark" href="my_address.html"> My address</a></li>
                       <li> <a class="text-dark" href="terms_conditions.html"> Terms &amp; conditions</a></li>
                       <li> <a class="text-dark" href="help_support.html"> Help &amp; support</a></li>
                       <li> <a class="text-dark" href="help_ticket.html"> Help ticket</a></li>
                       <li> <a class="text-dark" href="signin.html"> Logout</a></li>
                    </ul>
                 </aside>
                 <aside class="col-md">
                    <h6 class="title">Extra Pages</h6>
                    <ul class="list-unstyled list-padding">
                       <li><a href="promo_details.html" class="text-dark"> Promo Details </a></li>
                       <li><a href="terms_conditions.html" class="text-dark"> Conditions </a></li>
                       <li><a href="help_support.html" class="text-dark"> Help Support </a></li>
                       <li><a href="refund_payment.html" class="text-dark"> Refund Payment </a></li>
                       <li><a href="faq.html" class="text-dark"> FAQ </a></li>
                       <li><a href="signin.html" class="text-dark"> Sign In </a></li>
                    </ul>
                 </aside>
              </div>
           </div>
        </section>
        <section class="footer-bottom border-top py-4">
            <?php
                 $footer2  = $parts->where('section_name','Home-Footer-2')->first();
            ?>
           <div class="container">
              <div class="row">
                 <div class="col-md-6">
                    <span class="pr-2"><?php echo e($footer2['inner-list'][0]['field_default_text']); ?></span>
                 </div>
              </div>
           </div>
        </section>
     </footer>


    <div class="modal fade" id="commonModal" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header align-items-center">
                    <div class="modal-title">
                        <h6 class="mb-0" id="modelCommanModelLabel"></h6>
                    </div>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade right-modal" id="login" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
           <div class="modal-content">
              <div class="modal-header p-0">
                 <nav class="schedule w-100">
                    <div class="nav nav-tabs" id="nav-tab" role="tablist">
                       <a class="nav-link active col-5 py-4" id="nav-home-tab" data-toggle="tab" href="#nav-home" role="tab" aria-controls="nav-home" aria-selected="true">
                          <p class="mb-0 font-weight-bold">Sign in</p>
                       </a>
                       <a class="nav-link col-5 py-4" id="nav-profile-tab" data-toggle="tab" href="#nav-profile" role="tab" aria-controls="nav-profile" aria-selected="false">
                          <p class="mb-0 font-weight-bold">Sign up</p>
                       </a>
                       <a class="nav-link col-2 p-0 d-flex align-items-center justify-content-center" data-dismiss="modal" aria-label="Close">
                          <h1 class="m-0 h4 text-dark"><i class="icofont-close-line"></i></h1>
                       </a>
                    </div>
                 </nav>
              </div>
              <div class="modal-body p-0">
                <div class="tab-content" id="nav-tabContent">
                   <div class="tab-pane fade show active" id="nav-home" role="tabpanel" aria-labelledby="nav-home-tab">
                      <div class="osahan-signin p-4 rounded">
                         <div class="p-2">
                            <h2 class="my-0">Welcome Back</h2>
                            <p class="small mb-4">Sign in to Continue.</p>
                            <?php echo Form::open(array('route' => array('customer.login', $store->slug,(!empty($is_cart) && $is_cart==true)?$is_cart:false)),['method'=>'POST']); ?>

                               <div class="form-group">
                                   <label for="exampleInputEmail1"><?php echo e(__('username')); ?></label>
                                   <?php echo e(Form::text('email',null,array('class'=>'form-control','placeholder'=>__('Enter Your Email')))); ?>

                               </div>
                               <div class="form-group">
                                   <label for="exampleInputPassword1"><?php echo e(__('Password')); ?></label>
                                   <?php echo e(Form::password('password',array('class'=>'form-control','id'=>'exampleInputPassword1','placeholder'=>__('Enter Your Password')))); ?>

                               </div>
                               <button type="submit" class="btn btn-success btn-lg rounded btn-block"><?php echo e(__('Sign In')); ?></button>
                               <?php echo Form::close(); ?>


                            <p class="text-center mt-3 mb-0"><a href="#" class="text-dark">Don't have an account? Sign up</a></p>
                         </div>
                      </div>
                   </div>
                   <div class="tab-pane fade" id="nav-profile" role="tabpanel" aria-labelledby="nav-profile-tab">
                      <div class="osahan-signup bg-white p-4">
                         <div class="p-2">
                            <h2 class="my-0">Let's get started</h2>
                            <p class="small mb-4">Create account to see our top picks for you!</p>
                            <?php echo Form::open(array('route' => array('store.userstore', $store->slug)), ['method' => 'post']); ?>

                               <div class="form-group">
                                   <label for="exampleInputEmail1"><?php echo e(__('Full Name')); ?></label>
                                   <input name="name" class="form-control" type="text" placeholder="<?php echo e(__('Full Name *')); ?>" required="required">
                               </div>
                               <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                   <span class="error invalid-email text-danger" role="alert">
                                           <strong><?php echo e($message); ?></strong>
                                   </span>
                               <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                               <div class="form-group">
                                   <label for="exampleInputEmail1"><?php echo e(__('Email')); ?></label>
                                   <input name="email" class="form-control" type="email" placeholder="<?php echo e(__('Email *')); ?>" required="required">
                               </div>
                               <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                   <span class="error invalid-email text-danger" role="alert">
                                           <strong><?php echo e($message); ?></strong>
                                   </span>
                               <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                               <div class="form-group">
                                   <label for="exampleInputEmail1"><?php echo e(__('Number')); ?></label>
                                   <input name="phone_number" class="form-control" type="text" placeholder="<?php echo e(__('Number *')); ?>" required="required">
                               </div>
                               <?php $__errorArgs = ['number'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                   <span class="error invalid-email text-danger" role="alert">
                                           <strong><?php echo e($message); ?></strong>
                                   </span>
                               <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                               <div class="form-group">
                                   <label for="exampleInputEmail1"><?php echo e(__('Password')); ?></label>
                                   <input name="password" class="form-control" type="password" placeholder="<?php echo e(__('Password *')); ?>" required="required">
                               </div>
                               <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                   <span class="error invalid-email text-danger" role="alert">
                                           <strong><?php echo e($message); ?></strong>
                                   </span>
                               <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                               <div class="form-group">
                                   <label for="exampleInputEmail1"><?php echo e(__('Confirm Password')); ?></label>
                                   <input name="password_confirmation" class="form-control" type="password" placeholder="<?php echo e(__('Confirm Password *')); ?>" required="required">
                               </div>
                               <?php $__errorArgs = ['password_confirmation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                   <span class="error invalid-email text-danger" role="alert">
                                           <strong><?php echo e($message); ?></strong>
                                   </span>
                               <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                               <button type="submit" class="btn btn-success rounded btn-lg btn-block"><?php echo e(__('Register')); ?></button>
                            </form>
                            <p class="text-muted text-center small py-2 m-0">or</p>

                            <p class="text-center mt-3 mb-0"><a href="signin.html" class="text-dark">Already have an account! Sign in</a></p>
                         </div>
                      </div>
                   </div>
                </div>
             </div>
              <div class="modal-footer p-0 border-0">
                 <div class="col-6 m-0 p-0">
                    <a href="#" class="btn border-top border-right btn-lg btn-block" data-dismiss="modal">Close</a>
                 </div>
                 <div class="col-6 m-0 p-0">
                    <a href="help_support.html" class="btn border-top btn-lg btn-block">Help</a>
                 </div>
              </div>
           </div>
        </div>
     </div>

    <script src="<?php echo e(asset('assets/theme/vendor/jquery/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/theme/vendor/bootstrap/js/bootstrap.bundle.min.js')); ?>" type="8b1bece9aa867edd1858dc79-text/javascript"></script>
    <script type="8b1bece9aa867edd1858dc79-text/javascript" src="<?php echo e(asset('assets/theme/vendor/slick/slick.min.js')); ?>"></script>
    <script type="8b1bece9aa867edd1858dc79-text/javascript" src="<?php echo e(asset('assets/theme/vendor/sidebar/hc-offcanvas-nav.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/theme/js/osahan.js')); ?>" type="8b1bece9aa867edd1858dc79-text/javascript"></script>
    <script src="<?php echo e(asset('assets/theme/js/rocket-loader.min.js')); ?>" data-cf-settings="8b1bece9aa867edd1858dc79-|49" defer=""></script>
    <script defer src="https://static.cloudflareinsights.com/beacon.min.js/vaafb692b2aea4879b33c060e79fe94621666317369993" integrity="sha512-0ahDYl866UMhKuYcW078ScMalXqtFJggm7TmlUtp0UlD4eQk0Ixfnm5ykXKvGJNFjLMoortdseTfsRT8oCfgGA==" data-cf-beacon='{"rayId":"7ab116270c452965","version":"2023.2.0","r":1,"token":"dd471ab1978346bbb991feaa79e6ce5c","si":100}' crossorigin="anonymous"></script>


    <script>
        var dataTabelLang = {
            paginate: {
                previous: "<?php echo e('Previous'); ?>",
                next: "<?php echo e('Next'); ?>"
            },
            lengthMenu: "<?php echo e('Show'); ?> MENU <?php echo e('entries'); ?>",
            zeroRecords: "<?php echo e('No data available in table'); ?>",
            info: "<?php echo e('Showing'); ?> START <?php echo e('to'); ?> END <?php echo e('of'); ?> TOTAL <?php echo e('entries'); ?>",
            infoEmpty: " ",
            search: "<?php echo e('Search:'); ?>"
        }
    </script>
    <script src="<?php echo e(asset('custom/js/custom.js')); ?>"></script>
    <script src="<?php echo e(asset('custom/libs/bootstrap-notify/bootstrap-notify.min.js')); ?>"></script>

    <?php if(App\Models\Utility::getValByName('gdpr_cookie') == 'on'): ?>
        <script type="text/javascript">
            var defaults = {
                'messageLocales': {
                    /*'en': 'We use cookies to make sure you can have the best experience on our website. If you continue to use this site we assume that you will be happy with it.'*/
                    'en': "<?php echo e(App\Models\Utility::getValByName('cookie_text')); ?>"
                },
                'buttonLocales': {
                    'en': 'Ok'
                },
                'cookieNoticePosition': 'bottom',
                'learnMoreLinkEnabled': false,
                'learnMoreLinkHref': '/cookie-banner-information.html',
                'learnMoreLinkText': {
                    'it': 'Saperne di più',
                    'en': 'Learn more',
                    'de': 'Mehr erfahren',
                    'fr': 'En savoir plus'
                },
                'buttonLocales': {
                    'en': 'Ok'
                },
                'expiresIn': 30,
                'buttonBgColor': '#d35400',
                'buttonTextColor': '#fff',
                'noticeBgColor': '#000',
                'noticeTextColor': '#fff',
                'linkColor': '#009fdd'
            };
        </script>
        <script src="<?php echo e(asset('custom/js/cookie.notice.js')); ?>"></script>
    <?php endif; ?>

    <?php echo $__env->yieldPushContent('script-page'); ?>
    <?php if(Session::has('success')): ?>
        <script>
            show_toastr('<?php echo e(__('Success')); ?>', '<?php echo session('success'); ?>', 'success');
        </script>
        <?php echo e(Session::forget('success')); ?>

    <?php endif; ?>
    <?php if(Session::has('error')): ?>
        <script>
            show_toastr('<?php echo e(__('Error')); ?>', '<?php echo session('error'); ?>', 'error');
        </script>
        <?php echo e(Session::forget('error')); ?>

    <?php endif; ?>
    <?php
        $store_settings = \App\Models\Store::where('slug', $store->slug)->first();
    ?>
    <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e($store_settings->google_analytic); ?>"></script>

    <?php echo $store_settings->storejs; ?>

    <script>
        $(".add_to_cart").click(function(e) {
            e.preventDefault();
            var id = $(this).attr('data-id');
            var variants = [];
            $(".variant-selection").each(function(index, element) {
                variants.push(element.value);
            });

            if (jQuery.inArray('', variants) != -1) {
                show_toastr('Error', "<?php echo e(__('Please select all option.')); ?>", 'error');
                return false;
            }
            var variation_ids = $('#variant_id').val();

            $.ajax({
                url: '<?php echo e(route('user.addToCart', ['__product_id', $store->slug, 'variation_id'])); ?>'
                    .replace('__product_id', id).replace('variation_id', variation_ids ?? 0),
                type: "POST",
                data: {
                    "_token": "<?php echo e(csrf_token()); ?>",
                    variants: variants.join(' : '),
                },
                success: function(response) {
                    if (response.status == "Success") {
                        show_toastr('Success', response.success, 'success');
                        $(".shoping_counts").attr("value", response.item_count);
                        $(".shoping_counts").html(response.item_count);
                        fbq('track', 'AddToCart');
            
      
                    } else {
                        show_toastr('Error', response.error, 'error');
                    }
                },
                error: function(result) {
                    console.log('error');
                }
            });
        });

        $(document).on('change', '#pro_variants_name', function() {
            var variants = [];
            $(".variant-selection").each(function(index, element) {
                variants.push(element.value);
            });
            if (variants.length > 0) {
                $.ajax({
                    url: '<?php echo e(route('get.products.variant.quantity')); ?>',
                    data: {
                        "_token": $('meta[name="csrf-token"]').attr('content'),
                        variants: variants.join(' : '),
                        product_id: $('#product_id').val()
                    },

                    success: function(data) {
                        $('.variation_price').html(data.price);
                        $('#variant_id').val(data.variant_id);
                        $('#variant_qty').val(data.quantity);
                    }
                });
            }
        });
    </script>
    <script>
        $(".productTab").click(function(e) {
            e.preventDefault();
            $('.productTab').removeClass('active')

        });

        $("#pro_scroll").click(function() {
            $('html, body').animate({
                scrollTop: $("#pro_items").offset().top
            }, 1000);
        });

        $(document).on('click', '.add_to_wishlist', function(e) {
            e.preventDefault();
            var id = $(this).attr('data-id');
            $.ajax({
                type: "POST",
                url: '<?php echo e(route('store.addtowishlist', [$store->slug, '__product_id'])); ?>'.replace(
                    '__product_id', id),
                data: {
                    "_token": "<?php echo e(csrf_token()); ?>",
                },
                success: function(response) {
                    if (response.status == "Success") {
                        show_toastr('Success', response.message, 'success');
                        $('.wishlist_' + response.id).removeClass('add_to_wishlist');
                        $('.wishlist_' + response.id).html('<i class="fas fa-heart"></i>');
                        $('.wishlist_count').html(response.count);
                    } else {
                        show_toastr('Error', response.error, 'error');
                    }
                },
                error: function(result) {}
            });
        });
    </script>
    <script>
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }

        gtag('js', new Date());

        gtag('config', '<?php echo e($store_settings->google_analytic); ?>');
    </script>

    <!-- Facebook Pixel Code -->
    <script>
        ! function(f, b, e, v, n, t, s) {
            if (f.fbq) return;
            n = f.fbq = function() {
                n.callMethod ?
                    n.callMethod.apply(n, arguments) : n.queue.push(arguments)
            };
            if (!f._fbq) f._fbq = n;
            n.push = n;
            n.loaded = !0;
            n.version = '2.0';
            n.queue = [];
            t = b.createElement(e);
            t.async = !0;
            t.src = v;
            s = b.getElementsByTagName(e)[0];
            s.parentNode.insertBefore(t, s)
        }(window, document, 'script',
            'https://connect.facebook.net/en_US/fbevents.js');
        fbq('init', '<?php echo e($store_settings->fbpixel_code); ?>');
        fbq('track', 'PageView');
    </script>

    <script type="text/javascript">
        $(function() {
            $(".drop-down__button ").on("click", function(e) {
                $(".drop-down").addClass("drop-down--active");
                e.stopPropagation()
            });
            $(document).on("click", function(e) {
                if ($(e.target).is(".drop-down") === false) {
                    $(".drop-down").removeClass("drop-down--active");
                }
            });
        });
    </script>

    <noscript><img height="1" width="1" style="display:none"
            src="https://www.facebook.com/tr?id=0000&ev=PageView&noscript=<?php echo e($store_settings->fbpixel_code); ?>" /></noscript>

</body>

</html>
<?php /**PATH C:\laragon\www\saas\resources\views/storefront/layout/theme.blade.php ENDPATH**/ ?>