<?php
    $products = App\Models\Product::where('store_id', 0)
        ->orderBy('id', 'DESC')
        ->get();
    
    $product_categorie = App\Models\ProductCategorie::where('store_id', 0)
        ->get()
        ->pluck('name', 'id');
    $product_categorie->prepend('Select Category', '');
    $product_subcategorie = App\Models\ProductSubcategorie::where('store_id', 0)
        ->get()
        ->pluck('name', 'id');
    $product_subcategorie->prepend('Select Sub Category', '');
    $logo = \App\Models\Utility::get_file('uploads/is_cover_image/');
?>
<!DOCTYPE html>
<html lang="en">


<head>
    <meta charset="utf-8">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />

    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="Wilio Survey, Quotation, Review and Register form Wizard by Ansonika.">
    <meta name="author" content="Ansonika">
    <title>lapaas store</title>

    <!-- Favicons-->
    <link rel="shortcut icon" href="img/favicon.ico" type="image/x-icon">
    <link rel="apple-touch-icon" type="image/x-icon" href="img/apple-touch-icon-57x57-precomposed.png">
    <link rel="apple-touch-icon" type="image/x-icon" sizes="72x72" href="img/apple-touch-icon-72x72-precomposed.png">
    <link rel="apple-touch-icon" type="image/x-icon" sizes="114x114"
        href="img/apple-touch-icon-114x114-precomposed.png">
    <link rel="apple-touch-icon" type="image/x-icon" sizes="144x144"
        href="img/apple-touch-icon-144x144-precomposed.png">

    <!-- GOOGLE WEB FONT -->
    <link href="https://fonts.googleapis.com/css?family=Work+Sans:400,500,600" rel="stylesheet">

    <!-- BASE CSS -->
    <link href="<?php echo e(asset('assets/register/css/bootstrap.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/register/css/menu.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/register/css/style.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/register/css/vendors.css')); ?>" rel="stylesheet">

    <!-- YOUR CUSTOM CSS -->
    <link href="<?php echo e(asset('assets/register/css/custom.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/css/landing.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('custom/libs/select2/dist/css/select2.min.css')); ?>">

    <!-- MODERNIZR MENU -->

    <script src="<?php echo e(asset('assets/register/js/modernizr.js')); ?>"></script>

    <script type="text/javascript">
        function myFunction() {
            var copyText = document.getElementById("myInput");
            copyText.select();
            copyText.setSelectionRange(0, 99999)
            document.execCommand("copy");
            show_toastr('Success', "<?php echo e(__('Link copied')); ?>", 'success');
        }




        var _gaq = _gaq || [];
        _gaq.push(['_setAccount', 'UA-11097556-8']);
        _gaq.push(['_trackPageview']);

        (function() {
            var ga = document.createElement('script');
            ga.type = 'text/javascript';
            ga.async = true;
            ga.src = ('https:' == document.location.protocol ? 'https://ssl' : 'http://www') +
                '.google-analytics.com/ga.js';
            var s = document.getElementsByTagName('script')[0];
            s.parentNode.insertBefore(ga, s);
        })();
    </script>
    <style>
        .csk input[type="radio"][id^="cb"] {
            display: none;
        }

        .csk label {
            border: 1px solid #fff;
            padding: 10px;
            display: block;
            position: relative;
            margin: 10px;
            cursor: pointer;
            -webkit-touch-callout: none;
            -webkit-user-select: none;
            -khtml-user-select: none;
            -moz-user-select: none;
            -ms-user-select: none;
            user-select: none;
        }

        .csk label::before {
            background-color: white;
            color: white;
            content: " ";
            display: block;
            border-radius: 50%;
            border: 1px solid grey;
            position: absolute;
            top: 168px;
            left: 94px;
            width: 25px;
            height: 25px;
            text-align: center;
            line-height: 28px;
            transition-duration: 0.4s;
            transform: scale(0);
            z-index: 1;
        }

        .csk label img {
            height: 100px;
            width: 100px;
            transition-duration: 0.2s;
            transform-origin: 50% 50%;
        }

        .csk :checked+label {
            border-color: #ddd;
        }

        .csk :checked+label::before {
            content: "✓";
            background-color: grey;
            transform: scale(1);
        }

        .csk :checked+label img {
            transform: scale(0.9);
            box-shadow: 0 0 5px #333;
            z-index: -1;
        }

        .my-error-class {
            color: #FF0000;
            /* red */
        }

        .select2-container--default .select2-selection--single .select2-selection__rendered {
            padding-top: 6px;
        }

        .select2-container--default .select2-selection--single .select2-selection__arrow {
            top: 6px;
        }

        .select2-container {
            width: 100% !important;
        }
    </style>

</head>

<body>

    <div id="preloader">
        <div data-loader="circle-side"></div>
    </div><!-- /Preload -->

    <div id="loader_form">
        <div data-loader="circle-side-2"></div>
    </div><!-- /loader_form -->

    <nav>
        <ul class="cd-primary-nav">
            <li><a href="#" class="animated_link">Back To Home</a></li>
            <li class="">
                <a class="animated_link active" href="#"><?php echo e(__('Support')); ?></a>
            </li>
            <li class="">
                <a class="animated_link" href="#"><?php echo e(__('Terms')); ?></a>
            </li>
            <li class="">
                <a class="animated_link" href="#"><?php echo e(__('Privacy')); ?></a>
            </li>

        </ul>
    </nav>
    <!-- /menu -->

    <div class="container-fluid full-height">
        <div class="row row-height">
            <div class="col-lg-3 content-left">
                <div class="content-left-wrapper">

                    <div>
                        <figure><img src="<?php echo e(asset('assets/register/img/info_graphic_1.svg')); ?>" alt=""
                                class="img-fluid"></figure>
                        <h2>Lapaas Store</h2>
                        <p>Create your online Lapaas store in just 6 easy steps</p>

                        <a href="#start" class="btn_1 rounded mobile_btn">Start Now!</a>
                    </div>
                    <div class="copy">© Lapaas</div>
                </div>
                <!-- /content-left-wrapper -->
            </div>
            <!-- /content-left -->

            <div class="col-lg-9 content-right" id="start">
                <div id="wizard_container" style="width: 800px">
                    <div id="top-wizard">
                        <div id="progressbar"></div>
                    </div>
                    <!-- /top-wizard -->
                    <form id="wrapped" enctype="multipart/form-data" method="POST" action="<?php echo e(route('register')); ?>">
                        <?php echo csrf_field(); ?>
                        <input id="website" name="website" type="text" value="">
                        <!-- Leave for security protection, read docs for details -->
                        <div id="middle-wizard">
                            <div class="step">
                                <h3 class="main_question"><strong>1/6</strong>Please fill with your details</h3>
                                <div class="form-group">
                                    <input type="text" name="name" class="form-control required" id="name"
                                        value="<?php echo e(old('name')); ?>" placeholder="Name">
                                </div>
                                <div class="form-group">
                                    <input type="email" name="email" id="email" class="form-control required"
                                        value="<?php echo e(old('email')); ?>" placeholder="Email">
                                </div>
                                <div class="form-group">
                                    <input type="password" name="password" id="password"
                                        class="form-control required" required autocomplete="new-password"
                                        placeholder="Password">
                                </div>
                                <div class="form-group">
                                    <input type="password" name="password_confirmation" id="password_confirmation"
                                        class="form-control required" placeholder="Confirm Password">
                                </div>


                            </div>
                            <!-- /step-->
                            <div class="step">
                                <h3 class="main_question"><strong>2/6</strong>Select Your Store Category And Store
                                    Details</h3>

                                <div class="form-group">
                                    <?php echo Form::select('product_categorie', $product_categorie, null, [
                                        'class' => 'form-control custom_select multi-select','required',
                                        'id' => 'product_categorie',
                                    ]); ?>

                                </div>

                                <div class="form-group" id="sub_category_div" style="display:none">
                                    <?php echo Form::select('product_subcategorie', [], null, [
                                        'class' => 'product_subcategorie form-control custom_select multi-select','required',
                                        'id' => 'product_subcategorie',
                                    ]); ?>

                                </div>





                                <div class="form-group">
                                    <div class="form-group">
                                        <input type="text" name="store_name" id="store_name"
                                            class="form-control required" placeholder="Store Name">
                                        <?php echo e(Form::label('', '', ['id' => 'store_link', 'class' => 'form-label'])); ?>

                                        <?php echo e(Form::hidden('slug', null, ['class' => 'form-control', 'id' => 'slug', 'placeholder' => __('Enter Store name')])); ?>


                                    </div>
                                </div>






                            </div>

                            <div class="step">
                                <h3 class="main_question"><strong>3/6</strong>Almost Done..! Just last step to start
                                    your Shop</h3>

                                <div class="form-group row">
                                    <div class=" col-md-4">
                                        <input type="text" name="tagline" class="form-control required"
                                            placeholder="Tagline">
                                    </div>

                                    <div class=" col-md-8">
                                        <?php echo e(Form::textarea('address', null, ['class' => 'form-control', 'placeholder' => __('Shop Address')])); ?>


                                    </div>

                                </div>
                                <div class="form-group row">
                                    <div class=" col-md-4">
                                        <?php echo e(Form::text('city', null, ['class' => 'form-control', 'placeholder' => __('City')])); ?>

                                    </div>
                                    <div class=" col-md-4">
                                        <select name="state" class="form-control custom_select" id="state-select">
                                            <option value="">Select State</option>
                                            <option value="Andhra Pradesh">Andhra Pradesh</option>
                                            <option value="Arunachal Pradesh">Arunachal Pradesh</option>
                                            <option value="Assam">Assam</option>
                                            <option value="Bihar">Bihar</option>
                                            <option value="Chhattisgarh">Chhattisgarh</option>
                                            <option value="Goa">Goa</option>
                                            <option value="Gujarat">Gujarat</option>
                                            <option value="Haryana">Haryana</option>
                                            <option value="Himachal Pradesh">Himachal Pradesh</option>
                                            <option value="Jharkhand">Jharkhand</option>
                                            <option value="Karnataka">Karnataka</option>
                                            <option value="Kerala">Kerala</option>
                                            <option value="Madhya Pradesh">Madhya Pradesh</option>
                                            <option value="Maharashtra">Maharashtra</option>
                                            <option value="Manipur">Manipur</option>
                                            <option value="Meghalaya">Meghalaya</option>
                                            <option value="Mizoram">Mizoram</option>
                                            <option value="Nagaland">Nagaland</option>
                                            <option value="Odisha">Odisha</option>
                                            <option value="Punjab">Punjab</option>
                                            <option value="Rajasthan">Rajasthan</option>
                                            <option value="Sikkim">Sikkim</option>
                                            <option value="Tamil Nadu">Tamil Nadu</option>
                                            <option value="Telangana">Telangana</option>
                                            <option value="Tripura">Tripura</option>
                                            <option value="Uttar Pradesh">Uttar Pradesh</option>
                                            <option value="Uttarakhand">Uttarakhand</option>
                                            <option value="West Bengal">West Bengal</option>
                                        </select>
                                    </div>
                                    <div class=" col-md-4">
                                        <?php echo e(Form::text('zipcode', null, ['class' => 'form-control', 'onkeyup' => 'validateNumber(this)', 'placeholder' => __('Zipcode'), 'pattern' => '[0-9]*'])); ?>

                                    </div>
                                </div>
                                <div class="form-group row">
                                    <div class=" col-md-6">
                                        <select class="form-control" id="currency" name="currency">
                                            <option value=""> Select Currency </option>
                                            <option data-id="₹" value="INR"> INR </option>
                                            <option value="USD" data-id="$"> USD </option>

                                        </select>
                                    </div>
                                    <div class=" col-md-6">
                                        <?php echo e(Form::text('currency_symbol', null, ['class' => 'form-control', 'id' => 'currency_symbol', 'readonly', 'placeholder' => __('Symbol')])); ?>

                                    </div>
                                    <div class="form-group col-md-12 p-3">
                                        <?php echo e(Form::label('logo', __('Logo'), ['class' => 'form-label'])); ?>

                                        <?php echo e(Form::file('logo', null, ['class' => 'form-control', 'id' => 'fileid', 'placeholder' => __('Upload your logo')])); ?>

                                    </div>
                                </div>


                            </div>

                            <div class="step">
                                <h3 class="main_question"><strong>4/6</strong>Select Theme</h3>
                                <div class="row" style="height: 400px;overflow:auto">
                                    <?php $__currentLoopData = \App\Models\Utility::themeOne(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $v): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-4 cc-selector mb-2">
                                            <div class="mb-3 screen image">
                                                <div class="csk">
                                                    <input type="radio" required class="th" name="th"
                                                        id="cb<?php echo e($key); ?>" />
                                                    <label for="cb<?php echo e($key); ?>"><img
                                                            src="<?php echo e(asset(Storage::url('uploads/store_theme/' . $key . '/Home.png'))); ?>"
                                                            class="color1 img-center pro_max_width pro_max_height <?php echo e($key); ?>_img"
                                                            data-id="<?php echo e($key); ?>"></label>
                                                </div>
                                                <div class="actions">
                                                    <a href="">
                                                        <button type="button"
                                                            class="btn btn-default delete-image-btn pull-right">
                                                            <span class="glyphicon glyphicon-trash"></span>
                                                        </button>
                                                    </a>
                                                    <a href="">
                                                        <button type="button"
                                                            class="btn btn-default edit-image-btn pull-right">
                                                            <span class="glyphicon glyphicon-pencil"></span>
                                                        </button>
                                                    </a>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="row gutters-xs <?php echo e($key == 'theme10' ? 'theme10box' : ''); ?>"
                                                    id="<?php echo e($key); ?>">
                                                    <?php $__currentLoopData = $v; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $css => $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <div class="col">
                                                            <label class="colorinput">
                                                                <input name="theme_color" type="radio"
                                                                    value="<?php echo e($css); ?>"
                                                                    data-theme="<?php echo e($key); ?>"
                                                                    data-imgpath="<?php echo e($val['img_path']); ?>"
                                                                    class="colorinput-input color-<?php echo e($loop->index++); ?>"
                                                                    <?php echo e(isset($store_settings['store_theme']) && $store_settings['store_theme'] == $css && $store_settings['theme_dir'] == $key ? 'checked' : ''); ?>>
                                                                <span class="colorinput-color"
                                                                    style="background:#<?php echo e($val['color']); ?>"></span>
                                                            </label>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <div class="col">
                                                        <?php if(isset($store_settings['theme_dir']) && $store_settings['theme_dir'] == $key): ?>
                                                            <a href="<?php echo e(route('store.editproducts', [$store_settings->slug, $key])); ?>"
                                                                class="btn btn-outline-primary theme_btn"
                                                                type="button"
                                                                id="button-addon2"><?php echo e(__('Edit')); ?></a>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>

                            </div>
                            <!-- /step-->

                            <div class=" step ">

                                <h3 class="main_question"><strong>5/6</strong>Select Payment Mode</h3>
                                <div class="row" style="height: 400px;overflow:auto">

                                    <div class="faq justify-content-center">
                                        <div class="col-sm-12 col-md-10 col-xxl-12">
                                            <div class="row">
                                                <div class="col-6 py-2">
                                                    <h5 class="h5"><?php echo e(__('Cash On Delivery')); ?></h5>
                                                    <small>
                                                        <?php echo e(__('Note : Enable or disable cash on delivery.')); ?></small><br>
                                                    <small>
                                                        <?php echo e(__('This detail will use for make checkout of shopping cart.')); ?></small>
                                                </div>
                                                <div class="col-6 py-2 text-end">
                                                    <div class="form-check form-switch form-switch-right mb-2">
                                                        <input type="hidden" name="enable_cod" value="off">
                                                        <input type="checkbox" class="form-check-input mx-2"
                                                            name="enable_cod" id="enable_cod">
                                                        <label class="form-check-label"
                                                            for="enable_cod"><?php echo e(__('Enable')); ?></label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="row">
                                                <div class="col-6 py-2">
                                                    <h5 class="h5"><?php echo e(__('Whatsapp')); ?></h5>
                                                    <small>
                                                        <?php echo e(__('Note: This detail will use for make checkout of shopping cart.')); ?></small>
                                                </div>
                                                <div class="col-6 py-2 text-end">
                                                    <div class="form-check form-switch form-switch-right mb-2">
                                                        <input type="hidden" name="enable_whatsapp" value="off">
                                                        <input type="checkbox" class="form-check-input mx-2"
                                                            name="enable_whatsapp" id="enable_whatsapp">
                                                        <label class="form-check-label"
                                                            for="enable_whatsapp"><?php echo e(__('Enable')); ?></label>
                                                    </div>
                                                </div>
                                                <div class="col-md-6">
                                                    <div class="form-group">
                                                        <input type="text" name="whatsapp_number"
                                                            id="whatsapp_number" class="form-control input-mask"
                                                            data-mask="+00 00000000000"
                                                            placeholder="+00 00000000000" />
                                                    </div>
                                                </div>
                                            </div>
                                            <h3 class="main_question">Select Payment Getway</h3>

                                            <div class="accordion accordion-flush" id="accordionExample">




                                                <!-- Strip -->
                                                <div class="accordion-item card">
                                                    <h2 class="accordion-header" id="heading-2-2">
                                                        <button class="accordion-button collapsed" type="button"
                                                            data-bs-toggle="collapse" data-bs-target="#collapse1"
                                                            aria-expanded="true" aria-controls="collapse1">
                                                            <span class="d-flex align-items-center">
                                                                <i class="ti ti-credit-card text-primary"></i>
                                                                <?php echo e(__('Stripe')); ?>

                                                            </span>
                                                        </button>
                                                    </h2>
                                                    <div id="collapse1" class="accordion-collapse collapse"
                                                        aria-labelledby="heading-2-2"
                                                        data-bs-parent="#accordionExample">
                                                        <div class="accordion-body">
                                                            <div class="row">
                                                                <div class="col-6 py-2">
                                                                    
                                                                </div>
                                                                <div class="col-6 py-2 text-end">
                                                                    <div
                                                                        class="form-check form-switch form-switch-right mb-2">
                                                                        <input type="hidden" name="is_stripe_enabled"
                                                                            value="off">
                                                                        <input type="checkbox"
                                                                            class="form-check-input mx-2"
                                                                            name="is_stripe_enabled"
                                                                            id="is_stripe_enabled">
                                                                        <label class="form-check-label"
                                                                            for="is_stripe_enabled"><?php echo e(__('Enable')); ?></label>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <?php echo e(Form::label('stripe_key', __('Stripe Key'), ['class' => 'col-form-label'])); ?>

                                                                        <?php echo e(Form::text('stripe_key', null, ['class' => 'form-control', 'placeholder' => __('Enter Stripe Key')])); ?>

                                                                        <?php $__errorArgs = ['stripe_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                            <span class="invalid-stripe_key"
                                                                                role="alert">
                                                                                <strong
                                                                                    class="text-danger"><?php echo e($message); ?></strong>
                                                                            </span>
                                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <?php echo e(Form::label('stripe_secret', __('Stripe Secret'), ['class' => 'col-form-label'])); ?>

                                                                        <?php echo e(Form::text('stripe_secret', null, ['class' => 'form-control ', 'placeholder' => __('Enter Stripe Secret')])); ?>

                                                                        <?php $__errorArgs = ['stripe_secret'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                                            <span class="invalid-stripe_secret"
                                                                                role="alert">
                                                                                <strong
                                                                                    class="text-danger"><?php echo e($message); ?></strong>
                                                                            </span>
                                                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- Paypal -->
                                                <div class="accordion-item card">
                                                    <h2 class="accordion-header" id="heading-2-3">
                                                        <button class="accordion-button collapsed" type="button"
                                                            data-bs-toggle="collapse" data-bs-target="#collapse2"
                                                            aria-expanded="true" aria-controls="collapse2">
                                                            <span class="d-flex align-items-center">
                                                                <i class="ti ti-credit-card text-primary"></i>
                                                                <?php echo e(__('Paypal')); ?>

                                                            </span>
                                                        </button>
                                                    </h2>
                                                    <div id="collapse2" class="accordion-collapse collapse"
                                                        aria-labelledby="heading-2-3"
                                                        data-bs-parent="#accordionExample">
                                                        <div class="accordion-body">
                                                            <div class="row">
                                                                <div class="col-6 py-2">
                                                                    
                                                                </div>
                                                                <div class="col-6 py-2 text-end">
                                                                    <div
                                                                        class="form-check form-switch form-switch-right mb-2">
                                                                        <input type="hidden" name="is_paypal_enabled"
                                                                            value="off">
                                                                        <input type="checkbox"
                                                                            class="form-check-input mx-2"
                                                                            name="is_paypal_enabled"
                                                                            id="is_paypal_enabled">
                                                                        <label class="form-check-label"
                                                                            for="is_paypal_enabled"><?php echo e(__('Enable')); ?></label>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-12 pb-4">
                                                                    <label class="paypal-label col-form-label"
                                                                        for="paypal_mode"><?php echo e(__('Paypal Mode')); ?></label>
                                                                    <br>
                                                                    <div class="d-flex">
                                                                        <div class="mr-2"
                                                                            style="margin-right: 15px;">
                                                                            <div class="border card p-3">
                                                                                <div class="form-check">
                                                                                    <label
                                                                                        class="form-check-labe text-dark">
                                                                                        <input type="radio"
                                                                                            name="paypal_mode"
                                                                                            value="sandbox"
                                                                                            class="form-check-input">
                                                                                        <?php echo e(__('Sandbox')); ?>

                                                                                    </label>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="mr-2">
                                                                            <div class="border card p-3">
                                                                                <div class="form-check">
                                                                                    <label
                                                                                        class="form-check-labe text-dark">
                                                                                        <input type="radio"
                                                                                            name="paypal_mode"
                                                                                            value="live"
                                                                                            class="form-check-input">
                                                                                        <?php echo e(__('Live')); ?>

                                                                                    </label>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label for="paypal_client_id"
                                                                            class="col-form-label"><?php echo e(__('Client ID')); ?></label>
                                                                        <input type="text" name="paypal_client_id"
                                                                            id="paypal_client_id" class="form-control"
                                                                            placeholder="<?php echo e(__('Client ID')); ?>">
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label for="paypal_secret_key"
                                                                            class="col-form-label"><?php echo e(__('Secret Key')); ?></label>
                                                                        <input type="text" name="paypal_secret_key"
                                                                            id="paypal_secret_key"
                                                                            class="form-control"
                                                                            placeholder="<?php echo e(__('Secret Key')); ?>">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- Paystack -->
                                                <div class="accordion-item card">
                                                    <h2 class="accordion-header" id="heading-2-4">
                                                        <button class="accordion-button collapsed" type="button"
                                                            data-bs-toggle="collapse" data-bs-target="#collapse3"
                                                            aria-expanded="true" aria-controls="collapse3">
                                                            <span class="d-flex align-items-center">
                                                                <i class="ti ti-credit-card text-primary"></i>
                                                                <?php echo e(__('Paystack')); ?>

                                                            </span>
                                                        </button>
                                                    </h2>
                                                    <div id="collapse3" class="accordion-collapse collapse"
                                                        aria-labelledby="heading-2-4"
                                                        data-bs-parent="#accordionExample">
                                                        <div class="accordion-body">
                                                            <div class="row">
                                                                <div class="col-6 py-2">
                                                                    
                                                                </div>
                                                                <div class="col-6 py-2 text-end">
                                                                    <div
                                                                        class="form-check form-switch form-switch-right mb-2">
                                                                        <input type="hidden"
                                                                            name="is_paystack_enabled" value="off">
                                                                        <input type="checkbox"
                                                                            class="form-check-input mx-2"
                                                                            name="is_paystack_enabled"
                                                                            id="is_paystack_enabled">
                                                                        <label class="form-check-label"
                                                                            for="is_paystack_enabled"><?php echo e(__('Enable')); ?></label>

                                                                    </div>
                                                                </div>

                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label for="paypal_client_id"
                                                                            class="col-form-label"><?php echo e(__('Public Key')); ?></label>
                                                                        <input type="text"
                                                                            name="paystack_public_key"
                                                                            id="paystack_public_key"
                                                                            class="form-control"
                                                                            placeholder="<?php echo e(__('Public Key')); ?>" />
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label for="paystack_secret_key"
                                                                            class="col-form-label"><?php echo e(__('Secret Key')); ?></label>
                                                                        <input type="text"
                                                                            name="paystack_secret_key"
                                                                            id="paystack_secret_key"
                                                                            class="form-control"
                                                                            placeholder="<?php echo e(__('Secret Key')); ?>" />
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- FLUTTERWAVE -->
                                                <div class="accordion-item card">
                                                    <h2 class="accordion-header" id="heading-2-5">
                                                        <button class="accordion-button collapsed" type="button"
                                                            data-bs-toggle="collapse" data-bs-target="#collapse4"
                                                            aria-expanded="true" aria-controls="collapse4">
                                                            <span class="d-flex align-items-center">
                                                                <i class="ti ti-credit-card text-primary"></i>
                                                                <?php echo e(__('Flutterwave')); ?>

                                                            </span>
                                                        </button>
                                                    </h2>
                                                    <div id="collapse4" class="accordion-collapse collapse"
                                                        aria-labelledby="heading-2-5"
                                                        data-bs-parent="#accordionExample">
                                                        <div class="accordion-body">
                                                            <div class="row">
                                                                <div class="col-6 py-2">
                                                                    
                                                                </div>
                                                                <div class="col-6 py-2 text-end">
                                                                    <div
                                                                        class="form-check form-switch form-switch-right mb-2">
                                                                        <input type="hidden"
                                                                            name="is_flutterwave_enabled"
                                                                            value="off">
                                                                        <input type="checkbox"
                                                                            class="form-check-input mx-2"
                                                                            name="is_flutterwave_enabled"
                                                                            id="is_flutterwave_enabled">
                                                                        <label class="form-check-label"
                                                                            for="is_flutterwave_enabled"><?php echo e(__('Enable')); ?></label>
                                                                    </div>
                                                                </div>

                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label for="paypal_client_id"
                                                                            class="col-form-label"><?php echo e(__('Public Key')); ?></label>
                                                                        <input type="text"
                                                                            name="flutterwave_public_key"
                                                                            id="flutterwave_public_key"
                                                                            class="form-control"
                                                                            placeholder="Public Key">
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label for="paystack_secret_key"
                                                                            class="col-form-label"><?php echo e(__('Secret Key')); ?></label>
                                                                        <input type="text"
                                                                            name="flutterwave_secret_key"
                                                                            id="flutterwave_secret_key"
                                                                            class="form-control"
                                                                            placeholder="Secret Key">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- Razorpay -->
                                                <div class="accordion-item card">
                                                    <h2 class="accordion-header" id="heading-2-6">
                                                        <button class="accordion-button collapsed" type="button"
                                                            data-bs-toggle="collapse" data-bs-target="#collapse5"
                                                            aria-expanded="true" aria-controls="collapse5">
                                                            <span class="d-flex align-items-center">
                                                                <i class="ti ti-credit-card text-primary"></i>
                                                                <?php echo e(__('Razorpay')); ?>

                                                            </span>
                                                        </button>
                                                    </h2>
                                                    <div id="collapse5" class="accordion-collapse collapse"
                                                        aria-labelledby="heading-2-6"
                                                        data-bs-parent="#accordionExample">
                                                        <div class="accordion-body">
                                                            <div class="row">
                                                                <div class="col-6 py-2">
                                                                    
                                                                </div>
                                                                <div class="col-6 py-2 text-end">
                                                                    <div
                                                                        class="form-check form-switch form-switch-right mb-2">
                                                                        <input type="hidden"
                                                                            name="is_razorpay_enabled" value="off">
                                                                        <input type="checkbox"
                                                                            class="form-check-input mx-2"
                                                                            name="is_razorpay_enabled"
                                                                            id="is_razorpay_enabled">
                                                                        <label class="form-check-label"
                                                                            for="is_razorpay_enabled"><?php echo e(__('Enable')); ?></label>
                                                                    </div>
                                                                </div>

                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label for="paypal_client_id"
                                                                            class="col-form-label"><?php echo e(__('Public Key')); ?></label>

                                                                        <input type="text"
                                                                            name="razorpay_public_key"
                                                                            id="razorpay_public_key"
                                                                            class="form-control"
                                                                            placeholder="Public Key">
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label for="paystack_secret_key"
                                                                            class="col-form-label">
                                                                            <?php echo e(__('Secret Key')); ?></label>
                                                                        <input type="text"
                                                                            name="razorpay_secret_key"
                                                                            id="razorpay_secret_key"
                                                                            class="form-control"
                                                                            placeholder="Secret Key">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- Paytm -->
                                                <div class="accordion-item card">
                                                    <h2 class="accordion-header" id="heading-2-7">
                                                        <button class="accordion-button collapsed" type="button"
                                                            data-bs-toggle="collapse" data-bs-target="#collapse6"
                                                            aria-expanded="true" aria-controls="collapse6">
                                                            <span class="d-flex align-items-center">
                                                                <i class="ti ti-credit-card text-primary"></i>
                                                                <?php echo e(__('Paytm')); ?>

                                                            </span>
                                                        </button>
                                                    </h2>
                                                    <div id="collapse6" class="accordion-collapse collapse"
                                                        aria-labelledby="heading-2-7"
                                                        data-bs-parent="#accordionExample">
                                                        <div class="accordion-body">
                                                            <div class="row">
                                                                <div class="col-6 py-2">
                                                                    
                                                                </div>
                                                                <div class="col-6 py-2 text-end">
                                                                    <div
                                                                        class="form-check form-switch form-switch-right mb-2">
                                                                        <input type="hidden" name="is_paytm_enabled"
                                                                            value="off">
                                                                        <input type="checkbox"
                                                                            class="form-check-input mx-2"
                                                                            name="is_paytm_enabled"
                                                                            id="is_paytm_enabled">
                                                                        <label class="form-check-label"
                                                                            for="is_paytm_enabled"><?php echo e(__('Enable')); ?></label>

                                                                    </div>
                                                                </div>
                                                                <div class="col-md-12 pb-4">
                                                                    <label class="paypal-label col-form-label"
                                                                        for="paypal_mode"><?php echo e(__('Paytm Environment')); ?></label>
                                                                    <br>
                                                                    <div class="d-flex">
                                                                        <div class="mr-2"
                                                                            style="margin-right: 15px;">
                                                                            <div class="border card p-3">
                                                                                <div class="form-check">
                                                                                    <label
                                                                                        class="form-check-labe text-dark">
                                                                                        <input type="radio"
                                                                                            name="paytm_mode"
                                                                                            value="local"
                                                                                            class="form-check-input">
                                                                                        <?php echo e(__('Local')); ?>

                                                                                    </label>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="mr-2">
                                                                            <div class="border card p-3">
                                                                                <div class="form-check">
                                                                                    <label
                                                                                        class="form-check-labe text-dark">
                                                                                        <input type="radio"
                                                                                            name="paytm_mode"
                                                                                            value="production"
                                                                                            class="form-check-input">
                                                                                        <?php echo e(__('Production')); ?>

                                                                                    </label>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-4">
                                                                    <div class="form-group">
                                                                        <label for="paytm_public_key"
                                                                            class="col-form-label"><?php echo e(__('Merchant ID')); ?></label>
                                                                        <input type="text" name="paytm_merchant_id"
                                                                            id="paytm_merchant_id"
                                                                            class="form-control"
                                                                            placeholder="<?php echo e(__('Merchant ID')); ?>" />
                                                                        <?php if($errors->has('paytm_merchant_id')): ?>
                                                                            <span class="invalid-feedback d-block">
                                                                                <?php echo e($errors->first('paytm_merchant_id')); ?>

                                                                            </span>
                                                                        <?php endif; ?>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-4">
                                                                    <div class="form-group">
                                                                        <label for="paytm_secret_key"
                                                                            class="col-form-label"><?php echo e(__('Merchant Key')); ?></label>
                                                                        <input type="text"
                                                                            name="paytm_merchant_key"
                                                                            id="paytm_merchant_key"
                                                                            class="form-control"
                                                                            placeholder="<?php echo e(__('Merchant Key')); ?>" />
                                                                        <?php if($errors->has('paytm_merchant_key')): ?>
                                                                            <span class="invalid-feedback d-block">
                                                                                <?php echo e($errors->first('paytm_merchant_key')); ?>

                                                                            </span>
                                                                        <?php endif; ?>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-4">
                                                                    <div class="form-group">
                                                                        <label for="paytm_industry_type"
                                                                            class="col-form-label"><?php echo e(__('Industry Type')); ?></label>
                                                                        <input type="text"
                                                                            name="paytm_industry_type"
                                                                            id="paytm_industry_type"
                                                                            class="form-control"
                                                                            placeholder="<?php echo e(__('Industry Type')); ?>" />
                                                                        <?php if($errors->has('paytm_industry_type')): ?>
                                                                            <span class="invalid-feedback d-block">
                                                                                <?php echo e($errors->first('paytm_industry_type')); ?>

                                                                            </span>
                                                                        <?php endif; ?>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- Mercado Pago-->
                                                <div class="accordion-item card">
                                                    <h2 class="accordion-header" id="heading-2-8">
                                                        <button class="accordion-button collapsed" type="button"
                                                            data-bs-toggle="collapse" data-bs-target="#collapse7"
                                                            aria-expanded="true" aria-controls="collapse7">
                                                            <span class="d-flex align-items-center">
                                                                <i class="ti ti-credit-card text-primary"></i>
                                                                <?php echo e(__('Mercado Pago')); ?>

                                                            </span>
                                                        </button>
                                                    </h2>
                                                    <div id="collapse7" class="accordion-collapse collapse"
                                                        aria-labelledby="heading-2-8"
                                                        data-bs-parent="#accordionExample">
                                                        <div class="accordion-body">
                                                            <div class="row">
                                                                <div class="col-6 py-2">
                                                                    
                                                                </div>
                                                                <div class="col-6 py-2 text-end">
                                                                    <div
                                                                        class="form-check form-switch form-switch-right mb-2">
                                                                        <input type="hidden"
                                                                            name="is_mercado_enabled" value="off">
                                                                        <input type="checkbox"
                                                                            class="form-check-input mx-2"
                                                                            name="is_mercado_enabled"
                                                                            id="is_mercado_enabled">
                                                                        <label class="form-check-label"
                                                                            for="is_mercado_enabled"><?php echo e(__('Enable')); ?></label>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-12 pb-4">
                                                                    <label class="coingate-label col-form-label"
                                                                        for="mercado_mode"><?php echo e(__('Mercado Mode')); ?></label>
                                                                    <br>
                                                                    <div class="d-flex">
                                                                        <div class="mr-2"
                                                                            style="margin-right: 15px;">
                                                                            <div class="border card p-3">
                                                                                <div class="form-check">
                                                                                    <label
                                                                                        class="form-check-labe text-dark">
                                                                                        <input type="radio"
                                                                                            name="mercado_mode"
                                                                                            value="sandbox"
                                                                                            class="form-check-input">
                                                                                        <?php echo e(__('Sandbox')); ?>

                                                                                    </label>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="mr-2">
                                                                            <div class="border card p-3">
                                                                                <div class="form-check">
                                                                                    <label
                                                                                        class="form-check-labe text-dark">
                                                                                        <input type="radio"
                                                                                            name="mercado_mode"
                                                                                            value="live"
                                                                                            class="form-check-input">
                                                                                        <?php echo e(__('Live')); ?>

                                                                                    </label>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label for="mercado_access_token"
                                                                            class="col-form-label"><?php echo e(__('Access Token')); ?></label>
                                                                        <input type="text"
                                                                            name="mercado_access_token"
                                                                            id="mercado_access_token"
                                                                            class="form-control"
                                                                            placeholder="<?php echo e(__('Access Token')); ?>" />
                                                                        <?php if($errors->has('mercado_secret_key')): ?>
                                                                            <span class="invalid-feedback d-block">
                                                                                <?php echo e($errors->first('mercado_access_token')); ?>

                                                                            </span>
                                                                        <?php endif; ?>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- Mollie -->
                                                <div class="accordion-item card">
                                                    <h2 class="accordion-header" id="heading-2-9">
                                                        <button class="accordion-button collapsed" type="button"
                                                            data-bs-toggle="collapse" data-bs-target="#collapse8"
                                                            aria-expanded="true" aria-controls="collapse8">
                                                            <span class="d-flex align-items-center">
                                                                <i class="ti ti-credit-card text-primary"></i>
                                                                <?php echo e(__('Mollie')); ?>

                                                            </span>
                                                        </button>
                                                    </h2>
                                                    <div id="collapse8" class="accordion-collapse collapse"
                                                        aria-labelledby="heading-2-9"
                                                        data-bs-parent="#accordionExample">
                                                        <div class="accordion-body">
                                                            <div class="row">
                                                                <div class="col-6 py-2">
                                                                    
                                                                </div>
                                                                <div class="col-6 py-2 text-end">
                                                                    <div
                                                                        class="form-check form-switch form-switch-right mb-2">
                                                                        <input type="hidden" name="is_mollie_enabled"
                                                                            value="off">
                                                                        <input type="checkbox"
                                                                            class="form-check-input mx-2"
                                                                            name="is_mollie_enabled"
                                                                            id="is_mollie_enabled">
                                                                        <label class="form-check-label"
                                                                            for="is_mollie_enabled"><?php echo e(__('Enable')); ?></label>
                                                                    </div>
                                                                </div>

                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label for="mollie_api_key"
                                                                            class="col-form-label"><?php echo e(__('Mollie Api Key')); ?></label>
                                                                        <input type="text" name="mollie_api_key"
                                                                            id="mollie_api_key" class="form-control"
                                                                            placeholder="Mollie Api Key">
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label for="mollie_profile_id"
                                                                            class="col-form-label"><?php echo e(__('Mollie Profile Id')); ?></label>
                                                                        <input type="text" name="mollie_profile_id"
                                                                            id="mollie_profile_id"
                                                                            class="form-control"
                                                                            placeholder="Mollie Profile Id">
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label for="mollie_partner_id"
                                                                            class="col-form-label"><?php echo e(__('Mollie Partner Id')); ?></label>
                                                                        <input type="text" name="mollie_partner_id"
                                                                            id="mollie_partner_id"
                                                                            class="form-control"
                                                                            placeholder="Mollie Partner Id">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- Skrill -->
                                                <div class="accordion-item card">
                                                    <h2 class="accordion-header" id="heading-2-10">
                                                        <button class="accordion-button collapsed" type="button"
                                                            data-bs-toggle="collapse" data-bs-target="#collapse9"
                                                            aria-expanded="true" aria-controls="collapse9">
                                                            <span class="d-flex align-items-center">
                                                                <i class="ti ti-credit-card text-primary"></i>
                                                                <?php echo e(__('Skrill')); ?>

                                                            </span>
                                                        </button>
                                                    </h2>
                                                    <div id="collapse9" class="accordion-collapse collapse"
                                                        aria-labelledby="heading-2-10"
                                                        data-bs-parent="#accordionExample">
                                                        <div class="accordion-body">
                                                            <div class="row">
                                                                <div class="col-6 py-2">
                                                                    
                                                                </div>
                                                                <div class="col-6 py-2 text-end">
                                                                    <div
                                                                        class="form-check form-switch form-switch-right mb-2">
                                                                        <input type="hidden" name="is_skrill_enabled"
                                                                            value="off">
                                                                        <input type="checkbox"
                                                                            class="form-check-input mx-2"
                                                                            name="is_skrill_enabled"
                                                                            id="is_skrill_enabled">
                                                                        <label class="form-check-label"
                                                                            for="is_skrill_enabled"><?php echo e(__('Enable')); ?></label>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label for="mollie_api_key"
                                                                            class="col-form-label"><?php echo e(__('Skrill Email')); ?></label>
                                                                        <input type="email" name="skrill_email"
                                                                            id="skrill_email" class="form-control"
                                                                            placeholder="<?php echo e(__('Mollie Api Key')); ?>" />
                                                                        <?php if($errors->has('skrill_email')): ?>
                                                                            <span class="invalid-feedback d-block">
                                                                                <?php echo e($errors->first('skrill_email')); ?>

                                                                            </span>
                                                                        <?php endif; ?>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- CoinGate -->
                                                <div class="accordion-item card">
                                                    <h2 class="accordion-header" id="heading-2-11">
                                                        <button class="accordion-button collapsed" type="button"
                                                            data-bs-toggle="collapse" data-bs-target="#collapse10"
                                                            aria-expanded="true" aria-controls="collapse10">
                                                            <span class="d-flex align-items-center">
                                                                <i class="ti ti-credit-card text-primary"></i>
                                                                <?php echo e(__('CoinGate')); ?>

                                                            </span>
                                                        </button>
                                                    </h2>
                                                    <div id="collapse10" class="accordion-collapse collapse"
                                                        aria-labelledby="heading-2-11"
                                                        data-bs-parent="#accordionExample">
                                                        <div class="accordion-body">
                                                            <div class="row">
                                                                <div class="col-6 py-2">
                                                                    
                                                                </div>
                                                                <div class="col-6 py-2 text-end">
                                                                    <div
                                                                        class="form-check form-switch form-switch-right mb-2">
                                                                        <input type="hidden"
                                                                            name="is_coingate_enabled" value="off">
                                                                        <input type="checkbox"
                                                                            class="form-check-input mx-2"
                                                                            name="is_coingate_enabled"
                                                                            id="is_coingate_enabled">
                                                                        <label class="form-check-label"
                                                                            for="is_coingate_enabled"><?php echo e(__('Enable')); ?></label>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-12 pb-4">
                                                                    <label class="col-form-label"
                                                                        for="coingate_mode"><?php echo e(__('CoinGate Mode')); ?></label>
                                                                    <br>
                                                                    <div class="d-flex">
                                                                        <div class="mr-2"
                                                                            style="margin-right: 15px;">
                                                                            <div class="border card p-3">
                                                                                <div class="form-check">
                                                                                    <label
                                                                                        class="form-check-labe text-dark">
                                                                                        <input type="radio"
                                                                                            name="coingate_mode"
                                                                                            value="sandbox"
                                                                                            class="form-check-input">
                                                                                        <?php echo e(__('Sandbox')); ?>

                                                                                    </label>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="mr-2">
                                                                            <div class="border card p-3">
                                                                                <div class="form-check">
                                                                                    <label
                                                                                        class="form-check-labe text-dark">
                                                                                        <input type="radio"
                                                                                            name="coingate_mode"
                                                                                            value="live"
                                                                                            class="form-check-input">
                                                                                        <?php echo e(__('Live')); ?>

                                                                                    </label>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label for="coingate_auth_token"
                                                                            class="col-form-label"><?php echo e(__('CoinGate Auth Token')); ?></label>
                                                                        <input type="text"
                                                                            name="coingate_auth_token"
                                                                            id="coingate_auth_token"
                                                                            class="form-control"
                                                                            placeholder="CoinGate Auth Token">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- PaymentWall -->
                                                <div class="accordion-item card">
                                                    <h2 class="accordion-header" id="heading-2-12">
                                                        <button class="accordion-button collapsed" type="button"
                                                            data-bs-toggle="collapse" data-bs-target="#collapse11"
                                                            aria-expanded="true" aria-controls="collapse11">
                                                            <span class="d-flex align-items-center">
                                                                <i class="ti ti-credit-card text-primary"></i>
                                                                <?php echo e(__('PaymentWall')); ?>

                                                            </span>
                                                        </button>
                                                    </h2>
                                                    <div id="collapse11" class="accordion-collapse collapse"
                                                        aria-labelledby="heading-2-12"
                                                        data-bs-parent="#accordionExample">
                                                        <div class="accordion-body">
                                                            <div class="row">
                                                                <div class="col-6 py-2">
                                                                    
                                                                </div>
                                                                <div class="col-6 py-2 text-end">
                                                                    <div
                                                                        class="form-check form-switch form-switch-right mb-2">
                                                                        <input type="hidden"
                                                                            name="is_paymentwall_enabled"
                                                                            value="off">
                                                                        <input type="checkbox"
                                                                            class="form-check-input mx-2"
                                                                            name="is_paymentwall_enabled"
                                                                            id="is_paymentwall_enabled">
                                                                        <label class="form-check-label"
                                                                            for="is_paymentwall_enabled"><?php echo e(__('Enable')); ?>

                                                                        </label>
                                                                    </div>
                                                                </div>

                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label for="paymentwall_public_key"
                                                                            class="col-form-label"><?php echo e(__('Public Key')); ?></label>
                                                                        <input type="text"
                                                                            name="paymentwall_public_key"
                                                                            id="paymentwall_public_key"
                                                                            class="form-control"
                                                                            placeholder="<?php echo e(__('Public Key')); ?>">
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label for="paymentwall_private_key"
                                                                            class="col-form-label"><?php echo e(__('Private Key')); ?></label>
                                                                        <input type="text"
                                                                            name="paymentwall_private_key"
                                                                            id="paymentwall_private_key"
                                                                            class="form-control"
                                                                            placeholder="<?php echo e(__('Private Key')); ?>">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- One money -->
                                                <div class="accordion-item card">
                                                    <h2 class="accordion-header" id="heading-2-12">
                                                        <button class="accordion-button" type="button"
                                                            data-bs-toggle="collapse" data-bs-target="#collapseone"
                                                            aria-expanded="true" aria-controls="collapseone">
                                                            <span class="d-flex align-items-center">
                                                                <i class="ti ti-credit-card text-primary"></i>
                                                                <?php echo e(__('One money')); ?>

                                                            </span>
                                                        </button>
                                                    </h2>
                                                    <div id="collapseone" class="accordion-collapse collapse"
                                                        aria-labelledby="heading-2-12"
                                                        data-bs-parent="#accordionExample">
                                                        <div class="accordion-body">
                                                            <div class="row">
                                                                <div class="col-6 py-2">
                                                                    
                                                                </div>
                                                                <div class="col-6 py-2 text-end">
                                                                    <div
                                                                        class="form-check form-switch form-switch-right mb-2">
                                                                        <input type="hidden"
                                                                            name="is_onemoney_enabled" value="off">
                                                                        <input type="checkbox"
                                                                            class="form-check-input mx-2"
                                                                            name="is_onemoney_enabled"
                                                                            id="is_onemoney_enabled">
                                                                        <label class="form-check-label"
                                                                            for="is_onemoney_enabled"><?php echo e(__('Enable')); ?>

                                                                        </label>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-12 pb-4">
                                                                    <label class="onemony-label col-form-label"
                                                                        for="onemony_mode"><?php echo e(__('One Money Mode')); ?></label>
                                                                    <br>
                                                                    <div class="d-flex">
                                                                        <div class="mr-2"
                                                                            style="margin-right: 15px;">
                                                                            <div class="border card p-3">
                                                                                <div class="form-check">
                                                                                    <label
                                                                                        class="form-check-labe text-dark">
                                                                                        <input type="radio"
                                                                                            name="onemony_mode"
                                                                                            value="sandbox"
                                                                                            class="form-check-input">
                                                                                        <?php echo e(__('Sandbox')); ?>

                                                                                    </label>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="mr-2">
                                                                            <div class="border card p-3">
                                                                                <div class="form-check">
                                                                                    <label
                                                                                        class="form-check-labe text-dark">
                                                                                        <input type="radio"
                                                                                            name="onemony_mode"
                                                                                            value="live"
                                                                                            class="form-check-input">
                                                                                        <?php echo e(__('Live')); ?>

                                                                                    </label>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label for="onemoney_public_key"
                                                                            class="col-form-label"><?php echo e(__('Public Key')); ?></label>
                                                                        <input type="text"
                                                                            name="onemoney_public_key"
                                                                            id="onemoney_public_key"
                                                                            class="form-control"
                                                                            placeholder="<?php echo e(__('Public Key')); ?>">
                                                                    </div>
                                                                </div>
                                                                <div class="col-md-6">
                                                                    <div class="form-group">
                                                                        <label for="onemoney_secret_key"
                                                                            class="col-form-label"><?php echo e(__('Secret Key')); ?></label>
                                                                        <input type="text"
                                                                            name="onemoney_secret_key"
                                                                            id="onemoney_secret_key"
                                                                            class="form-control"
                                                                            placeholder="<?php echo e(__('Private Key')); ?>">
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>

                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>

                            <div class="submit step ">

                                <h3 class="main_question"><strong>6/6</strong>Select Product to import in your store
                                </h3>
                                <div class="row">
                                    <div class="col-4">
                                        <div class="form-group">
                                            <?php echo Form::select('new_product_categorie', $product_categorie, null, [
                                                'class' => 'form-control custom_select multi-select',
                                                'id' => 'new_product_categorie',
                                            ]); ?>

                                        </div>
                                    </div>

                                    <div class="col-4">

                                        <div class="form-group">
                                            <?php echo Form::select('new_product_subcategorie', $product_subcategorie, null, [
                                                'class' => 'product_subcategorie form-control custom_select multi-select',
                                                'id' => 'new_product_subcategorie',
                                            ]); ?>

                                        </div>
                                    </div>




                                    <div class="col-4">

                                        <div class="form-group">
                                            <div class="form-group">
                                                <input type="text" name="search" id="search"
                                                    class="form-control " placeholder="Search Product...">
                                                <?php echo e(Form::label('', '', ['id' => 'store_link', 'class' => 'form-label'])); ?>

                                                <?php echo e(Form::hidden('slug', null, ['class' => 'form-control', 'id' => 'slug', 'placeholder' => __('Enter Store name')])); ?>


                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="table-responsive" style="height: 250px;overflow:auto">
                                    <table class="table mb-0 dataTable">
                                        <thead>
                                            <tr>
                                                <th></th>
                                                <th><?php echo e(__('Products')); ?></th>
                                                <th><?php echo e(__('Category')); ?></th>
                                                <th><?php echo e(__('Sub Category')); ?></th>
                                                <th><?php echo e(__('Price')); ?></th>
                                                <th><?php echo e(__('Quantity')); ?></th>
                                                <th><?php echo e(__('Action')); ?></th>

                                            </tr>
                                        </thead>
                                        <tbody class="product_list">
                                        </tbody>
                                    </table>
                                </div>




                                <div class="col-md-12 p-3">
                                    <button type="button" id="submit_form" class="submit_form btn backward"
                                        name="process">Skip</button>
                                </div>
                            </div>
                            <!-- /step-->
                        </div>
                        <!-- /middle-wizard -->
                        <div id="bottom-wizard">
                            <?php echo e(Form::hidden('themefile', null, ['id' => 'themefile'])); ?>



                            <button type="button" name="backward" class="backward">Prev</button>
                            <button type="button" name="forward" class="forward">Next</button>
                            <button type="button" id="submit_form" name="process"
                                class="submit submit_form">Submit</button>
                        </div>
                        <!-- /bottom-wizard -->
                    </form>
                </div>
                <!-- /Wizard container -->
            </div>
            <!-- /content-right-->
        </div>
        <!-- /row-->
    </div>
    <!-- /container-fluid -->

    <div class="cd-overlay-nav">
        <span></span>
    </div>
    <!-- /cd-overlay-nav -->

    <div class="cd-overlay-content">
        <span></span>
    </div>
    <!-- /cd-overlay-content -->




    <!-- COMMON SCRIPTS -->
    <script src="<?php echo e(asset('assets/register/js/jquery-3.6.3.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/register/js/common_scripts.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/register/js/velocity.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/register/js/functions.js')); ?>"></script>
    <script src="<?php echo e(asset('custom/libs/select2/dist/js/select2.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/plugins/simple-datatables.js')); ?>"></script>
    <!-- Wizard script -->
    <script src="<?php echo e(asset('assets/register/js/survey_func.js')); ?>"></script>
    <script src="https://ajax.aspnetcdn.com/ajax/jquery.validate/1.12.0/jquery.validate.min.js"></script>


    <script>
        // $('.custom_select').select2();
        $('.custom_select').select2({
            width: 'resolve'
        });

        function validateNumber(input) {
            var pattern = /^[0-9]*$/;
            if (!pattern.test(input.value)) {
                input.value = "";
                // alert("Please enter a valid number.");
            }
        }

        $("#currency").change(function() {


            const selectedOption = $(this).find("option:selected");
            const dataId = selectedOption.data("id");
            // alert(dataId);
            $('#currency_symbol').val(dataId);
        });


        $(document).on('click', 'input[name="theme_color"]', function() {
            var eleParent = $(this).attr('data-theme');
            $('#themefile').val(eleParent);
            var imgpath = $(this).attr('data-imgpath');
            $('.' + eleParent + '_img').attr('src', imgpath);
        });

        $(document).ready(function() {

            setTimeout(function(e) {
                var checked = $("input[type=radio][name='theme_color']:checked");
                $('#themefile').val(checked.attr('data-theme'));
                $('.' + checked.attr('data-theme') + '_img').attr('src', checked.attr('data-imgpath'));
            }, 300);
        });

        $(".color1").click(function() {
            var dataId = $(this).attr("data-id");
            $('#' + dataId).trigger('click');
            var first_check = $('#' + dataId).find('.color-0').trigger("click");
        });

        $(".product_subcategorie").change(function() {
            $('#loader_form').show();
            var subcat_id = $(this).val();
            var cat_id = $('#product_categorie').val();

            var new_cat_id = $('#new_product_categorie').val();
            if (new_cat_id != '') {
                cat_id = $('#new_product_categorie').val();
            }

            var new_subcat_id = $('#new_product_subcategorie').val();
            if (new_subcat_id != '') {
                subcat_id = $('#new_product_subcategorie').val();
            }
                symbol = $('#currency_symbol').val();

            $.ajax({
                type: "POST",
                dataType: "JSON",
                url: '<?php echo e(route('categorie.products')); ?>',
                data: {
                    cat_id: cat_id,
                    subcat_id: subcat_id,
                     symbol:symbol
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            }).done(function(msg) {
                if (msg.status == 'success') {
                    $('#loader_form').hide();
                    $('.product_list').html(msg.output);
                    $('#new_product_subcategorie').val(subcat_id);
                    // $('#slug').val(msg.data.slug);
                    $('.custom_select').select2();

                }
            });

        });
        $("#search").on('keyup', function(e) {
            $('#loader_form').show();
            var search = $(this).val();
            var cat_id = $(this).val();
            var subcat_id = $('#product_subcategorie').val();

            var new_cat_id = $('#new_product_categorie').val();
            if (new_cat_id != '') {
                cat_id = $('#new_product_categorie').val();
                subcat_id = $('#new_product_subcategorie').val();
            }

                symbol = $('#currency_symbol').val();


            $.ajax({
                type: "POST",
                dataType: "JSON",
                url: '<?php echo e(route('categorie.products')); ?>',
                data: {
                    cat_id: cat_id,
                    subcat_id: subcat_id,
                    search: search,
                    symbol:symbol
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            }).done(function(msg) {
                if (msg.status == 'success') {
                    $('#loader_form').hide();
                    $('.product_list').html(msg.output);
                    // $('#slug').val(msg.data.slug);
                }
            });
        })
        $("#new_product_categorie").change(function() {
            var cat_id = $(this).val();
            $('#loader_form').show();

            $.ajax({

                url: "<?php echo e(route('get-sub-category')); ?>",
                type: 'POST',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    product_categorie: cat_id
                },
                success: function(data) {
                    $('#loader_form').hide();

                    // $('#sub_category_div').show();
                    $("#new_product_subcategorie").html(
                    '<option value="">Select Sub Category</option>');

                    $.each(data, function(index, val) {
                        $("#new_product_subcategorie").append('<option value="' + index + '">' +
                            val + '</option>');
                    });
                    $('.custom_select').select2();
                }
            })

            var cat_id = $(this).val();
            var subcat_id = $('#product_subcategorie').val();

            var new_cat_id = $('#new_product_categorie').val();
            if (new_cat_id != '') {
                cat_id = $('#new_product_categorie').val();
                subcat_id = $('#new_product_subcategorie').val();
            }
                symbol = $('#currency_symbol').val();



            $.ajax({
                type: "POST",
                dataType: "JSON",
                url: '<?php echo e(route('categorie.products')); ?>',
                data: {
                    cat_id: cat_id,
                    subcat_id: subcat_id,
                    symbol:symbol
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            }).done(function(msg) {
                if (msg.status == 'success') {
                    $('#loader_form').hide();
                    $('.product_list').html(msg.output);
                    // $('#slug').val(msg.data.slug);
                }
            });


        });
        $("#product_categorie").change(function() {
            var cat_id = $(this).val();
            $('#loader_form').show();

            $.ajax({

                url: "<?php echo e(route('get-sub-category')); ?>",
                type: 'POST',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    product_categorie: cat_id
                },
                success: function(data) {
                    $('#loader_form').hide();
                    $('#sub_category_div').show();
                    $("#product_subcategorie").html('<option value="">Select Sub Category</option>');
                    $("#new_product_subcategorie").html('<option value="">Select Sub Category</option>');

                    $.each(data, function(index, val) {
                        $("#product_subcategorie").append('<option value="' + index + '">' +
                            val + '</option>');
                        $("#new_product_subcategorie").append('<option value="' + index + '">' +
                            val + '</option>');
                    });
                    $("#new_product_categorie").val(cat_id);
                    $('.custom_select').select2();
                }
            })


        });




        var v = $('#wrapped').validate({
            errorClass: "my-error-class",
            validClass: "my-valid-class",
            rules: {
                "name": {
                    required: true,
                },
                "email": {
                    required: true,
                    email: true,
                },
                password: {
                    minlength: 8,
                },
                password_confirmation: {
                    minlength: 8,
                    equalTo: "#password"
                },
                th: {
                    required: true,
                }
            },

        });

        $('#name').blur(function() {
            v.element('#name');
        });
        $('#email').blur(function() {
            var email = $(this).val();
            // $('#loader_form').show();
            $.ajax({
                type: "POST",
                dataType: "JSON",
                url: '<?php echo e(route('checkemail')); ?>',
                data: {
                    email: email
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            }).done(function(msg) {
                // $('#loader_form').hide();
                if (msg == 1) {

                    alert('Email Already exist!');

                }
            });
        })


        $('#store_name').on('blur', function(e) {
            var name = $(this).val();
            $.ajax({
                type: "POST",
                dataType: "JSON",
                url: '<?php echo e(route('genrate.store_link')); ?>',
                data: {
                    name: name
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            }).done(function(msg) {
                if (msg.status == 'success') {
                    $('#store_link').html('<strong>Store Link:</strong> ' + msg.data.store_url);
                    $('#slug').val(msg.data.slug);
                }
            });

        })


        function edit_row(no) {
 $("#edit_button" + no).hide();
 $("#save_button" + no).show();
 

 var price = document.getElementById("price_row" + no);
 var quantity = document.getElementById("quantity_row" + no);
//  var age = document.getElementById("age_row" + no);

 var price_data = price.innerHTML;
 var quantity_data = quantity.innerHTML;
//  var age_data = age.innerHTML;

 price.innerHTML =
  "<input type='text' id='price_text" + no + "' class='form-control' value='" + price_data + "'>";
 quantity.innerHTML =
  "<input type='text' class='form-control'  id='quantity_text" +
  no +
  "' value='" +
  quantity_data +
  "'>";
//  age.innerHTML =
//   "<input type='text' id='age_text" + no + "' value='" + age_data + "'>";
}

function save_row(no) {
 var price_val = document.getElementById("price_text" + no).value;
 var quantity_val = document.getElementById("quantity_text" + no).value;
//  var age_val = document.getElementById("age_text" + no).value;
                symbol = $('#currency_symbol').val();
    

     $.ajax({
                type: "POST",
                dataType: "JSON",
                url: '<?php echo e(route('update.product')); ?>',
                data: {
                    product_id: no,
                    price: price_val,
                    quantity: quantity_val,
                    symbol:symbol
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            }).done(function(msg) {
                if (msg.status == 'success') {
                    
                    document.getElementById("price_row" + no).innerHTML = msg.price;
                    document.getElementById("quantity_row" + no).innerHTML = msg.quantity;
                    document.getElementById("edit_button" + no).style.display = "block";
                    document.getElementById("save_button" + no).style.display = "none";
                }else{
                    alert(msg.message);
                }
            });

//  document.getElementById("age_row" + no).innerHTML = age_val;

 

}



        $('.submit_form').on('click', function(e) {
            e.preventDefault();
            $('#loader_form').show();
            var formdata = $("#wrapped").serialize(); // here $(this) refere to the form its submitting
            console.log(formdata);
            // var name = $(this).find('input[name=name]').val();
            var form = $("#wrapped");

            var formData = new FormData(form[0]);

            $.ajax({
                type: "POST",
                dataType: "JSON",
                cache: false,
                contentType: false,
                processData: false,
                url: '<?php echo e(route('register.store')); ?>',
                data: formData,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            }).done(function(msg) {
                if (msg.status == 'success') {
                    $('#loader_form').hide();
                    // alert(msg.message);
                    //show_toastr('Success', msg.message, 'success');
                    location.href = '<?php echo e(url('/dashboard')); ?>';



                } else {
                    $('#loader_form').hide();
                    //show_toastr('Error', msg.message, 'error');

                    alert(msg.message);

                }
            });

        });
    </script>

</body>

</html>
<?php /**PATH /home/nexprism/saas.nexprism.com/resources/views/auth/register.blade.php ENDPATH**/ ?>