<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Product Details')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<?php
    if(!empty(session()->get('lang')))
    {
        $currantLang = session()->get('lang');
    }else{
        $currantLang = $store->lang;
    }
    $languages=\App\Models\Utility::languages();
    $storethemesetting=\App\Models\Utility::demoStoreThemeSetting($store->id,$store->theme_dir);
    $cart = session()->get($store->slug);
    $imgpath=\App\Models\Utility::get_file('uploads/is_cover_image/');
    $main_tax = 0;
    $total = 0;

?>
<nav aria-label="breadcrumb" class="breadcrumb mb-0">
    <div class="container">
        <ol class="d-flex align-items-center mb-0 p-0">
            <li class="breadcrumb-item"><a href="#" class="text-success">Home</a></li>
            <li class="breadcrumb-item active" aria-current="page">Cart</li>
        </ol>
    </div>
</nav>

<section class="py-4 osahan-main-body">
    <div class="container">
        <?php echo e(Form::model($cust_details,array('route' => array('store.customer',$store->slug), 'method' => 'POST'))); ?>

        <div class="row">

            <div class="col-lg-8">
                <div class="accordion" id="accordionExample">

                    <div class="card border-0 osahan-accor rounded shadow-sm overflow-hidden">

                        <div class="card-header bg-white border-0 p-0" id="headingOne">
                            <h2 class="mb-0">
                                <a
                                    class="btn d-flex align-items-center bg-white btn-block text-left btn-lg h5 px-3 py-4 m-0"
                                    type="button" href="<?php echo e(route('store.cart',$store->slug)); ?>">
                                    <span class="c-number">1</span> Cart (<?php echo e(count($products)); ?> items)
                            </a>
                            </h2>
                        </div>

                        <div id="collapseOne" class="collapse " aria-labelledby="headingOne"
                            data-parent="#accordionExample">
                            <div class="card-body p-0 border-top">

                            </div>
                        </div>
                    </div>

                    <div class="card border-0 osahan-accor rounded shadow-sm overflow-hidden mt-3">

                        <div class="card-header bg-white border-0 p-0" id="headingtwo">
                            <h2 class="mb-0">
                                <button
                                    class="btn d-flex align-items-center bg-white btn-block text-left btn-lg h5 px-3 py-4 m-0"
                                    type="button">
                                    <span class="c-number">2</span> Order Address
                                </button>
                            </h2>
                        </div>

                        <div id="collapsetwo" class="collapse show" >
                            <div class="card-body p-0 border-top">
                                <div class="osahan-order_address">
                                    <form method="POST" id="shipping_form">
                                        <?php echo csrf_field(); ?>
                                        <div class="p-3 row">
                                            <div class="customer-info">
                                                <h5><?php echo e(__('Billing information')); ?></h5>
                                                <p><?php echo e(__('Fill the form below so we can send you the orders invoice.')); ?></p>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <?php echo e(Form::label('name',__('First Name'),array("class"=>"form-control-label"))); ?>

                                                        <span style="color:red">*</span>
                                                        <?php echo e(Form::text('name',old('name'),array('class'=>'form-control','placeholder'=>__('Enter Your First Name'),'required'=>'required'))); ?>

                                                    </div>
                                                </div>
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <?php echo e(Form::label('last_name',__('Last Name'),array("class"=>"form-control-label"))); ?>

                                                        <span style="color:red">*</span>
                                                        <?php echo e(Form::text('last_name',old('last_name'),array('class'=>'form-control','placeholder'=>__('Enter Your Last Name'),'required'=>'required'))); ?>

                                                    </div>
                                                </div>
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <?php echo e(Form::label('phone',__('Phone'),array("class"=>"form-control-label"))); ?>

                                                        <span style="color:red">*</span>
                                                        <?php echo e(Form::text('phone',old('phone'),array('class'=>'form-control','placeholder'=>'(99) 12345 67890','required'=>'required'))); ?>

                                                    </div>
                                                </div>
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <?php echo e(Form::label('email',__('Email'),array("class"=>"form-control-label"))); ?>

                                                        <span style="color:red">*</span>
                                                        <?php echo e(Form::email('email',(Utility::CustomerAuthCheck($store->slug) ? Auth::guard('customers')->user()->email : ''),array('class'=>'form-control','placeholder'=>__('Enter Your Email Address')))); ?>

                                                    </div>
                                                </div>
                                                <?php if(!empty($store_payment_setting['custom_field_title_1'])): ?>
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <?php echo e(Form::label('custom_field_title_1',$store_payment_setting['custom_field_title_1'],array("class"=>"form-control-label"))); ?>

                                                        <span style="color:red">*</span>
                                                        <?php echo e(Form::text('custom_field_title_1',old('custom_field_title_1'),array('class'=>'form-control','placeholder'=>'Enter '.$store_payment_setting['custom_field_title_1'],'required'=>'required'))); ?>

                                                    </div>
                                                </div>
                                                <?php endif; ?>
                                                <?php if(!empty($store_payment_setting['custom_field_title_2'])): ?>
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <?php echo e(Form::label('custom_field_title_2',$store_payment_setting['custom_field_title_2'],array("class"=>"form-control-label"))); ?>

                                                        <span style="color:red">*</span>
                                                        <?php echo e(Form::text('custom_field_title_2',old('custom_field_title_2'),array('class'=>'form-control','placeholder'=>'Enter '.$store_payment_setting['custom_field_title_1'],'required'=>'required'))); ?>

                                                    </div>
                                                </div>
                                                <?php endif; ?>
                                                <?php if(!empty($store_payment_setting['custom_field_title_3'])): ?>
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <?php echo e(Form::label('custom_field_title_3',$store_payment_setting['custom_field_title_3'],array("class"=>"form-control-label"))); ?>

                                                        <span style="color:red">*</span>
                                                        <?php echo e(Form::text('custom_field_title_3',old('custom_field_title_3'),array('class'=>'form-control','placeholder'=>'Enter '.$store_payment_setting['custom_field_title_1'],'required'=>'required'))); ?>

                                                    </div>
                                                </div>
                                                <?php endif; ?>
                                                <?php if(!empty($store_payment_setting['custom_field_title_4'])): ?>
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <?php echo e(Form::label('custom_field_title_4',$store_payment_setting['custom_field_title_4'],array("class"=>"form-control-label"))); ?>

                                                        <span style="color:red">*</span>
                                                        <?php echo e(Form::text('custom_field_title_4',old('custom_field_title_4'),array('class'=>'form-control','placeholder'=>'Enter '.$store_payment_setting['custom_field_title_1'],'required'=>'required'))); ?>

                                                    </div>
                                                </div>
                                                <?php endif; ?>
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <?php echo e(Form::label('billingaddress',__('Address'),array("class"=>"form-control-label"))); ?>

                                                        <span style="color:red">*</span>
                                                        <?php echo e(Form::text('billing_address',old('billing_address'),array('class'=>'form-control','placeholder'=>__('Billing Address'),'required'=>'required'))); ?>

                                                    </div>
                                                </div>
                                                
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <?php echo e(Form::label('billing_country',__('Country'),array("class"=>"form-control-label"))); ?>

                                                        <span style="color:red">*</span>

                                                        <?php echo e(Form::text('billing_country',old('billing_country'),array('class'=>'form-control','placeholder'=>__('Billing Country'),'required'=>'required'))); ?>

                                                    </div>
                                                </div>
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <?php echo e(Form::label('billing_city',__('City'),array("class"=>"form-control-label"))); ?>

                                                        <span style="color:red">*</span>
                                                         <?php echo e(Form::text('billing_city',old('billing_city'),array('class'=>'form-control','placeholder'=>__('Billing City'),'required'=>'required'))); ?>



                                                    </div>
                                                </div>
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <?php echo e(Form::label('billing_postalcode',__('Postal Code'),array("class"=>"form-control-label"))); ?>

                                                        <span style="color:red">*</span>
                                                        <?php echo e(Form::text('billing_postalcode',old('billing_postalcode'),array('class'=>'form-control','placeholder'=>__('Billing Postal Code'),'required'=>'required'))); ?>

                                                    </div>
                                                </div>
                                                <?php if($store->enable_shipping == "on" && $shippings->count() > 0): ?>
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <?php echo e(Form::label('location_id',__('Location'),array("class"=>"form-control-label"))); ?>

                                                        <span style="color:red">*</span>
                                                        <?php echo e(Form::select('location_id', $locations, null,array('class' => 'form-control change_location','required'=>'required'))); ?>

                                                    </div>
                                                </div>
                                                <?php endif; ?>
                                                <div class="col-md-12 col-12">
                                                    <div class="row align-items-center">
                                                        <div class="col-md-6 col-12">
                                                            <div class="customer-info">
                                                                <h5><?php echo e(__('Shipping informations')); ?></h5>
                                                                <p><?php echo e(__('Fill the form below so we can send you the orders invoice.')); ?>

                                                                </p>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6 col-12">
                                                            <div class="addres-btn text-right">
                                                                <a class=" btn btn-success" onclick="billing_data()"
                                                                    id="billing_data" data-toggle="tooltip"
                                                                    data-placement="top" title="Same As Billing Address">
                                                                    <span
                                                                        class="btn-inner--text"><?php echo e(__('Copy Address')); ?></span>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-12 col-12">
                                                    <div class="form-group">
                                                        <?php echo e(Form::label('shipping_address',__('Address'),array("class"=>"form-control-label"))); ?>

                                                        <?php echo e(Form::text('shipping_address',old('shipping_address'),array('class'=>'form-control','placeholder'=>__('Shipping Address')))); ?>

                                                    </div>
                                                </div>
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <?php echo e(Form::label('shipping_country',__('Country'),array("class"=>"form-control-label"))); ?>

                                                        <?php echo e(Form::text('shipping_country',old('shipping_country'),array('class'=>'form-control','placeholder'=>__('Shipping Country')))); ?>

                                                    </div>
                                                </div>
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <?php echo e(Form::label('shipping_city',__('City'),array("class"=>"form-control-label"))); ?>

                                                        <?php echo e(Form::text('shipping_city',old('shipping_city'),array('class'=>'form-control','placeholder'=>__('Shipping City')))); ?>

                                                    </div>
                                                </div>
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        <?php echo e(Form::label('shipping_postalcode',__('Postal Code'),array("class"=>"form-control-label"))); ?>

                                                        <?php echo e(Form::text('shipping_postalcode',old('shipping_postalcode'),array('class'=>'form-control','placeholder'=>__('Shipping Postal Code')))); ?>

                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <button class="btn btn-success btn-lg btn-block mt-3" type="submit" id="shipping">Continue</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="card border-0 osahan-accor rounded shadow-sm overflow-hidden mt-3">

                        <div class="card-header bg-white border-0 p-0" id="headingfour">
                            <h2 class="mb-0">
                                <a
                                    class="btn d-flex align-items-center bg-white btn-block text-left btn-lg h5 px-3 py-4 m-0"
                                    href="<?php echo e(route('store-payment.payment',$store->slug)); ?>" >
                                    <span class="c-number">3</span> Payment
                            </a>
                            </h2>
                        </div>

                        <div id="collapsefour" class="collapse" aria-labelledby="headingfour"
                            data-parent="#accordionExample">
                            <div class="card-body px-3 pb-3 pt-1 border-top">
                                <div class="schedule">
                                    <ul class="nav nav-tabs justify-content-center nav-fill" id="myTab"
                                        role="tablist">
                                        <li class="nav-item" role="presentation">
                                            <a class="nav-link active text-dark" id="credit-tab" data-toggle="tab"
                                                href="#credit" role="tab" aria-controls="credit"
                                                aria-selected="true">
                                                <p class="mb-0 font-weight-bold"><i
                                                        class="icofont-credit-card mr-2"></i> Credit/Debit Card</p>
                                            </a>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <a class="nav-link text-dark" id="banking-tab" data-toggle="tab"
                                                href="#banking" role="tab" aria-controls="banking"
                                                aria-selected="false">
                                                <p class="mb-0 font-weight-bold"><i class="icofont-globe mr-2"></i>
                                                    Net Banking</p>
                                            </a>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <a class="nav-link text-dark" id="cash-tab" data-toggle="tab"
                                                href="#cash" role="tab" aria-controls="cash" aria-selected="false">
                                                <p class="mb-0 font-weight-bold"><i class="icofont-dollar mr-2"></i>
                                                    Cash on Delivery</p>
                                            </a>
                                        </li>
                                    </ul>
                                    <div class="tab-content bg-white" id="myTabContent">
                                        <div class="tab-pane fade show active" id="credit" role="tabpanel"
                                            aria-labelledby="credit-tab">
                                            <div class="osahan-card-body pt-3">
                                                <h6 class="m-0">Add new card</h6>
                                                <p class="small">WE ACCEPT <span
                                                        class="osahan-card ml-2 font-weight-bold">( Master Card /
                                                        Visa Card / Rupay )</span></p>
                                                <form>
                                                    <div class="form-row">
                                                        <div class="col-md-12 form-group">
                                                            <label class="form-label font-weight-bold small">Card
                                                                number</label>
                                                            <div class="input-group">
                                                                <input placeholder="Card number" type="number"
                                                                    class="form-control">
                                                                <div class="input-group-append"><button
                                                                        id="button-addon2" type="button"
                                                                        class="btn btn-outline-secondary"><i
                                                                            class="icofont-credit-card"></i></button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-8 form-group"><label
                                                                class="form-label font-weight-bold small">Valid
                                                                through(MM/YY)</label><input
                                                                placeholder="Enter Valid through(MM/YY)"
                                                                type="number" class="form-control"></div>
                                                        <div class="col-md-4 form-group"><label
                                                                class="form-label font-weight-bold small">CVV</label><input
                                                                placeholder="Enter CVV Number" type="number"
                                                                class="form-control"></div>
                                                        <div class="col-md-12 form-group"><label
                                                                class="form-label font-weight-bold small">Name on
                                                                card</label><input placeholder="Enter Card number"
                                                                type="text" class="form-control"></div>
                                                        <div class="col-md-12 form-group">
                                                            <div class="custom-control custom-checkbox">
                                                                <input type="checkbox" id="custom-checkbox1"
                                                                    class="custom-control-input">
                                                                <label title="" type="checkbox"
                                                                    for="custom-checkbox1"
                                                                    class="custom-control-label small pt-1">Securely
                                                                    save this card for a faster checkout next
                                                                    time.</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                        <div class="tab-pane fade" id="banking" role="tabpanel"
                                            aria-labelledby="banking-tab">
                                            <div class="osahan-card-body pt-3">
                                                <form>
                                                    <div class="btn-group btn-group-toggle w-100"
                                                        data-toggle="buttons">
                                                        <label class="btn btn-outline-secondary active">
                                                            <input type="radio" name="options" id="option1"
                                                                checked=""> HDFC
                                                        </label>
                                                        <label class="btn btn-outline-secondary">
                                                            <input type="radio" name="options" id="option2"> ICICI
                                                        </label>
                                                        <label class="btn btn-outline-secondary">
                                                            <input type="radio" name="options" id="option3"> AXIS
                                                        </label>
                                                    </div>
                                                    <div class="form-row pt-3">
                                                        <div class="col-md-12 form-group">
                                                            <label class="form-label small font-weight-bold">Select
                                                                Bank</label><br>
                                                            <select class="custom-select form-control">
                                                                <option>Bank</option>
                                                                <option>KOTAK</option>
                                                                <option>SBI</option>
                                                                <option>UCO</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                        <div class="tab-pane fade" id="cash" role="tabpanel"
                                            aria-labelledby="cash-tab">
                                            <div class="custom-control custom-checkbox pt-3">
                                                <input type="checkbox" class="custom-control-input"
                                                    id="customControlAutosizing">
                                                <label class="custom-control-label" for="customControlAutosizing">
                                                    <b>Cash</b><br>
                                                    <p class="small text-muted m-0">Please keep exact change handy
                                                        to help us serve you better</p>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <a href="checkout.html" class="btn btn-success btn-lg btn-block mt-3"
                                    type="button">Continue</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="sticky_sidebar">
                    <div class="bg-white rounded overflow-hidden shadow-sm mb-3 checkout-sidebar">
                        <?php if(Auth::guard('customers')->check()): ?>
                        <div class="d-flex align-items-center osahan-cart-item-profile border-bottom bg-white p-3">
                            <img alt="<?php echo e(Auth::guard('customers')->user()->name); ?>" src="<?php echo e(Utility::get_file('uploads/customerprofile/'.Auth::guard('customers')->user()->avatar)); ?>" class="mr-3 rounded-circle img-fluid">
                            <div class="d-flex flex-column">
                                <h6 class="mb-1 font-weight-bold"><?php echo e(ucFirst(Auth::guard('customers')->user()->name)); ?></h6>
                            </div>
                        </div>
                        <?php endif; ?>
                        <div class="align-items-center osahan-cart-item-profile border-bottom bg-white p-3">
                                <label for="stripe_coupon"><?php echo e(__('Coupon')); ?></label>
                                <input type="text" id="stripe_coupon" name="coupon" class="form-control coupon hidd_val" placeholder="<?php echo e(__('Enter Coupon Code')); ?>">
                                <input type="hidden" name="coupon" class="form-control hidden_coupon" value="">
                                <div class="apply-stripe-btn-coupon mt-2 ">
                                    <a href="#" class="btn btn-success apply-coupon btn-sm"><?php echo e(__('Apply')); ?></a>
                                </div>
                        </div>
                        <div>

                                <div class="card-body pr-4 pl-4 pb-0 pt-2">
                                    <?php if(!empty($products)): ?>
                                        <?php
                                            $total = 0;
                                            $sub_tax = 0;
                                            $sub_total= 0;
                                        ?>
                                        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if(isset($product['variant_id']) && !empty($product['variant_id'])): ?>
                                                <div class="row delimiter-bottom">
                                                    <div class="col-8">
                                                        <div class="media align-items-center">

                                                            <?php if(!empty($product['image'])): ?>
                                                                <img alt="" src="<?php echo e(asset(Storage::url('uploads/is_cover_image/'.$product['image']))); ?>" class="img-fluid" width="42px">
                                                            <?php else: ?>
                                                                <img alt="" src="<?php echo e(asset(Storage::url('uploads/is_cover_image/default.jpg'))); ?>" class="img-fluid" width="42px">
                                                            <?php endif; ?>
                                                            <div class="media-body p-2">
                                                                <div class="sum-title lh-100">
                                                                    <small class="font-weight-bold mb-0 TTNorms"><?php echo e($product['product_name'].' - ( ' . $product['variant_name'] .' ) '); ?></small>

                                                                </div>
                                                                <?php
                                                                    $total_tax=0;
                                                                ?>
                                                                <small class="text-muted s-dim text-primary">
                                                                    <?php echo e($product['quantity']); ?> x <?php echo e(\App\Models\Utility::priceFormat($product['variant_price'])); ?>

                                                                    <?php if(!empty($product['tax'])): ?>
                                                                        +
                                                                        <?php $__currentLoopData = $product['tax']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <?php
                                                                                $sub_tax = ($product['variant_price'] * $product['quantity'] * $tax['tax']) / 100;
                                                                                $total_tax += $sub_tax;
                                                                            ?>

                                                                            <?php echo e(\App\Models\Utility::priceFormat($sub_tax).' ('.$tax['tax_name'].' '.($tax['tax']).'%)'); ?>

                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php endif; ?>
                                                                </small>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-4 text-right lh-100">
                                                        <small class="text-muted s-dim text-dark"><?php echo e(__('Price')); ?></small>
                                                        <p class="text-dark s-rate t-black15 text-primary s-rate">
                                                            <?php
                                                                $totalprice = $product['variant_price'] * $product['quantity'] + $total_tax;
                                                                $subtotal = $product['variant_price'] * $product['quantity'];
                                                                $sub_total += $subtotal;
                                                            ?>
                                                            <?php echo e(\App\Models\Utility::priceFormat($totalprice)); ?>

                                                        </p>
                                                        <?php
                                                            $total += $totalprice;
                                                        ?>
                                                    </div>
                                                </div>
                                            <?php else: ?>
                                                <div class="row delimiter-bottom">
                                                    <div class="col-8">
                                                        <div class="d-flex  align-items-center">
                                                            <?php if(!empty($product['image'])): ?>
                                                            <img alt="" src="<?php echo e(asset(Storage::url('uploads/is_cover_image/'.$product['image']))); ?>" class="img-fluid" width="42px">
                                                        <?php else: ?>
                                                            <img alt="" src="<?php echo e(asset(Storage::url('uploads/is_cover_image/default.jpg'))); ?>" class="img-fluid"  width="42px">
                                                        <?php endif; ?>
                                                            <div class="media-body p-2">
                                                                <div class="sum-title lh-100">
                                                                    <small class="font-weight-bold mb-0 TTNorms"><?php echo e($product['product_name']); ?></small>
                                                                </div>
                                                                <?php
                                                                    $total_tax=0;
                                                                ?>
                                                                <small class="text-muted s-dim">
                                                                    <?php echo e($product['quantity']); ?> x <?php echo e(\App\Models\Utility::priceFormat($product['price'])); ?>

                                                                    <?php if(!empty($product['tax'])): ?>
                                                                        +
                                                                        <?php $__currentLoopData = $product['tax']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <?php
                                                                                $sub_tax = ($product['price'] * $product['quantity'] * $tax['tax']) / 100;
                                                                                $total_tax += $sub_tax;
                                                                            ?>

                                                                            <?php echo e(\App\Models\Utility::priceFormat($sub_tax).' ('.$tax['tax_name'].' '.($tax['tax']).'%)'); ?>

                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php endif; ?>
                                                                </small>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-4 text-right lh-100">
                                                        <small class="text-muted s-dim text-dark"><?php echo e(__('Price')); ?></small>
                                                        <p class="text-dark s-rate t-black15">
                                                            <?php
                                                                $totalprice = $product['price'] * $product['quantity'] + $total_tax;
                                                                $subtotal = $product['price'] * $product['quantity'];
                                                                $sub_total += $subtotal;
                                                            ?>
                                                            <?php echo e(\App\Models\Utility::priceFormat($totalprice)); ?>

                                                        </p>
                                                        <?php
                                                            $total += $totalprice;
                                                        ?>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                                <div class="card-body pt-0 border-top">
                                    <!-- Tax -->

                                    <?php $__currentLoopData = $taxArr['tax']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k=>$tax): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="row mt-2 pt-2 p-2 border-top">
                                            <div class="col-7 text-right">
                                                <div class="media align-items-center">
                                                    <div class="media-body">
                                                        <div class="text-limit lh-100">
                                                            <small class="font-weight-bold mb-0"><?php echo e($tax); ?></small>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-5 text-right">
                                                <span class="text-sm t-black15"><?php echo e(\App\Models\Utility::priceFormat($taxArr['rate'][$k])); ?></span>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



                                    <!-- Shipping -->
                                    <?php if($store->enable_shipping == "on"): ?>
                                        <div class="shipping_price_add" style="display: none">
                                            <div class="row mt-2 pt-2 p-2 border-top">
                                                <div class="col-7 text-right pt-2">
                                                    <div class="media align-items-center">
                                                        <div class="media-body text-dark">
                                                            <div class="font-weight-bold TTNorms"><?php echo e(__('Shipping Price')); ?> :</div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-5 text-right text-dark"><span class="text-sm font-weight-bold shipping_price" data-value=""></span></div>
                                            </div>
                                        </div>
                                    <?php endif; ?>


                                </div>
                                <?php endif; ?>
                            </div>
                            <div class="bg-white p-3 clearfix">

                                <p class="mb-1">Subtotal (Before Tax) <span class="small text-muted">(<?php echo e($total_item); ?> item)</span> <span
                                        class="float-right text-dark"><?php echo e(\App\Models\Utility::priceFormat(!empty($total)?$total:0)); ?></span></p>



                                <p class="mb-1">Tax : <span class="float-right text-dark"><?php echo e(\App\Models\Utility::priceFormat($main_tax)); ?></span></p>
                                <p class="mb-1">Coupon : <span class="float-right text-dark dicount_price"><?php echo e(\App\Models\Utility::priceFormat(0)); ?></span></p>
                            </div>
                            <div class="p-3 border-top">
                                <input type="hidden" class="product_total" value="<?php echo e($total); ?>">
                                <input type="hidden" class="total_pay_price" value="<?php echo e(App\Models\Utility::priceFormat($total)); ?>">
                                <h5 class="mb-0 ">TO PAY
                                    <span class="final_total_price">
                                        <span class="float-right text-danger pro_total_price"  data-original="<?php echo e(\App\Models\Utility::priceFormat(!empty($total)?$total:0)); ?>"><?php echo e(\App\Models\Utility::priceFormat(!empty($total)?$total:'0')); ?></span>
                                    </span>
                                </h5>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php echo e(Form::close()); ?>

    </div>
</section>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script-page'); ?>


<script src="<?php echo e(asset('assets/theme3/js/swiper.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/theme3/js/purpose.js')); ?>"></script>
<script src="<?php echo e(asset('custom/js/custom.js')); ?>"></script>
<script src="<?php echo e(asset('custom/libs/bootstrap-notify/bootstrap-notify.min.js')); ?>"></script>


<?php echo $__env->yieldPushContent('script-page'); ?>
<?php if(Session::has('success')): ?>
    <script>
        show_toastr('<?php echo e(__('Success')); ?>', '<?php echo session('success'); ?>', 'success');
    </script>
    <?php echo e(Session::forget('success')); ?>

<?php endif; ?>
<?php if(Session::has('error')): ?>
    <script>
        show_toastr('<?php echo e(__('Error')); ?>', '<?php echo session('error'); ?>', 'error');
    </script>
    <?php echo e(Session::forget('error')); ?>

<?php endif; ?>
<?php
    $store_settings = \App\Models\Store::where('slug',$store->slug)->first();
?>
<script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e($store_settings->google_analytic); ?>"></script>
<?php echo $store_settings->storejs; ?>

<script>
    function billing_data() {
        $("[name='shipping_address']").val($("[name='billing_address']").val());
        $("[name='shipping_city']").val($("[name='billing_city']").val());
        $("[name='shipping_state']").val($("[name='billing_state']").val());
        $("[name='shipping_country']").val($("[name='billing_country']").val());
        $("[name='shipping_postalcode']").val($("[name='billing_postalcode']").val());
    }

    $(document).ready(function () {
        $('.change_location').trigger('change');

        setTimeout(function () {
            var shipping_id = $("input[name='shipping_id']:checked").val();
            getTotal(shipping_id);
        }, 200);
    });

    $(document).on('change', '.shipping_mode', function () {
        var shipping_id = this.value;
        getTotal(shipping_id);
    });

    function getTotal(shipping_id) {
        var pro_total_price = $('.pro_total_price').attr('data-original');
        if (shipping_id == undefined) {
            $('.shipping_price_add').hide();
            return false
        } else {
            $('.shipping_price_add').show();
        }

        $.ajax({
            url: '<?php echo e(route('user.shipping', [$store->slug,'_shipping'])); ?>'.replace('_shipping', shipping_id),
            data: {
                "pro_total_price": pro_total_price,
                "_token": "<?php echo e(csrf_token()); ?>",
            },
            method: 'POST',
            context: this,
            dataType: 'json',

            success: function (data) {
                var price = data.price + pro_total_price;
                $('.shipping_price').html(data.price);
                $('.shipping_price').attr('data-value', data.price);
                $('.pro_total_price').html(data.total_price);
            }
        });
    }

    $(document).on('change', '.change_location', function () {
        var location_id = $('.change_location').val();

        if (location_id == 0) {
            $('#location_hide').hide();

        } else {
            $('#location_hide').show();

        }

        $.ajax({
            url: '<?php echo e(route('user.location', [$store->slug,'_location_id'])); ?>'.replace('_location_id', location_id),
            data: {
                "_token": "<?php echo e(csrf_token()); ?>",
            },
            method: 'POST',
            context: this,
            dataType: 'json',

            success: function (data) {
                var html = '';
                var shipping_id = '<?php echo e((isset($cust_details['shipping_id']) ? $cust_details['shipping_id'] : '')); ?>';
                $.each(data.shipping, function (key, value) {
                    var checked = '';
                    if (shipping_id != '' && shipping_id == value.id) {
                        checked = 'checked';
                    }

                    html += '<div class="shipping_location"><input type="radio" name="shipping_id" data-id="' + value.price + '" value="' + value.id + '" id="shipping_price' + key + '" class="shipping_mode" ' + checked + '>' +
                        ' <label name="shipping_label" for="shipping_price' + key + '" class="shipping_label"> ' + value.name + '</label></div>';

                });
                $('#shipping_location_content').html(html);
            }
        });
    });

    $(document).on('click', '.apply-coupon', function (e) {
        e.preventDefault();

        var ele = $(this);
        var coupon = ele.closest('.row').find('.coupon').val();
        var hidden_field = $('.hidden_coupon').val();
        var price = $('#card-summary .product_total').val();
        var shipping_price = $('#card-summary .shipping_price').attr('data-value');

        if (coupon == hidden_field && coupon != "") {
            show_toastr('Error', 'Coupon Already Used', 'error');
        } else {
            if (coupon != '') {
                $.ajax({
                    url: '<?php echo e(route('apply.productcoupon')); ?>',
                    datType: 'json',
                    data: {
                        price: price,
                        shipping_price: shipping_price,
                        store_id: <?php echo e($store->id); ?>,
                        coupon: coupon
                    },
                    success: function (data) {
                        $('#stripe_coupon, #paypal_coupon').val(coupon);
                        if (data.is_success) {
                            $('.hidden_coupon').val(coupon);
                            $('.hidden_coupon').attr(data);

                            $('.dicount_price').html(data.discount_price);

                            var html = '';
                            html += '<span class="float-right text-danger pro_total_price" data-original="' + data.final_price_data_value + '">' + data.final_price + '</span>'
                            $('.final_total_price').html(html);


                            // $('.coupon-tr').show().find('.coupon-price').text(data.discount_price);
                            // $('.final-price').text(data.final_price);
                            show_toastr('Success', data.message, 'success');
                        } else {
                            // $('.coupon-tr').hide().find('.coupon-price').text('');
                            // $('.final-price').text(data.final_price);
                            show_toastr('Error', data.message, 'error');
                        }
                    }
                })
            } else {
                $.ajax({
                        url: '<?php echo e(route('apply.removecoupn')); ?>',
                        datType: 'json',
                        data: {
                            price: "price",
                            shipping_price: "shipping_price",
                            slug:<?php echo e($store->id); ?> ,
                            coupon: "coupon"
                        },
                        success: function (data) {
                        }
                    });
                    var hidd_cou = $('.hidd_val').val();

                    if(hidd_cou == ""){
                       var total_pa_val =  $(".total_pay_price").val();
                       $(".final_total_price").html(total_pa_val);
                       $(".dicount_price").html(0.00);

                    }
                    show_toastr('Error', '<?php echo e(__('Invalid Coupon Code.')); ?>', 'error');
            }
        }

    });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('storefront.layout.theme', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp\www\company\saas\resources\views/storefront/theme/shipping.blade.php ENDPATH**/ ?>