
    
            <?php if(!empty($service->logo)): ?>
                <div class="logo-content mt-4 d-flex justify-content-center">
                    <img id="app-dark-logo" class="rounded-circle-avatar"
                        src="<?php echo e(asset('storage/uploads/service_logo/' . $service->logo)); ?>" alt="form_logo">
                </div>
            <?php endif; ?>
            <div class="card mt-3">
                <div class="card-header">
                    <h4 class="text-center w-100"><?php echo e($service->title); ?></h4>
                </div>
                <div class="card-body">
                    <form action="<?php echo e(route('service.form.fill.store', $service->id)); ?>" method="POST"
                        enctype="multipart/form-data" id="fill-form">
                        <?php echo method_field('PUT'); ?>
                        <?php if(session()->has('success')): ?>
                            <div class="text-center gallery" id="success_loader">
                                <img src="<?php echo e(asset('assets/images/success.gif')); ?>" />
                                <br>
                                <br>
                                <h2 class="w-100 "><?php echo e(session()->get('success')); ?></h2>
                            </div>
                        <?php else: ?>
                            <?php $__currentLoopData = $array; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $keys => $rows): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="tab">
                                    <div class="row">
                                        <?php $__currentLoopData = $rows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row_key => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                if (isset($row->column)) {
                                                    if ($row->column == 1) {
                                                        $col = 'col-12 step-' . $keys;
                                                    } elseif ($row->column == 2) {
                                                        $col = 'col-6 step-' . $keys;
                                                    } elseif ($row->column == 3) {
                                                        $col = 'col-4 step-' . $keys;
                                                    }
                                                } else {
                                                    $col = 'col-12 step-' . $keys;
                                                }
                                            ?>
                                            <?php if($row->type == 'checkbox-group'): ?>
                                                <div class="form-group <?php echo e($col); ?> ">
                                                    <?php echo e(Form::label($row->name, $row->label . ($row->required ? ' *' : ''), ['class' => 'd-block'])); ?>

                                                    <?php if(isset($row->description)): ?>
                                                        <small class="d-block"><?php echo e($row->description); ?></small>
                                                    <?php endif; ?>
                                                    <?php $__currentLoopData = $row->values; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $options): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php
                                                            $attr = ['class' => 'custom-control-input', 'id' => $row->name . '_' . $key];
                                                            $attr['name'] = $row->name . '[]';
                                                            if ($row->required) {
                                                                $attr['required'] = 'required';
                                                                $attr['class'] = $attr['class'] . ' required';
                                                            }
                                                            if ($row->inline) {
                                                                $class = 'form-check form-check-inline col-4 ';
                                                                if ($row->required) {
                                                                    $attr['class'] = 'custom-check-input required';
                                                                } else {
                                                                    $attr['class'] = 'custom-check-input';
                                                                }
                                                                $l_class = 'custom-check-label mb-0 ml-1';
                                                            } else {
                                                                $class = 'custom-control custom-checkbox';
                                                                if ($row->required) {
                                                                    $attr['class'] = 'custom-control-input required';
                                                                } else {
                                                                    $attr['class'] = 'custom-control-input';
                                                                }
                                                                $l_class = 'custom-control-label';
                                                            }
                                                        ?>
                                                        <div class="<?php echo e($class); ?>">
                                                            <?php echo e(Form::checkbox($row->name,$options->value,isset($options->selected) && $options->selected == 1 ? true : false,$attr)); ?>

                                                            <label class="<?php echo e($l_class); ?>"
                                                                for="<?php echo e($row->name . '_' . $key); ?>"><?php echo e($options->label); ?></label>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($row->required): ?>
                                                        <label class="required-msg" style="color:red"></label>
                                                    <?php endif; ?>
                                                </div>
                                            <?php elseif($row->type == 'file'): ?>
                                                <?php
                                                    $attr = [];
                                                    $attr['class'] = 'form-control';
                                                    if (isset($row->multiple)) {
                                                        $attr['multiple'] = 'true';
                                                        $attr['name'] = $row->name . '[]';
                                                    }
                                                    if (isset($row->required) && (!isset($row->value) || empty($row->value))) {
                                                        $attr['required'] = 'required';
                                                        $attr['class'] = $attr['class'] . ' required';
                                                    }
                                                ?>
                                                <div class="form-group <?php echo e($col); ?>">
                                                    <?php echo e(Form::label($row->name, $row->label)); ?><?php if($row->required): ?>
                                                        *
                                                    <?php endif; ?>
                                                    <?php echo e(Form::file($row->name, $attr)); ?>

                                                    <?php if(isset($row->description)): ?>
                                                        <small><?php echo e($row->description); ?></small>
                                                    <?php endif; ?>
                                                    <div>
                                                        <?php if(isset($row->value)): ?>
                                                            <?php if(is_array($row->value)): ?>
                                                                <div class="row">
                                                                    <?php $__currentLoopData = $row->value; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <div class="col-3">
                                                                            <img src="<?php echo e(Storage::url($img)); ?>"
                                                                                class="img-responsive img-thumbnail mb-2">
                                                                        </div>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </div>
                                                            <?php endif; ?>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            <?php elseif($row->type == 'header'): ?>
                                                <?php
                                                    $class = '';
                                                    if (isset($row->className)) {
                                                        $class = $class . ' ' . $row->className;
                                                    }
                                                ?>
                                                <div class="<?php echo e($col); ?>">
                                                    <<?php echo e($row->subtype); ?> class="<?php echo e($class); ?>">
                                                        <?php echo e($row->label); ?>

                                                        </<?php echo e($row->subtype); ?>>
                                                </div>
                                            <?php elseif($row->type == 'paragraph'): ?>
                                                <?php
                                                    $class = '';
                                                    if (isset($row->className)) {
                                                        $class = $class . ' ' . $row->className;
                                                    }
                                                ?>
                                                <div class="<?php echo e($col); ?>">
                                                    <<?php echo e($row->subtype); ?> class="<?php echo e($class); ?>">
                                                        <?php echo e($row->label); ?>

                                                        </<?php echo e($row->subtype); ?>>
                                                </div>
                                            <?php elseif($row->type == 'radio-group'): ?>
                                                <div class="form-group <?php echo e($col); ?>">
                                                    <?php echo e(Form::label($row->name, $row->label . ($row->required ? ' *' : ''), ['class' => 'd-block'])); ?>

                                                    <?php if(isset($row->description)): ?>
                                                        <small class="d-block"><?php echo e($row->description); ?></small>
                                                    <?php endif; ?>
                                                    <?php $__currentLoopData = $row->values; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $options): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <?php
                                                            // $attr = ['class' => 'custom-control-input', 'id' => $row->name . '_' . $key];
                                                            if ($row->required) {
                                                                $attr['required'] = 'required';
                                                                $attr = ['class' => 'custom-control-input required', 'required' => 'required', 'id' => $row->name . '_' . $key];
                                                            } else {
                                                                $attr = ['class' => 'custom-control-input', 'id' => $row->name . '_' . $key];
                                                            }
                                                            if ($row->inline) {
                                                                $class = 'form-check form-check-inline ';
                                                                if ($row->required) {
                                                                    $attr['class'] = 'custom-check-input required';
                                                                } else {
                                                                    $attr['class'] = 'custom-check-input';
                                                                }
                                                                $l_class = 'custom-check-label mb-0 ml-1';
                                                            } else {
                                                                $class = 'custom-control custom-radio';
                                                                if ($row->required) {
                                                                    $attr['class'] = 'custom-control-input required';
                                                                } else {
                                                                    $attr['class'] = 'custom-control-input';
                                                                }
                                                                $l_class = 'custom-control-label';
                                                            }
                                                        ?>
                                                        <div class=" <?php echo e($class); ?>">
                                                            <?php echo e(Form::radio($row->name,$options->value,isset($options->selected) && $options->selected ? true : false,$attr)); ?>

                                                            <label class="<?php echo e($l_class); ?>"
                                                                for="<?php echo e($row->name . '_' . $key); ?>"><?php echo e($options->label); ?></label>
                                                        </div>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                    <?php if($row->required): ?>
                                                        <label class="required-msg" style="color:red"></label>
                                                    <?php endif; ?>
                                                </div>
                                            <?php elseif($row->type == 'select' || $row->type == 'autocomplete'): ?>
                                                <div class="form-group <?php echo e($col); ?>">
                                                    <?php
                                                        $attr = ['class' => 'form-control custom_select w-100', 'id' => $row->name];
                                                        if ($row->required) {
                                                            $attr['required'] = 'required';
                                                            $attr['class'] = $attr['class'] . ' required';
                                                        }
                                                        if (isset($row->multiple) && !empty($row->multiple)) {
                                                            $attr['multiple'] = 'true';
                                                            $attr['name'] = $row->name . '[]';
                                                        }
                                                        if (isset($row->className) && $row->className == 'calculate') {
                                                            $attr['class'] = $attr['class'] . ' ' . $row->className;
                                                        }
                                                        if ($row->label == 'Registration') {
                                                            $attr['class'] = $attr['class'] . ' registration';
                                                        }
                                                        if (isset($row->is_parent) && $row->is_parent == 'true') {
                                                            $attr['class'] = $attr['class'] . ' parent';
                                                            $attr['data-number-of-control'] = isset($row->number_of_control) ? $row->number_of_control : 1;
                                                        }
                                                        $values = [];
                                                        $selected = [];
                                                        foreach ($row->values as $options) {
                                                            $values[$options->value] = $options->label;
                                                            if (isset($options->selected)) {
                                                                $selected[] = $options->value;
                                                            }
                                                        }
                                                    ?>
                                                    <?php if(isset($row->is_parent) && $row->is_parent == 'true'): ?>
                                                        <?php echo e(Form::label($row->name, $row->label)); ?><?php if($row->required): ?>
                                                            *
                                                        <?php endif; ?>
                                                        <div class="input-group">
                                                            <?php echo e(Form::select($row->name, $values, $selected, $attr)); ?>

                                                            <div class="input-group-append">
                                                                <button type="button"
                                                                    class="btn btn-outline-primary open-photo"><?php echo e(__('Add Photo')); ?></button>
                                                            </div>
                                                        </div>
                                                    <?php else: ?>
                                                        <?php echo e(Form::label($row->name, $row->label)); ?><?php if($row->required): ?>
                                                            *
                                                        <?php endif; ?>
                                                        <?php echo e(Form::select($row->name, $values, $selected, $attr)); ?>

                                                    <?php endif; ?>
                                                    <?php if($row->label == 'Registration'): ?>
                                                        <span class="text-warning registration-message"></span>
                                                    <?php endif; ?>
                                                </div>
                                            <?php elseif($row->type == 'date'): ?>
                                                <div class="form-group <?php echo e($col); ?>">
                                                    <?php
                                                        $attr = ['class' => 'form-control'];
                                                        if ($row->required) {
                                                            $attr['required'] = 'required';
                                                            $attr['class'] = $attr['class'] . ' required';
                                                        }
                                                    ?>
                                                    <?php echo e(Form::label($row->name, $row->label)); ?><?php if($row->required): ?>
                                                        *
                                                    <?php endif; ?>
                                                    <?php echo e(Form::date($row->name, isset($row->value) ? $row->value : null, $attr)); ?>

                                                    <?php if(isset($row->description)): ?>
                                                        <small><?php echo e($row->description); ?></small>
                                                    <?php endif; ?>
                                                </div>
                                            <?php elseif($row->type == 'hidden'): ?>
                                                <div class="form-group <?php echo e($col); ?>">
                                                    <?php echo e(Form::hidden($row->name, isset($row->value) ? $row->value : null)); ?>

                                                </div>
                                            <?php elseif($row->type == 'number'): ?>
                                                <div class="form-group <?php echo e($col); ?>">
                                                    <?php
                                                        $attr = ['class' => 'form-control'];
                                                        if ($row->required) {
                                                            $attr['required'] = 'required';
                                                            $attr['class'] = $attr['class'] . ' required';
                                                        }
                                                    ?>
                                                    <?php echo e(Form::label($row->name, $row->label)); ?>

                                                    <?php if($row->required): ?>
                                                        *
                                                    <?php endif; ?>
                                                    <?php echo e(Form::number($row->name, isset($row->value) ? $row->value : null, $attr)); ?>

                                                </div>
                                            <?php elseif($row->type == 'textarea'): ?>
                                                <div class="form-group <?php echo e($col); ?>">
                                                    <?php
                                                        $attr = ['class' => 'form-control text-area-height'];
                                                        if ($row->required) {
                                                            $attr['required'] = 'required';
                                                            $attr['class'] = $attr['class'] . ' required';
                                                        }
                                                        if (isset($row->rows)) {
                                                            $attr['rows'] = $row->rows;
                                                        } else {
                                                            $attr['rows'] = '3';
                                                        }

                                                        if ($row->subtype == 'ckeditor') {
                                                            $attr['class'] = $attr['class'] . ' ck_editor';
                                                        }
                                                    ?>
                                                    <?php echo e(Form::label($row->name, $row->label)); ?>

                                                    <?php echo e(Form::textarea($row->name, isset($row->value) ? $row->value : null, $attr)); ?>

                                                </div>
                                            <?php elseif($row->type == 'button'): ?>
                                                <div class="form-group <?php echo e($col); ?>">
                                                    <?php echo e(Form::button(__($row->label), ['name' => $row->name,'type' => $row->subtype,'class' => $row->className,'id' => $row->name])); ?>

                                                </div>
                                            <?php elseif($row->type == 'text'): ?>
                                                <div class="form-group <?php echo e($col); ?>">
                                                    <?php
                                                        $attr = ['class' => 'form-control'];
                                                        if ($row->required) {
                                                            $attr['required'] = 'required';
                                                            $attr['class'] = $attr['class'] . ' required';
                                                        }
                                                        if (isset($row->maxlength)) {
                                                            $attr['max'] = $row->maxlength;
                                                        }
                                                        if (isset($row->placeholder)) {
                                                            $attr['placeholder'] = $row->placeholder;
                                                        }
                                                        $value = isset($row->value) ? $row->value : '';
                                                        if ($row->subtype == 'datetime-local') {
                                                            $row->subtype = 'text';
                                                            $attr['class'] = $attr['class'] . ' date_time';
                                                        }
                                                    ?>
                                                    <?php echo e(Form::label($row->name, $row->label)); ?><?php if($row->required): ?>
                                                        *
                                                    <?php endif; ?>
                                                    <?php echo e(Form::input($row->subtype, $row->name, $value, $attr)); ?>

                                                    <?php if(isset($row->description)): ?>
                                                        <small><?php echo e($row->description); ?></small>
                                                    <?php endif; ?>
                                                    <?php if( $row->subtype='tel'): ?>
                                                        <label class="required-msg" style="color:red"></label>
                                                    <?php endif; ?>
                                                </div>
                                            <?php elseif($row->type == 'starRating'): ?>
                                                <div class="form-group <?php echo e($col); ?>">
                                                    <?php
                                                        $value = isset($row->value) ? $row->value : 0;
                                                        $num_of_star = isset($row->number_of_star) ? $row->number_of_star : 5;
                                                    ?>
                                                    <?php echo e(Form::label($row->name, $row->label)); ?><?php if($row->required): ?>
                                                        *
                                                    <?php endif; ?>
                                                    <div id="<?php echo e($row->name); ?>" class="starRating"
                                                        data-value="<?php echo e($value); ?>"
                                                        data-num_of_star="<?php echo e($num_of_star); ?>">
                                                    </div>
                                                    <input type="hidden" name="<?php echo e($row->name); ?>"
                                                        value="<?php echo e($value); ?>" class="calculate"
                                                        data-star="<?php echo e($num_of_star); ?>">
                                                </div>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php if(!isset($form_value) && $service->payment_status == 1): ?>
                                <?php if(!isset($form_value) && $service->payment_type == 'stripe'): ?>
                                    <div class="strip">
                                        <strong class="d-block"><?php echo e(__('Payment')); ?>

                                            (<?php echo e($service->currency_symbol); ?><?php echo e($service->amount); ?>)</strong>
                                        <div id="card-element" class="form-control">
                                            <!-- a Stripe Element will be inserted here. -->
                                        </div>
                                        <span id="card-errors" class="payment-errors"
                                            style="color: red; font-size: 22px; "></span>
                                        <br>
                                    </div>
                                <?php elseif(!isset($form_value) && $service->payment_type == 'razorpay'): ?>
                                    <div class="razorpay">
                                        <p><?php echo e(__('Make Payment')); ?></p>
                                        <input type="hidden" name="payment_id" id="payment_id">
                                        <h5><?php echo e(__('Payable Amount')); ?> : <?php echo e($service->currency_symbol); ?>

                                            <?php echo e($service->amount); ?></h5>
                                    </div>
                                <?php elseif(!isset($form_value) && $service->payment_type == 'paypal'): ?>
                                    <div class="paypal">
                                        <p><?php echo e(__('Make Payment')); ?></p>
                                        <input type="hidden" name="payment_id" id="payment_id">
                                        <h5><?php echo e(__('Payable Amount')); ?> : <?php echo e($service->currency_symbol); ?>

                                            <?php echo e($service->amount); ?></h5>
                                            <div id="paypal-button-container"></div>
                                            <span id="paypal-errors" class="payment-errors"
                                            style="color: red; font-size: 22px; "></span>
                                        <br>

                                    </div>
                                <?php endif; ?>
                            <?php endif; ?>
                            <div class="row">
                                <div class="col cap">
                                    <div class="form-actions pb-0 mt-3">
                                        <input type="hidden" name="form_value_id"
                                            value="<?php echo e(isset($form_value) ? $form_value->id : ''); ?>"
                                            id="form_value_id">
                                    </div>
                                </div>
                            </div>
                            <div style="overflow:auto;">
                                <div style="float:right;">
                                    <button type="button" class="btn btn-default" id="prevBtn"
                                        onclick="nextPrev(-1)"><?php echo e(__('Previous')); ?></button>
                                    <button type="button" class="btn btn-primary" id="nextBtn"
                                        onclick="nextPrev(1)"><?php echo e(__('Next')); ?></button>
                                </div>
                            </div>
                            <!-- Circles which indicates the steps of the form: -->
                            <div style="text-align:center;margin-top:40px;">
                                <?php $__currentLoopData = $array; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $keys => $rows): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <span class="step"></span>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        <?php endif; ?>
                        <?php echo e(Form::close()); ?>

                </div>
            </div>
        </div>
  
<?php /**PATH C:\laragon\www\saas\resources\views/service/multi_form.blade.php ENDPATH**/ ?>