<?php $__env->startSection('page-title'); ?>
<?php echo e(__('Product Details')); ?>

<?php $__env->stopSection(); ?>
<?php
$imgpath=\App\Models\Utility::get_file('uploads/product_image/');
$proimg=\App\Models\Utility::get_file('uploads/is_cover_image/');

?>
<?php $__env->startSection('content'); ?>

<nav aria-label="breadcrumb" class="breadcrumb mb-0">
    <div class="container">
        <ol class="d-flex align-items-center mb-0 p-0">
            <li class="breadcrumb-item"><a href="<?php echo e(route('store.slug',$store->slug)); ?>" class="text-success"><?php echo e(__('Home')); ?></a></li>
            <li class="breadcrumb-item active" aria-current="page"><?php echo e($products->name); ?></li>
        </ol>
    </div>
</nav>

<section class="py-4 osahan-main-body">
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <div class="recommend-slider mb-3">
                    <?php $__currentLoopData = $products_image; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $productss): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="osahan-slider-item">
                        <?php if(!empty($products_image[$key]->product_images) &&
                        \Storage::exists('uploads/product_image/'.$products_image[$key]->product_images)): ?>
                            <img src="<?php echo e($imgpath.$products_image[$key]->product_images); ?>" class="img-fluid mx-auto shadow-sm rounded" data-remote="<?php echo e($imgpath.$products_image[$key]->product_images); ?>"
                            data-type="image" data-toggle="lightbox" data-gallery="example-gallery"
                            alt="Responsive image">
                        <?php else: ?>
                            <img src="<?php echo e(asset(Storage::url('uploads/product_image/default.jpg'))); ?>" class="img-fluid mx-auto shadow-sm rounded" data-remote="<?php echo e(asset(Storage::url('uploads/product_image/default.jpg'))); ?>"
                            data-type="image" data-toggle="lightbox" data-gallery="example-gallery"
                            alt="Responsive image">
                        <?php endif; ?>

                    </div>

                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="pd-f d-flex align-items-center mb-3">
                    <a href="#" class="btn btn-warning p-3 rounded btn-block d-flex align-items-center justify-content-center mr-3 btn-lg add_to_cart"
                         data-id="<?php echo e($products->id); ?>">
                         <i class="icofont-plus m-0 mr-2"></i> <?php echo e(__('ADD TO CART')); ?></a>
                    <a href="#" data-id="<?php echo e($products->id); ?>"
                        class="btn btn-success p-3 rounded btn-block d-flex align-items-center justify-content-center btn-lg m-0 add_to_cart_Buy"><i
                            class="icofont-cart m-0 mr-2" ></i> <?php echo e(__('BUY NOW')); ?></a>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="p-4 bg-white rounded shadow-sm">
                    <div class="pt-0">
                        <h2 class="font-weight-bold"><?php echo e($products->name); ?></h2>
                        <p class="font-weight-light text-dark m-0 d-flex align-items-center">
                            Product MRP :
                                <b class="h6 text-dark m-0 variation_price">
                                <?php if($products->enable_product_variant =='on'): ?>
                                <?php echo e(\App\Models\Utility::priceFormat(0)); ?>

                                <?php else: ?>
                                    <?php echo e(\App\Models\Utility::priceFormat($products->price)); ?> /
                                    <del class="mb-0 sub-price text-muted"><?php echo e(\App\Models\Utility::priceFormat($products->last_price)); ?></del>
                                <?php endif; ?>
                                </b>

                        </p>
                        <a href="#">

                            <?php if($store_setting->enable_rating == 'on'): ?>
                            <div class="rating-wrap d-flex align-items-center mt-2">
                                <ul class="rating-stars list-unstyled">
                                    <li>
                                        <?php for($i =1;$i<=5;$i++): ?> <?php $icon='fa-star' ; $color='' ; $newVal1=($i-0.5); if($avg_rating < $i &&
                                        $avg_rating>= $newVal1)
                                        {
                                            $icon = 'fa-star-half-alt';
                                        }
                                        if($avg_rating >= $newVal1)
                                        {
                                            $color = 'text-warning';
                                        }
                                        ?>
                                        <i class="icofont-star <?php echo e($icon .' '. $color); ?>"></i>
                                        <?php endfor; ?>
                                    </li>
                                </ul>
                                <p class="label-rating text-muted ml-2 small"> <?php echo e($avg_rating); ?>/5 (<?php echo e($user_count); ?>  <?php echo e(__('reviews')); ?>)</p>
                            </div>
                            <?php endif; ?>
                        </a>
                    </div>
                    
                    <?php if($products->enable_product_variant =='on'): ?>
                    <input type="hidden" id="product_id" value="<?php echo e($products->id); ?>">
                    <input type="hidden" id="variant_id" value="">
                    <input type="hidden" id="variant_qty" value="">
                    <div class="p-color mt-3">
                        <p class="font-weight-bold mb-2"><?php echo e(__('VARIATION')); ?>:</p>
                        <?php $__currentLoopData = $product_variant_names; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $variant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-sm-6 mb-4 mb-sm-0">
                            <p class="d-block h6 mb-0 mt-2">
                                <table>
                                    <tr>
                                        <td> <p class="mb-0 pr-3"><?php echo e($variant->variant_name); ?></p></td>
                                        <td>
                                            <select name="product[<?php echo e($key); ?>]" id="pro_variants_name" class="form-control custom-select variant-selection  pro_variants_name<?php echo e($key); ?>">
                                                <?php $__currentLoopData = $variant->variant_options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $values): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($values); ?>"><?php echo e($values); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </td>
                                    </tr>
                                </table>


                                </span>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                    <?php endif; ?>
                     <div class="details">
                        <div class="pt-3">

                            <p class="font-weight-bold mb-2"><?php echo e(__('Product Details')); ?></p>
                            <p class="text-muted small mb-0"><?php echo $products->description; ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <h5 class="mt-3 mb-3"><?php echo e(__('Related products')); ?></h5>
        <div class="row">
            <?php $__currentLoopData = $all_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($product->id != $products->id): ?>
                    <div class="col-sm-3 col-md-3 mb-3">
                        <div class="list-card bg-white h-100 rounded overflow-hidden position-relative shadow-sm">
                            <div class="list-card-image">
                                <a href="<?php echo e(route('store.product.product_view',[$store->slug,$product->id])); ?>" class="text-dark">
                                    <div class="member-plan position-absolute"><span class="badge m-3 badge-danger">10%</span>
                                    </div>
                                    <div class="p-3">
                                        <?php if(!empty($product->is_cover) &&
                                        \Storage::exists('uploads/is_cover_image/'.$product->is_cover)): ?>
                                        <img class="img-fluid item-img w-100 mb-3"
                                            src="<?php echo e($proimg.$product->is_cover); ?>" alt="New collection" title="New collection">
                                        <?php else: ?>
                                        <img class="img-fluid item-img w-100 mb-3"
                                            src="<?php echo e(asset(Storage::url('uploads/is_cover_image/default.jpg'))); ?>"
                                            alt="New collection" title="New collection">
                                        <?php endif; ?>
                                        <h6><?php echo e($product['name']); ?></h6>
                                        <div class="d-flex align-items-center">
                                            <?php if($product['enable_product_variant'] != 'on'): ?>
                                                <h6 class="price m-0 text-success"><?php echo e(\App\Models\Utility::priceFormat($product->price)); ?></h6>


                                                <a data-toggle="collapse" href="#" role="button"
                                                data-id="<?php echo e($product['id']); ?>"
                                                    class="btn btn-success btn-sm ml-auto add_to_cart">
                                                    +
                                                </a>
                                            <?php else: ?>
                                            <h6 class="price m-0 text-success"><?php echo e(__('In Variant')); ?></h6>


                                            <a  href="<?php echo e(route('store.product.product_view', [$store->slug, $product['id']])); ?>" role="button"
                                            data-id="<?php echo e($product['id']); ?>"
                                                class="btn btn-success btn-sm ml-auto">
                                                +
                                            </a>
                                            <?php endif; ?>

                                        </div>
                                    </div>
                                </a>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

    </div>
</section>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('script-page'); ?>
<script>



    $(document).on('change', '#pro_variants_name', function () {
        var variants = [];
        $(".variant-selection").each(function (index, element) {
            variants.push(element.value);
        });
        if (variants.length > 0) {
            $.ajax({
                url: '<?php echo e(route('get.products.variant.quantity')); ?>',
                data: {
                    "_token": $('meta[name="csrf-token"]').attr('content'),
                    variants: variants.join(' : '),
                    product_id: $('#product_id').val()
                },

                success: function (data) {
                    $('.variation_price').html(data.price);
                    $('#variant_id').val(data.variant_id);
                    $('#variant_qty').val(data.quantity);
                }
            });
        }
    });
    $("#pro_variants_name").trigger("change");



        $(".add_to_cart_Buy").click(function(e) {
            e.preventDefault();
            var id = $(this).attr('data-id');
            var variants = [];
            $(".variant-selection").each(function(index, element) {
                variants.push(element.value);
            });

            if (jQuery.inArray('', variants) != -1) {
                show_toastr('Error', "<?php echo e(__('Please select all option.')); ?>", 'error');
                return false;
            }
            var variation_ids = $('#variant_id').val();

            $.ajax({
                url: '<?php echo e(route('user.addToCart', ['__product_id', $store->slug, 'variation_id'])); ?>'.replace(
                    '__product_id', id).replace('variation_id', variation_ids ?? 0),
                type: "POST",
                data: {
                    "_token": "<?php echo e(csrf_token()); ?>",
                    variants: variants.join(' : '),
                },
                success: function(response) {
                    if (response.status == "Success") {
                        show_toastr('Success', response.success, 'success');
                        $("#shoping_counts").html(response.item_count);
                        window.location.href = "<?php echo e(route('store.cart', $store->slug)); ?>";

                    } else {
                        show_toastr('Error', response.error, 'error');
                    }
                },
                error: function(result) {
                    console.log('error');
                }
            });
        });
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('storefront.layout.theme', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp\www\company\saas\resources\views/storefront/theme/view.blade.php ENDPATH**/ ?>