<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Import  Product')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('title'); ?>
    <div class="d-inline-block">
        <h5 class="h4 d-inline-block text-white font-weight-bold mb-0 "><?php echo e(__('Import Product')); ?></h5>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Home')); ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('Import Existing Product')); ?></li>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('action-btn'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('filter'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<?php echo e(Form::open(['method' => 'POST', 'route' => 'import.product', 'id' => 'frmTvfvarget', 'enctype' => 'multipart/form-data'])); ?>

    <div class="row">
                                    <div class="col-4">
                                        <div class="form-group">
                                            <?php echo Form::select('new_product_categorie', $product_categorie, null, [
                                                'class' => 'form-control custom_select multi-select',
                                                'id' => 'new_product_categorie',
                                            ]); ?>

                                        </div>
                                    </div>

                                    <div class="col-4">

                                        <div class="form-group">
                                            <?php echo Form::select('new_product_subcategorie', $product_subcategorie, null, [
                                                'class' => 'product_subcategorie form-control custom_select multi-select',
                                                'id' => 'new_product_subcategorie',
                                            ]); ?>

                                        </div>
                                    </div>




                                    <div class="col-4">

                                        <div class="form-group">
                                            <div class="form-group">
                                                <input type="text" name="search" id="search"
                                                    class="form-control " placeholder="Search Product...">
                                                <?php echo e(Form::label('', '', ['id' => 'store_link', 'class' => 'form-label'])); ?>

                                                <?php echo e(Form::hidden('slug', null, ['class' => 'form-control', 'id' => 'slug', 'placeholder' => __('Enter Store name')])); ?>


                                            </div>
                                        </div>
                                    </div>
                                </div>

    <div class="row product_list">
        <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        
            <div class="col-lg-3 col-sm-6 col-md-6">
                <div class="card text-white text-center">
                    <div class="card-header border-0 pb-0">
                        <div class="card-header-right">
                            <div class="btn-group card-option">
                                <div class="form-check  mb-3   " style="    right: -22px;position:absolute;  top: -5px;">
                                    <?php if(in_array($product->name, $company_products)): ?> 
                                    <input type="checkbox" id="customRadio5" name="selected_product[]" value="<?php echo e($product->id); ?>"
                                        class="form-check-input" checked="">
                                        <?php else: ?>
                                        <input type="checkbox" id="customRadio5" name="selected_product[]" value="<?php echo e($product->id); ?>"
                                        class="form-check-input">
                                        <?php endif; ?>
                                    <label class="form-check-label" for="customRadio5">Pre</label>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="card-body product_card">
                        <?php if(!empty($product->is_cover)): ?>
                            <a href="<?php echo e(asset(Storage::url('uploads/is_cover_image/' . $product->is_cover))); ?>"
                                target="_blank">
                                <img alt="Image placeholder"
                                    src="<?php echo e(asset(Storage::url('uploads/is_cover_image/' . $product->is_cover))); ?>"
                                    class="img-fluid rounded-circle card-avatar" alt="images">
                            </a>
                        <?php else: ?>
                            <a href="<?php echo e(asset(Storage::url('uploads/is_cover_image/default.jpg'))); ?>" target="_blank">
                                <img alt="Image placeholder"
                                    src="<?php echo e(asset(Storage::url('uploads/is_cover_image/default.jpg'))); ?>"
                                    class="img-fluid rounded-circle card-avatar" alt="images">
                            </a>
                        <?php endif; ?>
                        <h4 class="text-primary mt-2"> <a href="#"><?php echo e($product->name); ?></a></h4>
                        <h4 class="text-muted">
                            <small><?php echo e(\App\Models\Utility::priceFormat($product->price)); ?></small>
                        </h4>
                        <?php if($product->enable_product_variant != 'on'): ?>
                            <?php if($product->quantity == 0): ?>
                                <span class="badge bg-danger p-2 px-3 rounded">
                                    <?php echo e(__('Out of stock')); ?>

                                </span>
                            <?php else: ?>
                                <span class="badge bg-primary p-2 px-3 rounded">
                                    <?php echo e(__('In stock')); ?>

                                </span>
                            <?php endif; ?>
                        <?php endif; ?>
                        <div class="row mt-1">
                            <div class="col-12 col-sm-12">
                                <div>
                                    <?php for($i = 1; $i <= 5; $i++): ?>
                                        <?php
                                            $icon = 'fa-star';
                                            $color = '';
                                            $newVal1 = $i - 0.5;
                                            if ($product->product_rating() < $i && $product->product_rating() >= $newVal1) {
                                                $icon = 'fa-star-half-alt';
                                            }
                                            if ($product->product_rating() >= $newVal1) {
                                                $color = 'text-warning';
                                            } else {
                                                $color = 'text-black';
                                            }
                                        ?>
                                        <i class="fas <?php echo e($icon . ' ' . $color); ?>"></i>
                                    <?php endfor; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
       

    </div>
    <div class="row">
     <div class="form-group col-12 d-flex justify-content-end col-form-label">
            <button type="submit" id="submit-all" class="btn btn-primary me-2"><i class="ti ti-file-import"></i>
                Import</button>
            <a href="<?php echo e(route('product.create')); ?>" class="btn  btn-primary btn-light"> <i
                    class="ti ti-plus"><?php echo e(__('Create Product')); ?></i> Create
            </a>
        </div>
    </div>
  <?php echo e(Form::close()); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('script-page'); ?>
<script>

        $("#new_product_subcategorie").change(function() {
            var subcat_id = $(this).val();
            var cat_id = $('#new_product_categorie').val();

             $.ajax({
                type: "POST",
                dataType: "JSON",
                url: '<?php echo e(route('categorie.products.grid')); ?>',
                data: {
                    cat_id: cat_id,
                    subcat_id: subcat_id,
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            }).done(function(msg) {
                if (msg.status == 'success') {
                    // $('#loader_form').hide();
                    $('.product_list').html(msg.output);
                    // $('#slug').val(msg.data.slug);
                }
            });


        });
        $("#new_product_categorie").change(function() {
            // alert('here');
            var cat_id = $(this).val();
            // $('#loader_form').show();

            $.ajax({

                url: "<?php echo e(route('get-sub-category-by-category')); ?>",
                type: 'POST',
                data: {
                    _token: '<?php echo e(csrf_token()); ?>',
                    product_categorie: cat_id
                },
                success: function(data) {
                    $('#loader_form').hide();
                    // alert('here');
                    // $('#sub_category_div').show();
                    $("#new_product_subcategorie").html(
                    '<option value="">Select Sub Category</option>');

                    $.each(data, function(index, val) {
                        $("#new_product_subcategorie").append('<option value="' + index + '">' +
                            val + '</option>');
                    });
                    $('.custom_select').select2();
                }
            })

            var subcat_id = $('#new_product_subcategorie').val();

                



            $.ajax({
                type: "POST",
                dataType: "JSON",
                url: '<?php echo e(route('categorie.products.grid')); ?>',
                data: {
                    cat_id: cat_id,
                    subcat_id: subcat_id,
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            }).done(function(msg) {
                if (msg.status == 'success') {
                    // $('#loader_form').hide();
                    $('.product_list').html(msg.output);
                    // $('#slug').val(msg.data.slug);
                }
            });


        });

        $("#search").on('keyup', function(e) {
            // $('#loader_form').show();
            var search = $(this).val();
           
            
            cat_id = $('#new_product_categorie').val();
            subcat_id = $('#new_product_subcategorie').val();
                


            $.ajax({
                type: "POST",
                dataType: "JSON",
                url: '<?php echo e(route('categorie.products.grid')); ?>',
                data: {
                    cat_id: cat_id,
                    subcat_id: subcat_id,
                    search: search,
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            }).done(function(msg) {
                if (msg.status == 'success') {
                    // $('#loader_form').hide();
                    $('.product_list').html(msg.output);
                    // $('#slug').val(msg.data.slug);
                }
            });
        })

</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nexprism/saas.nexprism.com/resources/views/product/admin_product_list.blade.php ENDPATH**/ ?>