<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Cart')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<?php $__env->startSection('head-title'); ?>
    <?php echo e(__('Welcome') . ', ' . \Illuminate\Support\Facades\Auth::guard('customers')->user()->name); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<nav aria-label="breadcrumb" class="breadcrumb mb-0">
    <div class="container">
        <ol class="d-flex align-items-center mb-0 p-0">
            <li class="breadcrumb-item"><a href="<?php echo e(route('store.slug', $store->slug)); ?>" class="text-success">Home</a></li>
            <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('My Orders')); ?></li>
        </ol>
    </div>
</nav>

<section class="py-4 osahan-main-body">
    <div class="container">
        <div class="row">
            <div class="col-lg-4">
                <?php echo $__env->make('storefront.theme.customer.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            </div>
            <div class="col-lg-8 ">
                <div class="tab-pane fade show active" id="completed" >
                    <div class="order-body">
                        <?php if(!empty($orders) && count($orders) > 0): ?>
                            <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="pb-3">
                                <a href="<?php echo e(route('customer.order', [$store->slug, Crypt::encrypt($order->id)])); ?>" class="text-decoration-none text-dark">
                                    <div class="p-3 rounded shadow-sm bg-white">
                                        <div class="d-flex align-items-center mb-3">
                                            <?php if($order->status != 'Cancel Order'): ?>
                                            <p class=" <?php echo e($order->status == 'pending' ? 'bg-warning ' : 'bg-success'); ?> text-white py-1 px-2 mb-0 rounded small">
                                                <?php if($order->status == 'pending'): ?>
                                                    <?php echo e(__('Pending')); ?>

                                                <?php else: ?>
                                                    <?php echo e(__('Delivered')); ?>

                                                <?php endif; ?>
                                            </p>
                                            <p class="text-muted ml-auto small mb-0"><i class="icofont-clock-time"></i>
                                                <?php if($order->status == 'pending'): ?>
                                                <?php echo e(\App\Models\Utility::dateFormat($order->created_at)); ?>

                                                <?php else: ?>
                                                <?php echo e(\App\Models\Utility::dateFormat($order->updated_at)); ?>

                                                <?php endif; ?>
                                            </p>

                                            <?php else: ?>
                                            <p class="bg-danger  <?php echo e($order->status == 'pending' ? 'btn-soft-info' : 'btn-soft-success'); ?> text-white py-1 px-2 mb-0 rounded small">
                                                <?php echo e(__('Cancel Order')); ?>:
                                            </p>
                                            <p class="text-muted ml-auto small mb-0"><i class="icofont-clock-time"></i>
                                                <?php echo e(\App\Models\Utility::dateFormat($order->created_at)); ?>

                                            </p>
                                            <?php endif; ?>
                                        </div>




                                        <div class="d-flex">
                                            <p class="text-muted m-0"><?php echo e(__('Order')); ?><br>
                                                <span class="text-dark font-weight-bold"><a href="<?php echo e(route('customer.order', [$store->slug, Crypt::encrypt($order->id)])); ?>"
                                                    class=" text-dark">
                                                    <span class="btn-inner--text"><?php echo e('#' . $order->order_id); ?></span>
                                                </a></span>
                                            </p>
                                            <p class="text-muted m-0 ml-auto"><?php echo e(__('Date')); ?><br>
                                                <span class="text-dark font-weight-bold"><?php echo e(\App\Models\Utility::dateFormat($order->created_at)); ?></span>
                                            </p>
                                            <p class="text-muted m-0 ml-auto"><?php echo e(__('Value')); ?><br>
                                                <span class="text-dark font-weight-bold"><?php echo e(\App\Models\Utility::priceFormat($order->price)); ?></span>
                                            </p>
                                            <p class="text-muted m-0 ml-auto"><?php echo e(__('Payment Type')); ?><br>
                                                <span class="text-dark font-weight-bold"><?php echo e($order->payment_type); ?></span>
                                            </p>
                                        </div>
                                    </div>
                                </a>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?>
                        <div class="my-5 py-5 px-3 text-center">
                            <h4><?php echo e(__('Opps...')); ?></h4>
                            <p><?php echo __('No data Found.'); ?> </p>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script-page'); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('storefront.layout.theme', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp\www\company\saas\resources\views/storefront/theme/customer/index.blade.php ENDPATH**/ ?>