<form method="post" action="<?php echo e(route('product-coupon.store')); ?>" id="product-coupon-store">
    <?php echo csrf_field(); ?>
    <div class="row">
        <div class="form-group col-md-12">
            <?php echo e(Form::label('name', __('Name'), ['class' => 'form-label'])); ?>

            <?php echo e(Form::text('name', null, ['class' => 'form-control', 'placeholder' => __('Enter Name'), 'required' => 'required'])); ?>

        </div>
        <div class="form-group col-md-6">
            <div class="form-check form-switch">
                <input type="checkbox" class="form-check-input" name="enable_flat" id="enable_flat">
                <?php echo e(Form::label('enable_flat', __('Flat Discount'), ['class' => 'form-check-label mb-3'])); ?>

            </div>
        </div>
        <div class="form-group col-md-6">
            <div class="form-check form-switch">
                <input type="checkbox" class="form-check-input" name="new_user_only" id="new_user_only">
                <?php echo e(Form::label('new_user_only', __('Only New user use '), ['class' => 'form-check-label mb-3'])); ?>

            </div>
        </div>
        <div class="form-group col-md-12">
            <div class="form-check form-switch">
                <input type="checkbox" class="form-check-input" name="free_shiping" id="free_shiping">
                <?php echo e(Form::label('free_shiping', __('Allow Free shipping '), ['class' => 'form-check-label mb-3'])); ?>

            </div>
        </div>
        <div class="form-group col-md-12 nonflat_discount">
            <?php echo e(Form::label('discount', __('Discount'), ['class' => 'col-form-label'])); ?>

            <?php echo e(Form::number('discount', null, ['class' => 'form-control', 'step' => '0.01', 'placeholder' => __('Enter Discount')])); ?>

            <span class="small"><?php echo e(__('Note: Discount in Percentage')); ?></span>
        </div>
        <div class="form-group col-md-12 flat_discount" style="display: none;">
            <?php echo e(Form::label('pro_flat_discount', __('Flat Discount'), ['class' => 'col-form-label'])); ?>

            <?php echo e(Form::number('pro_flat_discount', null, ['class' => 'form-control', 'step' => '0.01', 'placeholder' => __('Enter Flat Discount')])); ?>

            <span class="small"><?php echo e(__('Note: Discount in Value')); ?></span>
        </div>
        <div class="form-group col-md-6">
            <?php echo e(Form::label('user_limit', __('Maximum user Limit'), ['class' => 'col-form-label'])); ?>

            <?php echo e(Form::number('user_limit', null, ['class' => 'form-control', 'placeholder' => __('Enter  User Limit'), 'required' => 'required'])); ?>

            <span class="small"><?php echo e(__('Note: Number of User count')); ?></span>
        </div>
        <div class="form-group col-md-6">
            <?php echo e(Form::label('limit', __('Coupon Limit'), ['class' => 'col-form-label'])); ?>

            <?php echo e(Form::number('limit', null, ['class' => 'form-control', 'placeholder' => __('Enter Coupon Limit'), 'required' => 'required'])); ?>

            <span class="small"><?php echo e(__('Note: Number of coupon uses')); ?></span>
        </div>
        <div class="form-group col-md-6">
            <?php echo e(Form::label('minimum_spend', __('Minimum Spend'), ['class' => 'col-form-label'])); ?>

            <?php echo e(Form::number('minimum_spend', null, ['class' => 'form-control', 'step' => '100', 'placeholder' => __('Enter Amount'), 'required' => 'required'])); ?>

            <span class="small"><?php echo e(__('Note: Minimum purchase')); ?></span>
        </div>
        <div class="form-group col-md-6">
            <?php echo e(Form::label('maximum_spend', __('Maximum Spend'), ['class' => 'col-form-label'])); ?>

            <?php echo e(Form::number('maximum_spend', null, ['class' => 'form-control', 'step' => '500', 'placeholder' => __('Enter Amount')])); ?>

            <span class="small"><?php echo e(__('Note: Maximum purchase')); ?></span>
        </div>
         <div class="form-group col-md-12">
            <?php echo e(Form::label('coupon_expiry', __('Coupon Expiry'), ['class' => 'col-form-label'])); ?>

            <?php echo e(Form::date('coupon_expiry',  null, ['class' => 'form-control','min' => date("Y-m-d"),'required' => 'required'])); ?>

        </div>
        <div class="form-group col-md-12">
            <?php echo e(Form::label('coupon_products', __('Products'), ['class' => 'col-form-label'])); ?>

            <?php echo e(Form::select('coupon_products[]', $all_products, null, ['class' => 'form-control multi-select', 'id' => 'choices-multiple1', 'multiple'])); ?>

        </div>
        <div class="form-group col-md-12">
            <?php echo e(Form::label('exclude_products', __('Exclude Products'), ['class' => 'col-form-label'])); ?>

            <?php echo e(Form::select('exclude_products[]', $all_products, null, ['class' => 'form-control multi-select', 'id' => 'choices-multiple2', 'multiple'])); ?>

        </div>
        <div class="form-group col-md-12" id="auto">
            <?php echo e(Form::label('limit', __('Code'), ['class' => 'col-form-label'])); ?>

            <div class="input-group">
                <?php echo e(Form::text('code', null, ['class' => 'form-control', 'id' => 'auto-code', 'required' => 'required'])); ?>

                <button class="btn btn-outline-secondary" type="button" id="code-generate"><i
                        class="fa fa-history pr-1"></i><?php echo e(__(' Generate')); ?></button>
            </div>
        </div>
        <div class="form-group col-12 d-flex justify-content-end col-form-label">
            <input type="button" value="<?php echo e(__('Cancel')); ?>" class="btn btn-secondary btn-light"
                data-bs-dismiss="modal">
            <input type="submit" value="<?php echo e(__('Save')); ?>" class="btn btn-primary ms-2">
        </div>
    </div>
</form>
<?php /**PATH /home/nexprism/saas.nexprism.com/resources/views/product-coupon/create.blade.php ENDPATH**/ ?>