<?php echo e(Form::open(['url' => 'product_subcategorie', 'method' => 'post', 'enctype' => 'multipart/form-data'])); ?>

<div class="row">
    <div class="col-12">

        <div class="form-group">
            <?php echo e(Form::label('category_id', __('Select Category'), ['class' => 'col-form-label'])); ?>

            <?php echo Form::select('category_id', $product_categorie, null, [
                'class' => 'form-control multi-select',
            ]); ?>

            <?php if(count($product_categorie) == 0): ?>
                <?php echo e(__('Add product category')); ?>

                <a href="<?php echo e(route('product_categorie.index')); ?>">
                    <?php echo e(__('Click here')); ?>

                </a>
            <?php endif; ?>
        </div>

        <div class="form-group">
            <?php echo e(Form::label('name', __('Name'), ['class' => 'col-form-label'])); ?>

            <?php echo e(Form::text('name', null, ['class' => 'form-control', 'placeholder' => __('Enter Product Category'), 'required' => 'required'])); ?>

        </div>
        <div class="form-group">
            <label for="subcategorie_img" class="col-form-label"><?php echo e(__('Upload Category Image')); ?></label>
            
            <input type="file" name="subcategorie_img" id="subcategorie_img" class="form-control"
                onchange="document.getElementById('catImg').src = window.URL.createObjectURL(this.files[0])" multiple>
            <img id="catImg" src="" width="20%" class="mt-2" />
        </div>
    </div>
    <div class="form-group col-12 d-flex justify-content-end col-form-label">
        <input type="button" value="<?php echo e(__('Cancel')); ?>" class="btn btn-secondary btn-light" data-bs-dismiss="modal">
        <input type="submit" value="<?php echo e(__('Save')); ?>" class="btn btn-primary ms-2">
    </div>
</div>
<?php echo e(Form::close()); ?>

<?php /**PATH C:\laragon\www\saas\resources\views/product_subcategory/create.blade.php ENDPATH**/ ?>