<?php $__env->startSection('page-title'); ?>
    <?php echo e(__('Services')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('title'); ?>
    <div class="d-inline-block">
        <h5 class="h4 d-inline-block text-white font-weight-bold mb-2"><?php echo e(__('Service')); ?></h5>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('breadcrumb'); ?>
    <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><?php echo e(__('Home')); ?></a></li>
    <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('Services')); ?></li>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('action-btn'); ?>
    <div class="pr-2">
        <a href="<?php echo e(route('service.create')); ?>" class="btn btn-sm btn-primary btn-icon m-1" data-bs-toggle="tooltip"
            data-bs-placement="top" title="<?php echo e(__('Create')); ?>"><i class="ti ti-plus"></i> Create</a>
    </div>
<?php $__env->stopSection(); ?>
<?php
    $logo = \App\Models\Utility::get_file('uploads/service_logo/');
?>
<?php $__env->startSection('filter'); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('css-page'); ?>
    <link rel="stylesheet" href="<?php echo e(asset('custom/libs/summernote/summernote-bs4.css')); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startPush('script-page'); ?>
    <script src="<?php echo e(asset('custom/libs/summernote/summernote-bs4.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body table-border-style">
                    <div class="table-responsive">
                        <table class="table mb-0 dataTable">
                            <thead>
                                <tr>
                                    <th><?php echo e(__('Logo')); ?></th>
                                    <th><?php echo e(__('Title')); ?></th>
                                    <th><?php echo e(__('Created at')); ?></th>
                                    <th class="text-right"><?php echo e(__('Action')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <?php if(!empty($service->logo)): ?>
                                                    
                                                    <a href="<?php echo e($logo . (isset($service->logo) && !empty($service->logo) ? $service->logo : 'is_cover_image.png')); ?>"
                                                        target="_blank">
                                                        <img alt="Image placeholder" alt="your image"
                                                            src="<?php echo e($logo . (isset($service->logo) && !empty($service->logo) ? $service->logo : 'is_cover_image.png')); ?>"
                                                            class="rounded-circle" alt="images">
                                                    </a>
                                                <?php else: ?>
                                                    <a href="<?php echo e($logo . (isset($service->logo) && !empty($service->logo) ? $service->logo : 'is_cover_image.png')); ?>"
                                                        target="_blank">
                                                        <img alt="Image placeholder" alt="your image"
                                                            src="<?php echo e($logo . (isset($service->logo) && !empty($service->logo) ? $service->logo : 'is_cover_image.png')); ?>"
                                                            class="rounded-circle" alt="images">
                                                    </a>
                                                <?php endif; ?>

                                            </div>
                                        </td>
                                        <td> <?php echo e($service->title); ?>

                                        </td>
                                        <td>
                                            <?php echo e(\App\Models\Utility::dateFormat($service->created_at)); ?>

                                        </td>
                                        <td>
                                            <div class="action-btn  bg-info ms-2">
                                                    <a href="<?php echo e(route('service.edit', $service->id)); ?>"
                                                        class="mx-3 btn btn-sm d-inline-flex align-items-center"
                                                        data-bs-toggle="tooltip" data-bs-placement="top"
                                                        title="<?php echo e(__('Edit')); ?>"><i
                                                            class="ti ti-pencil text-white"></i></a>
                                                </div>
                                                <div class="action-btn  bg-primary ms-2">
                                                    <a href="<?php echo e(route('service.form.design', $service->id)); ?>"
                                                        class="mx-3 btn btn-sm d-inline-flex align-items-center"
                                                        data-bs-toggle="tooltip" data-bs-placement="top"
                                                        title="<?php echo e(__('Design')); ?>"><i
                                                            class="fa fa-paint-brush text-white"></i></a>
                                                </div>
                                                 <?php if($service->json && empty($service->ServiceValue)): ?>
                                                 <div class="action-btn  bg-warning ms-2">
                                                    <a href="<?php echo e(route('service.form.fill', $service->id)); ?>"
                                                        class="mx-3 btn btn-sm d-inline-flex align-items-center"
                                                        data-bs-toggle="tooltip" data-bs-placement="top"
                                                        title="<?php echo e(__('Fill')); ?>"><i
                                                            class="fa fa-list text-white"></i></a>
                                                </div>
                                                 <?php endif; ?>
                                                <div class="action-btn bg-danger ms-2">
                                                    <a class="bs-pass-para align-items-center btn btn-sm d-inline-flex" href="#"
                                                        data-title="<?php echo e(__('Delete Lead')); ?>"
                                                        data-confirm="<?php echo e(__('Are You Sure?')); ?>"
                                                        data-text="<?php echo e(__('This action can not be undone. Do you want to continue?')); ?>"
                                                        data-confirm-yes="delete-form-<?php echo e($service->id); ?>"
                                                        data-bs-toggle="tooltip" data-bs-placement="top"
                                                        title="<?php echo e(__('Delete')); ?>">
                                                        <i class="ti ti-trash"></i>
                                                    </a>
                                                    <?php echo Form::open(['method' => 'DELETE', 'route' => ['service.destroy', $service->id], 'id' => 'delete-form-' . $service->id]); ?>

                                                    <?php echo Form::close(); ?>

                                                </div>
                                        </td>

                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script-page'); ?>
    <script>
        $(document).on('click', '#billing_data', function() {
            $("[name='shipping_address']").val($("[name='billing_address']").val());
            $("[name='shipping_city']").val($("[name='billing_city']").val());
            $("[name='shipping_state']").val($("[name='billing_state']").val());
            $("[name='shipping_country']").val($("[name='billing_country']").val());
            $("[name='shipping_postalcode']").val($("[name='billing_postalcode']").val());
        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/nexprism/saas.nexprism.com/resources/views/service/index.blade.php ENDPATH**/ ?>