-- --------------------------------------------------------
-- Host:                         127.0.0.1
-- Server version:               8.0.30 - MySQL Community Server - GPL
-- Server OS:                    Win64
-- HeidiSQL Version:             12.1.0.6537
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


-- Dumping database structure for saas
CREATE DATABASE IF NOT EXISTS `saas` /*!40100 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci */ /*!80016 DEFAULT ENCRYPTION='N' */;
USE `saas`;

-- Dumping structure for table saas.admin_payment_settings
CREATE TABLE IF NOT EXISTS `admin_payment_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_by` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `admin_payment_settings_name_created_by_unique` (`name`,`created_by`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.admin_payment_settings: 15 rows
/*!40000 ALTER TABLE `admin_payment_settings` DISABLE KEYS */;
INSERT INTO `admin_payment_settings` (`id`, `name`, `value`, `created_by`, `created_at`, `updated_at`) VALUES
	(1, 'is_stripe_enabled', 'off', 1, NULL, NULL),
	(2, 'is_paypal_enabled', 'off', 1, NULL, NULL),
	(3, 'is_paystack_enabled', 'off', 1, NULL, NULL),
	(4, 'is_flutterwave_enabled', 'off', 1, NULL, NULL),
	(5, 'is_razorpay_enabled', 'off', 1, NULL, NULL),
	(6, 'is_paytm_enabled', 'off', 1, NULL, NULL),
	(7, 'is_mercado_enabled', 'off', 1, NULL, NULL),
	(8, 'is_mollie_enabled', 'off', 1, NULL, NULL),
	(9, 'is_skrill_enabled', 'off', 1, NULL, NULL),
	(10, 'is_coingate_enabled', 'off', 1, NULL, NULL),
	(11, 'is_paymentwall_enabled', 'off', 1, NULL, NULL),
	(12, 'is_onemoney_enabled', 'on', 1, NULL, NULL),
	(13, 'onemony_mode', 'sandbox', 1, NULL, NULL),
	(14, 'onemoney_public_key', 'jk', 1, NULL, NULL),
	(15, 'onemoney_secret_key', 'jkljkl', 1, NULL, NULL);
/*!40000 ALTER TABLE `admin_payment_settings` ENABLE KEYS */;

-- Dumping structure for table saas.blogs
CREATE TABLE IF NOT EXISTS `blogs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `blog_cover_image` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `detail` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `store_id` int NOT NULL DEFAULT '0',
  `created_by` int NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.blogs: 0 rows
/*!40000 ALTER TABLE `blogs` DISABLE KEYS */;
/*!40000 ALTER TABLE `blogs` ENABLE KEYS */;

-- Dumping structure for table saas.blog_socials
CREATE TABLE IF NOT EXISTS `blog_socials` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `enable_social_button` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'off',
  `enable_email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'off',
  `enable_twitter` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'off',
  `enable_facebook` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'off',
  `enable_googleplus` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'off',
  `enable_linkedIn` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'off',
  `enable_pinterest` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'off',
  `enable_stumbleupon` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'off',
  `enable_whatsapp` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'off',
  `store_id` int NOT NULL DEFAULT '0',
  `created_by` int NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.blog_socials: 1 rows
/*!40000 ALTER TABLE `blog_socials` DISABLE KEYS */;
INSERT INTO `blog_socials` (`id`, `enable_social_button`, `enable_email`, `enable_twitter`, `enable_facebook`, `enable_googleplus`, `enable_linkedIn`, `enable_pinterest`, `enable_stumbleupon`, `enable_whatsapp`, `store_id`, `created_by`, `created_at`, `updated_at`) VALUES
	(1, 'on', 'on', 'on', 'on', 'on', 'on', 'on', 'on', 'on', 1, 2, '2023-04-13 10:03:38', '2023-04-13 10:03:38');
/*!40000 ALTER TABLE `blog_socials` ENABLE KEYS */;

-- Dumping structure for table saas.ch_favorites
CREATE TABLE IF NOT EXISTS `ch_favorites` (
  `id` bigint NOT NULL,
  `user_id` bigint NOT NULL,
  `favorite_id` bigint NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.ch_favorites: 0 rows
/*!40000 ALTER TABLE `ch_favorites` DISABLE KEYS */;
/*!40000 ALTER TABLE `ch_favorites` ENABLE KEYS */;

-- Dumping structure for table saas.ch_messages
CREATE TABLE IF NOT EXISTS `ch_messages` (
  `id` bigint NOT NULL,
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `from_id` bigint NOT NULL,
  `to_id` bigint NOT NULL,
  `body` varchar(5000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attachment` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `seen` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.ch_messages: 0 rows
/*!40000 ALTER TABLE `ch_messages` DISABLE KEYS */;
/*!40000 ALTER TABLE `ch_messages` ENABLE KEYS */;

-- Dumping structure for table saas.coupons
CREATE TABLE IF NOT EXISTS `coupons` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `discount` double(8,2) NOT NULL DEFAULT '0.00',
  `limit` int NOT NULL DEFAULT '0',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `is_active` int NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.coupons: 0 rows
/*!40000 ALTER TABLE `coupons` DISABLE KEYS */;
/*!40000 ALTER TABLE `coupons` ENABLE KEYS */;

-- Dumping structure for table saas.customers
CREATE TABLE IF NOT EXISTS `customers` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `password` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `store_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `avatar` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'en',
  `products_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.customers: 3 rows
/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` (`id`, `name`, `email`, `phone_number`, `password`, `remember_token`, `store_id`, `avatar`, `lang`, `products_id`, `created_at`, `updated_at`) VALUES
	(1, 'abc', 'abc@gamil.com', '123456789', '$2y$10$/TrRUvG7wwxDpghFB6XJ3OJlm0WQpdV4p9GTvGzjg13X6.W5sthI.', NULL, '1', 'avatar.png', 'en', NULL, '2023-04-14 12:09:52', '2023-04-14 12:09:52'),
	(2, 'Abcdd', 'abc@gmail.com', '1234567890', '$2y$10$X2Vfe9ZaUcojwEd3rCDSoO/RGGOxt1mlqtpRBwzhCjxw/nFSpQo6C', NULL, '1', 'v3_1681920586.jpg', 'en', NULL, '2023-04-17 12:44:48', '2023-04-19 10:39:47'),
	(3, 'xyz', 'xyz@gmail.com', '123456879', '$2y$10$uYbeIggXIu7w2qdv8CcBTO6VwqMeG8xOtG/wXGAg7d1JHKHQunJYi', NULL, '1', 'avatar.png', 'en', NULL, '2023-04-18 12:29:50', '2023-04-18 12:29:50');
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;

-- Dumping structure for table saas.email_templates
CREATE TABLE IF NOT EXISTS `email_templates` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `from` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.email_templates: 3 rows
/*!40000 ALTER TABLE `email_templates` DISABLE KEYS */;
INSERT INTO `email_templates` (`id`, `name`, `from`, `created_by`, `created_at`, `updated_at`) VALUES
	(1, 'Order Created', NULL, 1, '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(2, 'Status Change', NULL, 1, '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(3, 'Order Created For Owner', NULL, 1, '2023-04-13 10:03:38', '2023-04-13 10:03:38');
/*!40000 ALTER TABLE `email_templates` ENABLE KEYS */;

-- Dumping structure for table saas.email_template_langs
CREATE TABLE IF NOT EXISTS `email_template_langs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int NOT NULL,
  `lang` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=37 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.email_template_langs: 36 rows
/*!40000 ALTER TABLE `email_template_langs` DISABLE KEYS */;
INSERT INTO `email_template_langs` (`id`, `parent_id`, `lang`, `subject`, `content`, `created_at`, `updated_at`) VALUES
	(1, 1, 'ar', 'Order Complete', '<p>مرحبا ،</p><p>مرحبا بك في {app_name}.</p><p>مرحبا ، {order_name} ، شكرا للتسوق</p><p>قمنا باستلام طلب الشراء الخاص بك ، سيتم الاتصال بك قريبا !</p><p>شكرا ،</p><p>{app_name}</p><p>{order_url}</p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(2, 1, 'da', 'Order Complete', '<p>Hej, &nbsp;</p><p>Velkommen til {app_name}.</p><p>Hej, {order_name}, tak for at Shopping</p><p>Vi har modtaget din købsanmodning.</p><p>Tak,</p><p>{app_navn}</p><p>{order_url}</p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(3, 1, 'de', 'Order Complete', '<p>Hello, &nbsp;</p><p>Willkommen bei {app_name}.</p><p>Hi, {order_name}, Vielen Dank für Shopping</p><p>Wir haben Ihre Kaufanforderung erhalten, wir werden in Kürze in Kontakt sein!</p><p>Danke,</p><p>{app_name}</p><p>{order_url}</p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(4, 1, 'en', 'Order Complete', '<p>Hello,&nbsp;</p><p>Welcome to {app_name}.</p><p>Hi, {order_name}, Thank you for Shopping</p><p>We received your purchase request, we\'ll be in touch shortly!</p><p>Thanks,</p><p>{app_name}</p><p>{order_url}</p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(5, 1, 'es', 'Order Complete', '<p>Hola, &nbsp;</p><p>Bienvenido a {app_name}.</p><p>Hi, {order_name}, Thank you for Shopping</p><p>Recibimos su solicitud de compra, ¡estaremos en contacto en breve!</p><p>Gracias,</p><p>{app_name}</p><p>{order_url}</p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(6, 1, 'fr', 'Order Complete', '<p>Bonjour, &nbsp;</p><p>Bienvenue dans {app_name}.</p><p>Hi, {order_name}, Thank you for Shopping</p><p>We reçus your purchase request, we \'ll be in touch incess!</p><p>Thanks,</p><p>{app_name}</p><p>{order_url}</p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(7, 1, 'it', 'Order Complete', '<p>Ciao, &nbsp;</p><p>Benvenuti in {app_name}.</p><p>Ciao, {order_name}, Grazie per Shopping</p><p>Abbiamo ricevuto la tua richiesta di acquisto, noi \\ saremo in contatto a breve!</p><p>Grazie,</p><p>{app_name}</p><p>{order_url}</p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(8, 1, 'ja', 'Order Complete', '<p>こんにちは &nbsp;</p><p>{app_name}へようこそ。</p></p><p><p>こんにちは、 {order_name}、お客様の購買要求書をお受け取りいただき、すぐにご連絡いたします。</p><p>ありがとうございます。</p><p>{app_name}</p><p>{order_url}</p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(9, 1, 'nl', 'Order Complete', '<p>Hallo, &nbsp;</p><p>Welkom bij {app_name}.</p><p>Hallo, {order_name}, Dank u voor Winkelen</p><p>We hebben uw aankoopaanvraag ontvangen, we zijn binnenkort in contact!</p><p>Bedankt,</p><p>{ app_name }</p><p>{order_url}</p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(10, 1, 'pl', 'Order Complete', '<p>Hello, &nbsp;</p><p>Witamy w aplikacji {app_name}.</p><p>Hi, {order_name}, Dziękujemy za zakupy</p><p>Otrzymamy Twój wniosek o zakup, wkrótce będziemy w kontakcie!</p><p>Dzięki,</p><p>{app_name}</p><p>{order_url}</p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(11, 1, 'ru', 'Order Complete', '<p>Здравствуйте, &nbsp;</p><p>Вас приветствует {app_name}.</p><p>Hi, {order_name}, Спасибо за Шоппинг</p><p>Мы получили ваш запрос на покупку, мы \\ скоро свяжемся!</p><p>Спасибо,</p><p>{app_name}</p><p>{order_url}</p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(12, 1, 'pt', 'Order Complete', '<p>NAVE ÓRICA-Тутутутугальстугальский (app_name}).</p><p>Hi, {order_name}, пасссский</p><p>польстугальский потугальский (португальский), "скортугальский".</p><p>nome_do_appсссский!</p><p>{app_name}</p><p>{app_name}</p><p>{order_url}</p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(13, 2, 'ar', 'Order Status', '<p> مرحبًا ، </p> <p> مرحبًا بك في {app_name}. </p> <p> طلبك هو {order_status}! </p> <p> مرحبًا {order_name} ، شكرًا لك على التسوق </p> <p> شكرًا ، </ p> <p> {app_name} </p> <p> {order_url} </p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(14, 2, 'da', 'Order Status', '<p>Hej, &nbsp;</p><p>Velkommen til {app_name}.</p><p>Din ordre er {order_status}!</p><p>Hej {order_navn}, Tak for at Shopping</p><p>Tak,</p><p>{app_navn}</p><p>{order_url}</p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(15, 2, 'de', 'Order Status', '<p>Hello, &nbsp;</p><p>Willkommen bei {app_name}.</p><p>Ihre Bestellung lautet {order_status}!</p><p>Hi {order_name}, Danke für Shopping</p><p>Danke,</p><p>{app_name}</p><p>{order_url}</p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(16, 2, 'en', 'Order Status', '<p>Hello,&nbsp;</p><p>Welcome to {app_name}.</p><p>Your Order is {order_status}!</p><p>Hi {order_name}, Thank you for Shopping</p><p>Thanks,</p><p>{app_name}</p><p>{order_url}</p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(17, 2, 'es', 'Order Status', '<p>Hola, &nbsp;</p><p>Bienvenido a {app_name}.</p><p>Your Order is {order_status}!</p><p>Hi {order_name}, Thank you for Shopping</p><p>Thanks,</p><p>{app_name}</p><p>{order_url}</p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(18, 2, 'fr', 'Order Status', '<p>Bonjour, &nbsp;</p><p>Bienvenue dans {app_name}.</p><p>Votre commande est {order_status} !</p><p>Hi {order_name}, Thank you for Shopping</p><p>Thanks,</p><p>{app_name}</p><p>{order_url}</p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(19, 2, 'it', 'Order Status', '<p>Ciao, &nbsp;</p><p>Benvenuti in {app_name}.</p><p>Il tuo ordine è {order_status}!</p><p>Ciao {order_name}, Grazie per Shopping</p><p>Grazie,</p><p>{app_name}</p><p>{order_url}</p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(20, 2, 'ja', 'Order Status', '<p>Ciao, &nbsp;</p><p>Benvenuti in {app_name}.</p><p>Il tuo ordine è {order_status}!</p><p>Ciao {order_name}, Grazie per Shopping</p><p>Grazie,</p><p>{app_name}</p><p>{order_url}</p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(21, 2, 'nl', 'Order Status', '<p>Hallo, &nbsp;</p><p>Welkom bij {app_name}.</p><p>Uw bestelling is {order_status}!</p><p>Hi {order_name}, Dank u voor Winkelen</p><p>Bedankt,</p><p>{app_name}</p><p>{order_url}</p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(22, 2, 'pl', 'Order Status', '<p>Hello, &nbsp;</p><p>Witamy w aplikacji {app_name}.</p><p>Twoje zamówienie to {order_status}!</p><p>Hi {order_name}, Dziękujemy za zakupy</p><p>Thanks,</p><p>{app_name}</p><p>{order_url}</p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(23, 2, 'ru', 'Order Status', '<p>Здравствуйте, &nbsp;</p><p>Вас приветствует {app_name}.</p><p>Ваш заказ-{order_status}!</p><p>Hi {order_name}, Thank you for Shopping</p><p>Thanks,</p><p>{app_name}</p><p>{order_url}</p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(24, 2, 'pt', 'Order Status', '<p>SHOPPING CENTER-Тутутутугальстугальский (app_name}).</p><p>nomeia альстугальский (order_status}!</p><p>Hi {order_name}, Obrigado por Shopping</p><p>Obrigado,</p><p>{app_name}</p><p>{order_url}</p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(25, 3, 'ar', 'Order Detail', '<p> مرحبًا ، </ p> <p> عزيزي {owner_name}. </p> <p> هذا أمر تأكيد {order_id} ضعه على <span style = \\"font-size: 1rem؛\\"> {order_date}. </span> </p> <p> شكرًا ، </ p> <p> {order_url} </p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(26, 3, 'da', 'Order Detail', '<p>Hej </p><p>Kære {owner_name}.</p><p>Dette er ordrebekræftelse {order_id} sted på <span style=\\"font-size: 1rem;\\">{order_date}. </span></p><p>Tak,</p><p>{order_url}</p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(27, 3, 'de', 'Order Detail', '<p>Hallo, </p><p>Sehr geehrter {owner_name}.</p><p>Dies ist die Auftragsbestätigung {order_id}, die am <span style=\\"font-size: 1rem;\\">{order_date} aufgegeben wurde. </span></p><p>Danke,</p><p>{order_url}</p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(28, 3, 'en', 'Order Detail', '<p>Hello,&nbsp;</p><p>Dear {owner_name}.</p><p>This is Confirmation Order {order_id} place on&nbsp;<span style=\\"font-size: 1rem;\\">{order_date}.</span></p><p>Thanks,</p><p>{order_url}</p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(29, 3, 'es', 'Order Detail', '<p> Hola, </p> <p> Estimado {owner_name}. </p> <p> Este es el lugar de la orden de confirmación {order_id} en <span style = \\"font-size: 1rem;\\"> {order_date}. </span> </p> <p> Gracias, </p> <p> {order_url} </p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(30, 3, 'fr', 'Order Detail', '<p>Bonjour, </p><p>Cher {owner_name}.</p><p>Ceci est la commande de confirmation {order_id} passée le <span style=\\"font-size: 1rem;\\">{order_date}. </span></p><p>Merci,</p><p>{order_url}</p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(31, 3, 'it', 'Order Detail', '<p>Ciao, </p><p>Gentile {owner_name}.</p><p>Questo è l\'ordine di conferma {order_id} effettuato su <span style=\\"font-size: 1rem;\\">{order_date}. </span></p><p>Grazie,</p><p>{order_url}</p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(32, 3, 'ja', 'Order Detail', '<p>こんにちは、</ p> <p>親愛なる{owner_name}。</ p> <p>これは、<span style = \\"font-size：1rem;\\"> {order_date}の確認注文{order_id}の場所です。 </ span> </ p> <p>ありがとうございます</ p> <p> {order_url} </ p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(33, 3, 'nl', 'Order Detail', '<p>Hallo, </p><p>Beste {owner_name}.</p><p>Dit is de bevestigingsopdracht {order_id} die is geplaatst op <span style=\\"font-size: 1rem;\\">{order_date}. </span></p><p>Bedankt,</p><p>{order_url}</p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(34, 3, 'pl', 'Order Detail', '<p>Witaj, </p><p>Drogi {owner_name}.</p><p>To jest potwierdzenie zamówienia {order_id} złożone na <span style=\\"font-size: 1rem;\\">{order_date}. </span></p><p>Dzięki,</p><p>{order_url}</p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(35, 3, 'ru', 'Order Detail', '<p> Здравствуйте, </p> <p> Уважаемый {owner_name}. </p> <p> Это подтверждение заказа {order_id} на <span style = \\"font-size: 1rem;\\"> {order_date}. </span> </p> <p> Спасибо, </p> <p> {order_url} </p>', '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(36, 3, 'pt', 'Order Detail', '<p> Térica-Dicas de Cadeia Pública de Тутутугальский (owner_name}). </p> <p> Тугальстугальстугальский (order_id} ний <span style = \\" font-size: 1rem; \\ "> {order_date}. </span> </p> <p> nome_do_chave de vida, </p> <p> {order_url} </p> <p> {order_url}', '2023-04-13 10:03:38', '2023-04-13 10:03:38');
/*!40000 ALTER TABLE `email_template_langs` ENABLE KEYS */;

-- Dumping structure for table saas.failed_jobs
CREATE TABLE IF NOT EXISTS `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `connection` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.failed_jobs: 0 rows
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;

-- Dumping structure for table saas.locations
CREATE TABLE IF NOT EXISTS `locations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `store_id` int NOT NULL DEFAULT '0',
  `created_by` int NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.locations: 0 rows
/*!40000 ALTER TABLE `locations` DISABLE KEYS */;
/*!40000 ALTER TABLE `locations` ENABLE KEYS */;

-- Dumping structure for table saas.migrations
CREATE TABLE IF NOT EXISTS `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=73 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.migrations: 72 rows
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` (`id`, `migration`, `batch`) VALUES
	(1, '2014_10_12_000000_create_users_table', 1),
	(2, '2014_10_12_100000_create_password_resets_table', 1),
	(3, '2019_08_16_144239_create_plans_table', 1),
	(4, '2019_08_19_000000_create_failed_jobs_table', 1),
	(5, '2019_09_22_192348_create_messages_table', 1),
	(6, '2019_09_28_102009_create_settings_table', 1),
	(7, '2019_10_16_211433_create_favorites_table', 1),
	(8, '2019_10_18_223259_add_avatar_to_users', 1),
	(9, '2019_10_20_211056_add_messenger_color_to_users', 1),
	(10, '2019_10_22_000539_add_dark_mode_to_users', 1),
	(11, '2019_10_25_214038_add_active_status_to_users', 1),
	(12, '2020_04_12_095629_create_coupons_table', 1),
	(13, '2020_04_12_120749_create_user_coupons_table', 1),
	(14, '2020_05_02_075614_create_email_templates_table', 1),
	(15, '2020_05_02_075630_create_email_template_langs_table', 1),
	(16, '2020_05_02_075647_create_user_email_templates_table', 1),
	(17, '2020_05_21_065337_create_permission_tables', 1),
	(18, '2021_02_02_085506_create_stores_table', 1),
	(19, '2021_02_02_094240_create_user_stores_table', 1),
	(20, '2021_02_03_093659_create_product_categories_table', 1),
	(21, '2021_02_03_110342_create_product_taxes_table', 1),
	(22, '2021_02_03_112228_create_shippings_table', 1),
	(23, '2021_02_04_034943_create_products_table', 1),
	(24, '2021_02_06_042547_create_subscriptions_table', 1),
	(25, '2021_02_08_063716_create_product_images_table', 1),
	(26, '2021_02_13_053126_create_orders_table', 1),
	(27, '2021_02_15_071203_create_user_details_table', 1),
	(28, '2021_02_17_070453_create_rattings_table', 1),
	(29, '2021_02_26_061007_create_visits_table', 1),
	(30, '2021_03_04_110817_create_plan_orders_table', 1),
	(31, '2021_03_23_094310_create_product_variant_options_table', 1),
	(32, '2021_04_03_063418_create_locations_table', 1),
	(33, '2021_04_05_112122_update_location_field', 1),
	(34, '2021_04_07_054427_create_new_field_table', 1),
	(35, '2021_04_07_070019_create_page_options_table', 1),
	(36, '2021_04_08_043538_create_blogs_table', 1),
	(37, '2021_04_10_034521_create_product_coupons_table', 1),
	(38, '2021_04_12_070426_update_order_table', 1),
	(39, '2021_04_15_121323_create_blog_socials_table', 1),
	(40, '2021_05_25_043902_create_update_field_table', 1),
	(41, '2021_06_03_101323_create_admin_payment_settings', 1),
	(42, '2021_06_25_041037_create_custom_massage_table', 1),
	(43, '2021_07_01_043605_add_theme_field_store_table', 1),
	(44, '2021_07_05_063631_delete_store_field_table', 1),
	(45, '2021_07_07_084829_create_store_theme_settings_table', 1),
	(46, '2021_08_25_051549_create_add_new_field_table', 1),
	(47, '2021_09_04_051718_create_add_store_custom_field_table', 1),
	(48, '2021_10_07_053759_create_addnew_field_product__table', 1),
	(49, '2021_11_15_053620_add_fbpixelcode_to_stores_table', 1),
	(50, '2021_11_17_115318_create_plan_requests_table', 1),
	(51, '2021_11_17_115325_add_requested_plan_to_users_table', 1),
	(52, '2021_12_10_112155_add_metadata_to__store_table', 1),
	(53, '2022_01_10_052633_create__customers_table', 1),
	(54, '2022_01_10_092146_create_purchased_products_table', 1),
	(55, '2022_01_11_120915_create_field_in_order_table', 1),
	(56, '2022_01_25_055851_change_storejs', 1),
	(57, '2022_03_11_035756_add_twilio_to_stores_table', 1),
	(58, '2022_03_22_124009_add_decimal_number_to_stores_table', 1),
	(59, '2022_03_25_041551_add_is_store_enable_to_stores_table', 1),
	(60, '2022_06_20_053559_add_is_checkout_login_required_to_stores_table', 1),
	(61, '2022_07_08_044639_create_store_payment_settings', 1),
	(62, '2022_07_19_120128_add_store_id_settings_table', 1),
	(63, '2019_12_14_000001_create_personal_access_tokens_table', 2),
	(64, '2023_04_21_063111_create_services_table', 2),
	(65, '2023_04_21_175016_add_coloumn_services_table', 3),
	(66, '2020_04_25_121758_create_service_values_table', 4),
	(67, '2023_05_27_074549_add_coloumn_in_product_taxes_table', 5),
	(68, '2023_05_30_191250_add_coloumn_in_product_coupons_table', 5),
	(69, '2023_05_30_191624_add_coloumn_in_product_taxes_table', 5),
	(70, '2023_05_31_053715_add_coloumn_in_product_variant_options_table', 6),
	(71, '2023_06_09_144329_add_new_coloumn_in_product_coupons_table', 7),
	(72, '2023_08_01_093660_create_product_subcategories_table', 7);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;

-- Dumping structure for table saas.model_has_permissions
CREATE TABLE IF NOT EXISTS `model_has_permissions` (
  `permission_id` bigint unsigned NOT NULL,
  `model_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.model_has_permissions: 0 rows
/*!40000 ALTER TABLE `model_has_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `model_has_permissions` ENABLE KEYS */;

-- Dumping structure for table saas.model_has_roles
CREATE TABLE IF NOT EXISTS `model_has_roles` (
  `role_id` bigint unsigned NOT NULL,
  `model_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `model_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.model_has_roles: 0 rows
/*!40000 ALTER TABLE `model_has_roles` DISABLE KEYS */;
/*!40000 ALTER TABLE `model_has_roles` ENABLE KEYS */;

-- Dumping structure for table saas.orders
CREATE TABLE IF NOT EXISTS `orders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_number` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_exp_month` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_exp_year` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_address_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT '0',
  `shipping_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `price` double(8,2) DEFAULT NULL,
  `coupon` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `coupon_json` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `discount_price` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `plan_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `plan_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `price_currency` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `txn_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payment_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payment_status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `receipt` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` int NOT NULL DEFAULT '0',
  `subscription_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payer_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_frequency` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.orders: 4 rows
/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
INSERT INTO `orders` (`id`, `order_id`, `name`, `email`, `card_number`, `card_exp_month`, `card_exp_year`, `user_address_id`, `product_id`, `shipping_data`, `price`, `coupon`, `coupon_json`, `discount_price`, `plan_name`, `plan_id`, `product`, `price_currency`, `txn_id`, `payment_type`, `payment_status`, `status`, `phone`, `receipt`, `user_id`, `subscription_id`, `payer_id`, `payment_frequency`, `customer_id`, `created_by`, `created_at`, `updated_at`) VALUES
	(1, '1681839440', NULL, 'abc@gmail.com', '', '', '', '1', '1,2', '', 130.00, '1', '{"id":1,"name":"Test","code":"75UO4B8HUD","enable_flat":"on","discount":0,"flat_discount":10,"limit":5,"description":null,"store_id":1,"created_by":2,"created_at":"2023-04-18T16:59:31.000000Z","updated_at":"2023-04-18T16:59:31.000000Z"}', '$0.00', NULL, NULL, '{"1681833570":{"product_id":"1","product_name":"organce","image":"r3_1681547841.jpg","quantity":"3","price":"20","id":"1","downloadable_prodcut":null,"subtotal":"60","originalquantity":"10","variant_id":"0"},"1681836987":{"product_id":"2","product_name":"Chilli","image":"v1 (1)_1681547772.jpg","quantity":"4","price":"20","id":"2","downloadable_prodcut":null,"subtotal":"80","originalquantity":"50","variant_name":"10 pcs","variant_price":"20","variant_qty":"50","variant_subtotal":"$1,000.00","originalvariantquantity":"50","variant_id":"5"}}', 'USD', '', 'COD', 'approved', 'pending', NULL, '', 1, NULL, NULL, NULL, '2', 0, '2023-04-18 12:07:26', '2023-04-18 12:07:26'),
	(2, '1681841690', NULL, 'abc@gmail.com', '', '', '', '2', '1', '', 40.00, '0', '""', '$0.00', NULL, NULL, '{"1681841675":{"product_id":"1","product_name":"organce","image":"r3_1681547841.jpg","quantity":"2","price":"20","id":"1","downloadable_prodcut":null,"subtotal":"40","originalquantity":"7","variant_id":"0"}}', 'USD', '', 'COD', 'approved', 'pending', NULL, '', 1, NULL, NULL, NULL, '2', 0, '2023-04-18 12:45:05', '2023-04-18 12:45:05'),
	(3, '1681918968', 'Aida Bugg', 'abc@gmail.com', '', '', '', '3', '3', '', 30.00, '', '""', '', NULL, NULL, '{"1681918328":{"product_id":3,"product_name":"Tomato","image":"v3_1681550776.jpg","quantity":1,"price":30,"id":"3","downloadable_prodcut":"","tax":[],"subtotal":"$30.00","originalquantity":50,"variant_id":0}}', 'USD', 'pay_Lfhjn0e4p1jz0M', 'razerpay', 'success', 'pending', NULL, '', 1, NULL, NULL, NULL, '2', 0, '2023-04-19 10:12:48', '2023-04-19 10:12:48'),
	(4, '1681922576', NULL, 'abc@gmail.com', '', '', '', '4', '1,3', '', 30.00, NULL, '""', '$0.00', NULL, NULL, '{"1681921373":{"product_id":"1","product_name":"organce","image":"r3_1681547841.jpg","quantity":"1","price":"20","id":"1","downloadable_prodcut":null,"subtotal":"$20.00","originalquantity":"5","variant_id":"0"},"1681922570":{"product_id":"3","product_name":"Tomato","image":"v3_1681550776.jpg","quantity":"1","price":"30","id":"3","downloadable_prodcut":null,"subtotal":"$30.00","originalquantity":"49","variant_name":"4 pcs","variant_price":"10","variant_qty":"50","variant_subtotal":"$500.00","originalvariantquantity":"50","variant_id":"4"}}', 'USD', '', 'COD', 'approved', 'pending', NULL, '', 1, NULL, NULL, NULL, '2', 0, '2023-04-19 11:12:58', '2023-04-19 11:12:58');
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;

-- Dumping structure for table saas.page_options
CREATE TABLE IF NOT EXISTS `page_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `enable_page_header` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_page_footer` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `contents` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `store_id` int NOT NULL DEFAULT '0',
  `created_by` int NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.page_options: 2 rows
/*!40000 ALTER TABLE `page_options` DISABLE KEYS */;
INSERT INTO `page_options` (`id`, `name`, `slug`, `enable_page_header`, `enable_page_footer`, `contents`, `store_id`, `created_by`, `created_at`, `updated_at`) VALUES
	(1, 'About Us', 'about-us', 'on', 'off', '<h3 style="-webkit-tap-highlight-color: transparent; text-decoration-line: inherit; vertical-align: baseline; margin: 15px 0px; padding: 0px; font-size: 14px; list-style: none; font-family: &quot;Open Sans&quot;, Arial, sans-serif; color: rgb(0, 0, 0);">The standard Lorem Ipsum passage, used since the 1500s</h3><p style="-webkit-tap-highlight-color: transparent; text-decoration-line: inherit; vertical-align: baseline; margin-right: 0px; margin-bottom: 15px; margin-left: 0px; padding: 0px; list-style: none; font-family: &quot;Open Sans&quot;, Arial, sans-serif; color: rgb(39, 52, 68); text-align: justify;">"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum."</p><h3 style="-webkit-tap-highlight-color: transparent; text-decoration-line: inherit; vertical-align: baseline; margin: 15px 0px; padding: 0px; font-size: 14px; list-style: none; font-family: &quot;Open Sans&quot;, Arial, sans-serif; color: rgb(0, 0, 0);">Section 1.10.32 of "de Finibus Bonorum et Malorum", written by Cicero in 45 BC</h3><p style="-webkit-tap-highlight-color: transparent; text-decoration-line: inherit; vertical-align: baseline; margin-right: 0px; margin-bottom: 15px; margin-left: 0px; padding: 0px; list-style: none; font-family: &quot;Open Sans&quot;, Arial, sans-serif; color: rgb(39, 52, 68); text-align: justify;">"Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?"</p><h3 style="-webkit-tap-highlight-color: transparent; text-decoration-line: inherit; vertical-align: baseline; margin: 15px 0px; padding: 0px; font-size: 14px; list-style: none; font-family: &quot;Open Sans&quot;, Arial, sans-serif; color: rgb(0, 0, 0);">1914 translation by H. Rackham</h3><p style="-webkit-tap-highlight-color: transparent; text-decoration-line: inherit; vertical-align: baseline; margin-right: 0px; margin-bottom: 15px; margin-left: 0px; padding: 0px; list-style: none; font-family: &quot;Open Sans&quot;, Arial, sans-serif; color: rgb(39, 52, 68); text-align: justify;">"But I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally encounter consequences that are extremely painful. Nor again is there anyone who loves or pursues or desires to obtain pain of itself, because it is pain, but because occasionally circumstances occur in which toil and pain can procure him some great pleasure. To take a trivial example, which of us ever undertakes laborious physical exercise, except to obtain some advantage from it? But who has any right to find fault with a man who chooses to enjoy a pleasure that has no annoying consequences, or one who avoids a pain that produces no resultant pleasure?"</p>', 1, 2, '2023-04-15 04:24:51', '2023-04-15 04:24:51'),
	(2, 'Support', 'support', 'on', 'off', '<h3 style="-webkit-tap-highlight-color: transparent; text-decoration-line: inherit; vertical-align: baseline; margin: 15px 0px; padding: 0px; font-size: 14px; list-style: none; font-family: &quot;Open Sans&quot;, Arial, sans-serif; color: rgb(0, 0, 0);">The standard Lorem Ipsum passage, used since the 1500s</h3><p style="-webkit-tap-highlight-color: transparent; text-decoration-line: inherit; vertical-align: baseline; margin-right: 0px; margin-bottom: 15px; margin-left: 0px; padding: 0px; list-style: none; font-family: &quot;Open Sans&quot;, Arial, sans-serif; color: rgb(39, 52, 68); text-align: justify;">"Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum."</p><h3 style="-webkit-tap-highlight-color: transparent; text-decoration-line: inherit; vertical-align: baseline; margin: 15px 0px; padding: 0px; font-size: 14px; list-style: none; font-family: &quot;Open Sans&quot;, Arial, sans-serif; color: rgb(0, 0, 0);">Section 1.10.32 of "de Finibus Bonorum et Malorum", written by Cicero in 45 BC</h3><p style="-webkit-tap-highlight-color: transparent; text-decoration-line: inherit; vertical-align: baseline; margin-right: 0px; margin-bottom: 15px; margin-left: 0px; padding: 0px; list-style: none; font-family: &quot;Open Sans&quot;, Arial, sans-serif; color: rgb(39, 52, 68); text-align: justify;">"Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?"</p><h3 style="-webkit-tap-highlight-color: transparent; text-decoration-line: inherit; vertical-align: baseline; margin: 15px 0px; padding: 0px; font-size: 14px; list-style: none; font-family: &quot;Open Sans&quot;, Arial, sans-serif; color: rgb(0, 0, 0);">1914 translation by H. Rackham</h3><p style="-webkit-tap-highlight-color: transparent; text-decoration-line: inherit; vertical-align: baseline; margin-right: 0px; margin-bottom: 15px; margin-left: 0px; padding: 0px; list-style: none; font-family: &quot;Open Sans&quot;, Arial, sans-serif; color: rgb(39, 52, 68); text-align: justify;">"But I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally encounter consequences that are extremely painful. Nor again is there anyone who loves or pursues or desires to obtain pain of itself, because it is pain, but because occasionally circumstances occur in which toil and pain can procure him some great pleasure. To take a trivial example, which of us ever undertakes laborious physical exercise, except to obtain some advantage from it? But who has any right to find fault with a man who chooses to enjoy a pleasure that has no annoying consequences, or one who avoids a pain that produces no resultant pleasure?"</p>', 1, 2, '2023-04-15 04:25:19', '2023-04-15 04:25:19');
/*!40000 ALTER TABLE `page_options` ENABLE KEYS */;

-- Dumping structure for table saas.password_resets
CREATE TABLE IF NOT EXISTS `password_resets` (
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.password_resets: 0 rows
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;

-- Dumping structure for table saas.permissions
CREATE TABLE IF NOT EXISTS `permissions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.permissions: 0 rows
/*!40000 ALTER TABLE `permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `permissions` ENABLE KEYS */;

-- Dumping structure for table saas.personal_access_tokens
CREATE TABLE IF NOT EXISTS `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.personal_access_tokens: ~0 rows (approximately)

-- Dumping structure for table saas.plans
CREATE TABLE IF NOT EXISTS `plans` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` double(8,2) NOT NULL DEFAULT '0.00',
  `duration` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `max_stores` int NOT NULL DEFAULT '0',
  `max_products` int NOT NULL DEFAULT '0',
  `enable_custdomain` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'off',
  `enable_custsubdomain` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'off',
  `additional_page` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `blog` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_method` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `plans_name_unique` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.plans: 1 rows
/*!40000 ALTER TABLE `plans` DISABLE KEYS */;
INSERT INTO `plans` (`id`, `name`, `price`, `duration`, `max_stores`, `max_products`, `enable_custdomain`, `enable_custsubdomain`, `additional_page`, `blog`, `shipping_method`, `image`, `description`, `created_at`, `updated_at`) VALUES
	(1, 'Free Plan', 0.00, 'Unlimited', 2, 5, 'on', 'on', 'on', 'on', 'on', 'free_plan.png', 'For companies that need a robust full-featured time tracker.', '2023-04-13 10:03:38', '2023-04-13 10:03:38');
/*!40000 ALTER TABLE `plans` ENABLE KEYS */;

-- Dumping structure for table saas.plan_orders
CREATE TABLE IF NOT EXISTS `plan_orders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_number` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_exp_month` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `card_exp_year` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `plan_name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `plan_id` int NOT NULL,
  `price` double(8,2) DEFAULT NULL,
  `coupon` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `coupon_json` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `discount_price` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `price_currency` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `txn_id` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `payment_status` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `receipt` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` int NOT NULL DEFAULT '0',
  `store_id` int NOT NULL DEFAULT '0',
  `payment_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `plan_orders_order_id_unique` (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.plan_orders: 0 rows
/*!40000 ALTER TABLE `plan_orders` DISABLE KEYS */;
/*!40000 ALTER TABLE `plan_orders` ENABLE KEYS */;

-- Dumping structure for table saas.plan_requests
CREATE TABLE IF NOT EXISTS `plan_requests` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `plan_id` int NOT NULL,
  `duration` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'monthly',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.plan_requests: 0 rows
/*!40000 ALTER TABLE `plan_requests` DISABLE KEYS */;
/*!40000 ALTER TABLE `plan_requests` ENABLE KEYS */;

-- Dumping structure for table saas.products
CREATE TABLE IF NOT EXISTS `products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `store_id` int NOT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_categorie` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_subcategorie` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price` double(8,2) DEFAULT NULL,
  `last_price` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quantity` int NOT NULL DEFAULT '0',
  `SKU` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_tax` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field_1` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_value_1` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field_2` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_value_2` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field_3` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_value_3` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field_4` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_value_4` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `product_display` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'off',
  `downloadable_prodcut` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_product_variant` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'off',
  `variants_json` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `is_cover` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `attachment` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_active` int DEFAULT NULL,
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `detail` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `specification` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_by` int NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=58 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.products: 25 rows
/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` (`id`, `store_id`, `name`, `product_categorie`, `product_subcategorie`, `price`, `last_price`, `quantity`, `SKU`, `product_tax`, `custom_field_1`, `custom_value_1`, `custom_field_2`, `custom_value_2`, `custom_field_3`, `custom_value_3`, `custom_field_4`, `custom_value_4`, `product_display`, `downloadable_prodcut`, `enable_product_variant`, `variants_json`, `is_cover`, `attachment`, `is_active`, `description`, `detail`, `specification`, `created_by`, `created_at`, `updated_at`) VALUES
	(1, 1, 'organce', '1', NULL, 20.00, '19', 4, 'organce', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'on', '', 'off', '[{"variant_name":"Wight","variant_options":["500gm","1Kg","2Kg"]}]', 'r3_1681547841.jpg', '', NULL, 'Oranges are a favourite snack for many people. They can be eaten out-of-hand or used as a garnish. Besides orange juices, which are very popular worldwide, there are many other culinary uses of oranges. Oranges can be made into jams, marmalades, and preserves with the addition of sugar. They may also be used in salads, desserts, ice creams, sorbets, and savoury dishes. So, go ahead, buy Orange Imported 1 kg online now!', 'Oranges are a favourite snack for many people. They can be eaten out-of-hand or used as a garnish. Besides orange juices, which are very popular worldwide, there are many other culinary uses of oranges. Oranges can be made into jams, marmalades, and preserves with the addition of sugar. They may also be used in salads, desserts, ice creams, sorbets, and savoury dishes. So, go ahead, buy Orange Imported 1 kg online now!', 'Oranges are a favourite snack for many people. They can be eaten out-of-hand or used as a garnish. Besides orange juices, which are very popular worldwide, there are many other culinary uses of oranges. Oranges can be made into jams, marmalades, and preserves with the addition of sugar. They may also be used in salads, desserts, ice creams, sorbets, and savoury dishes. So, go ahead, buy Orange Imported 1 kg online now!', 2, '2023-04-14 11:37:33', '2023-04-19 11:12:58'),
	(3, 1, 'Tomato', '2', NULL, 30.00, '35', 49, 'Tomato', NULL, '', '', '', '', '', '', '', '', 'on', '', 'off', '{}', 'v3_1681550776.jpg', '', NULL, 'Tometo are a favourite snack for many people. They can be eaten out-of-hand or used as a garnish. Besides orange juices, which are very popular worldwide, there are many other culinary uses of oranges. Oranges can be made into jams, marmalades, and preserves with the addition of sugar. They may also be used in salads, desserts, ice creams, sorbets, and savoury dishes. So, go ahead, buy Orange Imported 1 kg online now!', 'Tometo are a favourite snack for many people. They can be eaten out-of-hand or used as a garnish. Besides orange juices, which are very popular worldwide, there are many other culinary uses of oranges. Oranges can be made into jams, marmalades, and preserves with the addition of sugar. They may also be used in salads, desserts, ice creams, sorbets, and savoury dishes. So, go ahead, buy Orange Imported 1 kg online now!', 'Tometo are a favourite snack for many people. They can be eaten out-of-hand or used as a garnish. Besides orange juices, which are very popular worldwide, there are many other culinary uses of oranges. Oranges can be made into jams, marmalades, and preserves with the addition of sugar. They may also be used in salads, desserts, ice creams, sorbets, and savoury dishes. So, go ahead, buy Orange Imported 1 kg online now!', 2, '2023-04-15 03:56:16', '2023-04-19 10:06:53'),
	(2, 1, 'Chilli', '2', NULL, 20.00, '15', 50, 'Chilli', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'on', '', 'on', '[{"variant_name":"PCS","variant_options":["4 pcs","10 pcs"," 20 pcs"]}]', 'v1 (1)_1681547772.jpg', '', NULL, 'High quality Fresh Orange fruit exporters from South Korea for sale. All citrus trees belong to the single genus Citrus and remain almost entirely interfertile. This includes grapefruits, lemons, limes, oranges, and various other types and hybrids. The fruit of any citrus tree is considered a hesperidium, a kind of modified berry; it is covered by a rind wall.', 'High quality Fresh Orange fruit exporters from South Korea for sale. All citrus trees belong to the single genus Citrus and remain almost entirely interfertile. This includes grapefruits, lemons, limes, oranges, and various other types and hybrids. The fruit of any citrus tree is considered a hesperidium, a kind of modified berry; it is covered by a rind wall.', 'High quality Fresh Orange fruit exporters from South Korea for sale. All citrus trees belong to the single genus Citrus and remain almost entirely interfertile. This includes grapefruits, lemons, limes, oranges, and various other types and hybrids. The fruit of any citrus tree is considered a hesperidium, a kind of modified berry; it is covered by a rind wall.', 2, '2023-04-15 03:06:12', '2023-04-15 03:23:09'),
	(45, 0, 'Oprah Randolph', '4', '1', 808.00, '520', 931, 'Tempora in sit nequ', NULL, 'Culpa doloribus dol', 'Alias deserunt corru', 'Nam perspiciatis te', 'Ut vel laudantium f', 'Dignissimos et repre', 'Aliqua Sed do excep', 'Est ipsum et facili', 'Quia sint est quae s', 'off', '', 'off', '{}', '', '', NULL, NULL, NULL, NULL, 1, '2023-07-24 04:09:13', '2023-08-02 08:49:07'),
	(46, 0, 'Eagan Luna', '4', '1', 443.00, '287', 257, 'Ad ea in ut veritati', NULL, 'Consequuntur officii', 'Quia eos voluptas in', 'Modi irure blanditii', 'Tempora omnis dolor', 'In ullamco recusanda', 'Ut esse quia unde e', 'Nemo et dolor iste s', 'Saepe corporis quis', 'off', '', 'off', '{}', '', '', NULL, NULL, NULL, NULL, 1, '2023-07-24 04:09:27', '2023-08-02 08:45:36'),
	(47, 0, 'Dexter Berg', '8', '3', 738.00, '35', 706, 'Ut non laborum Pari', NULL, 'Consequatur enim se', 'Voluptas minima susc', 'Voluptas pariatur M', 'Consectetur qui exer', 'Quis et voluptate te', 'Nostrum dicta repreh', 'Officiis consequatur', 'Omnis eligendi neces', 'off', '', 'off', '{}', '', '', NULL, NULL, NULL, NULL, 1, '2023-07-24 04:13:12', '2023-08-02 08:49:20'),
	(48, 0, 'Ursa Ball', '8', '2', 665.00, '68', 574, 'Nobis quod beatae eo', NULL, 'Facilis est dolore b', 'Aliquid esse minim c', 'Vitae esse ullam no', 'Labore ipsa odio vo', 'Mollitia ut voluptas', 'Amet laboriosam ea', 'Enim temporibus volu', 'Facere doloremque qu', 'off', '', 'off', '{}', '', '', NULL, NULL, NULL, NULL, 1, '2023-07-24 04:13:37', '2023-08-02 08:46:04'),
	(49, 37, 'Oprah Randolph', '4', NULL, 808.00, '520', 931, 'Tempora in sit nequ', NULL, 'Culpa doloribus dol', 'Alias deserunt corru', 'Nam perspiciatis te', 'Ut vel laudantium f', 'Dignissimos et repre', 'Aliqua Sed do excep', 'Est ipsum et facili', 'Quia sint est quae s', 'on', '', 'off', '{}', '', '', NULL, NULL, NULL, NULL, 1, '2023-07-24 08:16:18', '2023-07-24 08:16:18'),
	(50, 37, 'Eagan Luna', '4', NULL, 443.00, '287', 257, 'Ad ea in ut veritati', NULL, 'Consequuntur officii', 'Quia eos voluptas in', 'Modi irure blanditii', 'Tempora omnis dolor', 'In ullamco recusanda', 'Ut esse quia unde e', 'Nemo et dolor iste s', 'Saepe corporis quis', 'on', '', 'off', '{}', '', '', NULL, NULL, NULL, NULL, 1, '2023-07-24 08:16:18', '2023-07-24 08:16:18'),
	(51, 38, 'Oprah Randolph', '4', NULL, 808.00, '520', 931, 'Tempora in sit nequ', NULL, 'Culpa doloribus dol', 'Alias deserunt corru', 'Nam perspiciatis te', 'Ut vel laudantium f', 'Dignissimos et repre', 'Aliqua Sed do excep', 'Est ipsum et facili', 'Quia sint est quae s', 'on', '', 'off', '{}', '', '', NULL, NULL, NULL, NULL, 1, '2023-07-24 08:18:11', '2023-07-24 08:18:11'),
	(52, 38, 'Eagan Luna', '4', NULL, 443.00, '287', 257, 'Ad ea in ut veritati', NULL, 'Consequuntur officii', 'Quia eos voluptas in', 'Modi irure blanditii', 'Tempora omnis dolor', 'In ullamco recusanda', 'Ut esse quia unde e', 'Nemo et dolor iste s', 'Saepe corporis quis', 'on', '', 'off', '{}', '', '', NULL, NULL, NULL, NULL, 1, '2023-07-24 08:18:11', '2023-07-24 08:18:11'),
	(53, 38, 'Dexter Berg', '5', NULL, 738.00, '35', 706, 'Ut non laborum Pari', NULL, 'Consequatur enim se', 'Voluptas minima susc', 'Voluptas pariatur M', 'Consectetur qui exer', 'Quis et voluptate te', 'Nostrum dicta repreh', 'Officiis consequatur', 'Omnis eligendi neces', 'on', '', 'off', '{}', '', '', NULL, NULL, NULL, NULL, 1, '2023-07-24 08:21:25', '2023-07-24 08:21:25'),
	(37, 16, 'Helen Clements', NULL, NULL, 740.00, '286', 37, 'Et recusandae Sunt', NULL, 'Ut autem do facere e', 'Totam sequi perspici', 'Esse possimus quib', 'Optio non nihil est', 'Omnis consectetur N', 'Officia repellendus', 'Magni sit esse nec', 'Ut totam quia non es', 'on', '', 'on', '[{"variant_name":"Size","variant_options":["M","L"]}]', '', '', NULL, NULL, NULL, NULL, 1, '2023-06-20 13:19:28', '2023-06-20 13:19:28'),
	(31, 1, 'Helen Clements', NULL, NULL, 740.00, '286', 37, 'Et recusandae Sunt', NULL, 'Ut autem do facere e', 'Totam sequi perspici', 'Esse possimus quib', 'Optio non nihil est', 'Omnis consectetur N', 'Officia repellendus', 'Magni sit esse nec', 'Ut totam quia non es', 'on', '', 'on', '[{"variant_name":"Size","variant_options":["M","L"]}]', '', '', NULL, NULL, NULL, NULL, 1, '2023-06-20 05:35:09', '2023-06-20 05:35:09'),
	(32, 1, 'Ronan William', NULL, NULL, 709.00, '384', 265, 'Enim dicta dolor quo', NULL, 'Non veritatis suscip', 'Illo excepturi volup', 'Tenetur rerum cumque', 'Ratione dolore qui v', 'Et explicabo Aut qu', 'Explicabo Aspernatu', 'Esse atque natus dol', 'Consectetur alias s', 'on', '', 'on', '[{"variant_name":"Size","variant_options":["X","M"]}]', '', '', NULL, NULL, NULL, NULL, 1, '2023-06-20 05:35:09', '2023-06-20 05:35:09'),
	(35, 1, 'Talon Massey', NULL, NULL, 989.00, '317', 214, 'Iure aut accusantium', NULL, 'Quibusdam et in labo', 'Repudiandae a beatae', 'Excepturi sequi labo', 'Ducimus cupidatat d', 'Hic vel repellendus', 'Blanditiis cupidatat', 'Possimus aut volupt', 'Tempor quis ut corru', 'on', '', 'on', '[{"variant_name":"Size","variant_options":["M","L","x"]}]', '', '', NULL, NULL, NULL, NULL, 1, '2023-06-20 07:52:52', '2023-06-20 07:52:52'),
	(36, 1, 'Aaron Macdonald', NULL, NULL, 664.00, '559', 729, 'Vel dolores labore e', NULL, 'Architecto voluptas', 'Ut minus ex lorem di', 'Provident amet cor', 'Qui aliquid impedit', 'Temporibus ea aut cu', 'Aperiam dolor nulla', 'Corporis itaque irur', 'Ut voluptatem Ut do', 'on', '', 'off', '{}', '', '', NULL, NULL, NULL, NULL, 1, '2023-06-20 07:54:13', '2023-06-20 07:54:13'),
	(38, 16, 'Talon Massey', NULL, NULL, 989.00, '317', 214, 'Iure aut accusantium', NULL, 'Quibusdam et in labo', 'Repudiandae a beatae', 'Excepturi sequi labo', 'Ducimus cupidatat d', 'Hic vel repellendus', 'Blanditiis cupidatat', 'Possimus aut volupt', 'Tempor quis ut corru', 'on', '', 'on', '[{"variant_name":"Size","variant_options":["M","L","x"]}]', '', '', NULL, NULL, NULL, NULL, 1, '2023-06-20 13:19:28', '2023-06-20 13:19:28'),
	(40, 17, 'Helen Clements', NULL, NULL, 740.00, '286', 37, 'Et recusandae Sunt', NULL, 'Ut autem do facere e', 'Totam sequi perspici', 'Esse possimus quib', 'Optio non nihil est', 'Omnis consectetur N', 'Officia repellendus', 'Magni sit esse nec', 'Ut totam quia non es', 'on', '', 'on', '[{"variant_name":"Size","variant_options":["M","L"]}]', '', '', NULL, NULL, NULL, NULL, 1, '2023-06-22 03:47:13', '2023-06-22 03:47:13'),
	(41, 17, 'Keegan Roberts', NULL, NULL, 259.00, '575', 687, 'Laudantium fuga Do', NULL, 'Nam nisi dolores est', 'Aut quisquam nobis a', 'Quae id aliquid ut v', 'Obcaecati praesentiu', 'Minim praesentium ad', 'Aliquid id sed sit', 'Cupidatat voluptatum', 'Eligendi non magni s', 'on', '', 'on', '[{"variant_name":"Size","variant_options":["X","M","L"]}]', '', '', NULL, NULL, NULL, NULL, 1, '2023-06-22 03:47:13', '2023-06-22 03:47:13'),
	(42, 1, 'Regan Jarvis', NULL, NULL, 182.00, '447', 553, 'Eum numquam quasi ut', NULL, 'Aut suscipit asperna', 'Velit qui eu dolore', 'Animi labore eum na', 'Dolorem officia labo', 'Eligendi dolor place', 'Magna quo possimus', 'Nemo quia earum sunt', 'Est voluptatum susci', 'on', '', 'off', '{}', '', '', NULL, NULL, NULL, NULL, 1, '2023-06-27 00:40:16', '2023-06-27 00:40:16'),
	(43, 34, 'Regan Jarvis', NULL, NULL, 182.00, '447', 553, 'Eum numquam quasi ut', NULL, 'Aut suscipit asperna', 'Velit qui eu dolore', 'Animi labore eum na', 'Dolorem officia labo', 'Eligendi dolor place', 'Magna quo possimus', 'Nemo quia earum sunt', 'Est voluptatum susci', 'on', '', 'off', '{}', '', '', NULL, NULL, NULL, NULL, 1, '2023-07-20 04:46:22', '2023-07-20 04:46:22'),
	(44, 34, 'Helen Clements', NULL, NULL, 740.00, '286', 37, 'Et recusandae Sunt', NULL, 'Ut autem do facere e', 'Totam sequi perspici', 'Esse possimus quib', 'Optio non nihil est', 'Omnis consectetur N', 'Officia repellendus', 'Magni sit esse nec', 'Ut totam quia non es', 'on', '', 'on', '[{"variant_name":"Size","variant_options":["M","L"]}]', '', '', NULL, NULL, NULL, NULL, 1, '2023-07-20 04:46:22', '2023-07-20 04:46:22'),
	(54, 42, 'Oprah Randolph', '4', NULL, 808.00, '520', 931, 'Tempora in sit nequ', NULL, 'Culpa doloribus dol', 'Alias deserunt corru', 'Nam perspiciatis te', 'Ut vel laudantium f', 'Dignissimos et repre', 'Aliqua Sed do excep', 'Est ipsum et facili', 'Quia sint est quae s', 'on', '', 'off', '{}', '', '', NULL, NULL, NULL, NULL, 1, '2023-08-03 02:29:48', '2023-08-03 02:29:48'),
	(55, 42, 'Eagan Luna', '4', NULL, 443.00, '287', 257, 'Ad ea in ut veritati', NULL, 'Consequuntur officii', 'Quia eos voluptas in', 'Modi irure blanditii', 'Tempora omnis dolor', 'In ullamco recusanda', 'Ut esse quia unde e', 'Nemo et dolor iste s', 'Saepe corporis quis', 'on', '', 'off', '{}', '', '', NULL, NULL, NULL, NULL, 1, '2023-08-03 02:29:52', '2023-08-03 02:29:52'),
	(56, 43, 'Oprah Randolph', '4', '1', 808.00, '520', 931, 'Tempora in sit nequ', NULL, 'Culpa doloribus dol', 'Alias deserunt corru', 'Nam perspiciatis te', 'Ut vel laudantium f', 'Dignissimos et repre', 'Aliqua Sed do excep', 'Est ipsum et facili', 'Quia sint est quae s', 'on', '', 'off', '{}', '', '', NULL, NULL, NULL, NULL, 1, '2023-08-03 02:39:44', '2023-08-03 02:39:44'),
	(57, 43, 'Eagan Luna', '4', '1', 443.00, '287', 257, 'Ad ea in ut veritati', NULL, 'Consequuntur officii', 'Quia eos voluptas in', 'Modi irure blanditii', 'Tempora omnis dolor', 'In ullamco recusanda', 'Ut esse quia unde e', 'Nemo et dolor iste s', 'Saepe corporis quis', 'on', '', 'off', '{}', '', '', NULL, NULL, NULL, NULL, 1, '2023-08-03 02:39:44', '2023-08-03 02:39:44');
/*!40000 ALTER TABLE `products` ENABLE KEYS */;

-- Dumping structure for table saas.product_categories
CREATE TABLE IF NOT EXISTS `product_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `categorie_img` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `store_id` int NOT NULL DEFAULT '0',
  `created_by` int NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.product_categories: 10 rows
/*!40000 ALTER TABLE `product_categories` DISABLE KEYS */;
INSERT INTO `product_categories` (`id`, `name`, `categorie_img`, `store_id`, `created_by`, `created_at`, `updated_at`) VALUES
	(1, 'Fruits', 'fruits_1681372325_1681487962.png', 1, 2, '2023-04-14 10:29:22', '2023-04-14 10:29:22'),
	(2, 'Vegetable', 'healthy-food_1681372345_1681487987.png', 1, 2, '2023-04-14 10:29:47', '2023-04-14 10:29:47'),
	(3, 'Fashion', NULL, 0, 1, '2023-07-24 02:12:29', '2023-07-24 02:12:29'),
	(4, 'Cosmetics', NULL, 0, 1, '2023-07-24 02:12:59', '2023-07-24 02:12:59'),
	(5, 'Electronics', NULL, 0, 1, '2023-07-24 02:13:14', '2023-07-24 02:13:14'),
	(6, 'Footwear', NULL, 0, 1, '2023-07-24 02:13:37', '2023-07-24 02:13:37'),
	(7, 'Grocery', NULL, 0, 1, '2023-07-24 02:13:52', '2023-07-24 02:13:52'),
	(8, 'Vegitable', NULL, 0, 1, '2023-07-24 02:18:08', '2023-07-24 02:18:08'),
	(9, 'Cosmetics', NULL, 41, 1, '2023-08-03 02:28:46', '2023-08-03 02:28:46'),
	(10, 'Cosmetics', NULL, 42, 1, '2023-08-03 02:29:47', '2023-08-03 02:29:47'),
	(11, 'Cosmetics', NULL, 43, 47, '2023-08-03 02:39:44', '2023-08-03 02:39:44');
/*!40000 ALTER TABLE `product_categories` ENABLE KEYS */;

-- Dumping structure for table saas.product_coupons
CREATE TABLE IF NOT EXISTS `product_coupons` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `enable_flat` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'off',
  `new_user_only` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'off',
  `free_shiping` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'off',
  `discount` double(8,2) NOT NULL DEFAULT '0.00',
  `flat_discount` double(8,2) DEFAULT '0.00',
  `limit` int NOT NULL DEFAULT '0',
  `minimum_spend` double(8,2) NOT NULL,
  `maximum_spend` double(8,2) NOT NULL,
  `coupon_products` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `exclude_products` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `coupon_expiry` date DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `store_id` int NOT NULL DEFAULT '0',
  `created_by` int NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.product_coupons: 1 rows
/*!40000 ALTER TABLE `product_coupons` DISABLE KEYS */;
INSERT INTO `product_coupons` (`id`, `name`, `code`, `enable_flat`, `new_user_only`, `free_shiping`, `discount`, `flat_discount`, `limit`, `minimum_spend`, `maximum_spend`, `coupon_products`, `exclude_products`, `coupon_expiry`, `description`, `store_id`, `created_by`, `created_at`, `updated_at`) VALUES
	(1, 'Test', '75UO4B8HUD', 'on', 'off', 'off', 0.00, 10.00, 5, 0.00, 0.00, NULL, NULL, NULL, NULL, 1, 2, '2023-04-18 11:29:31', '2023-04-18 11:29:31');
/*!40000 ALTER TABLE `product_coupons` ENABLE KEYS */;

-- Dumping structure for table saas.product_images
CREATE TABLE IF NOT EXISTS `product_images` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int NOT NULL,
  `product_images` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.product_images: 8 rows
/*!40000 ALTER TABLE `product_images` DISABLE KEYS */;
INSERT INTO `product_images` (`id`, `product_id`, `product_images`, `created_at`, `updated_at`) VALUES
	(3, 1, 'r3_1681547841.jpg', '2023-04-15 03:07:21', '2023-04-15 03:07:21'),
	(4, 1, 'r3_1681547841.jpg', '2023-04-15 03:07:21', '2023-04-15 03:07:21'),
	(5, 2, 'r1 (1)_1681548789.jpg', '2023-04-15 03:23:09', '2023-04-15 03:23:09'),
	(6, 2, 'r1 (1)_1681548789.jpg', '2023-04-15 03:23:09', '2023-04-15 03:23:09'),
	(7, 2, 'r3 (1)_1681548789.jpg', '2023-04-15 03:23:09', '2023-04-15 03:23:09'),
	(8, 2, 'r3 (1)_1681548789.jpg', '2023-04-15 03:23:09', '2023-04-15 03:23:09'),
	(9, 3, 'r1 (1)_1681550776.jpg', '2023-04-15 03:56:16', '2023-04-15 03:56:16'),
	(10, 3, 'r3 (1)_1681550776.jpg', '2023-04-15 03:56:16', '2023-04-15 03:56:16');
/*!40000 ALTER TABLE `product_images` ENABLE KEYS */;

-- Dumping structure for table saas.product_subcategories
CREATE TABLE IF NOT EXISTS `product_subcategories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `store_id` int NOT NULL DEFAULT '0',
  `created_by` int NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.product_subcategories: ~4 rows (approximately)
INSERT INTO `product_subcategories` (`id`, `category_id`, `name`, `store_id`, `created_by`, `created_at`, `updated_at`) VALUES
	(1, 4, 'Hilary Lowetr gf', 0, 1, '2023-08-01 05:20:45', '2023-08-01 05:26:00'),
	(2, 8, 'Tometo', 0, 1, '2023-08-01 10:39:05', '2023-08-01 10:39:05'),
	(3, 8, 'Ptetots', 0, 1, '2023-08-01 11:16:03', '2023-08-01 11:16:03'),
	(4, 4, 'Hilary Lowetr gf', 42, 1, '2023-08-03 02:29:47', '2023-08-03 02:29:47'),
	(5, 4, 'Hilary Lowetr gf', 43, 47, '2023-08-03 02:39:44', '2023-08-03 02:39:44');

-- Dumping structure for table saas.product_taxes
CREATE TABLE IF NOT EXISTS `product_taxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tax_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sgst_rate` double(8,2) NOT NULL DEFAULT '0.00',
  `cgst_rate` double(8,2) NOT NULL DEFAULT '0.00',
  `igst_rate` double(8,2) NOT NULL DEFAULT '0.00',
  `rounding` int NOT NULL DEFAULT '0',
  `shop_price` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cart_price` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `rate` double(8,2) NOT NULL,
  `store_id` int NOT NULL DEFAULT '0',
  `created_by` int NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.product_taxes: 0 rows
/*!40000 ALTER TABLE `product_taxes` DISABLE KEYS */;
/*!40000 ALTER TABLE `product_taxes` ENABLE KEYS */;

-- Dumping structure for table saas.product_variant_options
CREATE TABLE IF NOT EXISTS `product_variant_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price` double(25,2) DEFAULT '0.00',
  `discount_price` double(25,2) DEFAULT '0.00',
  `quantity` int NOT NULL DEFAULT '0',
  `created_by` int NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.product_variant_options: 14 rows
/*!40000 ALTER TABLE `product_variant_options` DISABLE KEYS */;
INSERT INTO `product_variant_options` (`id`, `product_id`, `image`, `name`, `price`, `discount_price`, `quantity`, `created_by`, `created_at`, `updated_at`) VALUES
	(1, 1, '', '500gm', 19.00, 0.00, 10, 2, '2023-04-14 11:37:33', '2023-04-14 11:37:33'),
	(2, 1, '', '1Kg', 35.00, 0.00, 5, 2, '2023-04-14 11:37:33', '2023-04-14 11:37:33'),
	(3, 1, '', '2Kg', 70.00, 0.00, 3, 2, '2023-04-14 11:37:33', '2023-04-14 11:37:33'),
	(4, 2, '', '4 pcs', 10.00, 0.00, 49, 2, '2023-04-15 03:06:12', '2023-04-19 11:12:58'),
	(5, 2, '', '10 pcs', 20.00, 0.00, 46, 2, '2023-04-15 03:06:12', '2023-04-18 12:07:26'),
	(6, 2, '', '20 pcs', 40.00, 0.00, 50, 2, '2023-04-15 03:06:12', '2023-04-15 03:06:43'),
	(12, 31, '03_1686969008.jpg', 'M', 100.00, 999.00, 10, 1, '2023-06-20 05:35:09', '2023-06-20 05:35:09'),
	(13, 31, '04_1686969008.jpg', 'L', 1000.00, 990.00, 10, 1, '2023-06-20 05:35:09', '2023-06-20 05:35:09'),
	(14, 37, '03_1686969008.jpg', 'M', 100.00, 999.00, 10, 1, '2023-06-20 13:19:28', '2023-06-20 13:19:28'),
	(15, 37, '04_1686969008.jpg', 'L', 1000.00, 990.00, 10, 1, '2023-06-20 13:19:28', '2023-06-20 13:19:28'),
	(16, 40, '03_1686969008.jpg', 'M', 100.00, 999.00, 10, 1, '2023-06-22 03:47:13', '2023-06-22 03:47:13'),
	(17, 40, '04_1686969008.jpg', 'L', 1000.00, 990.00, 10, 1, '2023-06-22 03:47:13', '2023-06-22 03:47:13'),
	(18, 44, '03_1686969008.jpg', 'M', 100.00, 999.00, 10, 1, '2023-07-20 04:46:22', '2023-07-20 04:46:22'),
	(19, 44, '04_1686969008.jpg', 'L', 1000.00, 990.00, 10, 1, '2023-07-20 04:46:22', '2023-07-20 04:46:22');
/*!40000 ALTER TABLE `product_variant_options` ENABLE KEYS */;

-- Dumping structure for table saas.purchased_products
CREATE TABLE IF NOT EXISTS `purchased_products` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int NOT NULL,
  `product_id` int NOT NULL,
  `order_id` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.purchased_products: 6 rows
/*!40000 ALTER TABLE `purchased_products` DISABLE KEYS */;
INSERT INTO `purchased_products` (`id`, `customer_id`, `product_id`, `order_id`, `created_at`, `updated_at`) VALUES
	(1, 2, 1, 1, '2023-04-18 12:07:26', '2023-04-18 12:07:26'),
	(2, 2, 2, 1, '2023-04-18 12:07:26', '2023-04-18 12:07:26'),
	(3, 2, 1, 2, '2023-04-18 12:45:05', '2023-04-18 12:45:05'),
	(4, 2, 3, 3, '2023-04-19 10:12:48', '2023-04-19 10:12:48'),
	(5, 2, 1, 4, '2023-04-19 11:12:58', '2023-04-19 11:12:58'),
	(6, 2, 3, 4, '2023-04-19 11:12:58', '2023-04-19 11:12:58');
/*!40000 ALTER TABLE `purchased_products` ENABLE KEYS */;

-- Dumping structure for table saas.rattings
CREATE TABLE IF NOT EXISTS `rattings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `product_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `rating_view` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'on',
  `ratting` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.rattings: 2 rows
/*!40000 ALTER TABLE `rattings` DISABLE KEYS */;
INSERT INTO `rattings` (`id`, `slug`, `product_id`, `name`, `title`, `rating_view`, `ratting`, `description`, `created_at`, `updated_at`) VALUES
	(1, 'my-store', '1', 'Abc', 'Must', 'on', '4', 'dsasdsd', '2023-04-15 02:19:15', '2023-04-15 02:19:15'),
	(2, 'my-store', '2', 'Arjun', 'Abc', 'on', '4', 'dsdsd', '2023-04-15 03:26:11', '2023-04-15 03:26:11');
/*!40000 ALTER TABLE `rattings` ENABLE KEYS */;

-- Dumping structure for table saas.roles
CREATE TABLE IF NOT EXISTS `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `guard_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_by` int NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.roles: 0 rows
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;

-- Dumping structure for table saas.role_has_permissions
CREATE TABLE IF NOT EXISTS `role_has_permissions` (
  `permission_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.role_has_permissions: 0 rows
/*!40000 ALTER TABLE `role_has_permissions` DISABLE KEYS */;
/*!40000 ALTER TABLE `role_has_permissions` ENABLE KEYS */;

-- Dumping structure for table saas.services
CREATE TABLE IF NOT EXISTS `services` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_active` int NOT NULL DEFAULT '1',
  `json` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `html` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `created_by` bigint DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.services: ~3 rows (approximately)
INSERT INTO `services` (`id`, `title`, `description`, `logo`, `is_active`, `json`, `html`, `created_at`, `updated_at`, `created_by`) VALUES
	(2, 'Jackson Wood', NULL, 'bricks_1682102679.jpg', 1, '', '', '2023-04-21 12:44:29', '2023-04-21 13:14:39', 2),
	(3, 'Hakeem Cardenas', NULL, 'background_image_2_1682102667.jpg', 1, '[[\r\n  {\r\n    "type": "checkbox-group",\r\n    "required": false,\r\n    "label": "Checkbox Group",\r\n    "inline": false,\r\n    "name": "checkbox-group-1682104177695-0",\r\n    "other": false,\r\n    "column": "1",\r\n    "is_enable_chart": false,\r\n    "chart_type": "bar",\r\n    "values": [\r\n      {\r\n        "label": "Option 1",\r\n        "value": "option-1",\r\n        "selected": true\r\n      }\r\n    ]\r\n  },\r\n  {\r\n    "type": "text",\r\n    "required": false,\r\n    "label": "Text Field",\r\n    "className": "form-control",\r\n    "name": "text-1682104167980-0",\r\n    "subtype": "text",\r\n    "column": "1"\r\n  },\r\n  {\r\n    "type": "textarea",\r\n    "required": false,\r\n    "label": "Text Area",\r\n    "className": "form-control",\r\n    "name": "textarea-1682104172836-0",\r\n    "subtype": "textarea",\r\n    "column": "1"\r\n  },\r\n  {\r\n    "type": "textarea",\r\n    "required": false,\r\n    "label": "Text Area",\r\n    "className": "form-control",\r\n    "name": "textarea-1682104186967-0",\r\n    "subtype": "textarea",\r\n    "column": "1"\r\n  }\r\n],[\r\n  {\r\n    "type": "date",\r\n    "required": false,\r\n    "label": "Date Field",\r\n    "className": "form-control",\r\n    "name": "date-1682104311022-0",\r\n    "column": "1",\r\n    "is_enable_chart": false,\r\n    "chart_type": "bar"\r\n  },\r\n  {\r\n    "type": "checkbox-group",\r\n    "required": false,\r\n    "label": "Checkbox Group",\r\n    "inline": false,\r\n    "name": "checkbox-group-1682104309270-0",\r\n    "other": false,\r\n    "column": "1",\r\n    "is_enable_chart": false,\r\n    "chart_type": "bar",\r\n    "values": [\r\n      {\r\n        "label": "Option 1",\r\n        "value": "option-1",\r\n        "selected": true\r\n      }\r\n    ]\r\n  },\r\n  {\r\n    "type": "radio-group",\r\n    "required": false,\r\n    "label": "Radio Group",\r\n    "inline": false,\r\n    "name": "radio-group-1682104313696-0",\r\n    "other": false,\r\n    "column": "1",\r\n    "is_enable_chart": false,\r\n    "chart_type": "bar",\r\n    "values": [\r\n      {\r\n        "label": "Option 1",\r\n        "value": "option-1",\r\n        "selected": false\r\n      },\r\n      {\r\n        "label": "Option 2",\r\n        "value": "option-2",\r\n        "selected": false\r\n      },\r\n      {\r\n        "label": "Option 3",\r\n        "value": "option-3",\r\n        "selected": false\r\n      }\r\n    ]\r\n  }\r\n]]', '', '2023-04-21 12:48:39', '2023-04-21 13:41:55', 2),
	(4, 'Test Service', NULL, 'background_image_1682104726.jpg', 1, '[[\r\n  {\r\n    "type": "text",\r\n    "required": false,\r\n    "label": "Title",\r\n    "className": "form-control",\r\n    "name": "text-1682104741575-0",\r\n    "subtype": "text",\r\n    "column": "1"\r\n  },\r\n  {\r\n    "type": "textarea",\r\n    "subtype": "ckeditor",\r\n    "required": false,\r\n    "label": "Description",\r\n    "className": "form-control",\r\n    "name": "textarea-1682104755647-0",\r\n    "column": "1"\r\n  },\r\n  {\r\n    "type": "radio-group",\r\n    "required": false,\r\n    "label": "Select One",\r\n    "inline": false,\r\n    "name": "radio-group-1682104771801-0",\r\n    "other": false,\r\n    "column": "1",\r\n    "is_enable_chart": false,\r\n    "chart_type": "bar",\r\n    "values": [\r\n      {\r\n        "label": "Option 1",\r\n        "value": "option-1",\r\n        "selected": false\r\n      },\r\n      {\r\n        "label": "Option 2",\r\n        "value": "option-2",\r\n        "selected": false\r\n      },\r\n      {\r\n        "label": "Option 3",\r\n        "value": "option-3",\r\n        "selected": false\r\n      }\r\n    ]\r\n  },\r\n  {\r\n    "type": "select",\r\n    "required": false,\r\n    "label": "Select City",\r\n    "className": "form-control",\r\n    "name": "select-1682104807500-0",\r\n    "multiple": false,\r\n    "column": "1",\r\n    "is_enable_chart": false,\r\n    "chart_type": "bar",\r\n    "values": [\r\n      {\r\n        "label": "Surat",\r\n        "value": "surat",\r\n        "selected": true\r\n      },\r\n      {\r\n        "label": "Mathura",\r\n        "value": "mathura",\r\n        "selected": false\r\n      },\r\n      {\r\n        "label": "Baroda",\r\n        "value": "baroda",\r\n        "selected": false\r\n      }\r\n    ]\r\n  },\r\n  {\r\n    "type": "file",\r\n    "required": true,\r\n    "label": "Logo",\r\n    "className": "form-control",\r\n    "name": "file-1682104866141-0",\r\n    "subtype": "file",\r\n    "multiple": false,\r\n    "column": "1"\r\n  },\r\n  {\r\n    "type": "date",\r\n    "required": true,\r\n    "label": "Date Of Birth",\r\n    "className": "form-control",\r\n    "name": "date-1682104882740-0",\r\n    "column": "1",\r\n    "is_enable_chart": false,\r\n    "chart_type": "bar"\r\n  },\r\n  {\r\n    "type": "starRating",\r\n    "required": false,\r\n    "label": "Review",\r\n    "name": "starRating-1682104898158-0",\r\n    "column": "1",\r\n    "is_enable_chart": false,\r\n    "chart_type": "bar"\r\n  },\r\n  {\r\n    "type": "checkbox-group",\r\n    "required": false,\r\n    "label": "Hobbies",\r\n    "inline": false,\r\n    "name": "checkbox-group-1682104922630-0",\r\n    "other": false,\r\n    "column": "1",\r\n    "is_enable_chart": false,\r\n    "chart_type": "bar",\r\n    "values": [\r\n      {\r\n        "label": "Cricket",\r\n        "value": "cricket",\r\n        "selected": true\r\n      },\r\n      {\r\n        "label": "Dancing",\r\n        "value": "dancing",\r\n        "selected": false\r\n      },\r\n      {\r\n        "label": "Reading",\r\n        "value": "reading",\r\n        "selected": false\r\n      }\r\n    ]\r\n  }\r\n]]', '', '2023-04-21 13:48:46', '2023-04-21 14:26:12', 2),
	(5, 'Yael Duke', 'Aut porro natus quia Good', '', 1, '', '', '2023-06-26 06:56:22', '2023-06-26 06:56:42', 2);

-- Dumping structure for table saas.service_values
CREATE TABLE IF NOT EXISTS `service_values` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `service_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `json` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.service_values: ~4 rows (approximately)
INSERT INTO `service_values` (`id`, `service_id`, `user_id`, `json`, `created_at`, `updated_at`) VALUES
	(1, 4, 2, '[[{"type":"text","required":false,"label":"Title","className":"form-control","name":"text-1682104741575-0","subtype":"text","column":"1","value":"Porro omnis itaque s"},{"type":"textarea","subtype":"ckeditor","required":false,"label":"Description","className":"form-control","name":"textarea-1682104755647-0","column":"1","value":"Sint harum sequi Na"},{"type":"radio-group","required":false,"label":"Select One","inline":false,"name":"radio-group-1682104771801-0","other":false,"column":"1","is_enable_chart":false,"chart_type":"bar","values":[{"label":"Option 1","value":"option-1","selected":1},{"label":"Option 2","value":"option-2"},{"label":"Option 3","value":"option-3"}]},{"type":"select","required":false,"label":"Select City","className":"form-control","name":"select-1682104807500-0","multiple":false,"column":"1","is_enable_chart":false,"chart_type":"bar","values":[{"label":"Surat","value":"surat"},{"label":"Mathura","value":"mathura"},{"label":"Baroda","value":"baroda","selected":1}]},{"type":"file","required":true,"label":"Logo","className":"form-control","name":"file-1682104866141-0","subtype":"file","multiple":false,"column":"1","value":["form_values\\/4\\/IC0O0EXYYU1OhuFMOM542cipacrJlM6MhJbZabfS.jpg"]},{"type":"date","required":true,"label":"Date Of Birth","className":"form-control","name":"date-1682104882740-0","column":"1","is_enable_chart":false,"chart_type":"bar","value":"1981-01-18"},{"type":"starRating","required":false,"label":"Review","name":"starRating-1682104898158-0","column":"1","is_enable_chart":false,"chart_type":"bar","value":"0"},{"type":"checkbox-group","required":false,"label":"Hobbies","inline":false,"name":"checkbox-group-1682104922630-0","other":false,"column":"1","is_enable_chart":false,"chart_type":"bar","values":[{"label":"Cricket","value":"cricket"},{"label":"Dancing","value":"dancing","selected":1},{"label":"Reading","value":"reading"}]}]]', '2023-04-29 10:44:19', '2023-04-29 10:44:19'),
	(2, 4, 2, '[[{"type":"text","required":false,"label":"Title","className":"form-control","name":"text-1682104741575-0","subtype":"text","column":"1","value":"Porro omnis itaque s"},{"type":"textarea","subtype":"ckeditor","required":false,"label":"Description","className":"form-control","name":"textarea-1682104755647-0","column":"1","value":"Sint harum sequi Na"},{"type":"radio-group","required":false,"label":"Select One","inline":false,"name":"radio-group-1682104771801-0","other":false,"column":"1","is_enable_chart":false,"chart_type":"bar","values":[{"label":"Option 1","value":"option-1","selected":1},{"label":"Option 2","value":"option-2"},{"label":"Option 3","value":"option-3"}]},{"type":"select","required":false,"label":"Select City","className":"form-control","name":"select-1682104807500-0","multiple":false,"column":"1","is_enable_chart":false,"chart_type":"bar","values":[{"label":"Surat","value":"surat"},{"label":"Mathura","value":"mathura"},{"label":"Baroda","value":"baroda","selected":1}]},{"type":"file","required":true,"label":"Logo","className":"form-control","name":"file-1682104866141-0","subtype":"file","multiple":false,"column":"1","value":["form_values\\/4\\/ot8nIR8iPFHbebvejT43UjmS9vGt3Ei0f22yZaeQ.jpg"]},{"type":"date","required":true,"label":"Date Of Birth","className":"form-control","name":"date-1682104882740-0","column":"1","is_enable_chart":false,"chart_type":"bar","value":"1981-01-18"},{"type":"starRating","required":false,"label":"Review","name":"starRating-1682104898158-0","column":"1","is_enable_chart":false,"chart_type":"bar","value":"0"},{"type":"checkbox-group","required":false,"label":"Hobbies","inline":false,"name":"checkbox-group-1682104922630-0","other":false,"column":"1","is_enable_chart":false,"chart_type":"bar","values":[{"label":"Cricket","value":"cricket"},{"label":"Dancing","value":"dancing","selected":1},{"label":"Reading","value":"reading"}]}]]', '2023-04-29 10:45:46', '2023-04-29 10:45:46'),
	(3, 4, 2, '[[{"type":"text","required":false,"label":"Title","className":"form-control","name":"text-1682104741575-0","subtype":"text","column":"1","value":"Porro omnis itaque s"},{"type":"textarea","subtype":"ckeditor","required":false,"label":"Description","className":"form-control","name":"textarea-1682104755647-0","column":"1","value":"Sint harum sequi Na"},{"type":"radio-group","required":false,"label":"Select One","inline":false,"name":"radio-group-1682104771801-0","other":false,"column":"1","is_enable_chart":false,"chart_type":"bar","values":[{"label":"Option 1","value":"option-1","selected":1},{"label":"Option 2","value":"option-2"},{"label":"Option 3","value":"option-3"}]},{"type":"select","required":false,"label":"Select City","className":"form-control","name":"select-1682104807500-0","multiple":false,"column":"1","is_enable_chart":false,"chart_type":"bar","values":[{"label":"Surat","value":"surat"},{"label":"Mathura","value":"mathura"},{"label":"Baroda","value":"baroda","selected":1}]},{"type":"file","required":true,"label":"Logo","className":"form-control","name":"file-1682104866141-0","subtype":"file","multiple":false,"column":"1","value":["form_values\\/4\\/g8g9YFICzkQx0wLbXnRpehNfT70JBew2zmPpRVHu.jpg"]},{"type":"date","required":true,"label":"Date Of Birth","className":"form-control","name":"date-1682104882740-0","column":"1","is_enable_chart":false,"chart_type":"bar","value":"1981-01-18"},{"type":"starRating","required":false,"label":"Review","name":"starRating-1682104898158-0","column":"1","is_enable_chart":false,"chart_type":"bar","value":"0"},{"type":"checkbox-group","required":false,"label":"Hobbies","inline":false,"name":"checkbox-group-1682104922630-0","other":false,"column":"1","is_enable_chart":false,"chart_type":"bar","values":[{"label":"Cricket","value":"cricket"},{"label":"Dancing","value":"dancing","selected":1},{"label":"Reading","value":"reading"}]}]]', '2023-04-29 10:46:22', '2023-04-29 10:46:22'),
	(4, 4, 2, '[[{"type":"text","required":false,"label":"Title","className":"form-control","name":"text-1682104741575-0","subtype":"text","column":"1","value":"Praesentium itaque v"},{"type":"textarea","subtype":"ckeditor","required":false,"label":"Description","className":"form-control","name":"textarea-1682104755647-0","column":"1","value":"Excepturi voluptatum"},{"type":"radio-group","required":false,"label":"Select One","inline":false,"name":"radio-group-1682104771801-0","other":false,"column":"1","is_enable_chart":false,"chart_type":"bar","values":[{"label":"Option 1","value":"option-1"},{"label":"Option 2","value":"option-2","selected":1},{"label":"Option 3","value":"option-3"}]},{"type":"select","required":false,"label":"Select City","className":"form-control","name":"select-1682104807500-0","multiple":false,"column":"1","is_enable_chart":false,"chart_type":"bar","values":[{"label":"Surat","value":"surat","selected":1},{"label":"Mathura","value":"mathura"},{"label":"Baroda","value":"baroda"}]},{"type":"file","required":true,"label":"Logo","className":"form-control","name":"file-1682104866141-0","subtype":"file","multiple":false,"column":"1","value":["form_values\\/4\\/qg0scDi2l9eipvVPyxbHKE43SRVdtqSEchg5Qflb.jpg"]},{"type":"date","required":true,"label":"Date Of Birth","className":"form-control","name":"date-1682104882740-0","column":"1","is_enable_chart":false,"chart_type":"bar","value":"1978-10-17"},{"type":"starRating","required":false,"label":"Review","name":"starRating-1682104898158-0","column":"1","is_enable_chart":false,"chart_type":"bar","value":"0"},{"type":"checkbox-group","required":false,"label":"Hobbies","inline":false,"name":"checkbox-group-1682104922630-0","other":false,"column":"1","is_enable_chart":false,"chart_type":"bar","values":[{"label":"Cricket","value":"cricket","selected":1},{"label":"Dancing","value":"dancing","selected":1},{"label":"Reading","value":"reading","selected":1}]}]]', '2023-04-29 10:47:00', '2023-04-29 10:47:00'),
	(5, 4, 2, '[[{"type":"text","required":false,"label":"Title","className":"form-control","name":"text-1682104741575-0","subtype":"text","column":"1","value":"Incididunt voluptati"},{"type":"textarea","subtype":"ckeditor","required":false,"label":"Description","className":"form-control","name":"textarea-1682104755647-0","column":"1","value":"Est voluptas quis a"},{"type":"radio-group","required":false,"label":"Select One","inline":false,"name":"radio-group-1682104771801-0","other":false,"column":"1","is_enable_chart":false,"chart_type":"bar","values":[{"label":"Option 1","value":"option-1","selected":1},{"label":"Option 2","value":"option-2"},{"label":"Option 3","value":"option-3"}]},{"type":"select","required":false,"label":"Select City","className":"form-control","name":"select-1682104807500-0","multiple":false,"column":"1","is_enable_chart":false,"chart_type":"bar","values":[{"label":"Surat","value":"surat","selected":1},{"label":"Mathura","value":"mathura"},{"label":"Baroda","value":"baroda"}]},{"type":"file","required":true,"label":"Logo","className":"form-control","name":"file-1682104866141-0","subtype":"file","multiple":false,"column":"1","value":["form_values\\/4\\/xfMEwqWjXO5uQmGvf0ZP44rD9DpIvh4HbrRuRTYY.jpg"]},{"type":"date","required":true,"label":"Date Of Birth","className":"form-control","name":"date-1682104882740-0","column":"1","is_enable_chart":false,"chart_type":"bar","value":"1986-04-21"},{"type":"starRating","required":false,"label":"Review","name":"starRating-1682104898158-0","column":"1","is_enable_chart":false,"chart_type":"bar","value":"2.5"},{"type":"checkbox-group","required":false,"label":"Hobbies","inline":false,"name":"checkbox-group-1682104922630-0","other":false,"column":"1","is_enable_chart":false,"chart_type":"bar","values":[{"label":"Cricket","value":"cricket","selected":1},{"label":"Dancing","value":"dancing","selected":1},{"label":"Reading","value":"reading","selected":1}]}]]', '2023-04-29 10:49:35', '2023-04-29 10:49:35');

-- Dumping structure for table saas.settings
CREATE TABLE IF NOT EXISTS `settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_by` int NOT NULL,
  `store_id` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `settings_name_created_by_store_id_unique` (`name`,`created_by`,`store_id`)
) ENGINE=MyISAM AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.settings: 43 rows
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` (`id`, `name`, `value`, `created_by`, `store_id`, `created_at`, `updated_at`) VALUES
	(1, 'local_storage_validation', 'jpg,jpeg,png,xlsx,xls,csv,pdf', 1, 0, '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(2, 'wasabi_storage_validation', 'jpg,jpeg,png,xlsx,xls,csv,pdf', 1, 0, '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(3, 's3_storage_validation', 'jpg,jpeg,png,xlsx,xls,csv,pdf', 1, 0, '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(4, 'local_storage_max_upload_size', '2048000', 1, 0, '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(5, 'wasabi_max_upload_size', '2048000', 1, 0, '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(6, 's3_max_upload_size', '2048000', 1, 0, '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(7, 'storage_setting', 'local', 1, 0, '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(8, 'company_logo_dark', '1681545111_logo-dark.png', 2, 1, NULL, NULL),
	(9, 'company_logo_light', '1681922706logo-light.png', 2, 1, NULL, NULL),
	(10, 'site_date_format', 'M j, Y', 2, 1, NULL, NULL),
	(11, 'site_time_format', 'g:i A', 2, 1, NULL, NULL),
	(12, 'cust_theme_bg', 'on', 2, 1, NULL, NULL),
	(13, 'SITE_RTL', 'off', 2, 1, NULL, NULL),
	(14, 'cust_darklayout', 'off', 2, 1, NULL, NULL),
	(15, 'fashion_logo', 'fashion-logo.png', 1, 0, NULL, NULL),
	(16, 'cosmetics_logo', 'cosmetics-logo.png', 1, 0, NULL, NULL),
	(17, 'electronics_logo', 'electronics-logo.png', 1, 0, NULL, NULL),
	(18, 'footwear_logo', 'footwear-logo.png', 1, 0, NULL, NULL),
	(19, 'grocery_logo', 'grocery-logo.png', 1, 0, NULL, NULL),
	(20, 'electronics_logo', 'electronics-logo.png', 1, 16, NULL, NULL),
	(21, 'electronics_logo', 'electronics-logo.png', 1, 17, NULL, NULL),
	(22, 'currency', 'INR', 1, 0, '2023-06-26 02:29:32', '2023-06-26 02:29:32'),
	(23, 'currency_symbol', '$', 1, 0, '2023-06-26 02:29:32', '2023-06-26 02:29:32'),
	(24, 'paypal_mode', 'sandbox', 1, 0, '2023-06-26 02:29:32', '2023-06-26 02:29:32'),
	(25, 'paypal_client_id', '', 1, 0, '2023-06-26 02:29:32', '2023-06-26 02:29:32'),
	(26, 'paypal_secret_key', '', 1, 0, '2023-06-26 02:29:32', '2023-06-26 02:29:32'),
	(27, 'grocery_logo', 'grocery-logo.png', 1, 18, NULL, NULL),
	(28, 'fashion_logo', 'fashion-logo.png', 1, 19, NULL, NULL),
	(29, 'fashion_logo', 'fashion-logo.png', 1, 20, NULL, NULL),
	(30, 'cosmetics_logo', 'cosmetics-logo.png', 1, 21, NULL, NULL),
	(31, 'cosmetics_logo', 'cosmetics-logo.png', 1, 22, NULL, NULL),
	(32, 'grocery_logo', 'grocery-logo.png', 1, 23, NULL, NULL),
	(33, 'footwear_logo', 'footwear-logo.png', 1, 24, NULL, NULL),
	(34, 'cosmetics_logo', 'cosmetics-logo.png', 1, 25, NULL, NULL),
	(35, 'cosmetics_logo', 'cosmetics-logo.png', 1, 26, NULL, NULL),
	(36, 'footwear_logo', 'footwear-logo.png', 1, 27, NULL, NULL),
	(37, 'fashion_logo', 'fashion-logo.png', 1, 28, NULL, NULL),
	(38, 'fashion_logo', 'fashion-logo.png', 1, 29, NULL, NULL),
	(39, 'footwear_logo', 'footwear-logo.png', 1, 30, NULL, NULL),
	(40, 'footwear_logo', 'footwear-logo.png', 1, 31, NULL, NULL),
	(41, 'cosmetics_logo', 'cosmetics-logo.png', 1, 32, NULL, NULL),
	(42, 'footwear_logo', 'footwear-logo.png', 1, 33, NULL, NULL),
	(43, 'footwear_logo', 'footwear-logo.png', 1, 34, NULL, NULL);
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;

-- Dumping structure for table saas.shippings
CREATE TABLE IF NOT EXISTS `shippings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `price` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `location_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `store_id` int NOT NULL DEFAULT '0',
  `created_by` int NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.shippings: 0 rows
/*!40000 ALTER TABLE `shippings` DISABLE KEYS */;
/*!40000 ALTER TABLE `shippings` ENABLE KEYS */;

-- Dumping structure for table saas.stores
CREATE TABLE IF NOT EXISTS `stores` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `store_theme` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `theme_dir` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `domains` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_storelink` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'on',
  `enable_subdomain` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subdomain` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_domain` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'off',
  `content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `item_variable` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `about` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `tagline` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang` varchar(5) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'en',
  `storejs` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `currency` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '$',
  `currency_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'USD',
  `currency_symbol_position` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'pre',
  `currency_symbol_space` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'without',
  `whatsapp` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#',
  `facebook` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#',
  `instagram` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#',
  `twitter` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#',
  `youtube` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#',
  `google_analytic` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fbpixel_code` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metakeyword` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadesc` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `decimal_number` int NOT NULL DEFAULT '2',
  `footer_note` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_header_img` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'on',
  `header_img` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `header_title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `header_desc` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `button_text` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_subscriber` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'on',
  `enable_rating` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'on',
  `blog_enable` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'on',
  `enable_shipping` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'on',
  `sub_img` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subscriber_title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_title` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `city` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `zipcode` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `logo` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `invoice_logo` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_twilio_enabled` varchar(225) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `twilio_sid` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `twilio_token` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `twilio_from` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `notification_number` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `is_stripe_enabled` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'off',
  `stripe_key` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `stripe_secret` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `is_paypal_enabled` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'off',
  `paypal_mode` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `paypal_client_id` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `paypal_secret_key` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `mail_driver` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `mail_host` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `mail_port` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `mail_username` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `mail_password` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `mail_encryption` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `mail_from_address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `mail_from_name` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `is_store_enabled` int NOT NULL DEFAULT '1',
  `is_checkout_login_required` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'on',
  `is_active` int NOT NULL DEFAULT '1',
  `created_by` int NOT NULL DEFAULT '0',
  `enable_whatsapp` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'off',
  `whatsapp_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_telegram` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telegrambot` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telegramchatid` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `enable_cod` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'off',
  `enable_bank` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'off',
  `bank_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=44 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.stores: 38 rows
/*!40000 ALTER TABLE `stores` DISABLE KEYS */;
INSERT INTO `stores` (`id`, `name`, `email`, `store_theme`, `theme_dir`, `domains`, `enable_storelink`, `enable_subdomain`, `subdomain`, `enable_domain`, `content`, `item_variable`, `about`, `tagline`, `slug`, `lang`, `storejs`, `currency`, `currency_code`, `currency_symbol_position`, `currency_symbol_space`, `whatsapp`, `facebook`, `instagram`, `twitter`, `youtube`, `google_analytic`, `fbpixel_code`, `metakeyword`, `metadesc`, `decimal_number`, `footer_note`, `enable_header_img`, `header_img`, `header_title`, `header_desc`, `button_text`, `enable_subscriber`, `enable_rating`, `blog_enable`, `enable_shipping`, `sub_img`, `subscriber_title`, `sub_title`, `address`, `city`, `state`, `zipcode`, `country`, `logo`, `invoice_logo`, `is_twilio_enabled`, `twilio_sid`, `twilio_token`, `twilio_from`, `notification_number`, `is_stripe_enabled`, `stripe_key`, `stripe_secret`, `is_paypal_enabled`, `paypal_mode`, `paypal_client_id`, `paypal_secret_key`, `mail_driver`, `mail_host`, `mail_port`, `mail_username`, `mail_password`, `mail_encryption`, `mail_from_address`, `mail_from_name`, `is_store_enabled`, `is_checkout_login_required`, `is_active`, `created_by`, `enable_whatsapp`, `whatsapp_number`, `enable_telegram`, `telegrambot`, `telegramchatid`, `enable_cod`, `enable_bank`, `bank_number`, `created_at`, `updated_at`) VALUES
	(1, 'new store', 'owner@example.com', 'green-color.css', 'theme', 'adc.com', 'on', 'off', 'my-store.localhost', 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\nThanks {store_name}\n', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, NULL, 'new-store', 'en', NULL, '$', 'USD', 'pre', 'without', '#', '#', '#', '#', '#', NULL, '5977959308981088', NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '1680890150_logo-dark_1681922858.png', 'invoice_logo_1.png', NULL, NULL, NULL, NULL, NULL, 'off', '', '', 'off', 'sandbox', '', '', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 2, 'off', '', 'off', '', '', 'on', 'off', '', '2023-04-13 10:03:38', '2023-07-20 02:01:40'),
	(2, 'Div', 'divyangdhimmar2@gmail.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, NULL, 'div', 'en', NULL, '$', 'USD', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'invoice_logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', 'sandbox', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 3, 'off', NULL, NULL, NULL, NULL, 'off', 'off', NULL, '2023-04-25 13:25:59', '2023-04-25 13:25:59'),
	(3, 'test', 'gotep@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, NULL, 'test', 'en', NULL, '$', 'USD', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'invoice_logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', 'sandbox', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 5, 'off', NULL, NULL, NULL, NULL, 'off', 'off', NULL, '2023-06-02 06:54:06', '2023-06-02 06:54:06'),
	(4, 'good', 'rocij@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, NULL, 'good', 'en', NULL, '$', 'USD', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'invoice_logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', 'sandbox', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 6, 'off', NULL, NULL, NULL, NULL, 'off', 'off', NULL, '2023-06-02 06:54:50', '2023-06-02 06:54:50'),
	(5, 'hhh', 'wiluzav@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, NULL, 'hhh', 'en', NULL, '$', 'USD', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'invoice_logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', 'sandbox', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 7, 'off', NULL, NULL, NULL, NULL, 'off', 'off', NULL, '2023-06-02 06:56:15', '2023-06-02 06:56:15'),
	(6, 'huk', 'wode@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, NULL, 'huk', 'en', NULL, '$', 'USD', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'invoice_logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', 'sandbox', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 8, 'off', NULL, NULL, NULL, NULL, 'off', 'off', NULL, '2023-06-02 06:58:10', '2023-06-02 06:58:10'),
	(7, 'hj', 'tojypava@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, NULL, 'hj', 'en', NULL, '$', 'USD', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'invoice_logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', 'sandbox', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 9, 'off', NULL, NULL, NULL, NULL, 'off', 'off', NULL, '2023-06-02 07:09:54', '2023-06-02 07:09:54'),
	(8, 'bnbnm', 'vovexir@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, NULL, 'bnbnm', 'en', NULL, '$', 'USD', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'invoice_logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', 'sandbox', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 10, 'off', NULL, NULL, NULL, NULL, 'off', 'off', NULL, '2023-06-02 07:11:35', '2023-06-02 07:11:35'),
	(9, 'bnbnm', 'mexubohor@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, NULL, 'bnbnm-1', 'en', NULL, '$', 'USD', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'invoice_logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', 'sandbox', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 11, 'off', NULL, NULL, NULL, NULL, 'off', 'off', NULL, '2023-06-02 07:12:16', '2023-06-02 07:12:16'),
	(10, 'hj', 'mifo@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, NULL, 'hj-1', 'en', NULL, '$', 'USD', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'invoice_logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', 'sandbox', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 12, 'off', NULL, NULL, NULL, NULL, 'off', 'off', NULL, '2023-06-02 07:23:13', '2023-06-02 07:23:13'),
	(11, 'hjjhk', 'mozilyqu@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, NULL, 'hjjhk', 'en', NULL, '$', 'USD', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'invoice_logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', 'sandbox', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 13, 'off', NULL, NULL, NULL, NULL, 'off', 'off', NULL, '2023-06-02 07:33:53', '2023-06-02 07:33:53'),
	(12, 'test', 'qagy@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, NULL, 'test-1', 'en', NULL, '$', 'USD', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'invoice_logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', 'sandbox', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 14, 'off', NULL, NULL, NULL, NULL, 'off', 'off', NULL, '2023-06-02 07:36:16', '2023-06-02 07:36:16'),
	(13, 'hgjgj', 'qetuga@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, NULL, 'hgjgj', 'en', NULL, '$', 'USD', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'invoice_logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', 'sandbox', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 15, 'off', NULL, NULL, NULL, NULL, 'off', 'off', NULL, '2023-06-02 07:37:28', '2023-06-02 07:37:28'),
	(14, 'hgjgj', 'xobyfosise@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, NULL, 'hgjgj-1', 'en', NULL, '$', 'USD', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'invoice_logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', 'sandbox', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 16, 'off', NULL, NULL, NULL, NULL, 'off', 'off', NULL, '2023-06-02 07:39:17', '2023-06-02 07:39:17'),
	(15, 'Div', 'cahybas@mailinator.com', NULL, NULL, NULL, 'on', NULL, NULL, 'off', NULL, NULL, NULL, NULL, 'div-1', 'en', NULL, '$', 'USD', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'electronics-logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', 'sandbox', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 19, 'off', NULL, NULL, NULL, NULL, 'off', 'off', NULL, '2023-06-20 12:53:52', '2023-06-20 12:53:52'),
	(16, 'Div', 'cipu@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, NULL, 'div-2', 'en', NULL, '$', 'USD', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'electronics-logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', 'sandbox', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 20, 'off', NULL, NULL, NULL, NULL, 'off', 'off', NULL, '2023-06-20 12:56:01', '2023-06-20 12:56:01'),
	(17, 'avc', 'byqaqo@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, NULL, 'avc', 'en', NULL, '$', 'USD', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'electronics-logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', 'sandbox', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 21, 'off', NULL, NULL, NULL, NULL, 'off', 'off', NULL, '2023-06-22 03:46:32', '2023-06-22 03:46:32'),
	(18, 'Zenia Collier', 'netico@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, 'Velit veritatis susc', 'zenia-collier', 'en', NULL, 'Dolore numquam iusto', 'Quo similique omnis', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, 'Incidunt voluptatib', 'Qui cumque fuga Ani', 'Id magnam deserunt a', '99560', NULL, NULL, 'grocery-logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', 'sandbox', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 22, 'off', NULL, NULL, NULL, NULL, 'off', 'off', NULL, '2023-07-10 05:47:21', '2023-07-10 05:47:21'),
	(19, 'Dean Goodman', 'joradoqud@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, 'Cum quod est quis i', 'dean-goodman', 'en', NULL, '£', 'GBP', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, 'Alias quae nihil vol', 'Aut eum nobis dignis', 'Omnis dolorem magni', '31797', NULL, NULL, 'fashion-logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', 'sandbox', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 23, 'off', NULL, NULL, NULL, NULL, 'off', 'off', NULL, '2023-07-13 04:18:04', '2023-07-13 04:18:04'),
	(20, 'Dean Goodman', 'bydefyl@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, 'Cum quod est quis i', 'dean-goodman-1', 'en', NULL, '£', 'GBP', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, 'Alias quae nihil vol', 'Aut eum nobis dignis', 'Omnis dolorem magni', '31797', NULL, NULL, 'fashion-logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', 'sandbox', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 24, 'off', NULL, NULL, NULL, NULL, 'off', 'off', NULL, '2023-07-13 04:18:51', '2023-07-13 04:18:51'),
	(21, 'Fletcher Rodriguez', 'fykikynom@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, 'Id voluptatibus mag', 'fletcher-rodriguez', 'en', NULL, 'EUR', '€', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, 'Aut est molestias u', 'Distinctio Voluptat', 'Molestias repudianda', '74306', NULL, NULL, 'cosmetics-logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', 'sandbox', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 25, 'off', NULL, NULL, NULL, NULL, 'off', 'off', NULL, '2023-07-17 00:21:00', '2023-07-17 00:21:01'),
	(22, 'Amethyst Lopez', 'vysicex@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, 'Esse corporis incidi', 'amethyst-lopez', 'en', NULL, 'INR', '₹', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, 'Pariatur Aperiam vo', 'Ullamco consequatur', 'Tempor veritatis con', '13546', NULL, NULL, 'cosmetics-logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', 'sandbox', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 26, 'off', NULL, NULL, NULL, NULL, 'off', 'off', NULL, '2023-07-17 02:19:30', '2023-07-17 02:19:30'),
	(23, 'Ginger Schwartz', 'geguj@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, 'A et cumque autem qu', 'ginger-schwartz', 'en', NULL, 'EUR', '$', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, 'Est molestiae earum', 'Sunt sint nostrum vo', 'Dicta similique a no', '26186', NULL, NULL, 'grocery-logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', 'sandbox', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 27, 'off', NULL, NULL, NULL, NULL, 'off', 'off', NULL, '2023-07-17 03:11:24', '2023-07-17 03:11:24'),
	(24, 'Anne Bradford', 'sicid@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, 'Cillum architecto in', 'anne-bradford', 'en', NULL, 'INR', '¥', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, 'Eos sunt eos volup', 'Adipisci sed impedit', 'Harum mollit nesciun', '14343', NULL, NULL, 'footwear-logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', 'sandbox', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 28, 'off', NULL, NULL, NULL, NULL, 'off', 'off', NULL, '2023-07-20 03:55:40', '2023-07-20 03:55:40'),
	(25, 'Whitney Haynes', 'gybysy@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, 'Quia sit similique', 'whitney-haynes', 'en', NULL, 'EUR', '¥', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, 'Temporibus sed ut ve', 'Cillum voluptas eaqu', 'Laborum Adipisicing', '78862', NULL, NULL, 'cosmetics-logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', 'sandbox', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 29, 'off', NULL, NULL, NULL, NULL, 'off', 'off', NULL, '2023-07-20 03:57:15', '2023-07-20 03:57:15'),
	(26, 'Whitney Haynes', 'denyzanuda@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, 'Quia sit similique', 'whitney-haynes-1', 'en', NULL, 'EUR', '¥', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, 'Temporibus sed ut ve', 'Cillum voluptas eaqu', 'Laborum Adipisicing', '78862', NULL, NULL, 'cosmetics-logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', 'sandbox', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 30, 'off', NULL, NULL, NULL, NULL, 'off', 'off', NULL, '2023-07-20 03:58:48', '2023-07-20 03:58:48'),
	(27, 'Veronica Norton', 'loxajy@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, 'Quis ipsa atque cum', 'veronica-norton', 'en', NULL, 'YEN', '₹', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, 'Quaerat tempore con', 'Veniam adipisicing', 'Et minim dolores har', '47905', NULL, NULL, 'footwear-logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', 'sandbox', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 31, 'off', NULL, NULL, NULL, NULL, 'off', 'off', NULL, '2023-07-20 03:59:22', '2023-07-20 03:59:22'),
	(28, 'Mollie Lamb', 'xalo@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, 'Esse quis repudianda', 'mollie-lamb', 'en', NULL, 'INR', '€', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, 'Quia consequuntur of', 'Est impedit tempor', 'Aute fugit impedit', '21110', NULL, NULL, 'fashion-logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', 'sandbox', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 32, 'off', NULL, NULL, NULL, NULL, 'off', 'off', NULL, '2023-07-20 04:10:52', '2023-07-20 04:10:52'),
	(29, 'Mollie Lamb', 'filatylade@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, 'Esse quis repudianda', 'mollie-lamb-1', 'en', NULL, 'INR', '€', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, 'Quia consequuntur of', 'Est impedit tempor', 'Aute fugit impedit', '21110', NULL, NULL, 'fashion-logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 33, 'off', '', 'off', '', '', 'off', 'off', NULL, '2023-07-20 04:20:21', '2023-07-20 04:20:21'),
	(30, 'Drake Clark', 'zatokem@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, 'Esse quis repudianda', 'drake-clark', 'en', NULL, 'INR', '€', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, 'Quia consequuntur of', 'Est impedit tempor', 'Aute fugit impedit', '21110', NULL, NULL, 'footwear-logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 34, 'off', '', 'off', '', '', 'off', 'off', NULL, '2023-07-20 04:28:50', '2023-07-20 04:28:50'),
	(31, 'Drake Clark', 'lekugydajo@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, 'Esse quis repudianda', 'drake-clark-1', 'en', NULL, 'INR', '€', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, 'Quia consequuntur of', 'Est impedit tempor', 'Aute fugit impedit', '21110', NULL, NULL, 'footwear-logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 35, 'off', '', 'off', '', '', 'off', 'off', NULL, '2023-07-20 04:29:15', '2023-07-20 04:29:15'),
	(32, 'Caleb Fleming', 'jiqiwef@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, 'Magni qui cillum qui', 'caleb-fleming', 'en', NULL, 'GBP', '£', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, 'Ullamco nobis laudan', 'Voluptate voluptas v', 'Sit officiis fuga M', '54626', NULL, NULL, 'cosmetics-logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', 'sandbox', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 36, 'off', NULL, NULL, NULL, NULL, 'off', 'off', NULL, '2023-07-20 04:39:58', '2023-07-20 04:39:58'),
	(33, 'Renee Spencer', 'rivacyr@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, 'Porro eos nulla cons', 'renee-spencer', 'en', NULL, 'GBP', '$', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, 'Occaecat commodo rei', 'Facilis sint placeat', 'Iure quas consequunt', '98967', NULL, NULL, 'footwear-logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', 'sandbox', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 37, 'off', NULL, NULL, NULL, NULL, 'off', 'off', NULL, '2023-07-20 04:45:08', '2023-07-20 04:45:08'),
	(34, 'Renee Spencer', 'dabiqenu@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, 'Porro eos nulla cons', 'renee-spencer-1', 'en', NULL, 'GBP', '$', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, 'Occaecat commodo rei', 'Facilis sint placeat', 'Iure quas consequunt', '98967', NULL, NULL, 'footwear-logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 38, 'off', '', 'off', '', '', 'on', 'off', NULL, '2023-07-20 04:46:22', '2023-07-20 04:46:22'),
	(35, 'Cameron Callahan', 'fezaryd@mailinator.com', NULL, NULL, NULL, 'on', NULL, NULL, 'off', NULL, NULL, NULL, NULL, 'cameron-callahan', 'en', NULL, 'EUR', '₹', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'invoice_logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', 'sandbox', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 39, 'off', NULL, NULL, NULL, NULL, 'off', 'off', NULL, '2023-07-24 07:58:34', '2023-07-24 07:58:34'),
	(36, 'Orlando Delacruz', 'telom@mailinator.com', NULL, NULL, NULL, 'on', NULL, NULL, 'off', NULL, NULL, NULL, NULL, 'orlando-delacruz', 'en', NULL, 'INR', '$', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'invoice_logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', 'sandbox', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 40, 'off', NULL, NULL, NULL, NULL, 'off', 'off', NULL, '2023-07-24 08:14:17', '2023-07-24 08:14:17'),
	(37, 'Orlando Delacruz', 'telomdf@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, 'Facere incididunt qu', 'orlando-delacruz-1', 'en', NULL, 'INR', '$', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, 'Corporis veniam per', 'Ex quia animi rem d', 'Quo aut dolorem sed', '28403', NULL, NULL, 'invoice_logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 41, 'off', '', 'off', '', '', 'on', 'off', NULL, '2023-07-24 08:16:18', '2023-07-24 08:16:18'),
	(38, 'Orlando Delacruz', 'telomdsdf@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, 'Facere incididunt qu', 'orlando-delacruz-2', 'en', NULL, 'INR', '$', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, 'Corporis veniam per', 'Ex quia animi rem d', 'Quo aut dolorem sed', '28403', NULL, NULL, 'invoice_logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 42, 'off', '', 'off', '', '', 'on', 'off', NULL, '2023-07-24 08:18:11', '2023-07-24 08:18:11'),
	(39, 'Hop England', 'qevyj@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, 'Dolorum iste dolor e', 'hop-england', 'en', NULL, '£', 'EUR', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, 'Ut sint sapiente ad', 'Praesentium veniam', 'Impedit voluptate n', '55374', NULL, NULL, 'invoice_logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 43, 'off', '', 'off', '', '', 'on', 'off', NULL, '2023-08-02 19:53:15', '2023-08-02 19:53:15'),
	(40, 'Tallulah Dean', 'pymu@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, 'Possimus voluptatem', 'tallulah-dean', 'en', NULL, '$', 'USD', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, 'At cillum animi vol', 'Tempore accusantium', 'Cumque fuga Enim om', '73555', NULL, NULL, 'invoice_logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 44, 'off', '', 'off', '', '', 'off', 'off', NULL, '2023-08-03 02:16:14', '2023-08-03 02:16:14'),
	(41, 'Reuben Wade', 'hepaveha@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, 'Culpa eveniet hic i', 'reuben-wade', 'en', NULL, '$', 'EUR', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, 'Molestias recusandae', 'Architecto est face', 'Fugiat enim amet s', '48944', NULL, NULL, 'invoice_logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', 'sandbox', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 45, 'off', NULL, NULL, NULL, NULL, 'off', 'off', NULL, '2023-08-03 02:28:46', '2023-08-03 02:28:46'),
	(42, 'Reuben Wade', 'hepavegfgfha@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, 'Culpa eveniet hic i', 'reuben-wade-1', 'en', NULL, '$', 'EUR', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, 'Molestias recusandae', 'Architecto est face', 'Fugiat enim amet s', '48944', NULL, NULL, 'invoice_logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 46, 'off', '', 'off', '', '', 'off', 'off', NULL, '2023-08-03 02:29:47', '2023-08-03 02:29:52'),
	(43, 'Jason Peck', 'feqocuxim@mailinator.com', 'green-color.css', 'theme1', NULL, 'on', NULL, NULL, 'off', 'Hi,\n*Welcome to* {store_name},\nYour order is confirmed & your order no. is {order_no}\nYour order detail is:\nName : {customer_name}\nAddress : {billing_address} {billing_city} , {shipping_address} {shipping_city}\n~~~~~~~~~~~~~~~~\n{item_variable}\n~~~~~~~~~~~~~~~~\nQty Total : {qty_total}\nSub Total : {sub_total}\nDiscount Price : {discount_amount}\nShipping Price : {shipping_amount}\nTax : {total_tax}\nTotal : {final_total}\n~~~~~~~~~~~~~~~~~~\nTo collect the order you need to show the receipt at the counter.\n                Thanks {store_name}\n                ', '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}', NULL, 'Laborum Aliquam vel', 'jason-peck', 'en', NULL, '$', 'USD', 'pre', 'without', '#', '#', '#', '#', '#', NULL, NULL, NULL, NULL, 2, NULL, 'on', NULL, NULL, NULL, NULL, 'on', 'on', 'on', 'on', NULL, NULL, NULL, 'Unde cupiditate volu', 'Aute sed aperiam nis', 'Qui velit animi oc', '79861', NULL, NULL, 'invoice_logo.png', NULL, NULL, NULL, NULL, NULL, 'off', NULL, NULL, 'off', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1, 'on', 1, 47, 'off', '', 'off', '', '', 'on', 'off', NULL, '2023-08-03 02:39:44', '2023-08-03 02:39:44');
/*!40000 ALTER TABLE `stores` ENABLE KEYS */;

-- Dumping structure for table saas.store_payment_settings
CREATE TABLE IF NOT EXISTS `store_payment_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `store_id` int NOT NULL,
  `created_by` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `store_payment_settings_name_store_id_created_by_unique` (`name`,`store_id`,`created_by`)
) ENGINE=MyISAM AUTO_INCREMENT=108 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.store_payment_settings: 39 rows
/*!40000 ALTER TABLE `store_payment_settings` DISABLE KEYS */;
INSERT INTO `store_payment_settings` (`id`, `name`, `value`, `store_id`, `created_by`, `created_at`, `updated_at`) VALUES
	(1, 'custom_field_title_1', '', 1, 2, NULL, NULL),
	(2, 'custom_field_title_2', '', 1, 2, NULL, NULL),
	(3, 'custom_field_title_3', '', 1, 2, NULL, NULL),
	(4, 'custom_field_title_4', '', 1, 2, NULL, NULL),
	(5, 'is_stripe_enabled', 'off', 1, 2, NULL, NULL),
	(6, 'is_paypal_enabled', 'off', 1, 2, NULL, NULL),
	(7, 'is_paystack_enabled', 'off', 1, 2, NULL, NULL),
	(8, 'is_flutterwave_enabled', 'off', 1, 2, NULL, NULL),
	(9, 'is_razorpay_enabled', 'on', 1, 2, NULL, NULL),
	(10, 'razorpay_public_key', 'rzp_test_e8PsdGTRCf72A3', 1, 2, NULL, NULL),
	(11, 'razorpay_secret_key', 'ICKMMeS7W9lDNZXz9PsCcHz8', 1, 2, NULL, NULL),
	(12, 'is_paytm_enabled', 'off', 1, 2, NULL, NULL),
	(13, 'is_mercado_enabled', 'off', 1, 2, NULL, NULL),
	(14, 'is_mollie_enabled', 'off', 1, 2, NULL, NULL),
	(15, 'is_skrill_enabled', 'off', 1, 2, NULL, NULL),
	(16, 'is_coingate_enabled', 'off', 1, 2, NULL, NULL),
	(17, 'is_paymentwall_enabled', 'off', 1, 2, NULL, NULL),
	(18, 'enable_telegram', 'off', 1, 2, NULL, NULL),
	(19, 'is_onemoney_enabled', 'on', 1, 2, NULL, NULL),
	(20, 'onemony_mode', 'sandbox', 1, 2, NULL, NULL),
	(21, 'onemoney_public_key', 'abcd', 1, 2, NULL, NULL),
	(22, 'onemoney_secret_key', 'asdkfl', 1, 2, NULL, NULL),
	(23, 'custom_field_title_1', NULL, 38, 42, NULL, NULL),
	(24, 'custom_field_title_2', NULL, 38, 42, NULL, NULL),
	(25, 'custom_field_title_3', NULL, 38, 42, NULL, NULL),
	(26, 'custom_field_title_4', NULL, 38, 42, NULL, NULL),
	(27, 'is_stripe_enabled', 'off', 38, 42, NULL, NULL),
	(28, 'is_paypal_enabled', 'off', 38, 42, NULL, NULL),
	(29, 'is_paystack_enabled', 'off', 38, 42, NULL, NULL),
	(30, 'is_flutterwave_enabled', 'off', 38, 42, NULL, NULL),
	(31, 'is_razorpay_enabled', 'off', 38, 42, NULL, NULL),
	(32, 'is_paytm_enabled', 'off', 38, 42, NULL, NULL),
	(33, 'is_mercado_enabled', 'off', 38, 42, NULL, NULL),
	(34, 'is_mollie_enabled', 'off', 38, 42, NULL, NULL),
	(35, 'is_skrill_enabled', 'off', 38, 42, NULL, NULL),
	(36, 'is_coingate_enabled', 'off', 38, 42, NULL, NULL),
	(37, 'is_paymentwall_enabled', 'off', 38, 42, NULL, NULL),
	(38, 'is_onemoney_enabled', 'off', 38, 42, NULL, NULL),
	(39, 'enable_telegram', 'off', 38, 42, NULL, NULL),
	(40, 'custom_field_title_1', NULL, 39, 43, NULL, NULL),
	(41, 'custom_field_title_2', NULL, 39, 43, NULL, NULL),
	(42, 'custom_field_title_3', NULL, 39, 43, NULL, NULL),
	(43, 'custom_field_title_4', NULL, 39, 43, NULL, NULL),
	(44, 'is_stripe_enabled', 'off', 39, 43, NULL, NULL),
	(45, 'is_paypal_enabled', 'off', 39, 43, NULL, NULL),
	(46, 'is_paystack_enabled', 'off', 39, 43, NULL, NULL),
	(47, 'is_flutterwave_enabled', 'off', 39, 43, NULL, NULL),
	(48, 'is_razorpay_enabled', 'off', 39, 43, NULL, NULL),
	(49, 'is_paytm_enabled', 'off', 39, 43, NULL, NULL),
	(50, 'is_mercado_enabled', 'off', 39, 43, NULL, NULL),
	(51, 'is_mollie_enabled', 'off', 39, 43, NULL, NULL),
	(52, 'is_skrill_enabled', 'off', 39, 43, NULL, NULL),
	(53, 'is_coingate_enabled', 'off', 39, 43, NULL, NULL),
	(54, 'is_paymentwall_enabled', 'off', 39, 43, NULL, NULL),
	(55, 'is_onemoney_enabled', 'off', 39, 43, NULL, NULL),
	(56, 'enable_telegram', 'off', 39, 43, NULL, NULL),
	(57, 'custom_field_title_1', NULL, 40, 44, NULL, NULL),
	(58, 'custom_field_title_2', NULL, 40, 44, NULL, NULL),
	(59, 'custom_field_title_3', NULL, 40, 44, NULL, NULL),
	(60, 'custom_field_title_4', NULL, 40, 44, NULL, NULL),
	(61, 'is_stripe_enabled', 'off', 40, 44, NULL, NULL),
	(62, 'is_paypal_enabled', 'off', 40, 44, NULL, NULL),
	(63, 'is_paystack_enabled', 'off', 40, 44, NULL, NULL),
	(64, 'is_flutterwave_enabled', 'off', 40, 44, NULL, NULL),
	(65, 'is_razorpay_enabled', 'off', 40, 44, NULL, NULL),
	(66, 'is_paytm_enabled', 'off', 40, 44, NULL, NULL),
	(67, 'is_mercado_enabled', 'off', 40, 44, NULL, NULL),
	(68, 'is_mollie_enabled', 'off', 40, 44, NULL, NULL),
	(69, 'is_skrill_enabled', 'off', 40, 44, NULL, NULL),
	(70, 'is_coingate_enabled', 'off', 40, 44, NULL, NULL),
	(71, 'is_paymentwall_enabled', 'off', 40, 44, NULL, NULL),
	(72, 'is_onemoney_enabled', 'off', 40, 44, NULL, NULL),
	(73, 'enable_telegram', 'off', 40, 44, NULL, NULL),
	(74, 'custom_field_title_1', NULL, 42, 46, NULL, NULL),
	(75, 'custom_field_title_2', NULL, 42, 46, NULL, NULL),
	(76, 'custom_field_title_3', NULL, 42, 46, NULL, NULL),
	(77, 'custom_field_title_4', NULL, 42, 46, NULL, NULL),
	(78, 'is_stripe_enabled', 'off', 42, 46, NULL, NULL),
	(79, 'is_paypal_enabled', 'off', 42, 46, NULL, NULL),
	(80, 'is_paystack_enabled', 'off', 42, 46, NULL, NULL),
	(81, 'is_flutterwave_enabled', 'off', 42, 46, NULL, NULL),
	(82, 'is_razorpay_enabled', 'off', 42, 46, NULL, NULL),
	(83, 'is_paytm_enabled', 'off', 42, 46, NULL, NULL),
	(84, 'is_mercado_enabled', 'off', 42, 46, NULL, NULL),
	(85, 'is_mollie_enabled', 'off', 42, 46, NULL, NULL),
	(86, 'is_skrill_enabled', 'off', 42, 46, NULL, NULL),
	(87, 'is_coingate_enabled', 'off', 42, 46, NULL, NULL),
	(88, 'is_paymentwall_enabled', 'off', 42, 46, NULL, NULL),
	(89, 'is_onemoney_enabled', 'off', 42, 46, NULL, NULL),
	(90, 'enable_telegram', 'off', 42, 46, NULL, NULL),
	(91, 'custom_field_title_1', NULL, 43, 47, NULL, NULL),
	(92, 'custom_field_title_2', NULL, 43, 47, NULL, NULL),
	(93, 'custom_field_title_3', NULL, 43, 47, NULL, NULL),
	(94, 'custom_field_title_4', NULL, 43, 47, NULL, NULL),
	(95, 'is_stripe_enabled', 'off', 43, 47, NULL, NULL),
	(96, 'is_paypal_enabled', 'off', 43, 47, NULL, NULL),
	(97, 'is_paystack_enabled', 'off', 43, 47, NULL, NULL),
	(98, 'is_flutterwave_enabled', 'off', 43, 47, NULL, NULL),
	(99, 'is_razorpay_enabled', 'off', 43, 47, NULL, NULL),
	(100, 'is_paytm_enabled', 'off', 43, 47, NULL, NULL),
	(101, 'is_mercado_enabled', 'off', 43, 47, NULL, NULL),
	(102, 'is_mollie_enabled', 'off', 43, 47, NULL, NULL),
	(103, 'is_skrill_enabled', 'off', 43, 47, NULL, NULL),
	(104, 'is_coingate_enabled', 'off', 43, 47, NULL, NULL),
	(105, 'is_paymentwall_enabled', 'off', 43, 47, NULL, NULL),
	(106, 'is_onemoney_enabled', 'off', 43, 47, NULL, NULL),
	(107, 'enable_telegram', 'off', 43, 47, NULL, NULL);
/*!40000 ALTER TABLE `store_payment_settings` ENABLE KEYS */;

-- Dumping structure for table saas.store_theme_settings
CREATE TABLE IF NOT EXISTS `store_theme_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'name/pagename',
  `value` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci COMMENT 'value/json_value',
  `type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `store_id` int NOT NULL,
  `theme_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_by` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.store_theme_settings: 2 rows
/*!40000 ALTER TABLE `store_theme_settings` DISABLE KEYS */;
INSERT INTO `store_theme_settings` (`id`, `name`, `value`, `type`, `store_id`, `theme_name`, `created_by`, `created_at`, `updated_at`) VALUES
	(1, 'dashboard', '[{"section_name":"Home-Brand-Logo","section_slug":"homepage-brand-logo","array_type":"inner-list","loop_number":"1","section_enable":"on","inner-list":[{"field_name":"Brand Logo","field_slug":"homepage-brand-logo-input","field_help_text":null,"field_default_text":"theme\\/header\\/placeholder-logo-82304151681551628.png","field_type":"photo upload","field_prev_text":"theme\\/header\\/placeholder-logo-82304151681551628.png"}]},{"section_name":"Home-Categories","section_slug":"homepage-categories","array_type":"inner-list","loop_number":"1","section_enable":"on","inner-list":[{"field_name":"Title","field_slug":"homepage-categories-title","field_help_text":"Please add title text here","field_default_text":"What do you looking for?","field_type":"text"}]},{"section_name":"Home-Promotions","section_slug":"homepage-promotions","array_type":"inner-list","loop_number":"1","section_enable":"on","inner-list":[{"field_name":"Title","field_slug":"homepage-promotions","field_help_text":"Please add title text here","field_default_text":"Promos for you","field_type":"text"}]},{"section_name":"Home-Promotions","section_slug":"homepage-promotions","array_type":"multi-inner-list","loop_number":"5","inner-list":[{"field_name":"Images","field_slug":"homepage-promotions-images","field_help_text":"Please click here to find images","field_default_text":null,"field_type":"photo upload"}],"homepage-promotions-images":[{"field_prev_text":"theme\\/header\\/0_21_2304141681490725.jpg"},{"field_prev_text":"theme\\/header\\/1_72_2304141681490725.jpg"},{"field_prev_text":"theme\\/header\\/2_87_2304141681490797.jpg"},{"field_prev_text":"theme\\/header\\/3_100_2304141681490797.jpg"},{"field_prev_text":"theme\\/header\\/4_79_2304141681490797.jpg"}]},{"section_name":"Home-Latest","section_slug":"homepage-latest","array_type":"inner-list","loop_number":"1","section_enable":"on","inner-list":[{"field_name":"Title","field_slug":"homepage-categories-title","field_help_text":"Please add title text here","field_default_text":"Pick\'s Today","field_type":"text"}]},{"section_name":"Home-Email-Subscriber","section_slug":"homepage-email-subscriber","array_type":"inner-list","loop_number":"1","section_enable":"on","inner-list":[{"field_name":"Subscriber Title","field_slug":"homepage-subscriber-title","field_help_text":"Please add title here","field_default_text":"Always on time","field_type":"text"},{"field_name":"Subscribe Button Text","field_slug":"homepage-subscriber-button","field_help_text":"Please add button text here","field_default_text":"Subscribes","field_type":"text"}]},{"section_name":"Home-Email-Subscriber","section_slug":"homepage-email-subscriber","array_type":"multi-inner-list","loop_number":"4","inner-list":[{"field_name":"Social Link Icon","field_slug":"homepage-footer-2-social-icon","field_help_text":"Please click here to find font... fontawesome.com","field_default_text":"<i class=\'fab fa-youtube\'><\\/i>","field_type":"text"},{"field_name":"Social Link","field_slug":"homepage-footer-2-social-link","field_help_text":"Please add social link here","field_default_text":"https:\\/\\/www.youtube.com\\/","field_type":"text"}],"homepage-footer-2-social-icon":["<i class=\\"icofont-facebook\\"><\\/i>","<i class=\'icofont-twitter\'><\\/i>","<i class=\'icofont-instagram\'><\\/i>","<i class=\'icofont-youtube\'><\\/i>"],"homepage-footer-2-social-link":["https:\\/\\/www.facebook.com\\/","https:\\/\\/www.twitter.com\\/","https:\\/\\/www.instagram.com\\/","https:\\/\\/www.youtube.com\\/"]},{"section_name":"Home-Footer-1","section_slug":"homepage-footer-1","array_type":"inner-list","loop_number":"1","section_enable":"on","inner-list":[{"field_name":"Enable Quick Link 1","field_slug":"homepage-quick-link-enable","field_help_text":null,"field_default_text":"on","field_type":"checkbox"},{"field_name":"Footer Quick Link Header Name 1","field_slug":"homepage-footer-header-quick-link-name-1","field_help_text":null,"field_default_text":"Products","field_type":"text"}]},{"section_name":"Home-Footer-1","section_slug":"homepage-footer-1","array_type":"multi-inner-list","loop_number":"4","inner-list":[{"field_name":"Quick Link","field_slug":"homepage-header-quick-link-name-1","field_help_text":"Please add link name here","field_default_text":"Home Pages","field_type":"text"},{"field_name":"Quick Link Url","field_slug":"homepage-header-quick-link-1","field_help_text":"Please add link here","field_default_text":"#","field_type":"text"}],"homepage-header-quick-link-name-1":["Detail","Trending","Recommended","Most Popular"],"homepage-header-quick-link-1":["#","#","#","#"]},{"section_name":"Home-Footer-1","section_slug":"homepage-footer-1","array_type":"inner-list","loop_number":"1","inner-list":[{"field_name":"Enable Quick Link 1","field_slug":"homepage-quick-link-enable","field_help_text":null,"field_default_text":"on","field_type":"checkbox"},{"field_name":"Footer Quick Link Header Name 1","field_slug":"homepage-footer-header-quick-link-name-1","field_help_text":null,"field_default_text":"Checkout Process","field_type":"text"}]},{"section_name":"Home-Footer-1","section_slug":"homepage-footer-1","array_type":"multi-inner-list","loop_number":"4","inner-list":[{"field_name":"Quick Link","field_slug":"homepage-header-quick-link-name-1","field_help_text":"Please add link name here","field_default_text":"Home Pages","field_type":"text"},{"field_name":"Quick Link Url","field_slug":"homepage-header-quick-link-1","field_help_text":"Please add link here","field_default_text":"#","field_type":"text"}],"homepage-header-quick-link-name-1":["Cart","Order Address","Order Payment","Checkout"],"homepage-header-quick-link-1":["#","#","#","#"]},{"section_name":"Home-Footer-1","section_slug":"homepage-footer-1","array_type":"inner-list","loop_number":"1","inner-list":[{"field_name":"Enable Quick Link 2","field_slug":"homepage-quick-link-enable","field_help_text":null,"field_default_text":"on","field_type":"checkbox"},{"field_name":"Footer Quick Link Header Name 2","field_slug":"homepage-footer-header-quick-link-name-2","field_help_text":null,"field_default_text":"My Order","field_type":"text"}]},{"section_name":"Home-Footer-1","section_slug":"homepage-footer-1","array_type":"multi-inner-list","loop_number":"4","inner-list":[{"field_name":"Quick Link","field_slug":"homepage-header-quick-link-name-2","field_help_text":"Please add link name here","field_default_text":"Blog","field_type":"text"},{"field_name":"Quick Link Url","field_slug":"homepage-header-quick-link-2","field_help_text":"Please add link here","field_default_text":"#","field_type":"text"}],"homepage-header-quick-link-name-2":["My order","Status Complete","Status Canceled","Review"],"homepage-header-quick-link-2":["#","#","#","#"]},{"section_name":"Home-Footer-1","section_slug":"homepage-footer-1","array_type":"inner-list","loop_number":"1","inner-list":[{"field_name":"Footer Quick Link Header Name 3","field_slug":"homepage-footer-header-quick-link-name-3","field_help_text":null,"field_default_text":"My Account","field_type":"text"},{"field_name":"Enable Quick Link 3","field_slug":"homepage-quick-link-enable","field_help_text":null,"field_default_text":"on","field_type":"checkbox"}]},{"section_name":"Home-Footer-1","section_slug":"homepage-footer-1","array_type":"multi-inner-list","loop_number":"4","inner-list":[{"field_name":"Quick Link","field_slug":"homepage-header-quick-link-name-3","field_help_text":"Please add link name here","field_default_text":"Terms and Policy","field_type":"text"},{"field_name":"Quick Link Url","field_slug":"homepage-header-quick-link-3","field_help_text":"Please add link here","field_default_text":"#","field_type":"text"}],"homepage-header-quick-link-name-3":["My account","Promos","My address","Terms & conditions"],"homepage-header-quick-link-3":["#","#","#","#"]},{"section_name":"Home-Footer-1","section_slug":"homepage-footer-1","array_type":"inner-list","loop_number":"1","inner-list":[{"field_name":"Footer Quick Link Header Name 4","field_slug":"homepage-footer-header-quick-link-name-4","field_help_text":null,"field_default_text":"Extra Pages","field_type":"text"},{"field_name":"Enable Quick Link 4","field_slug":"homepage-quick-link-enable","field_help_text":null,"field_default_text":"on","field_type":"checkbox"}]},{"section_name":"Home-Footer-1","section_slug":"homepage-footer-1","array_type":"multi-inner-list","loop_number":"2","inner-list":[{"field_name":"Quick Link","field_slug":"homepage-header-quick-link-name-4","field_help_text":"Please add link name here","field_default_text":"Terms and Policy","field_type":"text"},{"field_name":"Quick Link Url","field_slug":"homepage-header-quick-link-4","field_help_text":"Please add link here","field_default_text":"#","field_type":"text"}],"homepage-header-quick-link-name-4":["Refund Payment","FAQ"],"homepage-header-quick-link-4":["#","#"]},{"section_name":"Home-Footer-2","section_slug":"home-footer-2","array_type":"inner-list","loop_number":"1","section_enable":"on","inner-list":[{"field_name":"Footer Note","field_slug":"homepage-footer-2-note","field_help_text":"Please add footer note here","field_default_text":"2021 My Store. All rights reserved","field_type":"text"}]},{"section_name":"Home-Footer-2","section_slug":"home-footer-2","array_type":"inner-list","loop_number":"1","inner-list":[{"field_name":"Store Custom JS","field_slug":"homepage-footer-2-custom-js","field_help_text":"Please add custom js here","field_default_text":"console.log(\'Hello World!\');","field_type":"text area"}]}]', NULL, 1, 'theme', 2, '2023-04-13 12:18:02', '2023-04-19 11:48:03'),
	(2, 'enable_top_bar', 'off', NULL, 1, 'theme', 2, '2023-04-13 12:18:02', '2023-04-13 12:18:02');
/*!40000 ALTER TABLE `store_theme_settings` ENABLE KEYS */;

-- Dumping structure for table saas.subscriptions
CREATE TABLE IF NOT EXISTS `subscriptions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `store_id` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.subscriptions: 1 rows
/*!40000 ALTER TABLE `subscriptions` DISABLE KEYS */;
INSERT INTO `subscriptions` (`id`, `email`, `store_id`, `created_at`, `updated_at`) VALUES
	(1, 'abc@gmail.com', 1, '2023-04-19 11:54:35', '2023-04-19 11:54:35');
/*!40000 ALTER TABLE `subscriptions` ENABLE KEYS */;

-- Dumping structure for table saas.users
CREATE TABLE IF NOT EXISTS `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `remember_token` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `current_store` int DEFAULT NULL,
  `avatar` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `question_1` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'user',
  `plan` int NOT NULL DEFAULT '1',
  `plan_expire_date` date DEFAULT NULL,
  `requested_plan` int NOT NULL DEFAULT '0',
  `created_by` int NOT NULL DEFAULT '0',
  `mode` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'light',
  `plan_is_active` int NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `messenger_color` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '#2180f3',
  `dark_mode` tinyint(1) NOT NULL DEFAULT '0',
  `active_status` tinyint(1) NOT NULL DEFAULT '0',
  `is_stripe_enabled` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`)
) ENGINE=MyISAM AUTO_INCREMENT=48 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.users: 47 rows
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` (`id`, `name`, `email`, `email_verified_at`, `password`, `remember_token`, `lang`, `current_store`, `avatar`, `question_1`, `type`, `plan`, `plan_expire_date`, `requested_plan`, `created_by`, `mode`, `plan_is_active`, `created_at`, `updated_at`, `messenger_color`, `dark_mode`, `active_status`, `is_stripe_enabled`) VALUES
	(1, 'Super Admin', 'superadmin@example.com', NULL, '$2y$10$KvZxVdHuFVIay45Ux1SzJugIc4/72apbwC0vsVhQMQ1tdUxMHbjhC', NULL, 'en', NULL, NULL, NULL, 'super admin', 1, NULL, 0, 0, 'light', 1, '2023-04-13 10:03:38', '2023-04-13 10:03:38', '#2180f3', 0, 0, NULL),
	(2, 'Owner', 'owner@example.com', NULL, '$2y$10$OSqSRhoJzAOmHiNEkBm5veXPRRR8NQylvZq/A9Mu9idIAtUScy1Ou', NULL, NULL, 1, NULL, NULL, 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-04-13 10:03:38', '2023-04-13 10:03:38', '#2180f3', 0, 0, NULL),
	(3, 'Test', 'divyangdhimmar2@gmail.com', NULL, '$2y$10$xXj8dtUn/eszhOGd8SSD6OLFl9bA4DlkXxKW8vz08vKZCrDprX.3K', NULL, NULL, 2, NULL, NULL, 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-04-25 13:25:59', '2023-04-25 13:25:59', '#2180f3', 0, 0, NULL),
	(4, 'Alfreda Gilliam', 'geruno@mailinator.com', NULL, '$2y$10$P/IKy89jL7ZlllBCsrZXgeQvMKIb./J0CEqxBADKt7y6Lo.065pfy', NULL, NULL, NULL, NULL, NULL, 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-06-02 06:53:01', '2023-06-02 06:53:01', '#2180f3', 0, 0, NULL),
	(5, 'Dai Moran', 'gotep@mailinator.com', NULL, '$2y$10$Jo6bVAW3svnbgvicl6jdieG/j96GK.8U7vRd1xmd1m822Ij9E2eqO', NULL, NULL, 3, NULL, NULL, 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-06-02 06:54:06', '2023-06-02 06:54:06', '#2180f3', 0, 0, NULL),
	(6, 'Dante Mccarty', 'rocij@mailinator.com', NULL, '$2y$10$rzm8S.J2kUTYkzuGCBVsu.DxnFn5Qr6Tbt9//A7qvxGD8iq/tJPbu', NULL, NULL, 4, NULL, NULL, 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-06-02 06:54:50', '2023-06-02 06:54:50', '#2180f3', 0, 0, NULL),
	(7, 'Odessa Reyes', 'wiluzav@mailinator.com', NULL, '$2y$10$DvCH9CLqFXl2XSzbdwRqGOd3ZVBo8Ig7d0veDRRpuCadGnpi9/gQ2', NULL, NULL, 5, NULL, NULL, 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-06-02 06:56:15', '2023-06-02 06:56:15', '#2180f3', 0, 0, NULL),
	(8, 'Ali Flores', 'wode@mailinator.com', NULL, '$2y$10$QPBDOqujhIgnZcLLt3FWmOZMkuFH4O./23sposdBEyZnccv3aNX.C', NULL, NULL, 6, NULL, NULL, 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-06-02 06:58:10', '2023-06-02 06:58:10', '#2180f3', 0, 0, NULL),
	(9, 'Kathleen Morgan', 'tojypava@mailinator.com', NULL, '$2y$10$x1r5MotYqhoD5ye6MJRLEu3NYW5KioJeImNWI44Mr/v.iaNx1Ybnq', NULL, NULL, 7, NULL, NULL, 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-06-02 07:09:54', '2023-06-02 07:09:54', '#2180f3', 0, 0, NULL),
	(10, 'Ulla Hooper', 'vovexir@mailinator.com', NULL, '$2y$10$sML16MeCMecEvTVj2mo6aODoLt1mJ3I7CfCflVghelVCXY8LMluKq', NULL, NULL, 8, NULL, NULL, 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-06-02 07:11:35', '2023-06-02 07:11:35', '#2180f3', 0, 0, NULL),
	(11, 'Serena Ashley', 'mexubohor@mailinator.com', NULL, '$2y$10$9cg/I3owLzl8wr8hb40EbOkOQKMRb1Q6//nmgcSEKXQs05zas9Alm', NULL, NULL, 9, NULL, NULL, 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-06-02 07:12:16', '2023-06-02 07:12:16', '#2180f3', 0, 0, NULL),
	(12, 'Lucian Fry', 'mifo@mailinator.com', NULL, '$2y$10$xybJIGvb2qg9pSxsGcZfZ.82EdRxIgMR.XNoOe5B9ffkCvZjNsxO6', NULL, NULL, 10, NULL, NULL, 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-06-02 07:23:13', '2023-06-02 07:23:13', '#2180f3', 0, 0, NULL),
	(13, 'Dara Woodard', 'mozilyqu@mailinator.com', NULL, '$2y$10$UknzFItrJGlsCbaWR7e/Q.K91aQP7POmk1AJ/aX1aetFG8X9irc9W', NULL, NULL, 11, NULL, NULL, 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-06-02 07:33:53', '2023-06-02 07:33:53', '#2180f3', 0, 0, NULL),
	(14, 'Aline Jefferson', 'qagy@mailinator.com', NULL, '$2y$10$y3XeYb/USKwTgNUery1HIugitZQwWtxd/J5bKOlC4kD8LdytfeBsy', NULL, NULL, 12, NULL, NULL, 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-06-02 07:36:16', '2023-06-02 07:36:16', '#2180f3', 0, 0, NULL),
	(15, 'Jennifer Guzman', 'qetuga@mailinator.com', NULL, '$2y$10$k2IqAKncz93./xie92tmouw10uIELQ.E5LMrGGIQ7pqILCEyaPPda', NULL, NULL, 13, NULL, NULL, 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-06-02 07:37:28', '2023-06-02 07:37:28', '#2180f3', 0, 0, NULL),
	(16, 'Ila Cook', 'xobyfosise@mailinator.com', NULL, '$2y$10$abHUQ4X2h9yHRS36TnTJGugNzXkc2WwkcsYln3YLjQHFuwdbQEMmK', NULL, NULL, 14, NULL, NULL, 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-06-02 07:39:17', '2023-06-02 07:39:17', '#2180f3', 0, 0, NULL),
	(17, 'Keith Caldwell', 'sakadafodo@mailinator.com', NULL, '$2y$10$FO0lVJ7mHEqyhbW8gPULf.a5nZvS3qWyXCIHPCAlV44h9DVcqXThe', NULL, NULL, NULL, NULL, NULL, 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-06-20 12:45:30', '2023-06-20 12:45:30', '#2180f3', 0, 0, NULL),
	(18, 'Kaye Bowers', 'kowebe@mailinator.com', NULL, '$2y$10$h.11Apa6wtLLL9RDNiF9Qe8MSAZdrV20eDAC31KBYppZkI1NIx2k.', NULL, NULL, NULL, NULL, NULL, 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-06-20 12:46:05', '2023-06-20 12:46:05', '#2180f3', 0, 0, NULL),
	(19, 'Jarrod Gibbs', 'cahybas@mailinator.com', NULL, '$2y$10$zGjfjrjaRnSKV1KLqK95Aee1DnpdxOSu6I6IbKiG0RzhVp9zEk5QC', NULL, NULL, NULL, NULL, NULL, 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-06-20 12:53:52', '2023-06-20 12:53:52', '#2180f3', 0, 0, NULL),
	(20, 'Stephen Mcgee', 'cipu@mailinator.com', NULL, '$2y$10$IPxdNaiI1tZxWuqUO7uyHOsMgjZBDX/o4HO0Hp8MnwSBa1JMPJ5nK', NULL, NULL, 16, NULL, 'electronics', 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-06-20 12:56:01', '2023-06-20 12:56:01', '#2180f3', 0, 0, NULL),
	(21, 'Jescie Hutchinson', 'byqaqo@mailinator.com', NULL, '$2y$10$kYGTXQ4Q4WjX3zStjb2PEuxR1YAyMGP3dgnNfjBAKAJQtDeItUKKW', NULL, NULL, 17, NULL, NULL, 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-06-22 03:46:32', '2023-06-22 03:46:32', '#2180f3', 0, 0, NULL),
	(22, 'Gemma Salinas', 'netico@mailinator.com', NULL, '$2y$10$nTfDPyeNGRoAtnsgfA3vcuvm6K6Psx3S1IXo9OVWpWTufKpWS0GNK', NULL, NULL, 18, NULL, 'grocery', 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-07-10 05:47:21', '2023-07-10 05:47:21', '#2180f3', 0, 0, NULL),
	(23, 'Gabriel Shields', 'joradoqud@mailinator.com', NULL, '$2y$10$eDVLVyf.hi1Oq3qo/YEnJeEouovYAyo3jW1K77Mzw5XmOrNTLQiEq', NULL, NULL, NULL, NULL, 'fashion', 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-07-13 04:18:03', '2023-07-13 04:18:03', '#2180f3', 0, 0, NULL),
	(24, 'Belle Juarez', 'bydefyl@mailinator.com', NULL, '$2y$10$/YG40rp/3TGzayxYIRCQAufIfWrVFGdja1HqXNdkYWt2NIkndRtqy', NULL, NULL, NULL, NULL, 'fashion', 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-07-13 04:18:51', '2023-07-13 04:18:51', '#2180f3', 0, 0, NULL),
	(25, 'Chase Garner', 'fykikynom@mailinator.com', NULL, '$2y$10$b5xjaPSW/V01r5VGCPCayOsOBaFAGzeP8tG82c4F95pV8K0sAS7Wi', NULL, NULL, NULL, NULL, 'cosmetics', 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-07-17 00:21:00', '2023-07-17 00:21:00', '#2180f3', 0, 0, NULL),
	(26, 'Jamal Robles', 'vysicex@mailinator.com', NULL, '$2y$10$.15L/9m7nnIZzJrL.trx8OZavIKUZmIoVa7zcmBKfOhrUXBd.ETZu', NULL, NULL, NULL, NULL, 'cosmetics', 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-07-17 02:19:30', '2023-07-17 02:19:30', '#2180f3', 0, 0, NULL),
	(27, 'Byron Little', 'geguj@mailinator.com', NULL, '$2y$10$bbHGyQnV/LwgtNkzg6gMI.HpLEEYR2PsRUF7aU6stMcVUhirANi9K', NULL, NULL, NULL, NULL, 'grocery', 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-07-17 03:11:24', '2023-07-17 03:11:24', '#2180f3', 0, 0, NULL),
	(28, 'Hiroko Benson', 'sicid@mailinator.com', NULL, '$2y$10$P/Kgd55afltgz0nKJZw9p.L./bh8Eg4Hi5snfYPhK4J1aHheB0s6.', NULL, NULL, NULL, NULL, 'footwear', 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-07-20 03:55:40', '2023-07-20 03:55:40', '#2180f3', 0, 0, NULL),
	(29, 'Rafael Johns', 'gybysy@mailinator.com', NULL, '$2y$10$6b4CIx68S/wSDxaML2hcTeCsmQ3Wfp4gSwUWHpzpHoT.X3KNKQ2Oe', NULL, NULL, NULL, NULL, 'cosmetics', 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-07-20 03:57:15', '2023-07-20 03:57:15', '#2180f3', 0, 0, NULL),
	(30, 'Duncan Wise', 'denyzanuda@mailinator.com', NULL, '$2y$10$EN9kMZIyD6xIKCQw5Ujnoek/rvZGhEBMxt9pEi.w34JLHSCwRlWaG', NULL, NULL, NULL, NULL, 'cosmetics', 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-07-20 03:58:48', '2023-07-20 03:58:48', '#2180f3', 0, 0, NULL),
	(31, 'Sharon Rose', 'loxajy@mailinator.com', NULL, '$2y$10$HXd5yUX6w.MBV6cwsErGSOcoXdqa/sKjECMzkx2N2VvNEvVLTieje', NULL, NULL, NULL, NULL, 'footwear', 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-07-20 03:59:22', '2023-07-20 03:59:22', '#2180f3', 0, 0, NULL),
	(32, 'Kuame Gamble', 'xalo@mailinator.com', NULL, '$2y$10$J./lghZsNWeIxd/ln1RBWeGyLb9n/wcO8CjSWMoWu5VD6qSebb5h2', NULL, NULL, NULL, NULL, 'fashion', 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-07-20 04:10:52', '2023-07-20 04:10:52', '#2180f3', 0, 0, NULL),
	(33, 'Tatiana Mckee', 'filatylade@mailinator.com', NULL, '$2y$10$PsyTeDFEF5UdAh.z0FB8Kux2erxnh6jRA4wLhNBlhw5wOO8tbS2uK', NULL, NULL, 29, NULL, 'fashion', 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-07-20 04:20:21', '2023-07-20 04:20:21', '#2180f3', 0, 0, NULL),
	(34, 'Oprah Peterson', 'zatokem@mailinator.com', NULL, '$2y$10$anlZUyyWN88SZJwN0BHLiOBSYnV3EKoU./EIDUxfwJs/MflVp.kBW', NULL, NULL, 30, NULL, 'footwear', 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-07-20 04:28:50', '2023-07-20 04:28:50', '#2180f3', 0, 0, NULL),
	(35, 'Alyssa Howe', 'lekugydajo@mailinator.com', NULL, '$2y$10$fsc9d.0yDkjH9H7Ji8bii.8o69XzM9On4mbA7t9/vz78zU61Zq62y', NULL, NULL, 31, NULL, 'footwear', 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-07-20 04:29:15', '2023-07-20 04:29:15', '#2180f3', 0, 0, NULL),
	(36, 'Kevyn Massey', 'jiqiwef@mailinator.com', NULL, '$2y$10$VrJxHgZJF9l5vq0xBQ9W1ehvtf7kCJi8zLpW5nK9Z7uvNvyq7woEu', NULL, NULL, NULL, NULL, 'cosmetics', 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-07-20 04:39:58', '2023-07-20 04:39:58', '#2180f3', 0, 0, NULL),
	(37, 'Xander Bowers', 'rivacyr@mailinator.com', NULL, '$2y$10$4ciNt2a7fbpebOz/eLQyFe862IaEtQ8XAwxt7qtDgzZ3Zkhyq7H0G', NULL, NULL, NULL, NULL, 'footwear', 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-07-20 04:45:08', '2023-07-20 04:45:08', '#2180f3', 0, 0, NULL),
	(38, 'Guy Michael', 'dabiqenu@mailinator.com', NULL, '$2y$10$.RQ6b4GfKOrxqLlMK63czu9ARL4AbUIImH7bGo/qQm0SgTtCqcVdy', NULL, NULL, 34, NULL, 'footwear', 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-07-20 04:46:22', '2023-07-20 04:46:22', '#2180f3', 0, 0, NULL),
	(39, 'Hiram Workman', 'fezaryd@mailinator.com', NULL, '$2y$10$KT8FPEzjVwbapWJrtZEcUeJdLyq46Hg9fnS/HirvswhU4EpR7KvYq', NULL, NULL, NULL, NULL, '4', 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-07-24 07:58:34', '2023-07-24 07:58:34', '#2180f3', 0, 0, NULL),
	(40, 'Magee Carlson', 'telom@mailinator.com', NULL, '$2y$10$8KUp2d9VGIhRxnhcUfBlSudK/7O47HULb9Rjh7W6RlAHKYjI8cv5q', NULL, NULL, NULL, NULL, '4', 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-07-24 08:14:16', '2023-07-24 08:14:16', '#2180f3', 0, 0, NULL),
	(41, 'Magee Carlson', 'telomdf@mailinator.com', NULL, '$2y$10$7BQt/EwhWMCCj8VCGKezEe614qd3DF.Bq3uOAkelc0Y718e3pNy8G', NULL, NULL, 37, NULL, '4', 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-07-24 08:16:18', '2023-07-24 08:16:18', '#2180f3', 0, 0, NULL),
	(42, 'Magee Carlson', 'telomdsdf@mailinator.com', NULL, '$2y$10$VDth6JDkGqtsY/BznLhHXOuB4s4egP4hwl73OezdQxqMhHRKPzOXm', NULL, NULL, 38, NULL, '4', 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-07-24 08:18:11', '2023-07-24 08:18:11', '#2180f3', 0, 0, NULL),
	(43, 'Maggie Barnes', 'qevyj@mailinator.com', NULL, '$2y$10$kw/1HqvJWr6LuaSZcLbQKupdmF42hPU3b2smeyCOEFQw4VxEpVajO', NULL, NULL, 39, NULL, NULL, 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-08-02 19:53:14', '2023-08-02 19:53:15', '#2180f3', 0, 0, NULL),
	(44, 'Melissa Garcia', 'pymu@mailinator.com', NULL, '$2y$10$.gEG9NqcNEsNwIepE0cQSOnM4iw1.ZSnrsAfDqr28Eas/W/Et.yyO', NULL, NULL, 40, NULL, NULL, 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-08-03 02:16:13', '2023-08-03 02:16:16', '#2180f3', 0, 0, NULL),
	(45, 'Iliana Cole', 'hepaveha@mailinator.com', NULL, '$2y$10$leIlTLirX2TsF0gKZRxgNupslGdkqsz9PUJdS4lKVrGR5PegSmssO', NULL, NULL, NULL, NULL, '4', 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-08-03 02:28:45', '2023-08-03 02:28:45', '#2180f3', 0, 0, NULL),
	(46, 'Iliana Cole', 'hepavegfgfha@mailinator.com', NULL, '$2y$10$MiTjWWGuJG77TsA0RhVgJOpxu8ovbt62O8dULvpWEc6FjY9FRC9Di', NULL, NULL, 42, NULL, '4', 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-08-03 02:29:46', '2023-08-03 02:29:53', '#2180f3', 0, 0, NULL),
	(47, 'Edan Hampton', 'feqocuxim@mailinator.com', NULL, '$2y$10$yHJxcayzHtK9s8ANJJdLMekoSidjqzzbsqIbb4AG7rvisepYOjo1q', NULL, NULL, 43, NULL, '4', 'Owner', 1, NULL, 0, 1, 'light', 1, '2023-08-03 02:39:44', '2023-08-03 02:39:44', '#2180f3', 0, 0, NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;

-- Dumping structure for table saas.user_coupons
CREATE TABLE IF NOT EXISTS `user_coupons` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user` int NOT NULL,
  `coupon` int NOT NULL,
  `order` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.user_coupons: 0 rows
/*!40000 ALTER TABLE `user_coupons` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_coupons` ENABLE KEYS */;

-- Dumping structure for table saas.user_details
CREATE TABLE IF NOT EXISTS `user_details` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `store_id` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `phone` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `billing_address` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `billing_country` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `billing_city` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `billing_postalcode` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `shipping_address` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field_title_1` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field_title_2` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field_title_3` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `custom_field_title_4` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_country` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_city` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `shipping_postalcode` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `location_id` int NOT NULL DEFAULT '0',
  `shipping_id` int NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.user_details: 4 rows
/*!40000 ALTER TABLE `user_details` DISABLE KEYS */;
INSERT INTO `user_details` (`id`, `store_id`, `name`, `last_name`, `phone`, `email`, `billing_address`, `billing_country`, `billing_city`, `billing_postalcode`, `shipping_address`, `custom_field_title_1`, `custom_field_title_2`, `custom_field_title_3`, `custom_field_title_4`, `shipping_country`, `shipping_city`, `shipping_postalcode`, `location_id`, `shipping_id`, `created_at`, `updated_at`) VALUES
	(1, '1', 'Aida Bugg', 'Ou7cyKTfCk', '9365219104', 'abc@gmail.com', 'xdo8fjBv3H', 'lGGhwd8gHdfdfdfdf', 'wsz1G8zf7U', 'INWwEIPFZy', 'xdo8fjBv3H', NULL, NULL, NULL, NULL, 'lGGhwd8gHdfdfdfdf', 'wsz1G8zf7U', 'INWwEIPFZy', 0, 0, '2023-04-18 11:36:57', '2023-04-18 11:36:57'),
	(2, '1', 'Aida Bugg', 'aV3YtJCmUL', '7723622922', 'abc@gmail.com', 'NgOSj0Vmql', 'lGGhwd8gHdfdfdfdf', 'ThtDtH4VvC', 'FajtGBJwPn', 'NgOSj0Vmql', NULL, NULL, NULL, NULL, 'lGGhwd8gHdfdfdfdf', 'ThtDtH4VvC', 'FajtGBJwPn', 0, 0, '2023-04-18 12:44:50', '2023-04-18 12:44:50'),
	(3, '1', 'Aida Bugg', 's29kun5Ukg', '3645667472', 'abc@gmail.com', 'TBGeCSHYee', 'india', 'XzZKN8rgDB', 'GI9jt07eOe', 'TBGeCSHYee', NULL, NULL, NULL, NULL, 'india', 'XzZKN8rgDB', 'GI9jt07eOe', 0, 0, '2023-04-19 10:02:19', '2023-04-19 10:03:12'),
	(4, '1', 'Aida Bugg', 'UaZpw1035d', '5281607058', 'abc@gmail.com', 'AK6ytwi2FG', 'lGGhwd8gHdfdfdfdf', 'G08ZaqWfTz', 'twQyAGb2sX', 'AK6ytwi2FG', NULL, NULL, NULL, NULL, 'lGGhwd8gHdfdfdfdf', 'G08ZaqWfTz', 'twQyAGb2sX', 0, 0, '2023-04-19 11:12:56', '2023-04-19 11:12:56');
/*!40000 ALTER TABLE `user_details` ENABLE KEYS */;

-- Dumping structure for table saas.user_email_templates
CREATE TABLE IF NOT EXISTS `user_email_templates` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `template_id` int NOT NULL,
  `user_id` int NOT NULL,
  `is_active` int NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.user_email_templates: 3 rows
/*!40000 ALTER TABLE `user_email_templates` DISABLE KEYS */;
INSERT INTO `user_email_templates` (`id`, `template_id`, `user_id`, `is_active`, `created_at`, `updated_at`) VALUES
	(1, 1, 1, 1, '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(2, 2, 1, 1, '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(3, 3, 1, 1, '2023-04-13 10:03:38', '2023-04-13 10:03:38');
/*!40000 ALTER TABLE `user_email_templates` ENABLE KEYS */;

-- Dumping structure for table saas.user_stores
CREATE TABLE IF NOT EXISTS `user_stores` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `store_id` int NOT NULL,
  `permission` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_active` int NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.user_stores: 18 rows
/*!40000 ALTER TABLE `user_stores` DISABLE KEYS */;
INSERT INTO `user_stores` (`id`, `user_id`, `store_id`, `permission`, `is_active`, `created_at`, `updated_at`) VALUES
	(1, 2, 1, 'Owner', 1, '2023-04-13 10:03:38', '2023-04-13 10:03:38'),
	(2, 3, 2, 'Owner', 1, '2023-04-25 13:25:59', '2023-04-25 13:25:59'),
	(3, 5, 3, 'Owner', 1, '2023-06-02 06:54:06', '2023-06-02 06:54:06'),
	(4, 6, 4, 'Owner', 1, '2023-06-02 06:54:50', '2023-06-02 06:54:50'),
	(5, 7, 5, 'Owner', 1, '2023-06-02 06:56:15', '2023-06-02 06:56:15'),
	(6, 8, 6, 'Owner', 1, '2023-06-02 06:58:10', '2023-06-02 06:58:10'),
	(7, 9, 7, 'Owner', 1, '2023-06-02 07:09:54', '2023-06-02 07:09:54'),
	(8, 10, 8, 'Owner', 1, '2023-06-02 07:11:35', '2023-06-02 07:11:35'),
	(9, 11, 9, 'Owner', 1, '2023-06-02 07:12:16', '2023-06-02 07:12:16'),
	(10, 12, 10, 'Owner', 1, '2023-06-02 07:23:13', '2023-06-02 07:23:13'),
	(11, 13, 11, 'Owner', 1, '2023-06-02 07:33:53', '2023-06-02 07:33:53'),
	(12, 14, 12, 'Owner', 1, '2023-06-02 07:36:16', '2023-06-02 07:36:16'),
	(13, 15, 13, 'Owner', 1, '2023-06-02 07:37:28', '2023-06-02 07:37:28'),
	(14, 16, 14, 'Owner', 1, '2023-06-02 07:39:17', '2023-06-02 07:39:17'),
	(15, 20, 16, 'Owner', 1, '2023-06-20 12:56:01', '2023-06-20 12:56:01'),
	(16, 21, 17, 'Owner', 1, '2023-06-22 03:46:32', '2023-06-22 03:46:32'),
	(17, 22, 18, 'Owner', 1, '2023-07-10 05:47:21', '2023-07-10 05:47:21'),
	(18, 42, 38, 'Owner', 1, '2023-07-24 08:18:11', '2023-07-24 08:18:11'),
	(19, 43, 39, 'Owner', 1, '2023-08-02 19:53:15', '2023-08-02 19:53:15'),
	(20, 44, 40, 'Owner', 1, '2023-08-03 02:16:16', '2023-08-03 02:16:16'),
	(21, 46, 42, 'Owner', 1, '2023-08-03 02:29:53', '2023-08-03 02:29:53'),
	(22, 47, 43, 'Owner', 1, '2023-08-03 02:39:44', '2023-08-03 02:39:44');
/*!40000 ALTER TABLE `user_stores` ENABLE KEYS */;

-- Dumping structure for table saas.visitor
CREATE TABLE IF NOT EXISTS `visitor` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `method` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `request` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `url` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `referer` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `languages` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `useragent` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `headers` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `device` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `platform` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `browser` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `ip` varchar(45) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `visitable_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visitable_id` bigint unsigned DEFAULT NULL,
  `visitor_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `visitor_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `visitor_visitable_type_visitable_id_index` (`visitable_type`,`visitable_id`),
  KEY `visitor_visitor_type_visitor_id_index` (`visitor_type`,`visitor_id`)
) ENGINE=MyISAM AUTO_INCREMENT=384 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table saas.visitor: 383 rows
/*!40000 ALTER TABLE `visitor` DISABLE KEYS */;
INSERT INTO `visitor` (`id`, `method`, `request`, `url`, `referer`, `languages`, `useragent`, `headers`, `device`, `platform`, `browser`, `ip`, `slug`, `visitable_type`, `visitable_id`, `visitor_type`, `visitor_id`, `created_at`, `updated_at`) VALUES
	(1, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6InBSbWNmYWRpWWdIUWtic0svUlc4L2c9PSIsInZhbHVlIjoiQVhSd0RqaDFmanBleUZNdkMxalRIK1B0akFIZWFMM0xyYmM3NXRBQzYwQkRnNkdBSE9mOTc0dVgvWmkwQ3dBdURUQlpQZklLMnhYUDdhVUVWZG1ReU55QThHRWxqd3JKKytWQ1VzQ01uZ256T2tRUVI3R3dZNmRUNlduaHRxMlEiLCJtYWMiOiIzOThkODFjYmZlMzFkYTBlNTY4Y2M2ZTEyYTAyNzk5NTYwMzlkY2U3YWE1N2IzMzk5ZTI0MTMwZGRlZDMzNjJjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:26:22', '2023-04-13 11:26:22'),
	(2, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6InBSbWNmYWRpWWdIUWtic0svUlc4L2c9PSIsInZhbHVlIjoiQVhSd0RqaDFmanBleUZNdkMxalRIK1B0akFIZWFMM0xyYmM3NXRBQzYwQkRnNkdBSE9mOTc0dVgvWmkwQ3dBdURUQlpQZklLMnhYUDdhVUVWZG1ReU55QThHRWxqd3JKKytWQ1VzQ01uZ256T2tRUVI3R3dZNmRUNlduaHRxMlEiLCJtYWMiOiIzOThkODFjYmZlMzFkYTBlNTY4Y2M2ZTEyYTAyNzk5NTYwMzlkY2U3YWE1N2IzMzk5ZTI0MTMwZGRlZDMzNjJjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:26:22', '2023-04-13 11:26:22'),
	(3, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6IkQrVmVqMjZzWm1ZNFVwc0xDV3g5Nnc9PSIsInZhbHVlIjoidHhZbzVxQmxjYjlxRndkSkxBRWkrUndnRElKeExCVGNnM3l4YlBaT3F6Q2VnMGk1ak5ZZFFTbU5FSldaRUZFb01iTGFRTjJtK0RlZUVvNFpDbXM5cFg4RXZDWk9DbEswblhHcW5sVGU4Mi9HUk5xRzNFdExHQmd6aTJGckN0SnMiLCJtYWMiOiIxMjczMGI4MDEzZGE2ZTcxNzViZDAyYTk1Mzc1YjJkOWExNzhmNTJjMGJkNGQ3NWEwNDRiYjRhZjEzNWMzN2I2IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:26:40', '2023-04-13 11:26:40'),
	(4, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6IkQrVmVqMjZzWm1ZNFVwc0xDV3g5Nnc9PSIsInZhbHVlIjoidHhZbzVxQmxjYjlxRndkSkxBRWkrUndnRElKeExCVGNnM3l4YlBaT3F6Q2VnMGk1ak5ZZFFTbU5FSldaRUZFb01iTGFRTjJtK0RlZUVvNFpDbXM5cFg4RXZDWk9DbEswblhHcW5sVGU4Mi9HUk5xRzNFdExHQmd6aTJGckN0SnMiLCJtYWMiOiIxMjczMGI4MDEzZGE2ZTcxNzViZDAyYTk1Mzc1YjJkOWExNzhmNTJjMGJkNGQ3NWEwNDRiYjRhZjEzNWMzN2I2IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:26:40', '2023-04-13 11:26:40'),
	(5, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"pragma":["no-cache"],"cache-control":["no-cache"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6IjArY1dLdWw4a3hsMXhDdmFRVGhVOGc9PSIsInZhbHVlIjoidVRzNmZuamVNUWM4bjhXVVhVUUk2NE9aZ2U3YTBIa3BJYkgramVTNk5GTjRMUUxaeUFhWXd1azRXd1dONkh4aXVBcXpuN3FkQjVjcjM0bWxoVVVBSUVpY0IyVG9IYy9GWG1TSEZxQnpnQnltY2JBUVRmVFNTWnJ6TnEvQ0Yrd1AiLCJtYWMiOiI2MzEyNGM1MmRiYTIyODFlNzFmYTRhNzUzM2I2M2I0YjM0ODM4OTgwNjdlMDdiYmMyZDBmMTM1OTljMjM0YTE2IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:26:41', '2023-04-13 11:26:41'),
	(6, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"pragma":["no-cache"],"cache-control":["no-cache"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6IjArY1dLdWw4a3hsMXhDdmFRVGhVOGc9PSIsInZhbHVlIjoidVRzNmZuamVNUWM4bjhXVVhVUUk2NE9aZ2U3YTBIa3BJYkgramVTNk5GTjRMUUxaeUFhWXd1azRXd1dONkh4aXVBcXpuN3FkQjVjcjM0bWxoVVVBSUVpY0IyVG9IYy9GWG1TSEZxQnpnQnltY2JBUVRmVFNTWnJ6TnEvQ0Yrd1AiLCJtYWMiOiI2MzEyNGM1MmRiYTIyODFlNzFmYTRhNzUzM2I2M2I0YjM0ODM4OTgwNjdlMDdiYmMyZDBmMTM1OTljMjM0YTE2IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:26:41', '2023-04-13 11:26:41'),
	(7, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6InF5TVNIc2NEZWF5MjIrTHJDTG9PM3c9PSIsInZhbHVlIjoiUkFEeWlOMkNSc3kzd2QxcXVBTjdxWEJKcUdUZ2J4bHhMSVQzcWNKak9CeW5qSmtURThhYzVLRi9pU0o0OFNXdFhGam8xczRPbU9NY2dMKzJQZmJjaGJlYXN0MjVucXlJQ3hZT0dHM1ZKdVpRRHY0RTRzVFNsaTJ4bVh1TUh6OTYiLCJtYWMiOiIwNjNhYjcxZWUzODAyNjI3ZmM1OTcxYWI0OTVjMmVlNmU5NGQzZDZiZDJmM2EzYWViMmY4Mjg2NzIzMjE3OTRjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:26:50', '2023-04-13 11:26:50'),
	(8, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6InF5TVNIc2NEZWF5MjIrTHJDTG9PM3c9PSIsInZhbHVlIjoiUkFEeWlOMkNSc3kzd2QxcXVBTjdxWEJKcUdUZ2J4bHhMSVQzcWNKak9CeW5qSmtURThhYzVLRi9pU0o0OFNXdFhGam8xczRPbU9NY2dMKzJQZmJjaGJlYXN0MjVucXlJQ3hZT0dHM1ZKdVpRRHY0RTRzVFNsaTJ4bVh1TUh6OTYiLCJtYWMiOiIwNjNhYjcxZWUzODAyNjI3ZmM1OTcxYWI0OTVjMmVlNmU5NGQzZDZiZDJmM2EzYWViMmY4Mjg2NzIzMjE3OTRjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:26:50', '2023-04-13 11:26:50'),
	(9, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6InZTWi92Ukk4aTZPL2FRcEU3bHM2K3c9PSIsInZhbHVlIjoiQ2k5NGVOY2hmNVlKYjBnQXEwSzlSSzB6VEdCUkQ5NG5uYkQ1dnIyOUR3SDNTY0QvbnhwRlU4Rmh1QkFzVFVSUFZIZFBqRytZQ0dOSE5FK0llR3E0eHlLd3VwcEk1U1p3OGdmckFVcy9zbDh4b1R6MSsrY3VLMHUxZk5BcEFlNjIiLCJtYWMiOiIxZGZjMTJmZDNlYzhkY2MyNmEzYTg4ZTgzZDIwNTRkYWIyOTU2YTFiOTcyMDkzZmEwNWFkYWY5ZWFmN2QwODUzIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:27:36', '2023-04-13 11:27:36'),
	(10, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6InZTWi92Ukk4aTZPL2FRcEU3bHM2K3c9PSIsInZhbHVlIjoiQ2k5NGVOY2hmNVlKYjBnQXEwSzlSSzB6VEdCUkQ5NG5uYkQ1dnIyOUR3SDNTY0QvbnhwRlU4Rmh1QkFzVFVSUFZIZFBqRytZQ0dOSE5FK0llR3E0eHlLd3VwcEk1U1p3OGdmckFVcy9zbDh4b1R6MSsrY3VLMHUxZk5BcEFlNjIiLCJtYWMiOiIxZGZjMTJmZDNlYzhkY2MyNmEzYTg4ZTgzZDIwNTRkYWIyOTU2YTFiOTcyMDkzZmEwNWFkYWY5ZWFmN2QwODUzIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:27:36', '2023-04-13 11:27:36'),
	(11, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"pragma":["no-cache"],"cache-control":["no-cache"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6Ilp1cENHQ1NUc2k4NGZxVm9uOGd2QWc9PSIsInZhbHVlIjoiUzlDWjQ1dzFUZUNPNVhyL2lEOWtEMXNzb3dvMTNZb1JFY00vbWxRaDgxamdTMmo5WU9obTFXOEcrbVZjVFkyc0lzZXM4cHQ3VjRMYzQrSUFiVGtjeTRHYlAyeTlqbmpINXFmenN2U0JlbWZZVFFMLzA3Z0lSYXJ4VXY4ZmNvNWciLCJtYWMiOiJmYjFmYTRiODM4ZWYyOTJkMjBhNTcxMzVmNjM0ZDVlOWUwZGI5NGUwZGQwNGE0MzY3OWQxOGYxNDYyNTk5NmMyIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:27:39', '2023-04-13 11:27:39'),
	(12, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"pragma":["no-cache"],"cache-control":["no-cache"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6Ilp1cENHQ1NUc2k4NGZxVm9uOGd2QWc9PSIsInZhbHVlIjoiUzlDWjQ1dzFUZUNPNVhyL2lEOWtEMXNzb3dvMTNZb1JFY00vbWxRaDgxamdTMmo5WU9obTFXOEcrbVZjVFkyc0lzZXM4cHQ3VjRMYzQrSUFiVGtjeTRHYlAyeTlqbmpINXFmenN2U0JlbWZZVFFMLzA3Z0lSYXJ4VXY4ZmNvNWciLCJtYWMiOiJmYjFmYTRiODM4ZWYyOTJkMjBhNTcxMzVmNjM0ZDVlOWUwZGI5NGUwZGQwNGE0MzY3OWQxOGYxNDYyNTk5NmMyIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:27:39', '2023-04-13 11:27:39'),
	(13, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"pragma":["no-cache"],"cache-control":["no-cache"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6Ik5iclFGd2NGdmhKeFJpdTBmU2U2SlE9PSIsInZhbHVlIjoiQ0FQK0p5WjFZZVl4dVZjOVJXeTR1bG9hcHBVbkF1T01Uc3EwVVVWUUhVTFkrU0VscWluaWRXaHVuTnk1UHJpV3Z5blhEdnh1ak9Ya0VuNFg0dGE2SEVMRkZVVmovY1B4c2NpZEROUnZCR0dBZ3laSnkyTXl6YmxacE9wUW9rUkIiLCJtYWMiOiI1ZmFmYTNlOWZhODBjOGIwY2Q3MjQxMGVmZTE3NzczZGNlYjEyNTkzMWRkMjM1ZjVjMzY4MTM1NzhmNjU4ZTg1IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:29:02', '2023-04-13 11:29:02'),
	(14, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"pragma":["no-cache"],"cache-control":["no-cache"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6Ik5iclFGd2NGdmhKeFJpdTBmU2U2SlE9PSIsInZhbHVlIjoiQ0FQK0p5WjFZZVl4dVZjOVJXeTR1bG9hcHBVbkF1T01Uc3EwVVVWUUhVTFkrU0VscWluaWRXaHVuTnk1UHJpV3Z5blhEdnh1ak9Ya0VuNFg0dGE2SEVMRkZVVmovY1B4c2NpZEROUnZCR0dBZ3laSnkyTXl6YmxacE9wUW9rUkIiLCJtYWMiOiI1ZmFmYTNlOWZhODBjOGIwY2Q3MjQxMGVmZTE3NzczZGNlYjEyNTkzMWRkMjM1ZjVjMzY4MTM1NzhmNjU4ZTg1IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:29:02', '2023-04-13 11:29:02'),
	(15, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6IlAzS211T0huWHQvV1BnS3M3bWpzbnc9PSIsInZhbHVlIjoiSHM4d2cwbTBaUlFFUGg0TEwrWHliKzRXVm9UT0hSMkRzWVlQV3BXQmlmSjhRWVBRZzRTRlVVU0l3c21OZzNMbGVObCt5TXlpREZFOWZ4YmowUVQyallDYW5oTDRlb0tINlQxdUlDM2JIRjBpTmRLZGk5dVl0eFFkRmp4QXhjNngiLCJtYWMiOiJmODM1Y2Y5MThjM2NlNzkzOGIzN2ZhNjcyMGYxZjQwMTZjNmU4NWUwZGZlNTVjYjNhMzFmMWRhNTM1NWRjZWQxIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:38:17', '2023-04-13 11:38:17'),
	(16, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6IlAzS211T0huWHQvV1BnS3M3bWpzbnc9PSIsInZhbHVlIjoiSHM4d2cwbTBaUlFFUGg0TEwrWHliKzRXVm9UT0hSMkRzWVlQV3BXQmlmSjhRWVBRZzRTRlVVU0l3c21OZzNMbGVObCt5TXlpREZFOWZ4YmowUVQyallDYW5oTDRlb0tINlQxdUlDM2JIRjBpTmRLZGk5dVl0eFFkRmp4QXhjNngiLCJtYWMiOiJmODM1Y2Y5MThjM2NlNzkzOGIzN2ZhNjcyMGYxZjQwMTZjNmU4NWUwZGZlNTVjYjNhMzFmMWRhNTM1NWRjZWQxIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:38:17', '2023-04-13 11:38:17'),
	(17, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"pragma":["no-cache"],"cache-control":["no-cache"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6IlpqNklEN0VpWWRla0c4dlo2OGxMV2c9PSIsInZhbHVlIjoiSzBoRVdHdG5yMDJ3Q0RpTVEvWmZtdm9RWktJRDFoVWlZMWIvVlhNaG9pZkM0UkFhUFZmdHRhazBUYVRWYnZzSWJJUWc2WklqMC85azZCS3FlWlhQSHBiV2lCVzJYamx3UEFTUGRud2FzNWFBS21BUzV2b0tjMU8raUVML3JGdDYiLCJtYWMiOiI0NmE3MWU5MzVjNzMwZGIwMzZlMzc2YjAyMDk0ZTM5ZWY4NzY3YWNmOWYzZjUwMmEyZjZiZWQxYmQwNWMwZWQ3IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:38:19', '2023-04-13 11:38:19'),
	(18, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"pragma":["no-cache"],"cache-control":["no-cache"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6IlpqNklEN0VpWWRla0c4dlo2OGxMV2c9PSIsInZhbHVlIjoiSzBoRVdHdG5yMDJ3Q0RpTVEvWmZtdm9RWktJRDFoVWlZMWIvVlhNaG9pZkM0UkFhUFZmdHRhazBUYVRWYnZzSWJJUWc2WklqMC85azZCS3FlWlhQSHBiV2lCVzJYamx3UEFTUGRud2FzNWFBS21BUzV2b0tjMU8raUVML3JGdDYiLCJtYWMiOiI0NmE3MWU5MzVjNzMwZGIwMzZlMzc2YjAyMDk0ZTM5ZWY4NzY3YWNmOWYzZjUwMmEyZjZiZWQxYmQwNWMwZWQ3IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:38:19', '2023-04-13 11:38:19'),
	(19, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6Ii93dHRVdTd3T0JmaVluNFJCYzYvdWc9PSIsInZhbHVlIjoiNGQxdVd1UGZJUlc0dStKNzVsWmMxKzBrQnc4amhjdUI1ZnE4MWhkeVoxdDRKTUxsZ1lhUEFmb3Uwc21PbkNnYlJhOHZwc0ZiaUllRUFFcVUyVzNQbVBNejZMNTVvMUFHazdYdGwzMEI2YXFvcHlqdHJ1K25pSUl1ZXQ3cEtod1ciLCJtYWMiOiI1ZDE3OWJjNGZlODIzMmI3NGQ3Mjg0MzFmZmFmMThhNzNhY2EzNDE3Mzc1NmQwMWVjMmVhMjFhOWU2NmQwOTdkIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:40:01', '2023-04-13 11:40:01'),
	(20, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6Ii93dHRVdTd3T0JmaVluNFJCYzYvdWc9PSIsInZhbHVlIjoiNGQxdVd1UGZJUlc0dStKNzVsWmMxKzBrQnc4amhjdUI1ZnE4MWhkeVoxdDRKTUxsZ1lhUEFmb3Uwc21PbkNnYlJhOHZwc0ZiaUllRUFFcVUyVzNQbVBNejZMNTVvMUFHazdYdGwzMEI2YXFvcHlqdHJ1K25pSUl1ZXQ3cEtod1ciLCJtYWMiOiI1ZDE3OWJjNGZlODIzMmI3NGQ3Mjg0MzFmZmFmMThhNzNhY2EzNDE3Mzc1NmQwMWVjMmVhMjFhOWU2NmQwOTdkIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:40:01', '2023-04-13 11:40:01'),
	(21, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6Ii93dHRVdTd3T0JmaVluNFJCYzYvdWc9PSIsInZhbHVlIjoiNGQxdVd1UGZJUlc0dStKNzVsWmMxKzBrQnc4amhjdUI1ZnE4MWhkeVoxdDRKTUxsZ1lhUEFmb3Uwc21PbkNnYlJhOHZwc0ZiaUllRUFFcVUyVzNQbVBNejZMNTVvMUFHazdYdGwzMEI2YXFvcHlqdHJ1K25pSUl1ZXQ3cEtod1ciLCJtYWMiOiI1ZDE3OWJjNGZlODIzMmI3NGQ3Mjg0MzFmZmFmMThhNzNhY2EzNDE3Mzc1NmQwMWVjMmVhMjFhOWU2NmQwOTdkIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:40:35', '2023-04-13 11:40:35'),
	(22, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6Ii93dHRVdTd3T0JmaVluNFJCYzYvdWc9PSIsInZhbHVlIjoiNGQxdVd1UGZJUlc0dStKNzVsWmMxKzBrQnc4amhjdUI1ZnE4MWhkeVoxdDRKTUxsZ1lhUEFmb3Uwc21PbkNnYlJhOHZwc0ZiaUllRUFFcVUyVzNQbVBNejZMNTVvMUFHazdYdGwzMEI2YXFvcHlqdHJ1K25pSUl1ZXQ3cEtod1ciLCJtYWMiOiI1ZDE3OWJjNGZlODIzMmI3NGQ3Mjg0MzFmZmFmMThhNzNhY2EzNDE3Mzc1NmQwMWVjMmVhMjFhOWU2NmQwOTdkIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:40:35', '2023-04-13 11:40:35'),
	(23, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6ImUyMVpYa2FtQ05uZHlXRDl1Ti9zTXc9PSIsInZhbHVlIjoic0R5bGVFV1p4eDBDUFZMeHhQZzBsc3B6aEdTWWh0R0E4ZWc5dHdIUkUrT2Y1RmtFK21rSDQ1bEJ3UWFOa24wZzIrN1owMWZKYS9IaGl5VFF5U1RrMjBNTjBTWnRxVmFlWkhqcDJRY2JBeUZVN05ESnVjWmtEMnVSZFBBSmJTakEiLCJtYWMiOiI1YTk0NjI5YzNlN2Q0NGMxN2E5ZDQ1NjU0OTA0ZTM5NjcwNTBhY2JhYjQ0NDhjMDJiZTgwMjcxMTU5MGYwOTllIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:40:51', '2023-04-13 11:40:51'),
	(24, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6ImUyMVpYa2FtQ05uZHlXRDl1Ti9zTXc9PSIsInZhbHVlIjoic0R5bGVFV1p4eDBDUFZMeHhQZzBsc3B6aEdTWWh0R0E4ZWc5dHdIUkUrT2Y1RmtFK21rSDQ1bEJ3UWFOa24wZzIrN1owMWZKYS9IaGl5VFF5U1RrMjBNTjBTWnRxVmFlWkhqcDJRY2JBeUZVN05ESnVjWmtEMnVSZFBBSmJTakEiLCJtYWMiOiI1YTk0NjI5YzNlN2Q0NGMxN2E5ZDQ1NjU0OTA0ZTM5NjcwNTBhY2JhYjQ0NDhjMDJiZTgwMjcxMTU5MGYwOTllIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:40:51', '2023-04-13 11:40:51'),
	(25, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6IjQ0eDhuTnppMGFURWtZZ0MwMEZEbGc9PSIsInZhbHVlIjoicWxJTnk3cmY2ait1U1Myb1ZSTit6R1V1aCtUd1hQR21ac1BXcVZCcjRMcitYTjQ2U0ZSa3dNdUlZdWg3Tm55czdPUWhwT2VkbmxkVnppT3BiaXU5VG4vS0k3VkJ5YnhhalMrT2E5WFlKZEJBRGNqbHF2enpVTzJSZ2ZsRnY0QkoiLCJtYWMiOiI2MWVjZmFkYWY0MDIzZDQ4MmEwNjI4YmUzMDhkZDM3NDZhZmJmZDljOGQ0ZTkyNzdlNjQ3ZGExNWM4NDVlZTA3IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:41:09', '2023-04-13 11:41:09'),
	(26, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6IjQ0eDhuTnppMGFURWtZZ0MwMEZEbGc9PSIsInZhbHVlIjoicWxJTnk3cmY2ait1U1Myb1ZSTit6R1V1aCtUd1hQR21ac1BXcVZCcjRMcitYTjQ2U0ZSa3dNdUlZdWg3Tm55czdPUWhwT2VkbmxkVnppT3BiaXU5VG4vS0k3VkJ5YnhhalMrT2E5WFlKZEJBRGNqbHF2enpVTzJSZ2ZsRnY0QkoiLCJtYWMiOiI2MWVjZmFkYWY0MDIzZDQ4MmEwNjI4YmUzMDhkZDM3NDZhZmJmZDljOGQ0ZTkyNzdlNjQ3ZGExNWM4NDVlZTA3IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:41:09', '2023-04-13 11:41:09'),
	(27, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6IjIxRG80TG5FVG44dkNHY2hKdWw4L3c9PSIsInZhbHVlIjoid3hjc1RMUTZGY1NKajRtQU4rdk9NaWtlVHY3Z0ppaHdqd2xmV3YzTnFHY2FkYmYvZlcwRFdFbGErd1JjU0I2NU9YNi95M3JORkZ4eFQrdjV0a3c3SmZMZ3ZOS0pzYTBEM1RqV0taTDNINFd1YXVRSTl2Y0E1bHpES3RPVkRlbjgiLCJtYWMiOiJlMTJiNDI4NmU4YTFmZDBhNTdlODM5NjA3MDgzYmYwZmNhYzNhN2FkMDdiOWVkMjM3Yjg2Njc2ZTllYjg4ODgxIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:41:29', '2023-04-13 11:41:29'),
	(28, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6IjIxRG80TG5FVG44dkNHY2hKdWw4L3c9PSIsInZhbHVlIjoid3hjc1RMUTZGY1NKajRtQU4rdk9NaWtlVHY3Z0ppaHdqd2xmV3YzTnFHY2FkYmYvZlcwRFdFbGErd1JjU0I2NU9YNi95M3JORkZ4eFQrdjV0a3c3SmZMZ3ZOS0pzYTBEM1RqV0taTDNINFd1YXVRSTl2Y0E1bHpES3RPVkRlbjgiLCJtYWMiOiJlMTJiNDI4NmU4YTFmZDBhNTdlODM5NjA3MDgzYmYwZmNhYzNhN2FkMDdiOWVkMjM3Yjg2Njc2ZTllYjg4ODgxIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:41:29', '2023-04-13 11:41:29'),
	(29, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"pragma":["no-cache"],"cache-control":["no-cache"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6IlA2S1dGWG5kYStOREpuSW44YU83RUE9PSIsInZhbHVlIjoiSC9tYjhQR04zb2NlYk4xcWVjS0JqRyt4dWNCN1UxdUcvQ3NvZi9nWGtWSGJ6Y2F5d1ordmxRTnJacGgvelhaT0p4Z213WUhLV1ZQcFBSd1dDamJYdi9GRlBkRnFjZVh5N2tWZWJNZThsZ0R6bUkzTkEzNzYrdTJkQWZ2V1JOMDUiLCJtYWMiOiJjYmFmOGZiNTNkZGRmZjFmZDY3M2NmNjIxNjY0Mzc2ZjZhMzFhY2E5OTMwYmFlZGM0Y2FmZmQ1ZjUyNzUwMjQ0IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:41:59', '2023-04-13 11:41:59'),
	(30, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"pragma":["no-cache"],"cache-control":["no-cache"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6IlA2S1dGWG5kYStOREpuSW44YU83RUE9PSIsInZhbHVlIjoiSC9tYjhQR04zb2NlYk4xcWVjS0JqRyt4dWNCN1UxdUcvQ3NvZi9nWGtWSGJ6Y2F5d1ordmxRTnJacGgvelhaT0p4Z213WUhLV1ZQcFBSd1dDamJYdi9GRlBkRnFjZVh5N2tWZWJNZThsZ0R6bUkzTkEzNzYrdTJkQWZ2V1JOMDUiLCJtYWMiOiJjYmFmOGZiNTNkZGRmZjFmZDY3M2NmNjIxNjY0Mzc2ZjZhMzFhY2E5OTMwYmFlZGM0Y2FmZmQ1ZjUyNzUwMjQ0IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:41:59', '2023-04-13 11:41:59'),
	(31, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6IndpV1Z1Z0hOMkdHaFFhcTYwL3R1NUE9PSIsInZhbHVlIjoia0dWT21iSkROM1RaQndNVitjS3VpY2NmMC9QQlo3b05mTmU4MG9tTmlhWXRYTk1sblo2TXpWSTR0UENNc1FtbGtBbU1xWFg4NWFXNDFVQmYrUENRZld6VWREck5VN3RGMzBoNTZ6WGVsN0FNNktlUStyMzRsV1kzL2l5WmRPV1QiLCJtYWMiOiIxY2JkMTcxY2IzMmNjYTQ1NWM5NDI5OWM3OGExNDM1NzhjMGE2MmU0MzhiNTJmY2I0YTIxMmE5MmMxMzZiNWZlIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:42:15', '2023-04-13 11:42:15'),
	(32, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6IndpV1Z1Z0hOMkdHaFFhcTYwL3R1NUE9PSIsInZhbHVlIjoia0dWT21iSkROM1RaQndNVitjS3VpY2NmMC9QQlo3b05mTmU4MG9tTmlhWXRYTk1sblo2TXpWSTR0UENNc1FtbGtBbU1xWFg4NWFXNDFVQmYrUENRZld6VWREck5VN3RGMzBoNTZ6WGVsN0FNNktlUStyMzRsV1kzL2l5WmRPV1QiLCJtYWMiOiIxY2JkMTcxY2IzMmNjYTQ1NWM5NDI5OWM3OGExNDM1NzhjMGE2MmU0MzhiNTJmY2I0YTIxMmE5MmMxMzZiNWZlIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:42:15', '2023-04-13 11:42:15'),
	(33, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6Ik84OUVJbGJnWVBBcWFXdEoxZVFMVWc9PSIsInZhbHVlIjoieDhFVXhhOXJnWER1T21GTktoakVvaUxLUUxFQ2w0REpPeWNaaHhaTXNkRDl4QXlxeEpmaHc5b2hVanVEMUprZkwybGlIclBqQ2YvVEJVT04xcnlMYitvc3ZaS1FaL2loV0JLOWZSRUx4ZWJNSHNxK3J1cSsyNFgxcU9WZFRobWUiLCJtYWMiOiJkZjgzMGVlYzE3ZWQxM2QzMzFhZDUyMGY3Yzk1MTQzNzlhYjdjNzJjMmQwZmU0YzJjNjc5YzJmYjNjN2RlNGM1IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:42:19', '2023-04-13 11:42:19'),
	(34, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6Ik84OUVJbGJnWVBBcWFXdEoxZVFMVWc9PSIsInZhbHVlIjoieDhFVXhhOXJnWER1T21GTktoakVvaUxLUUxFQ2w0REpPeWNaaHhaTXNkRDl4QXlxeEpmaHc5b2hVanVEMUprZkwybGlIclBqQ2YvVEJVT04xcnlMYitvc3ZaS1FaL2loV0JLOWZSRUx4ZWJNSHNxK3J1cSsyNFgxcU9WZFRobWUiLCJtYWMiOiJkZjgzMGVlYzE3ZWQxM2QzMzFhZDUyMGY3Yzk1MTQzNzlhYjdjNzJjMmQwZmU0YzJjNjc5YzJmYjNjN2RlNGM1IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:42:19', '2023-04-13 11:42:19'),
	(35, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6IlBtemswN01yS2hjUzIxS1dvVXJQcHc9PSIsInZhbHVlIjoibThLVzUweUY1NzVIaDNlQ2JFTWV3K0VxNkQxRU9CQ2dXSzdtZXNHM2VLR1JMYWJDSEJnNGNIY0RnTlhmbXB5bmZqS1UveDIvSXZ1YXNmNDZXZVlnNGlQWmpiYWl1SEdjSEdJVzM5S1NrazhlQldOelBjck14Z1EzUnZpbWthb20iLCJtYWMiOiI2YzBmZTAwNzliMTdmOGY2ZWYxNjBhMDdhYzBlZDUxOTNmMjVhNjUxMmNmODJiZTYwYWNmNTMzNGJkYmZkZTVlIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:42:31', '2023-04-13 11:42:31'),
	(36, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6IlBtemswN01yS2hjUzIxS1dvVXJQcHc9PSIsInZhbHVlIjoibThLVzUweUY1NzVIaDNlQ2JFTWV3K0VxNkQxRU9CQ2dXSzdtZXNHM2VLR1JMYWJDSEJnNGNIY0RnTlhmbXB5bmZqS1UveDIvSXZ1YXNmNDZXZVlnNGlQWmpiYWl1SEdjSEdJVzM5S1NrazhlQldOelBjck14Z1EzUnZpbWthb20iLCJtYWMiOiI2YzBmZTAwNzliMTdmOGY2ZWYxNjBhMDdhYzBlZDUxOTNmMjVhNjUxMmNmODJiZTYwYWNmNTMzNGJkYmZkZTVlIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:42:31', '2023-04-13 11:42:31'),
	(37, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"pragma":["no-cache"],"cache-control":["no-cache"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6Iml2SzdoODdGdjhhbXpIQkNUekR4S0E9PSIsInZhbHVlIjoiOTZBVHlaZDIrQ29WVnE1N1B2U2NEYmxFUUphUkhnS0dzbFR3WlhzdWpQTTJsZnpNcWZhbWpyTlBodDNRSU52RlgrK0ozRlo5ZTgrdWxqdXBHSWpBNUQ3QWt3V1dlYlYzK1o1bzd2SE5DTWFsbmFuSUhic2FkVk9BRE4zRDdFNDkiLCJtYWMiOiJlZGI4M2Y1MTI3NmZlM2UxOTA1MmQwY2ExOWQ4NDQ0NzJlNjhjNzkwYTkwMTY0MDA1NDI2MWIzZjYxNjMwMzExIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:43:14', '2023-04-13 11:43:14'),
	(38, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"pragma":["no-cache"],"cache-control":["no-cache"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6Iml2SzdoODdGdjhhbXpIQkNUekR4S0E9PSIsInZhbHVlIjoiOTZBVHlaZDIrQ29WVnE1N1B2U2NEYmxFUUphUkhnS0dzbFR3WlhzdWpQTTJsZnpNcWZhbWpyTlBodDNRSU52RlgrK0ozRlo5ZTgrdWxqdXBHSWpBNUQ3QWt3V1dlYlYzK1o1bzd2SE5DTWFsbmFuSUhic2FkVk9BRE4zRDdFNDkiLCJtYWMiOiJlZGI4M2Y1MTI3NmZlM2UxOTA1MmQwY2ExOWQ4NDQ0NzJlNjhjNzkwYTkwMTY0MDA1NDI2MWIzZjYxNjMwMzExIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:43:14', '2023-04-13 11:43:14'),
	(39, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6IitLRzA2Um1wRzZDN0V0S3huNkd3L3c9PSIsInZhbHVlIjoiNmJneDZGb2YrMTYxRFJsUDZNMVdNaTZQcGZVMHRNRVlBQ3JoMGxjOTFjelVSelZ2OXFqN3JjN3RzU0cvMno3SXhlYWZTYmRLVWs5MVhJSWFHaFNTczFCS0pSams0cURicFEzbG16M2wrSG1wR0NYVExxR2lzQ0pxNlUxNTJDZ2wiLCJtYWMiOiI4Yzc4MzgzZjEyZDZkM2UzNzUwY2M0ZWE2Nzg0Yjg5NzQxMzgxZGY5OTUxNjc2NjEyNmU2NWM0ZDQ5NTUzZmQzIiwidGFnIjoiIn0%3D; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:45:27', '2023-04-13 11:45:27'),
	(40, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; XSRF-TOKEN=eyJpdiI6IitLRzA2Um1wRzZDN0V0S3huNkd3L3c9PSIsInZhbHVlIjoiNmJneDZGb2YrMTYxRFJsUDZNMVdNaTZQcGZVMHRNRVlBQ3JoMGxjOTFjelVSelZ2OXFqN3JjN3RzU0cvMno3SXhlYWZTYmRLVWs5MVhJSWFHaFNTczFCS0pSams0cURicFEzbG16M2wrSG1wR0NYVExxR2lzQ0pxNlUxNTJDZ2wiLCJtYWMiOiI4Yzc4MzgzZjEyZDZkM2UzNzUwY2M0ZWE2Nzg0Yjg5NzQxMzgxZGY5OTUxNjc2NjEyNmU2NWM0ZDQ5NTUzZmQzIiwidGFnIjoiIn0%3D; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:45:27', '2023-04-13 11:45:27'),
	(41, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6Im1xNHFYUmJBZHhBWWxIWW8rTnZPYVE9PSIsInZhbHVlIjoiMFpnUWVBTnhDZjZTVWpKOFpheFBpcUFoWVJNQ21mYnEvZXFzL1JreDJ3NVRYL1o0ZlkyNWVSU0N3NWVtdmM0eFVlcDcwZjNFYXdzNHMxMWVYSHNwdExrUks1dWNVVkRiZGgrL25wa0xVeDlZTnU1N3RLcTJhZ25wT3pkcWxjMm0iLCJtYWMiOiIzNmQwOTE3ZjRkZWFkM2JjM2JjZmUwYTcyZDQ2ZmE0NGQyNmFjYjNlOTBmMzcwOWQ3Y2FiOTJhZjk4NGJjMWQ5IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:46:00', '2023-04-13 11:46:00'),
	(42, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6Im1xNHFYUmJBZHhBWWxIWW8rTnZPYVE9PSIsInZhbHVlIjoiMFpnUWVBTnhDZjZTVWpKOFpheFBpcUFoWVJNQ21mYnEvZXFzL1JreDJ3NVRYL1o0ZlkyNWVSU0N3NWVtdmM0eFVlcDcwZjNFYXdzNHMxMWVYSHNwdExrUks1dWNVVkRiZGgrL25wa0xVeDlZTnU1N3RLcTJhZ25wT3pkcWxjMm0iLCJtYWMiOiIzNmQwOTE3ZjRkZWFkM2JjM2JjZmUwYTcyZDQ2ZmE0NGQyNmFjYjNlOTBmMzcwOWQ3Y2FiOTJhZjk4NGJjMWQ5IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:46:00', '2023-04-13 11:46:00'),
	(43, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IlJiNTdnWjlvRk16cWFLUVZTQ0FUL2c9PSIsInZhbHVlIjoiRGVjRmlwTUJzTWdQc0orbnlqdk9Dc0hsRzdHdTJwOWFIdVY3bzZnZWZPM1pzYTRMQkNmYkNkQTZDRS9NVjJrOHdaTnJXZThzMkpXK2plSTBpK0JQZCt5REdQd2RTRnhqeGVKbWxDTlFYa1gvckpSakJUTk53c3lQcTNPVjFlUUsiLCJtYWMiOiJlMGRlOTBkNzA3NzJhNWZmNzlhMmMzYjcxMzljMDgxNjY1MWNiNGNlZWJiOTJiMzBmZWFjODZlMGEzNWRiMWYzIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:46:12', '2023-04-13 11:46:12'),
	(44, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IlJiNTdnWjlvRk16cWFLUVZTQ0FUL2c9PSIsInZhbHVlIjoiRGVjRmlwTUJzTWdQc0orbnlqdk9Dc0hsRzdHdTJwOWFIdVY3bzZnZWZPM1pzYTRMQkNmYkNkQTZDRS9NVjJrOHdaTnJXZThzMkpXK2plSTBpK0JQZCt5REdQd2RTRnhqeGVKbWxDTlFYa1gvckpSakJUTk53c3lQcTNPVjFlUUsiLCJtYWMiOiJlMGRlOTBkNzA3NzJhNWZmNzlhMmMzYjcxMzljMDgxNjY1MWNiNGNlZWJiOTJiMzBmZWFjODZlMGEzNWRiMWYzIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:46:12', '2023-04-13 11:46:12'),
	(45, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6Ijk0aHBoRFg5cm1JRTA3MHJ2aVNQK2c9PSIsInZhbHVlIjoiUXFaT1RJR1cyeE9YN0JBcnJXcENHWGZTUjZIN0xoY3BVZmJuNVlUdUNtSjB1eUdoQ0tHakhaQXlxYitadEg0Y0VjQisxM3pIRjBsRjE4ZDV1dVBlU3d2clpLNHZHNHF0dmlvbDgxQjdtTzNIWWZmKytudWEveGd5cFRTUzgwZXQiLCJtYWMiOiI1NzMwMDlkYmRhZmYzZjUzMzJjZmM4NmI4MTgyYTI3MjViZjE3NjQwMmVjMTQ2NGE3MzUzZGI5ZThkMmU1MTRhIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:46:32', '2023-04-13 11:46:32'),
	(46, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6Ijk0aHBoRFg5cm1JRTA3MHJ2aVNQK2c9PSIsInZhbHVlIjoiUXFaT1RJR1cyeE9YN0JBcnJXcENHWGZTUjZIN0xoY3BVZmJuNVlUdUNtSjB1eUdoQ0tHakhaQXlxYitadEg0Y0VjQisxM3pIRjBsRjE4ZDV1dVBlU3d2clpLNHZHNHF0dmlvbDgxQjdtTzNIWWZmKytudWEveGd5cFRTUzgwZXQiLCJtYWMiOiI1NzMwMDlkYmRhZmYzZjUzMzJjZmM4NmI4MTgyYTI3MjViZjE3NjQwMmVjMTQ2NGE3MzUzZGI5ZThkMmU1MTRhIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:46:32', '2023-04-13 11:46:32'),
	(47, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IkMrVXMrMFBLUEZjc2dOd3FjMXYxbGc9PSIsInZhbHVlIjoiR21UemZDaWxCUmlhamlYek1USmo5NHdTYUM0aE1YcWRxYlRDVHNPc2hmU2Fac2tqLzd2dm1zVXIxSm5OeUcrOGlHd1I4YWd2UmwyOHozK3lLQStCZlNrK1p3OGdKVytJN0sxTHdtbExwSzlRdGc2Ty9rYTlrMldJZXBGei81bGUiLCJtYWMiOiI0MDVlYTdhM2E0MjYyMDM3ZGJkOWNiZjYzM2M2MjUyNjlmNzdjZjlhMmE4MjgyZTg4ZmY5NzQ1YTI3NmM4OGNmIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:47:09', '2023-04-13 11:47:09'),
	(48, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IkMrVXMrMFBLUEZjc2dOd3FjMXYxbGc9PSIsInZhbHVlIjoiR21UemZDaWxCUmlhamlYek1USmo5NHdTYUM0aE1YcWRxYlRDVHNPc2hmU2Fac2tqLzd2dm1zVXIxSm5OeUcrOGlHd1I4YWd2UmwyOHozK3lLQStCZlNrK1p3OGdKVytJN0sxTHdtbExwSzlRdGc2Ty9rYTlrMldJZXBGei81bGUiLCJtYWMiOiI0MDVlYTdhM2E0MjYyMDM3ZGJkOWNiZjYzM2M2MjUyNjlmNzdjZjlhMmE4MjgyZTg4ZmY5NzQ1YTI3NmM4OGNmIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:47:09', '2023-04-13 11:47:09'),
	(49, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6Ilp3cFlpdGYxU2pJbnNQSWFyaFlmaHc9PSIsInZhbHVlIjoibzZPZmFMdEhKYXU1NU45cmNnZWFmLytIdmVhaTRwUmVnejVjM1lLaGJZOVlwcXFGL3lXbHVNZlVzbHNxN2VNTEJVWW1UckdJdjdqTHZtdG50RkNobllybDl5aWJkVkFVL3BjVlpRVVRGcjhMMUxVZHdmV0dxSlVtQk5ZSjhJNXEiLCJtYWMiOiI5N2I0NzUwMTQzMmFkOTAwMmRiZWFmMTExZmM2NDkwMzg3MjkxYjkxZDNiNjdhZGY2NmVjMDU4MjQ4YWViMzZiIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:47:26', '2023-04-13 11:47:26'),
	(50, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6Ilp3cFlpdGYxU2pJbnNQSWFyaFlmaHc9PSIsInZhbHVlIjoibzZPZmFMdEhKYXU1NU45cmNnZWFmLytIdmVhaTRwUmVnejVjM1lLaGJZOVlwcXFGL3lXbHVNZlVzbHNxN2VNTEJVWW1UckdJdjdqTHZtdG50RkNobllybDl5aWJkVkFVL3BjVlpRVVRGcjhMMUxVZHdmV0dxSlVtQk5ZSjhJNXEiLCJtYWMiOiI5N2I0NzUwMTQzMmFkOTAwMmRiZWFmMTExZmM2NDkwMzg3MjkxYjkxZDNiNjdhZGY2NmVjMDU4MjQ4YWViMzZiIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:47:26', '2023-04-13 11:47:26'),
	(51, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IkFyTFNvUnVvcHFObjVHWGl5R3h2TXc9PSIsInZhbHVlIjoiUzhnWDNBK2JVZlIvMjZkNnlZU05VVldOTDBlOWFvOHZJUFRpYVJCSS9YYVVVYXBYMXZHMC8xVVFJZG1hQXFqblp5UWt3TVRPM01NVmdXaHpXV2RkemsyYU5Bb0FLNVlHbzVkYkdCTFdONmdPS1QwcG5FK0hHZXF1ZFh5bVVUNmMiLCJtYWMiOiIzYjE1M2NlMWZjZTNhMGMzZjQwYWEzNzQzYzc1NzkyMTFjOTQ0NWQ1MDczYTE2YTU5MTBjMjMzYmEzZDUwNDFjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:47:55', '2023-04-13 11:47:55'),
	(52, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IkFyTFNvUnVvcHFObjVHWGl5R3h2TXc9PSIsInZhbHVlIjoiUzhnWDNBK2JVZlIvMjZkNnlZU05VVldOTDBlOWFvOHZJUFRpYVJCSS9YYVVVYXBYMXZHMC8xVVFJZG1hQXFqblp5UWt3TVRPM01NVmdXaHpXV2RkemsyYU5Bb0FLNVlHbzVkYkdCTFdONmdPS1QwcG5FK0hHZXF1ZFh5bVVUNmMiLCJtYWMiOiIzYjE1M2NlMWZjZTNhMGMzZjQwYWEzNzQzYzc1NzkyMTFjOTQ0NWQ1MDczYTE2YTU5MTBjMjMzYmEzZDUwNDFjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:47:55', '2023-04-13 11:47:55'),
	(53, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IjZESVpYaG5qMzBaRVVVaDgwY2VvQ1E9PSIsInZhbHVlIjoiNEpERm1zeTBWUFlzTkNMTndoaXNweFBEL21samFCcEVzQVBBOUNvZUEzOVdVRmIrSmVlOHVYQVkyaGxQbENtQVErV0JRMDFwNFpuT0ViN3BlQkhEUTZZajk1RndpOXNiZkh5RnlNNHUwZVBBSVM3enNQcWhZNTZsZEJkekVFSFkiLCJtYWMiOiJkZjkwYmRmY2JmN2VjZDMxZWNlNWU0YTVjNzEzY2QwNGNhYWNkNjc0MjlmYzQzMGI0MmRkM2EyMzIwMzkxMjIxIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:48:14', '2023-04-13 11:48:14'),
	(54, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IjZESVpYaG5qMzBaRVVVaDgwY2VvQ1E9PSIsInZhbHVlIjoiNEpERm1zeTBWUFlzTkNMTndoaXNweFBEL21samFCcEVzQVBBOUNvZUEzOVdVRmIrSmVlOHVYQVkyaGxQbENtQVErV0JRMDFwNFpuT0ViN3BlQkhEUTZZajk1RndpOXNiZkh5RnlNNHUwZVBBSVM3enNQcWhZNTZsZEJkekVFSFkiLCJtYWMiOiJkZjkwYmRmY2JmN2VjZDMxZWNlNWU0YTVjNzEzY2QwNGNhYWNkNjc0MjlmYzQzMGI0MmRkM2EyMzIwMzkxMjIxIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:48:14', '2023-04-13 11:48:14'),
	(55, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"pragma":["no-cache"],"cache-control":["no-cache"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6ImV5bG5KSlJ0Qkd2L2VERjM5Q2lYaUE9PSIsInZhbHVlIjoiZmF6TkRKWHA1TDdWYXE2VlZPNlVpcHloU0NqdFdPVXE2TzM2ZWRUSkV1RkxKRXJoOGdOV3NBR1BETUFGTXpBbGsrOEJIREsxMk44Y0taQXZ5WjM2ZG56bXo5a2c3QlJjNjZZeVpwbEtBMWVPdW1NSjB5YXhkcVVKSEM0UnpRMXoiLCJtYWMiOiJkN2EyYjcwNzUwMGMxMGNiNjZkMjYzODFhZGNkNGIyNjUwY2QxMjczMzAxYTFiZGYyMWQ2MmNmMTdhMTk4Zjc4IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:48:54', '2023-04-13 11:48:54'),
	(56, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"pragma":["no-cache"],"cache-control":["no-cache"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6ImV5bG5KSlJ0Qkd2L2VERjM5Q2lYaUE9PSIsInZhbHVlIjoiZmF6TkRKWHA1TDdWYXE2VlZPNlVpcHloU0NqdFdPVXE2TzM2ZWRUSkV1RkxKRXJoOGdOV3NBR1BETUFGTXpBbGsrOEJIREsxMk44Y0taQXZ5WjM2ZG56bXo5a2c3QlJjNjZZeVpwbEtBMWVPdW1NSjB5YXhkcVVKSEM0UnpRMXoiLCJtYWMiOiJkN2EyYjcwNzUwMGMxMGNiNjZkMjYzODFhZGNkNGIyNjUwY2QxMjczMzAxYTFiZGYyMWQ2MmNmMTdhMTk4Zjc4IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:48:54', '2023-04-13 11:48:54'),
	(57, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6ImVhQ213MnRNUStVT1lOZmZ1M04xd0E9PSIsInZhbHVlIjoiYk9lM2lkN2FObWtHUjhGcnJ1Z3AvQzhuOW56S0o0UktTRDVGRFUvYWFaYzhMdjJWaFVMVURjVC9tVnd5REdMenpxU1g0ZktPR2Y5a2xFQ2lvdUIvanVjdmk3dXJiWHFiNFBHc3NVMTlOVkgxQmpyc01EbGluODEvaUVmT2VYUWMiLCJtYWMiOiJkOGQ2YzQ5YWIwYTU4NjFhOTg3MjIxMjYwOWU0YzcwYWNiOGFiYWEwZjE4OThmYmI1OTE5YTlhYTNlMmFiYmY2IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:49:17', '2023-04-13 11:49:17'),
	(58, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6ImVhQ213MnRNUStVT1lOZmZ1M04xd0E9PSIsInZhbHVlIjoiYk9lM2lkN2FObWtHUjhGcnJ1Z3AvQzhuOW56S0o0UktTRDVGRFUvYWFaYzhMdjJWaFVMVURjVC9tVnd5REdMenpxU1g0ZktPR2Y5a2xFQ2lvdUIvanVjdmk3dXJiWHFiNFBHc3NVMTlOVkgxQmpyc01EbGluODEvaUVmT2VYUWMiLCJtYWMiOiJkOGQ2YzQ5YWIwYTU4NjFhOTg3MjIxMjYwOWU0YzcwYWNiOGFiYWEwZjE4OThmYmI1OTE5YTlhYTNlMmFiYmY2IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:49:17', '2023-04-13 11:49:17'),
	(59, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6InVmZ2VXa0htYnFhamZHVmgzS0NvSnc9PSIsInZhbHVlIjoiSDFNTFNkZk9aYlVVWnI1WDlORGdVYkNOaFNlakxENnl1eDdhaVVzdDhDUE1kbjZNekVvWXhJUEhFTnIvRjRrRVd4U3JaMFZkMHpCS2xZRVZ4Z2NoOGpSbHczcDZMVFdvbnMxMWMzVzBRMjlkTm1xSk9Eam5acHpaMHlIMGM0ZVUiLCJtYWMiOiIyNTM5MTFiNGY1Y2UyZjYxZTBlZmEyYzY2NWM2YThmZTJkZDc4NGM0YjdlNDRjNGIyNTM1ODE2N2M0MTA4NDgyIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:49:46', '2023-04-13 11:49:46'),
	(60, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6InVmZ2VXa0htYnFhamZHVmgzS0NvSnc9PSIsInZhbHVlIjoiSDFNTFNkZk9aYlVVWnI1WDlORGdVYkNOaFNlakxENnl1eDdhaVVzdDhDUE1kbjZNekVvWXhJUEhFTnIvRjRrRVd4U3JaMFZkMHpCS2xZRVZ4Z2NoOGpSbHczcDZMVFdvbnMxMWMzVzBRMjlkTm1xSk9Eam5acHpaMHlIMGM0ZVUiLCJtYWMiOiIyNTM5MTFiNGY1Y2UyZjYxZTBlZmEyYzY2NWM2YThmZTJkZDc4NGM0YjdlNDRjNGIyNTM1ODE2N2M0MTA4NDgyIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:49:46', '2023-04-13 11:49:46'),
	(61, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6InZibXF3ZFVCRUhVd3g3eTZTYmdObmc9PSIsInZhbHVlIjoidmpmdWlKMHpJenVoUnhYc1VGZ1A3NEdmZ3FQdFBGR3ZuaTRQdlJJTUdFcXJtTEZWaDZDTS9nNG82OGcrMW5HMHJzV0VFd3YvbEdlbWRwVi9aN2dnY2l2YkgzNnhoSXBQT01PUE1pMFJ6MVpRMFozZ0ZWMDJQcTcram1wWGJPRTYiLCJtYWMiOiJiNmYzODc2MWIyNTQ2YjYzNTcxODU4ZjRkMTg0MmYyMGE0OTI4ZDYwZDBmNjI1MmYwZDhiNWIwZWJiMzU2ZGE2IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:51:29', '2023-04-13 11:51:29'),
	(62, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6InZibXF3ZFVCRUhVd3g3eTZTYmdObmc9PSIsInZhbHVlIjoidmpmdWlKMHpJenVoUnhYc1VGZ1A3NEdmZ3FQdFBGR3ZuaTRQdlJJTUdFcXJtTEZWaDZDTS9nNG82OGcrMW5HMHJzV0VFd3YvbEdlbWRwVi9aN2dnY2l2YkgzNnhoSXBQT01PUE1pMFJ6MVpRMFozZ0ZWMDJQcTcram1wWGJPRTYiLCJtYWMiOiJiNmYzODc2MWIyNTQ2YjYzNTcxODU4ZjRkMTg0MmYyMGE0OTI4ZDYwZDBmNjI1MmYwZDhiNWIwZWJiMzU2ZGE2IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:51:29', '2023-04-13 11:51:29'),
	(63, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6Ik82aFVXV0pHR1gyK25jazEvUFBabWc9PSIsInZhbHVlIjoiWDdQWTRPQTJXc2wvVGxQZlM1cURUcit1WWh6ajBuVVRCYXNjRXdjczNldFdTL2tXWUUyWEJFb1g5cFBKVjl5Njg2NUduT3QwRGRyKzd4aE5HcHJmZzNDcEJteEVSZVZQbU9uQWVjMkNERnhlakNCdzU4cjlhV0VEUGNhRkZlcUciLCJtYWMiOiJkZjU3Y2ZmMzY2NjQ1NTNmYTIxNzI5YjQwYmQ2OTVjOTdmY2UwMDA2NjAxZjZkMTkyOWUzYzQ4NjRmNmU2Mjc0IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:51:45', '2023-04-13 11:51:45'),
	(64, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6Ik82aFVXV0pHR1gyK25jazEvUFBabWc9PSIsInZhbHVlIjoiWDdQWTRPQTJXc2wvVGxQZlM1cURUcit1WWh6ajBuVVRCYXNjRXdjczNldFdTL2tXWUUyWEJFb1g5cFBKVjl5Njg2NUduT3QwRGRyKzd4aE5HcHJmZzNDcEJteEVSZVZQbU9uQWVjMkNERnhlakNCdzU4cjlhV0VEUGNhRkZlcUciLCJtYWMiOiJkZjU3Y2ZmMzY2NjQ1NTNmYTIxNzI5YjQwYmQ2OTVjOTdmY2UwMDA2NjAxZjZkMTkyOWUzYzQ4NjRmNmU2Mjc0IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:51:45', '2023-04-13 11:51:45'),
	(65, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"pragma":["no-cache"],"cache-control":["no-cache"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IjlNTGxCM0tFQkFLcGtQZ1RzSDNoTkE9PSIsInZhbHVlIjoiNVcyei96TlhDUFpUMithUWVPT095M0x1OFBzdW9qTW5ZZGVBaDU5TWk5Zno1UlpQQjh4OXMzMHFWRXViaEJXVlFDeEZrTis4ZjNnODFMNXNwSVp3MEF3elhJbTdNMEZkTHdEK3hRbkZQL0VoTU9scVRkQUpRSWdFOUNzRDlVdDkiLCJtYWMiOiIwZTExOWQ3ODQ0Zjc3Y2I0NDgzZGZiZmJmODAyYzA1ODE2Y2NhYWYzN2JlYWU5YWJkODcwZTU2MzQ0YWI0OTE4IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:51:58', '2023-04-13 11:51:58'),
	(66, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"pragma":["no-cache"],"cache-control":["no-cache"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IjlNTGxCM0tFQkFLcGtQZ1RzSDNoTkE9PSIsInZhbHVlIjoiNVcyei96TlhDUFpUMithUWVPT095M0x1OFBzdW9qTW5ZZGVBaDU5TWk5Zno1UlpQQjh4OXMzMHFWRXViaEJXVlFDeEZrTis4ZjNnODFMNXNwSVp3MEF3elhJbTdNMEZkTHdEK3hRbkZQL0VoTU9scVRkQUpRSWdFOUNzRDlVdDkiLCJtYWMiOiIwZTExOWQ3ODQ0Zjc3Y2I0NDgzZGZiZmJmODAyYzA1ODE2Y2NhYWYzN2JlYWU5YWJkODcwZTU2MzQ0YWI0OTE4IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:51:59', '2023-04-13 11:51:59'),
	(67, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6Imxsd3BVczRZTGNFcXh6VXE4NUlsZFE9PSIsInZhbHVlIjoic1ZubUMrekh3eTZVMFpBa3hack9OdlZGOHdHQVV6cFJZS2pVbEE1NGluRVVQZFBveG1xdndCMUZOMXhMT0FvOGI4Y2JpbHpFa2V1NjNtTzZtMUZYVHBEMUVCSTVVbGtMUnE2UElZZEVUdUQzbGJ4aVllaDRzcUxnM1JFVjhmY0YiLCJtYWMiOiJhNGZhMWM5ZDlhZWRiZjIwMTk2ODRjZjI0MTAzNmQwYWQ5YTdlNWY1NTY4Yjk1NDdlZDA2ODZhODdiMDU3ZDQ3IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:52:14', '2023-04-13 11:52:14'),
	(68, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6Imxsd3BVczRZTGNFcXh6VXE4NUlsZFE9PSIsInZhbHVlIjoic1ZubUMrekh3eTZVMFpBa3hack9OdlZGOHdHQVV6cFJZS2pVbEE1NGluRVVQZFBveG1xdndCMUZOMXhMT0FvOGI4Y2JpbHpFa2V1NjNtTzZtMUZYVHBEMUVCSTVVbGtMUnE2UElZZEVUdUQzbGJ4aVllaDRzcUxnM1JFVjhmY0YiLCJtYWMiOiJhNGZhMWM5ZDlhZWRiZjIwMTk2ODRjZjI0MTAzNmQwYWQ5YTdlNWY1NTY4Yjk1NDdlZDA2ODZhODdiMDU3ZDQ3IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:52:14', '2023-04-13 11:52:14'),
	(69, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IkVlditMNTZnalBsNFI3SHFaazhKUXc9PSIsInZhbHVlIjoiUVFiaGhtRkd2QmRJcHBPNytTZmg4cjlGWFMyRUVxZVE5cGd1dzNyaWZ3a3lLcnJGc043MTNPdDMrNVNsSjRRUlY5dUdPUFhlekJwL3lqUS9zd1RGSE1uVDdJT2R3eXlUL3A2aEU0MmFUa3A4cHNtVE5VSjFiUndOUm5vQ0Voc2QiLCJtYWMiOiJlZWU4ODgwZjFkMWQwZTUzZDFkODEwM2ZjZjI1MzgyZDYxZmYyMGRiZGMyNGZkYmE5ZjRlYjFlNTBkYzI3NjI1IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:53:35', '2023-04-13 11:53:35'),
	(70, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IkVlditMNTZnalBsNFI3SHFaazhKUXc9PSIsInZhbHVlIjoiUVFiaGhtRkd2QmRJcHBPNytTZmg4cjlGWFMyRUVxZVE5cGd1dzNyaWZ3a3lLcnJGc043MTNPdDMrNVNsSjRRUlY5dUdPUFhlekJwL3lqUS9zd1RGSE1uVDdJT2R3eXlUL3A2aEU0MmFUa3A4cHNtVE5VSjFiUndOUm5vQ0Voc2QiLCJtYWMiOiJlZWU4ODgwZjFkMWQwZTUzZDFkODEwM2ZjZjI1MzgyZDYxZmYyMGRiZGMyNGZkYmE5ZjRlYjFlNTBkYzI3NjI1IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:53:35', '2023-04-13 11:53:35'),
	(71, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IitSY0lkZ1JiN0FFRncyVjAwV29wamc9PSIsInZhbHVlIjoidXRncE52WGpycEJGRHNDZmlZMnRORGFOMmRTdkxsVk0rcXhmTXMzYXJxK21OSFlMY0RmQXNZRVBmR3BWemRNb01Wc0tPbUV6TS9EN0JiMkNZa0JqZjNUK0FyOTl0M3hoZnNBNHFBWUIzRXZ0U2d5V0ZDemluOVBsampucUlGSTgiLCJtYWMiOiJhYWFiODc0YTEwYzAyOTJlODk1OTQwYzE1MjlhNzg1YjIyNzE1MjBiMDAyMzE3YTdjZWM4YTRhNTMwM2E3M2IxIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:54:14', '2023-04-13 11:54:14'),
	(72, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IitSY0lkZ1JiN0FFRncyVjAwV29wamc9PSIsInZhbHVlIjoidXRncE52WGpycEJGRHNDZmlZMnRORGFOMmRTdkxsVk0rcXhmTXMzYXJxK21OSFlMY0RmQXNZRVBmR3BWemRNb01Wc0tPbUV6TS9EN0JiMkNZa0JqZjNUK0FyOTl0M3hoZnNBNHFBWUIzRXZ0U2d5V0ZDemluOVBsampucUlGSTgiLCJtYWMiOiJhYWFiODc0YTEwYzAyOTJlODk1OTQwYzE1MjlhNzg1YjIyNzE1MjBiMDAyMzE3YTdjZWM4YTRhNTMwM2E3M2IxIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:54:14', '2023-04-13 11:54:14'),
	(73, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"pragma":["no-cache"],"cache-control":["no-cache"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6Ilo2dUc3alh5Q2xpVEtQUVRlY2tQY2c9PSIsInZhbHVlIjoiOEJueEc1emxXRHhFS1pCZ2t6YmxtOEt0STM4V1NzMHFLaWRJYU5Ib3RpNllLbDhSY2lsTnkrTlZIQzB4VzdyL2psY0JxTGoyTjFmSXFLK3lMZHAvSU5uSWs2WWdrQjVnT3J5MGI4ZE9VZFIxVXE5aE5jTGJTb0pHdkhKOU9pSkMiLCJtYWMiOiJlNzQ1NDFiNWU3MDBmYmZkNGI5YTNkNDliYjMzYWZlNGZlYTEwYzA5YzkzZDk1NDgzODFhYTg0ODZjNWY3OGFiIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:55:26', '2023-04-13 11:55:26'),
	(74, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"pragma":["no-cache"],"cache-control":["no-cache"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6Ilo2dUc3alh5Q2xpVEtQUVRlY2tQY2c9PSIsInZhbHVlIjoiOEJueEc1emxXRHhFS1pCZ2t6YmxtOEt0STM4V1NzMHFLaWRJYU5Ib3RpNllLbDhSY2lsTnkrTlZIQzB4VzdyL2psY0JxTGoyTjFmSXFLK3lMZHAvSU5uSWs2WWdrQjVnT3J5MGI4ZE9VZFIxVXE5aE5jTGJTb0pHdkhKOU9pSkMiLCJtYWMiOiJlNzQ1NDFiNWU3MDBmYmZkNGI5YTNkNDliYjMzYWZlNGZlYTEwYzA5YzkzZDk1NDgzODFhYTg0ODZjNWY3OGFiIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:55:26', '2023-04-13 11:55:26'),
	(75, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"pragma":["no-cache"],"cache-control":["no-cache"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6Ik45dDFwVGh6N0tUNFJyQitCTjRUSFE9PSIsInZhbHVlIjoiSXFyNmNOd2FPMDhEWWx5WWM0dENOQnJTU3Q2QVc1WVdUWkg0ZXZUVlYwbmZuZ24yOXR2RVZDaFo0Qko3UW1Wa0tnSUMvbVdFbGFvZDdoNWozQ1l6RlBWYVk4YXlzd0NGRXU2b01Kc2NUNXJJQmpKbUMzbGN5MFBSMGRPWlh4VUoiLCJtYWMiOiJmZWU2YTg3Njk2MjA3ZDdmYzQzOTA0YTZlYzg3ZTI0YWY5OTA4NWE4ZjIyMTkwZDI0OTkxZjAyM2IyYjhmNzc1IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:55:31', '2023-04-13 11:55:31'),
	(76, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"pragma":["no-cache"],"cache-control":["no-cache"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6Ik45dDFwVGh6N0tUNFJyQitCTjRUSFE9PSIsInZhbHVlIjoiSXFyNmNOd2FPMDhEWWx5WWM0dENOQnJTU3Q2QVc1WVdUWkg0ZXZUVlYwbmZuZ24yOXR2RVZDaFo0Qko3UW1Wa0tnSUMvbVdFbGFvZDdoNWozQ1l6RlBWYVk4YXlzd0NGRXU2b01Kc2NUNXJJQmpKbUMzbGN5MFBSMGRPWlh4VUoiLCJtYWMiOiJmZWU2YTg3Njk2MjA3ZDdmYzQzOTA0YTZlYzg3ZTI0YWY5OTA4NWE4ZjIyMTkwZDI0OTkxZjAyM2IyYjhmNzc1IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:55:31', '2023-04-13 11:55:31'),
	(77, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6Ik1hM3hVaFovcVdJQ3p5Q0dFa3JUSWc9PSIsInZhbHVlIjoiaElKUkFkcit5cHk0V2Vla3V2cSt3cUo0UFJjY1BHaFQ4SUZUNnI4bW0wbkhvR1M2YjlyS2c1TGJ0Q2FyZ0NVWVg4WTI0Q1pmdDNLd3EwUmJpbHdoOEtFbit6bFM2TUZ4djNGMU92Um9JM1NnWU5uaVVPam1iZWsxSVFtUVpCU20iLCJtYWMiOiJhN2NmZjVkMDYwZDIyZjliMzM3NjM1YjUwMTNhZGM3MjNiMGM4ZjMxZmI3YzFkM2I5MDNkMzI2ZWIwOGJiNDA2IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:56:12', '2023-04-13 11:56:12'),
	(78, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6Ik1hM3hVaFovcVdJQ3p5Q0dFa3JUSWc9PSIsInZhbHVlIjoiaElKUkFkcit5cHk0V2Vla3V2cSt3cUo0UFJjY1BHaFQ4SUZUNnI4bW0wbkhvR1M2YjlyS2c1TGJ0Q2FyZ0NVWVg4WTI0Q1pmdDNLd3EwUmJpbHdoOEtFbit6bFM2TUZ4djNGMU92Um9JM1NnWU5uaVVPam1iZWsxSVFtUVpCU20iLCJtYWMiOiJhN2NmZjVkMDYwZDIyZjliMzM3NjM1YjUwMTNhZGM3MjNiMGM4ZjMxZmI3YzFkM2I5MDNkMzI2ZWIwOGJiNDA2IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:56:12', '2023-04-13 11:56:12'),
	(79, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IlFKSlhnZ1FxaHJkODRYYW9WY1ZXY2c9PSIsInZhbHVlIjoiR3B1aStBN1FFN1Jqb3hzTDZJVGd2aTBtMWVoNUVReEIrcnJyNnpGTEFxcXY4T09WaSs1aE1UenpDNlhsMndqWHNHTzlZN2tmZGVHVGxKR3ZFVTJvYjZXK3ZheUMwT1FsRy96UmgrZ3drb2xJR0dUanFzYXk1VHNuaVNqa0l0K1AiLCJtYWMiOiJjZTRjMDY5OWEwYzJlOTQ3MGI3YjZlYjU5MTczODNkODgwY2FkNmYzNDY1NTBmYjg5YTdjOWUyYzA2NGFmZjgxIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:57:02', '2023-04-13 11:57:02'),
	(80, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; storego_saas_session=OTko8hKjnWO6zDe9aQTC8qOKJSAEZSoquhqlD7we; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IlFKSlhnZ1FxaHJkODRYYW9WY1ZXY2c9PSIsInZhbHVlIjoiR3B1aStBN1FFN1Jqb3hzTDZJVGd2aTBtMWVoNUVReEIrcnJyNnpGTEFxcXY4T09WaSs1aE1UenpDNlhsMndqWHNHTzlZN2tmZGVHVGxKR3ZFVTJvYjZXK3ZheUMwT1FsRy96UmgrZ3drb2xJR0dUanFzYXk1VHNuaVNqa0l0K1AiLCJtYWMiOiJjZTRjMDY5OWEwYzJlOTQ3MGI3YjZlYjU5MTczODNkODgwY2FkNmYzNDY1NTBmYjg5YTdjOWUyYzA2NGFmZjgxIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 11:57:02', '2023-04-13 11:57:02'),
	(81, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IjdJeVlIdElrNXRQenJmZnNJNkpnMkE9PSIsInZhbHVlIjoiamtlQVgwRW5GMnpOSDRIYVg1WHZrYVRJcDdab2htR2dNSS9sek1BV09WakNHWElFZzJ4MndCQndlTmZaMWplS1o3WXNuMjdKVll4TVJYbVBuOGQ2ZGQ1b0FRN3llUjZsRjlnTER3RW9CdWxueEpROVZPeXpnMFZUdU52YVEvSEQiLCJtYWMiOiJkNzJlMWJhODc5YThiNTI4ODhjMzFhNjE4ZDY1Y2FiMDliOTc2Y2VkMDc3ZjgzM2YyMzZiNzUyZmI0Mjg5YTY0IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:03:48', '2023-04-13 12:03:48'),
	(82, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IjdJeVlIdElrNXRQenJmZnNJNkpnMkE9PSIsInZhbHVlIjoiamtlQVgwRW5GMnpOSDRIYVg1WHZrYVRJcDdab2htR2dNSS9sek1BV09WakNHWElFZzJ4MndCQndlTmZaMWplS1o3WXNuMjdKVll4TVJYbVBuOGQ2ZGQ1b0FRN3llUjZsRjlnTER3RW9CdWxueEpROVZPeXpnMFZUdU52YVEvSEQiLCJtYWMiOiJkNzJlMWJhODc5YThiNTI4ODhjMzFhNjE4ZDY1Y2FiMDliOTc2Y2VkMDc3ZjgzM2YyMzZiNzUyZmI0Mjg5YTY0IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:03:48', '2023-04-13 12:03:48'),
	(83, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IlkrUllzWFplTmswSCtJK1ZMaUY0d1E9PSIsInZhbHVlIjoiZklrTTFsMHYwM2Q2RnhiRzJXZWRDalZFc0wxek9CVHloQytIV3cyaEhyS0dCZzU5MlA2ZXdIYnlyWUdNTy9iNUt5eXRVd0hYc1NheXZKT1FtVWZEd29TVEpqdmU5RnZUSEgxcFk1Z0Y1Qkg3cmhIMzl5RUd5b2dyamhIWmRFRnQiLCJtYWMiOiIzNzRkZDlhZDAxYTFlMTExN2Q4NDM5NmIxZGZkNGYxY2Q5MDA5NjJiNzE2YjYyNmQyNjI2YjBjYzA1MDE3ZTg3IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:03:54', '2023-04-13 12:03:54'),
	(84, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IlkrUllzWFplTmswSCtJK1ZMaUY0d1E9PSIsInZhbHVlIjoiZklrTTFsMHYwM2Q2RnhiRzJXZWRDalZFc0wxek9CVHloQytIV3cyaEhyS0dCZzU5MlA2ZXdIYnlyWUdNTy9iNUt5eXRVd0hYc1NheXZKT1FtVWZEd29TVEpqdmU5RnZUSEgxcFk1Z0Y1Qkg3cmhIMzl5RUd5b2dyamhIWmRFRnQiLCJtYWMiOiIzNzRkZDlhZDAxYTFlMTExN2Q4NDM5NmIxZGZkNGYxY2Q5MDA5NjJiNzE2YjYyNmQyNjI2YjBjYzA1MDE3ZTg3IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:03:54', '2023-04-13 12:03:54'),
	(85, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IklIb20wWlhvWkFYNzlLTEg2U1l4TEE9PSIsInZhbHVlIjoiNkZuTFFvRHQvVnhVY3RSTS8yRng4WWhFSWV1dUtNcUJtc2hhUlFyM0JnWDN4TnZtVDAxbkFiSXRreXhCaitkWGYvNllCQXRLUWI3K1ExSHZ0UHZwNWhnZmliVTYrK3VwaXF0S2RtV25wYzN3b0Z6MHhaTXlZdmhUUjgrYVB6YkEiLCJtYWMiOiI4Yjk2NWQzNTI4YTdkMDQxNTEzNjVlN2U0NWE1OWFmMjAzMzAyYjc4ODYyOWQ3NDQxZTYzNThlNWJhOGNiMTE3IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:03:59', '2023-04-13 12:03:59'),
	(86, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IklIb20wWlhvWkFYNzlLTEg2U1l4TEE9PSIsInZhbHVlIjoiNkZuTFFvRHQvVnhVY3RSTS8yRng4WWhFSWV1dUtNcUJtc2hhUlFyM0JnWDN4TnZtVDAxbkFiSXRreXhCaitkWGYvNllCQXRLUWI3K1ExSHZ0UHZwNWhnZmliVTYrK3VwaXF0S2RtV25wYzN3b0Z6MHhaTXlZdmhUUjgrYVB6YkEiLCJtYWMiOiI4Yjk2NWQzNTI4YTdkMDQxNTEzNjVlN2U0NWE1OWFmMjAzMzAyYjc4ODYyOWQ3NDQxZTYzNThlNWJhOGNiMTE3IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:03:59', '2023-04-13 12:03:59'),
	(87, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IlczYTV4bG5pYjV5U0tEYU0xZUExekE9PSIsInZhbHVlIjoiWlpUSTc1T094bDNWbWRHNjduOUdjUTdyUEcxTGZQYVRsUllpVnJxb0IxdCtja29QUkRNdTNlK0UrZWoxbmp0NXI0TndmWGliNzF3YzRUVEtlVHMxTGZRKzdydmcrZzFTZVBuSThkeFdlSHppemszTnZXNVhuT3RMOEd6NDBnVFYiLCJtYWMiOiI0MWIzMzljOTEzZDNlNDc4OTMzYzc4MTVhMmYwNmUxMzcxN2U1Y2U1YWQxY2Y5ODA0YmVhY2ZkMmYzZjY0ODM1IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:04:02', '2023-04-13 12:04:02'),
	(88, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IlczYTV4bG5pYjV5U0tEYU0xZUExekE9PSIsInZhbHVlIjoiWlpUSTc1T094bDNWbWRHNjduOUdjUTdyUEcxTGZQYVRsUllpVnJxb0IxdCtja29QUkRNdTNlK0UrZWoxbmp0NXI0TndmWGliNzF3YzRUVEtlVHMxTGZRKzdydmcrZzFTZVBuSThkeFdlSHppemszTnZXNVhuT3RMOEd6NDBnVFYiLCJtYWMiOiI0MWIzMzljOTEzZDNlNDc4OTMzYzc4MTVhMmYwNmUxMzcxN2U1Y2U1YWQxY2Y5ODA0YmVhY2ZkMmYzZjY0ODM1IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:04:02', '2023-04-13 12:04:02'),
	(89, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IkFkdERmSXdEYzVwSkNSWExUNXM2OEE9PSIsInZhbHVlIjoicldNZmxYZG5QRnJXY1V2VUV1RlQ4cWZZdWpzUXI1TFlFR1NhT0dQYUFNdUdzd2pzcVZ2RUFtaThYamtnc21McTczSmRFdklsNjhhQk5lNS91OFNSZkFtSlhRK3IrSldhRnY5OVREL1dWRmw5R05BZnVYdXRCWWNKNmVUL1RMTlMiLCJtYWMiOiJjNWMyZjgxZTM3ODJhZjk0ZDc5ZDRmMTBkMjJmOGYzYzg1ZWRiMDExMjU1MjA0ZTQwZjhhNzM4YTAyNzI1ZjEyIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:04:06', '2023-04-13 12:04:06'),
	(90, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IkFkdERmSXdEYzVwSkNSWExUNXM2OEE9PSIsInZhbHVlIjoicldNZmxYZG5QRnJXY1V2VUV1RlQ4cWZZdWpzUXI1TFlFR1NhT0dQYUFNdUdzd2pzcVZ2RUFtaThYamtnc21McTczSmRFdklsNjhhQk5lNS91OFNSZkFtSlhRK3IrSldhRnY5OVREL1dWRmw5R05BZnVYdXRCWWNKNmVUL1RMTlMiLCJtYWMiOiJjNWMyZjgxZTM3ODJhZjk0ZDc5ZDRmMTBkMjJmOGYzYzg1ZWRiMDExMjU1MjA0ZTQwZjhhNzM4YTAyNzI1ZjEyIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:04:06', '2023-04-13 12:04:06'),
	(91, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6ImFiLzJiWnhSOVdKNFhJelhacitqMXc9PSIsInZhbHVlIjoiTjdlRTF0cEc0b1R5d3R2S0J5YzVWTHpyNVlsSkZqTWlldDllc0NMWTVJalZDNk8wemVGMFQzaUJzWFVvb2lxSHRDZ203SldiNURBM2ZNUHc4UG9ISnp4bi9mVHpXQ0paQ0NKRWV1dmZmdFd4aG5KWHJHSVpLNUUybUJpMnZFc2UiLCJtYWMiOiIyNjMwOGUxY2FlNTU4Y2Y1NGVjZThmZmM4YWMzZDI1ZjkwZjc5YzM4YTg5ZjEwZTAzZjdmZmEwMjVhMzFjYmExIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:06:17', '2023-04-13 12:06:17'),
	(92, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6ImFiLzJiWnhSOVdKNFhJelhacitqMXc9PSIsInZhbHVlIjoiTjdlRTF0cEc0b1R5d3R2S0J5YzVWTHpyNVlsSkZqTWlldDllc0NMWTVJalZDNk8wemVGMFQzaUJzWFVvb2lxSHRDZ203SldiNURBM2ZNUHc4UG9ISnp4bi9mVHpXQ0paQ0NKRWV1dmZmdFd4aG5KWHJHSVpLNUUybUJpMnZFc2UiLCJtYWMiOiIyNjMwOGUxY2FlNTU4Y2Y1NGVjZThmZmM4YWMzZDI1ZjkwZjc5YzM4YTg5ZjEwZTAzZjdmZmEwMjVhMzFjYmExIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:06:17', '2023-04-13 12:06:17'),
	(93, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IkFYWWZoRndwWXV4bzJFZXo5elg5MGc9PSIsInZhbHVlIjoiM1hML29vWXRUQTJ5WHFiRmUrL3UzUDNMTE0vWkJUQ09kOEw5THlhcEJDZm1CeFVsZXBEbU9sUmtTUlBKRStLdW9CRTE4eFJiT3NmK0g0WjREZnR4UzdTR280REYxZkxEMWttc250QVNPZ0tOdDZ6eHRVejBJNENkTkQwa3VOOE4iLCJtYWMiOiJiYzIwYzg0MjI5OWIwM2E0ODM4YjkzOWVkOTMyNTY0ZjNlNzcxYzQwODE5OTU4N2NmNDUyMDIyN2VlMmM4ZDM4IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:07:59', '2023-04-13 12:07:59'),
	(94, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IkFYWWZoRndwWXV4bzJFZXo5elg5MGc9PSIsInZhbHVlIjoiM1hML29vWXRUQTJ5WHFiRmUrL3UzUDNMTE0vWkJUQ09kOEw5THlhcEJDZm1CeFVsZXBEbU9sUmtTUlBKRStLdW9CRTE4eFJiT3NmK0g0WjREZnR4UzdTR280REYxZkxEMWttc250QVNPZ0tOdDZ6eHRVejBJNENkTkQwa3VOOE4iLCJtYWMiOiJiYzIwYzg0MjI5OWIwM2E0ODM4YjkzOWVkOTMyNTY0ZjNlNzcxYzQwODE5OTU4N2NmNDUyMDIyN2VlMmM4ZDM4IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:07:59', '2023-04-13 12:07:59'),
	(95, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IkFYWWZoRndwWXV4bzJFZXo5elg5MGc9PSIsInZhbHVlIjoiM1hML29vWXRUQTJ5WHFiRmUrL3UzUDNMTE0vWkJUQ09kOEw5THlhcEJDZm1CeFVsZXBEbU9sUmtTUlBKRStLdW9CRTE4eFJiT3NmK0g0WjREZnR4UzdTR280REYxZkxEMWttc250QVNPZ0tOdDZ6eHRVejBJNENkTkQwa3VOOE4iLCJtYWMiOiJiYzIwYzg0MjI5OWIwM2E0ODM4YjkzOWVkOTMyNTY0ZjNlNzcxYzQwODE5OTU4N2NmNDUyMDIyN2VlMmM4ZDM4IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:09:23', '2023-04-13 12:09:23'),
	(96, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IkFYWWZoRndwWXV4bzJFZXo5elg5MGc9PSIsInZhbHVlIjoiM1hML29vWXRUQTJ5WHFiRmUrL3UzUDNMTE0vWkJUQ09kOEw5THlhcEJDZm1CeFVsZXBEbU9sUmtTUlBKRStLdW9CRTE4eFJiT3NmK0g0WjREZnR4UzdTR280REYxZkxEMWttc250QVNPZ0tOdDZ6eHRVejBJNENkTkQwa3VOOE4iLCJtYWMiOiJiYzIwYzg0MjI5OWIwM2E0ODM4YjkzOWVkOTMyNTY0ZjNlNzcxYzQwODE5OTU4N2NmNDUyMDIyN2VlMmM4ZDM4IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:09:23', '2023-04-13 12:09:23'),
	(97, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IkFYWWZoRndwWXV4bzJFZXo5elg5MGc9PSIsInZhbHVlIjoiM1hML29vWXRUQTJ5WHFiRmUrL3UzUDNMTE0vWkJUQ09kOEw5THlhcEJDZm1CeFVsZXBEbU9sUmtTUlBKRStLdW9CRTE4eFJiT3NmK0g0WjREZnR4UzdTR280REYxZkxEMWttc250QVNPZ0tOdDZ6eHRVejBJNENkTkQwa3VOOE4iLCJtYWMiOiJiYzIwYzg0MjI5OWIwM2E0ODM4YjkzOWVkOTMyNTY0ZjNlNzcxYzQwODE5OTU4N2NmNDUyMDIyN2VlMmM4ZDM4IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:10:29', '2023-04-13 12:10:29'),
	(98, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IkFYWWZoRndwWXV4bzJFZXo5elg5MGc9PSIsInZhbHVlIjoiM1hML29vWXRUQTJ5WHFiRmUrL3UzUDNMTE0vWkJUQ09kOEw5THlhcEJDZm1CeFVsZXBEbU9sUmtTUlBKRStLdW9CRTE4eFJiT3NmK0g0WjREZnR4UzdTR280REYxZkxEMWttc250QVNPZ0tOdDZ6eHRVejBJNENkTkQwa3VOOE4iLCJtYWMiOiJiYzIwYzg0MjI5OWIwM2E0ODM4YjkzOWVkOTMyNTY0ZjNlNzcxYzQwODE5OTU4N2NmNDUyMDIyN2VlMmM4ZDM4IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:10:29', '2023-04-13 12:10:29'),
	(99, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"pragma":["no-cache"],"cache-control":["no-cache"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IkFYWWZoRndwWXV4bzJFZXo5elg5MGc9PSIsInZhbHVlIjoiM1hML29vWXRUQTJ5WHFiRmUrL3UzUDNMTE0vWkJUQ09kOEw5THlhcEJDZm1CeFVsZXBEbU9sUmtTUlBKRStLdW9CRTE4eFJiT3NmK0g0WjREZnR4UzdTR280REYxZkxEMWttc250QVNPZ0tOdDZ6eHRVejBJNENkTkQwa3VOOE4iLCJtYWMiOiJiYzIwYzg0MjI5OWIwM2E0ODM4YjkzOWVkOTMyNTY0ZjNlNzcxYzQwODE5OTU4N2NmNDUyMDIyN2VlMmM4ZDM4IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:10:34', '2023-04-13 12:10:34'),
	(100, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"pragma":["no-cache"],"cache-control":["no-cache"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IkFYWWZoRndwWXV4bzJFZXo5elg5MGc9PSIsInZhbHVlIjoiM1hML29vWXRUQTJ5WHFiRmUrL3UzUDNMTE0vWkJUQ09kOEw5THlhcEJDZm1CeFVsZXBEbU9sUmtTUlBKRStLdW9CRTE4eFJiT3NmK0g0WjREZnR4UzdTR280REYxZkxEMWttc250QVNPZ0tOdDZ6eHRVejBJNENkTkQwa3VOOE4iLCJtYWMiOiJiYzIwYzg0MjI5OWIwM2E0ODM4YjkzOWVkOTMyNTY0ZjNlNzcxYzQwODE5OTU4N2NmNDUyMDIyN2VlMmM4ZDM4IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:10:34', '2023-04-13 12:10:34'),
	(101, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IkFYWWZoRndwWXV4bzJFZXo5elg5MGc9PSIsInZhbHVlIjoiM1hML29vWXRUQTJ5WHFiRmUrL3UzUDNMTE0vWkJUQ09kOEw5THlhcEJDZm1CeFVsZXBEbU9sUmtTUlBKRStLdW9CRTE4eFJiT3NmK0g0WjREZnR4UzdTR280REYxZkxEMWttc250QVNPZ0tOdDZ6eHRVejBJNENkTkQwa3VOOE4iLCJtYWMiOiJiYzIwYzg0MjI5OWIwM2E0ODM4YjkzOWVkOTMyNTY0ZjNlNzcxYzQwODE5OTU4N2NmNDUyMDIyN2VlMmM4ZDM4IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:10:44', '2023-04-13 12:10:44'),
	(102, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IkFYWWZoRndwWXV4bzJFZXo5elg5MGc9PSIsInZhbHVlIjoiM1hML29vWXRUQTJ5WHFiRmUrL3UzUDNMTE0vWkJUQ09kOEw5THlhcEJDZm1CeFVsZXBEbU9sUmtTUlBKRStLdW9CRTE4eFJiT3NmK0g0WjREZnR4UzdTR280REYxZkxEMWttc250QVNPZ0tOdDZ6eHRVejBJNENkTkQwa3VOOE4iLCJtYWMiOiJiYzIwYzg0MjI5OWIwM2E0ODM4YjkzOWVkOTMyNTY0ZjNlNzcxYzQwODE5OTU4N2NmNDUyMDIyN2VlMmM4ZDM4IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:10:44', '2023-04-13 12:10:44'),
	(103, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IkFYWWZoRndwWXV4bzJFZXo5elg5MGc9PSIsInZhbHVlIjoiM1hML29vWXRUQTJ5WHFiRmUrL3UzUDNMTE0vWkJUQ09kOEw5THlhcEJDZm1CeFVsZXBEbU9sUmtTUlBKRStLdW9CRTE4eFJiT3NmK0g0WjREZnR4UzdTR280REYxZkxEMWttc250QVNPZ0tOdDZ6eHRVejBJNENkTkQwa3VOOE4iLCJtYWMiOiJiYzIwYzg0MjI5OWIwM2E0ODM4YjkzOWVkOTMyNTY0ZjNlNzcxYzQwODE5OTU4N2NmNDUyMDIyN2VlMmM4ZDM4IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:11:28', '2023-04-13 12:11:28'),
	(104, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IkFYWWZoRndwWXV4bzJFZXo5elg5MGc9PSIsInZhbHVlIjoiM1hML29vWXRUQTJ5WHFiRmUrL3UzUDNMTE0vWkJUQ09kOEw5THlhcEJDZm1CeFVsZXBEbU9sUmtTUlBKRStLdW9CRTE4eFJiT3NmK0g0WjREZnR4UzdTR280REYxZkxEMWttc250QVNPZ0tOdDZ6eHRVejBJNENkTkQwa3VOOE4iLCJtYWMiOiJiYzIwYzg0MjI5OWIwM2E0ODM4YjkzOWVkOTMyNTY0ZjNlNzcxYzQwODE5OTU4N2NmNDUyMDIyN2VlMmM4ZDM4IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:11:28', '2023-04-13 12:11:28'),
	(105, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IjhoWDdYbFM3MG1NZ1ErcjJRcG9CYnc9PSIsInZhbHVlIjoiOVo4NWx6YUtaZ2VWRERsUTNUNzlGZXlIamdaSkdKZWJ4OGt0NVpuMmErRHY0S1VubnFXbCtQdHBrWnBBNExLMXdFeFJUWWdBMWg5VTRlTWxEZUxYZW15NURzam9PMG93VWZIUFZIbVU2ZUllSFhaYjcxeUd6ZkNBMkxtOWZJdkciLCJtYWMiOiIxZTU2ZmY5YzliNDU2ODAxNmIwNzVkNWEzZDdjN2VhYjQwN2Q2MTk2MjhiZWY2YWI0N2IzZjZiOWJhZjU5ZWZjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:11:38', '2023-04-13 12:11:38'),
	(106, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IjhoWDdYbFM3MG1NZ1ErcjJRcG9CYnc9PSIsInZhbHVlIjoiOVo4NWx6YUtaZ2VWRERsUTNUNzlGZXlIamdaSkdKZWJ4OGt0NVpuMmErRHY0S1VubnFXbCtQdHBrWnBBNExLMXdFeFJUWWdBMWg5VTRlTWxEZUxYZW15NURzam9PMG93VWZIUFZIbVU2ZUllSFhaYjcxeUd6ZkNBMkxtOWZJdkciLCJtYWMiOiIxZTU2ZmY5YzliNDU2ODAxNmIwNzVkNWEzZDdjN2VhYjQwN2Q2MTk2MjhiZWY2YWI0N2IzZjZiOWJhZjU5ZWZjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:11:38', '2023-04-13 12:11:38'),
	(107, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IjhoWDdYbFM3MG1NZ1ErcjJRcG9CYnc9PSIsInZhbHVlIjoiOVo4NWx6YUtaZ2VWRERsUTNUNzlGZXlIamdaSkdKZWJ4OGt0NVpuMmErRHY0S1VubnFXbCtQdHBrWnBBNExLMXdFeFJUWWdBMWg5VTRlTWxEZUxYZW15NURzam9PMG93VWZIUFZIbVU2ZUllSFhaYjcxeUd6ZkNBMkxtOWZJdkciLCJtYWMiOiIxZTU2ZmY5YzliNDU2ODAxNmIwNzVkNWEzZDdjN2VhYjQwN2Q2MTk2MjhiZWY2YWI0N2IzZjZiOWJhZjU5ZWZjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:12:26', '2023-04-13 12:12:26'),
	(108, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IjhoWDdYbFM3MG1NZ1ErcjJRcG9CYnc9PSIsInZhbHVlIjoiOVo4NWx6YUtaZ2VWRERsUTNUNzlGZXlIamdaSkdKZWJ4OGt0NVpuMmErRHY0S1VubnFXbCtQdHBrWnBBNExLMXdFeFJUWWdBMWg5VTRlTWxEZUxYZW15NURzam9PMG93VWZIUFZIbVU2ZUllSFhaYjcxeUd6ZkNBMkxtOWZJdkciLCJtYWMiOiIxZTU2ZmY5YzliNDU2ODAxNmIwNzVkNWEzZDdjN2VhYjQwN2Q2MTk2MjhiZWY2YWI0N2IzZjZiOWJhZjU5ZWZjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:12:26', '2023-04-13 12:12:26'),
	(109, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IjhoWDdYbFM3MG1NZ1ErcjJRcG9CYnc9PSIsInZhbHVlIjoiOVo4NWx6YUtaZ2VWRERsUTNUNzlGZXlIamdaSkdKZWJ4OGt0NVpuMmErRHY0S1VubnFXbCtQdHBrWnBBNExLMXdFeFJUWWdBMWg5VTRlTWxEZUxYZW15NURzam9PMG93VWZIUFZIbVU2ZUllSFhaYjcxeUd6ZkNBMkxtOWZJdkciLCJtYWMiOiIxZTU2ZmY5YzliNDU2ODAxNmIwNzVkNWEzZDdjN2VhYjQwN2Q2MTk2MjhiZWY2YWI0N2IzZjZiOWJhZjU5ZWZjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:12:35', '2023-04-13 12:12:35'),
	(110, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IjhoWDdYbFM3MG1NZ1ErcjJRcG9CYnc9PSIsInZhbHVlIjoiOVo4NWx6YUtaZ2VWRERsUTNUNzlGZXlIamdaSkdKZWJ4OGt0NVpuMmErRHY0S1VubnFXbCtQdHBrWnBBNExLMXdFeFJUWWdBMWg5VTRlTWxEZUxYZW15NURzam9PMG93VWZIUFZIbVU2ZUllSFhaYjcxeUd6ZkNBMkxtOWZJdkciLCJtYWMiOiIxZTU2ZmY5YzliNDU2ODAxNmIwNzVkNWEzZDdjN2VhYjQwN2Q2MTk2MjhiZWY2YWI0N2IzZjZiOWJhZjU5ZWZjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:12:35', '2023-04-13 12:12:35'),
	(111, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IjhoWDdYbFM3MG1NZ1ErcjJRcG9CYnc9PSIsInZhbHVlIjoiOVo4NWx6YUtaZ2VWRERsUTNUNzlGZXlIamdaSkdKZWJ4OGt0NVpuMmErRHY0S1VubnFXbCtQdHBrWnBBNExLMXdFeFJUWWdBMWg5VTRlTWxEZUxYZW15NURzam9PMG93VWZIUFZIbVU2ZUllSFhaYjcxeUd6ZkNBMkxtOWZJdkciLCJtYWMiOiIxZTU2ZmY5YzliNDU2ODAxNmIwNzVkNWEzZDdjN2VhYjQwN2Q2MTk2MjhiZWY2YWI0N2IzZjZiOWJhZjU5ZWZjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:14:44', '2023-04-13 12:14:44'),
	(112, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IjhoWDdYbFM3MG1NZ1ErcjJRcG9CYnc9PSIsInZhbHVlIjoiOVo4NWx6YUtaZ2VWRERsUTNUNzlGZXlIamdaSkdKZWJ4OGt0NVpuMmErRHY0S1VubnFXbCtQdHBrWnBBNExLMXdFeFJUWWdBMWg5VTRlTWxEZUxYZW15NURzam9PMG93VWZIUFZIbVU2ZUllSFhaYjcxeUd6ZkNBMkxtOWZJdkciLCJtYWMiOiIxZTU2ZmY5YzliNDU2ODAxNmIwNzVkNWEzZDdjN2VhYjQwN2Q2MTk2MjhiZWY2YWI0N2IzZjZiOWJhZjU5ZWZjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:14:44', '2023-04-13 12:14:44'),
	(113, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IjhoWDdYbFM3MG1NZ1ErcjJRcG9CYnc9PSIsInZhbHVlIjoiOVo4NWx6YUtaZ2VWRERsUTNUNzlGZXlIamdaSkdKZWJ4OGt0NVpuMmErRHY0S1VubnFXbCtQdHBrWnBBNExLMXdFeFJUWWdBMWg5VTRlTWxEZUxYZW15NURzam9PMG93VWZIUFZIbVU2ZUllSFhaYjcxeUd6ZkNBMkxtOWZJdkciLCJtYWMiOiIxZTU2ZmY5YzliNDU2ODAxNmIwNzVkNWEzZDdjN2VhYjQwN2Q2MTk2MjhiZWY2YWI0N2IzZjZiOWJhZjU5ZWZjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:14:53', '2023-04-13 12:14:53'),
	(114, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IjhoWDdYbFM3MG1NZ1ErcjJRcG9CYnc9PSIsInZhbHVlIjoiOVo4NWx6YUtaZ2VWRERsUTNUNzlGZXlIamdaSkdKZWJ4OGt0NVpuMmErRHY0S1VubnFXbCtQdHBrWnBBNExLMXdFeFJUWWdBMWg5VTRlTWxEZUxYZW15NURzam9PMG93VWZIUFZIbVU2ZUllSFhaYjcxeUd6ZkNBMkxtOWZJdkciLCJtYWMiOiIxZTU2ZmY5YzliNDU2ODAxNmIwNzVkNWEzZDdjN2VhYjQwN2Q2MTk2MjhiZWY2YWI0N2IzZjZiOWJhZjU5ZWZjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:14:53', '2023-04-13 12:14:53'),
	(115, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IlJhUnJIdmlTTk1CVnEwVWYvZEdJWXc9PSIsInZhbHVlIjoiUTVXcHpLUVdTRW85d0M5N05QQ1NzNFpNc1JMbms2elE1M0t1YTBpejdtOWRxRkhISzFVbFhYQlo4UmtlaEJaN01KQzZuUHVzbEgvRGNQK1psdkUwSHprcjFWb0Q4UXJVOVB3eGszM3ExMmpBbmc4Nys0NEVPbjUwejlSdVdZQ1oiLCJtYWMiOiI0OGQ2YzRjNjQ2ODllZjQxN2NkZWEzYmRiNDgwZjdkN2IyMmU2YjYyNzZkYWYzZDU3ZDQ1OTI3NmE0YjMxYjFiIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:15:49', '2023-04-13 12:15:49'),
	(116, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6IlJhUnJIdmlTTk1CVnEwVWYvZEdJWXc9PSIsInZhbHVlIjoiUTVXcHpLUVdTRW85d0M5N05QQ1NzNFpNc1JMbms2elE1M0t1YTBpejdtOWRxRkhISzFVbFhYQlo4UmtlaEJaN01KQzZuUHVzbEgvRGNQK1psdkUwSHprcjFWb0Q4UXJVOVB3eGszM3ExMmpBbmc4Nys0NEVPbjUwejlSdVdZQ1oiLCJtYWMiOiI0OGQ2YzRjNjQ2ODllZjQxN2NkZWEzYmRiNDgwZjdkN2IyMmU2YjYyNzZkYWYzZDU3ZDQ1OTI3NmE0YjMxYjFiIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:15:49', '2023-04-13 12:15:49'),
	(117, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6Ii8xYnIydExsRWRrd21RSVRwN2JPQUE9PSIsInZhbHVlIjoicnZaajg0dGF5emtJY3I5Rm5TR204VFpRenVlaHl6REROeE9COVUxckttYVlFbXlRU0JBRndCdUpnUjJUMnQ0bnFUZFZtQ1BYM0Uwb1I2bEVlZWNyYm9WQ0lSNktBUXFKRy9IMUxMeVArMzYxVjA3MFZSelNZbm1ud1hjcS9OZmsiLCJtYWMiOiI5NTViZjBkMzM2MzZiYjU2MWEwZTRmYjFjODlkNTk1OTU0ZDFlMTU5YjRmMWFhNzY5MTgyYmUyOGI2MTY3MTkyIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:15:55', '2023-04-13 12:15:55'),
	(118, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6Ii8xYnIydExsRWRrd21RSVRwN2JPQUE9PSIsInZhbHVlIjoicnZaajg0dGF5emtJY3I5Rm5TR204VFpRenVlaHl6REROeE9COVUxckttYVlFbXlRU0JBRndCdUpnUjJUMnQ0bnFUZFZtQ1BYM0Uwb1I2bEVlZWNyYm9WQ0lSNktBUXFKRy9IMUxMeVArMzYxVjA3MFZSelNZbm1ud1hjcS9OZmsiLCJtYWMiOiI5NTViZjBkMzM2MzZiYjU2MWEwZTRmYjFjODlkNTk1OTU0ZDFlMTU5YjRmMWFhNzY5MTgyYmUyOGI2MTY3MTkyIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:15:55', '2023-04-13 12:15:55'),
	(119, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6Ii8xYnIydExsRWRrd21RSVRwN2JPQUE9PSIsInZhbHVlIjoicnZaajg0dGF5emtJY3I5Rm5TR204VFpRenVlaHl6REROeE9COVUxckttYVlFbXlRU0JBRndCdUpnUjJUMnQ0bnFUZFZtQ1BYM0Uwb1I2bEVlZWNyYm9WQ0lSNktBUXFKRy9IMUxMeVArMzYxVjA3MFZSelNZbm1ud1hjcS9OZmsiLCJtYWMiOiI5NTViZjBkMzM2MzZiYjU2MWEwZTRmYjFjODlkNTk1OTU0ZDFlMTU5YjRmMWFhNzY5MTgyYmUyOGI2MTY3MTkyIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:16:24', '2023-04-13 12:16:24'),
	(120, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6Ii8xYnIydExsRWRrd21RSVRwN2JPQUE9PSIsInZhbHVlIjoicnZaajg0dGF5emtJY3I5Rm5TR204VFpRenVlaHl6REROeE9COVUxckttYVlFbXlRU0JBRndCdUpnUjJUMnQ0bnFUZFZtQ1BYM0Uwb1I2bEVlZWNyYm9WQ0lSNktBUXFKRy9IMUxMeVArMzYxVjA3MFZSelNZbm1ud1hjcS9OZmsiLCJtYWMiOiI5NTViZjBkMzM2MzZiYjU2MWEwZTRmYjFjODlkNTk1OTU0ZDFlMTU5YjRmMWFhNzY5MTgyYmUyOGI2MTY3MTkyIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:16:24', '2023-04-13 12:16:24'),
	(121, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6InEydUlYOHpxMmNkUEJsa0I4RDhXanc9PSIsInZhbHVlIjoiQXlpSTllYTM5ejl2eG11Z2RCMlp6U3NkRitwMm9Rcmw0cnhaVE44OS90OGJBWXhoVUMwNWlid2dkUEE5RmpUQUxWM3dSNThYQ0ltZThvempIUFpma2JNS3daR1dvSjlyN2N6eW5hdXMxZVlnY2xITlBKYUZ5bUk2a01pZFlXREQiLCJtYWMiOiJkYWFhMzkzMTI3MmVkNzBjMGM5M2FhOWE3ZTdhYmY2NTYzNjIzNTJmNmE1YWY2MWNiMTNjOGZjOTBmZDU5NjhmIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:17:24', '2023-04-13 12:17:24'),
	(122, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6InEydUlYOHpxMmNkUEJsa0I4RDhXanc9PSIsInZhbHVlIjoiQXlpSTllYTM5ejl2eG11Z2RCMlp6U3NkRitwMm9Rcmw0cnhaVE44OS90OGJBWXhoVUMwNWlid2dkUEE5RmpUQUxWM3dSNThYQ0ltZThvempIUFpma2JNS3daR1dvSjlyN2N6eW5hdXMxZVlnY2xITlBKYUZ5bUk2a01pZFlXREQiLCJtYWMiOiJkYWFhMzkzMTI3MmVkNzBjMGM5M2FhOWE3ZTdhYmY2NTYzNjIzNTJmNmE1YWY2MWNiMTNjOGZjOTBmZDU5NjhmIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:17:24', '2023-04-13 12:17:24'),
	(123, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6InNvNnU3Vk1Gak5mbVp5bllBSUticGc9PSIsInZhbHVlIjoiTlZud3NURkE3WElZUnhvZDBYSlFxVmkyeWlZOGo4ZUVPWDFkNTVETjB2dmQ4enFKUmhOTVVLaURGN3V4bkRLWGt1cnIxMzVjaDM0M1gyVDdHUVQrOVJjOEhQVk1TQlJPdTBtZ2U4ek50MkFCbVVpMTRQRmZLcCtHTVdZWHRsc2siLCJtYWMiOiIwNDU5MmZhNDRmY2YzZWRlN2E0YTlhNTdhMGMxY2NhOTgxMTU0NzVjMWFmMzA0YmQ5NzlmMDMyM2JlMGQ5OGQ1IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:18:05', '2023-04-13 12:18:05'),
	(124, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saas_session=IcPMRRtE3rw25UFi747Zsm7MXJf9GwYTgTr6jtTJ; ecom_saase_session=h1TupqDLqoIwEvI5FwdevFZQckXAUhB6TdbuJkZI; XSRF-TOKEN=eyJpdiI6InNvNnU3Vk1Gak5mbVp5bllBSUticGc9PSIsInZhbHVlIjoiTlZud3NURkE3WElZUnhvZDBYSlFxVmkyeWlZOGo4ZUVPWDFkNTVETjB2dmQ4enFKUmhOTVVLaURGN3V4bkRLWGt1cnIxMzVjaDM0M1gyVDdHUVQrOVJjOEhQVk1TQlJPdTBtZ2U4ek50MkFCbVVpMTRQRmZLcCtHTVdZWHRsc2siLCJtYWMiOiIwNDU5MmZhNDRmY2YzZWRlN2E0YTlhNTdhMGMxY2NhOTgxMTU0NzVjMWFmMzA0YmQ5NzlmMDMyM2JlMGQ5OGQ1IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-13 12:18:05', '2023-04-13 12:18:05'),
	(125, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IlBGV1RRZEFjMXM1R2kya0FramNtbXc9PSIsInZhbHVlIjoicUNGVWhZT0l4bjNaY3lHRExRVUtaVnduVHlCdXlIMm5LTzFiVERYWnl4VTBadnVVODJybzNRV1dReTNYV0s3VFVPbnh5eXhvUEVIQUpkOGlkNUsvcllJdzNIODdBbDQzTHlraFRNME9sMWhVZnNRTHdEVUFqaVZXMHdodENEcTYiLCJtYWMiOiJmNDVmYWFlMjFlNTNjNDM4MzQxNjg5ODcxMDEwOGY4YWM2NDE1ZjYzZTE4NDMyMmVkYmIzNjExMTliZWVhYTQzIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:05:37', '2023-04-14 10:05:37'),
	(126, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IlBGV1RRZEFjMXM1R2kya0FramNtbXc9PSIsInZhbHVlIjoicUNGVWhZT0l4bjNaY3lHRExRVUtaVnduVHlCdXlIMm5LTzFiVERYWnl4VTBadnVVODJybzNRV1dReTNYV0s3VFVPbnh5eXhvUEVIQUpkOGlkNUsvcllJdzNIODdBbDQzTHlraFRNME9sMWhVZnNRTHdEVUFqaVZXMHdodENEcTYiLCJtYWMiOiJmNDVmYWFlMjFlNTNjNDM4MzQxNjg5ODcxMDEwOGY4YWM2NDE1ZjYzZTE4NDMyMmVkYmIzNjExMTliZWVhYTQzIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:05:37', '2023-04-14 10:05:37'),
	(127, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IjlkYzdGczRta0drTGRYSVJrdDQxUlE9PSIsInZhbHVlIjoiWURzd2dRVHRMdXVjR0cxV0FJVWVScFRWaGluREdVSkU1RFRnT1RmeW1SUWRKWGNHQ2hsb3k0bXdIdExFSVo0NWVzRVVZZ2dMVEN4N0NHK3pMV3BsdzUrWkg1SmQrK1JKdFg5bVpmOGYranAzTlJXZFZ6c1ozUFdmS3l6cmFINS8iLCJtYWMiOiI4NTQ0NjBhZjkwYTY5YzliMGMzZmQ5N2Y1OWM1NjExNTYyODM5MGEzMzJlMmIyNjE4NDI2ZWZiNjc4YWZiYjMzIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:05:46', '2023-04-14 10:05:46'),
	(128, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IjlkYzdGczRta0drTGRYSVJrdDQxUlE9PSIsInZhbHVlIjoiWURzd2dRVHRMdXVjR0cxV0FJVWVScFRWaGluREdVSkU1RFRnT1RmeW1SUWRKWGNHQ2hsb3k0bXdIdExFSVo0NWVzRVVZZ2dMVEN4N0NHK3pMV3BsdzUrWkg1SmQrK1JKdFg5bVpmOGYranAzTlJXZFZ6c1ozUFdmS3l6cmFINS8iLCJtYWMiOiI4NTQ0NjBhZjkwYTY5YzliMGMzZmQ5N2Y1OWM1NjExNTYyODM5MGEzMzJlMmIyNjE4NDI2ZWZiNjc4YWZiYjMzIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:05:46', '2023-04-14 10:05:46'),
	(129, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IjZId2NmSHUvVnJnK0NEU25sYjNsVHc9PSIsInZhbHVlIjoiWklxamxTbHBIdWtGbVU0OEtGYUg5ekpXbFVIMW1pb0Rld0plWGxkTjA3SlA3Sy8vTzdJTVg0R0RkTk14Qm00dXVtZ1VkVTdBQlczZlhGOGoxbWJYenA2U3Y0cmhPWW1jZVVRaDQwY24yaGsycmJ6dTFzZDM4K1RKOWlWSndOeTIiLCJtYWMiOiI1MzU3ZGY3YzM2MDg4YTk2MzhiNmY3YmY4ZTE4MWM4ZjgxMGExZTU5YWViZTY1MzBiODI1MzZjNjUzNzkxZmZmIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:05:49', '2023-04-14 10:05:49'),
	(130, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IjZId2NmSHUvVnJnK0NEU25sYjNsVHc9PSIsInZhbHVlIjoiWklxamxTbHBIdWtGbVU0OEtGYUg5ekpXbFVIMW1pb0Rld0plWGxkTjA3SlA3Sy8vTzdJTVg0R0RkTk14Qm00dXVtZ1VkVTdBQlczZlhGOGoxbWJYenA2U3Y0cmhPWW1jZVVRaDQwY24yaGsycmJ6dTFzZDM4K1RKOWlWSndOeTIiLCJtYWMiOiI1MzU3ZGY3YzM2MDg4YTk2MzhiNmY3YmY4ZTE4MWM4ZjgxMGExZTU5YWViZTY1MzBiODI1MzZjNjUzNzkxZmZmIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:05:49', '2023-04-14 10:05:49'),
	(131, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IklyQVlHOXgreGJjRHh2Qmp2WENsK2c9PSIsInZhbHVlIjoiQ2RIckwwb0ozUUtvMVl2Q1hHdXNtNDBwNkFEVFZIdXhib2VYaWtuSHd3SmI2SUVJU3lyaWYzT1ovb2hmVzFhYzZ3VGxRZW9iaXdQQ0lHL1FxdFNjOGhoK1AvZUQyTmg4cURXdnJlNnozRWI0SXFHTjF6eVZZK0R2djJnNWJLazQiLCJtYWMiOiIxNGZjZDY1MTA5ZTU3MDQyZTc0NWM2YjcyZjU4NjM4MGVkNWRmZjBiMDYwNGYxMDQ2NThlZDUwZjBjZWIyNDE4IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:05:51', '2023-04-14 10:05:51'),
	(132, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IklyQVlHOXgreGJjRHh2Qmp2WENsK2c9PSIsInZhbHVlIjoiQ2RIckwwb0ozUUtvMVl2Q1hHdXNtNDBwNkFEVFZIdXhib2VYaWtuSHd3SmI2SUVJU3lyaWYzT1ovb2hmVzFhYzZ3VGxRZW9iaXdQQ0lHL1FxdFNjOGhoK1AvZUQyTmg4cURXdnJlNnozRWI0SXFHTjF6eVZZK0R2djJnNWJLazQiLCJtYWMiOiIxNGZjZDY1MTA5ZTU3MDQyZTc0NWM2YjcyZjU4NjM4MGVkNWRmZjBiMDYwNGYxMDQ2NThlZDUwZjBjZWIyNDE4IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:05:51', '2023-04-14 10:05:51'),
	(133, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Im5Qcmo0dmVOMTIzemhMUE1CTUhpc3c9PSIsInZhbHVlIjoiMnhnL1FxaFkvUEI2OWhDM3RRQ2dHOGhtRnF1WGpySDRKQS9STHN5Rm9RcDBOdGR5MVdBSUJkR0JJeXYrTUxabHV5R1MySjlHSm81NDdJOWU1R3BMOXVzQWlOdXBZZDdyZ1JRRldhWFBzWWp0QXFTcEJ1N0tnNnlnTGhVanZnT3YiLCJtYWMiOiI4NTAxYjAzYzcyNzk5Yzc2NzI3NDFiMzZlZDUzMWQyMzZlYzZmYTJhYTUzNzI3YmRkOWJhNDQxY2ZjNTU4MTQ5IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:07:14', '2023-04-14 10:07:14'),
	(134, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Im5Qcmo0dmVOMTIzemhMUE1CTUhpc3c9PSIsInZhbHVlIjoiMnhnL1FxaFkvUEI2OWhDM3RRQ2dHOGhtRnF1WGpySDRKQS9STHN5Rm9RcDBOdGR5MVdBSUJkR0JJeXYrTUxabHV5R1MySjlHSm81NDdJOWU1R3BMOXVzQWlOdXBZZDdyZ1JRRldhWFBzWWp0QXFTcEJ1N0tnNnlnTGhVanZnT3YiLCJtYWMiOiI4NTAxYjAzYzcyNzk5Yzc2NzI3NDFiMzZlZDUzMWQyMzZlYzZmYTJhYTUzNzI3YmRkOWJhNDQxY2ZjNTU4MTQ5IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:07:14', '2023-04-14 10:07:14'),
	(135, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Im5Qcmo0dmVOMTIzemhMUE1CTUhpc3c9PSIsInZhbHVlIjoiMnhnL1FxaFkvUEI2OWhDM3RRQ2dHOGhtRnF1WGpySDRKQS9STHN5Rm9RcDBOdGR5MVdBSUJkR0JJeXYrTUxabHV5R1MySjlHSm81NDdJOWU1R3BMOXVzQWlOdXBZZDdyZ1JRRldhWFBzWWp0QXFTcEJ1N0tnNnlnTGhVanZnT3YiLCJtYWMiOiI4NTAxYjAzYzcyNzk5Yzc2NzI3NDFiMzZlZDUzMWQyMzZlYzZmYTJhYTUzNzI3YmRkOWJhNDQxY2ZjNTU4MTQ5IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:08:20', '2023-04-14 10:08:20'),
	(136, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Im5Qcmo0dmVOMTIzemhMUE1CTUhpc3c9PSIsInZhbHVlIjoiMnhnL1FxaFkvUEI2OWhDM3RRQ2dHOGhtRnF1WGpySDRKQS9STHN5Rm9RcDBOdGR5MVdBSUJkR0JJeXYrTUxabHV5R1MySjlHSm81NDdJOWU1R3BMOXVzQWlOdXBZZDdyZ1JRRldhWFBzWWp0QXFTcEJ1N0tnNnlnTGhVanZnT3YiLCJtYWMiOiI4NTAxYjAzYzcyNzk5Yzc2NzI3NDFiMzZlZDUzMWQyMzZlYzZmYTJhYTUzNzI3YmRkOWJhNDQxY2ZjNTU4MTQ5IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:08:20', '2023-04-14 10:08:20'),
	(137, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"pragma":["no-cache"],"cache-control":["no-cache"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Im5Qcmo0dmVOMTIzemhMUE1CTUhpc3c9PSIsInZhbHVlIjoiMnhnL1FxaFkvUEI2OWhDM3RRQ2dHOGhtRnF1WGpySDRKQS9STHN5Rm9RcDBOdGR5MVdBSUJkR0JJeXYrTUxabHV5R1MySjlHSm81NDdJOWU1R3BMOXVzQWlOdXBZZDdyZ1JRRldhWFBzWWp0QXFTcEJ1N0tnNnlnTGhVanZnT3YiLCJtYWMiOiI4NTAxYjAzYzcyNzk5Yzc2NzI3NDFiMzZlZDUzMWQyMzZlYzZmYTJhYTUzNzI3YmRkOWJhNDQxY2ZjNTU4MTQ5IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:09:23', '2023-04-14 10:09:23'),
	(138, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"pragma":["no-cache"],"cache-control":["no-cache"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Im5Qcmo0dmVOMTIzemhMUE1CTUhpc3c9PSIsInZhbHVlIjoiMnhnL1FxaFkvUEI2OWhDM3RRQ2dHOGhtRnF1WGpySDRKQS9STHN5Rm9RcDBOdGR5MVdBSUJkR0JJeXYrTUxabHV5R1MySjlHSm81NDdJOWU1R3BMOXVzQWlOdXBZZDdyZ1JRRldhWFBzWWp0QXFTcEJ1N0tnNnlnTGhVanZnT3YiLCJtYWMiOiI4NTAxYjAzYzcyNzk5Yzc2NzI3NDFiMzZlZDUzMWQyMzZlYzZmYTJhYTUzNzI3YmRkOWJhNDQxY2ZjNTU4MTQ5IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:09:23', '2023-04-14 10:09:23'),
	(139, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Im5Qcmo0dmVOMTIzemhMUE1CTUhpc3c9PSIsInZhbHVlIjoiMnhnL1FxaFkvUEI2OWhDM3RRQ2dHOGhtRnF1WGpySDRKQS9STHN5Rm9RcDBOdGR5MVdBSUJkR0JJeXYrTUxabHV5R1MySjlHSm81NDdJOWU1R3BMOXVzQWlOdXBZZDdyZ1JRRldhWFBzWWp0QXFTcEJ1N0tnNnlnTGhVanZnT3YiLCJtYWMiOiI4NTAxYjAzYzcyNzk5Yzc2NzI3NDFiMzZlZDUzMWQyMzZlYzZmYTJhYTUzNzI3YmRkOWJhNDQxY2ZjNTU4MTQ5IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:09:49', '2023-04-14 10:09:49'),
	(140, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Im5Qcmo0dmVOMTIzemhMUE1CTUhpc3c9PSIsInZhbHVlIjoiMnhnL1FxaFkvUEI2OWhDM3RRQ2dHOGhtRnF1WGpySDRKQS9STHN5Rm9RcDBOdGR5MVdBSUJkR0JJeXYrTUxabHV5R1MySjlHSm81NDdJOWU1R3BMOXVzQWlOdXBZZDdyZ1JRRldhWFBzWWp0QXFTcEJ1N0tnNnlnTGhVanZnT3YiLCJtYWMiOiI4NTAxYjAzYzcyNzk5Yzc2NzI3NDFiMzZlZDUzMWQyMzZlYzZmYTJhYTUzNzI3YmRkOWJhNDQxY2ZjNTU4MTQ5IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:09:49', '2023-04-14 10:09:49'),
	(141, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Im5Qcmo0dmVOMTIzemhMUE1CTUhpc3c9PSIsInZhbHVlIjoiMnhnL1FxaFkvUEI2OWhDM3RRQ2dHOGhtRnF1WGpySDRKQS9STHN5Rm9RcDBOdGR5MVdBSUJkR0JJeXYrTUxabHV5R1MySjlHSm81NDdJOWU1R3BMOXVzQWlOdXBZZDdyZ1JRRldhWFBzWWp0QXFTcEJ1N0tnNnlnTGhVanZnT3YiLCJtYWMiOiI4NTAxYjAzYzcyNzk5Yzc2NzI3NDFiMzZlZDUzMWQyMzZlYzZmYTJhYTUzNzI3YmRkOWJhNDQxY2ZjNTU4MTQ5IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:10:35', '2023-04-14 10:10:35'),
	(142, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Im5Qcmo0dmVOMTIzemhMUE1CTUhpc3c9PSIsInZhbHVlIjoiMnhnL1FxaFkvUEI2OWhDM3RRQ2dHOGhtRnF1WGpySDRKQS9STHN5Rm9RcDBOdGR5MVdBSUJkR0JJeXYrTUxabHV5R1MySjlHSm81NDdJOWU1R3BMOXVzQWlOdXBZZDdyZ1JRRldhWFBzWWp0QXFTcEJ1N0tnNnlnTGhVanZnT3YiLCJtYWMiOiI4NTAxYjAzYzcyNzk5Yzc2NzI3NDFiMzZlZDUzMWQyMzZlYzZmYTJhYTUzNzI3YmRkOWJhNDQxY2ZjNTU4MTQ5IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:10:35', '2023-04-14 10:10:35'),
	(143, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Im5Qcmo0dmVOMTIzemhMUE1CTUhpc3c9PSIsInZhbHVlIjoiMnhnL1FxaFkvUEI2OWhDM3RRQ2dHOGhtRnF1WGpySDRKQS9STHN5Rm9RcDBOdGR5MVdBSUJkR0JJeXYrTUxabHV5R1MySjlHSm81NDdJOWU1R3BMOXVzQWlOdXBZZDdyZ1JRRldhWFBzWWp0QXFTcEJ1N0tnNnlnTGhVanZnT3YiLCJtYWMiOiI4NTAxYjAzYzcyNzk5Yzc2NzI3NDFiMzZlZDUzMWQyMzZlYzZmYTJhYTUzNzI3YmRkOWJhNDQxY2ZjNTU4MTQ5IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:10:47', '2023-04-14 10:10:47'),
	(144, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Im5Qcmo0dmVOMTIzemhMUE1CTUhpc3c9PSIsInZhbHVlIjoiMnhnL1FxaFkvUEI2OWhDM3RRQ2dHOGhtRnF1WGpySDRKQS9STHN5Rm9RcDBOdGR5MVdBSUJkR0JJeXYrTUxabHV5R1MySjlHSm81NDdJOWU1R3BMOXVzQWlOdXBZZDdyZ1JRRldhWFBzWWp0QXFTcEJ1N0tnNnlnTGhVanZnT3YiLCJtYWMiOiI4NTAxYjAzYzcyNzk5Yzc2NzI3NDFiMzZlZDUzMWQyMzZlYzZmYTJhYTUzNzI3YmRkOWJhNDQxY2ZjNTU4MTQ5IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:10:47', '2023-04-14 10:10:47'),
	(145, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IlU3UjRudUlaY3o1eUxVOTkyV1g1OUE9PSIsInZhbHVlIjoiVFNpM2ZZTXFrUzhkVW4yZ1pUSmltcXBzUjZrbGFTenNGSW51Mjl0Rm9lVTVCNkZkN0lKVFpLSWQweFpPMzR5bWYzVG8zVUxMMmx3UEVZMTlvZDN3RXJwSjNRTE12dU9xeGIyTUhZNjBjdUtWWm5sazFydHc5cTh6cUF6MGp6c0ciLCJtYWMiOiI1YTJjZGMzNWIyNTNiYTk2ZTc4ZjE2NzQ4ZDFiZGU3ODdlYTg5ZGMzNmM0ZWJjZTRmNDc2YjMwNjcxYWI4NmJjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:12:31', '2023-04-14 10:12:31'),
	(146, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IlU3UjRudUlaY3o1eUxVOTkyV1g1OUE9PSIsInZhbHVlIjoiVFNpM2ZZTXFrUzhkVW4yZ1pUSmltcXBzUjZrbGFTenNGSW51Mjl0Rm9lVTVCNkZkN0lKVFpLSWQweFpPMzR5bWYzVG8zVUxMMmx3UEVZMTlvZDN3RXJwSjNRTE12dU9xeGIyTUhZNjBjdUtWWm5sazFydHc5cTh6cUF6MGp6c0ciLCJtYWMiOiI1YTJjZGMzNWIyNTNiYTk2ZTc4ZjE2NzQ4ZDFiZGU3ODdlYTg5ZGMzNmM0ZWJjZTRmNDc2YjMwNjcxYWI4NmJjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:12:31', '2023-04-14 10:12:31'),
	(147, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IlM4OTRhZVNjTks3bmVUaXBrN3lGQUE9PSIsInZhbHVlIjoiNjVxZUFua0thSTFLTXdkcWtia0RNb3NLUG5HK1l0L25laU54bmtqSDZMYzJudGtCZlVrWkVhTGpPVlZVNnlubHdhT0IrWkhSWVRDR1BOSFBLRnU2S0plR1ZwQ2JBK1ZTM0ZwZWhSdVpJdnQrbE80RFZ3REUzRWpEY01uOU4wN2UiLCJtYWMiOiJjMjkwNjFjYzQ1MzA2ODcxN2NhYjg1YmQ0OGE1YjI0ZmI3NWQ5YTNkMDEzNzZhMTRmMjUyOWMxYzA2MWEwNGQzIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:16:04', '2023-04-14 10:16:04'),
	(148, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IlM4OTRhZVNjTks3bmVUaXBrN3lGQUE9PSIsInZhbHVlIjoiNjVxZUFua0thSTFLTXdkcWtia0RNb3NLUG5HK1l0L25laU54bmtqSDZMYzJudGtCZlVrWkVhTGpPVlZVNnlubHdhT0IrWkhSWVRDR1BOSFBLRnU2S0plR1ZwQ2JBK1ZTM0ZwZWhSdVpJdnQrbE80RFZ3REUzRWpEY01uOU4wN2UiLCJtYWMiOiJjMjkwNjFjYzQ1MzA2ODcxN2NhYjg1YmQ0OGE1YjI0ZmI3NWQ5YTNkMDEzNzZhMTRmMjUyOWMxYzA2MWEwNGQzIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:16:04', '2023-04-14 10:16:04'),
	(149, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImpTQTFlcDVXejJOa3RCWWQrbUYyUFE9PSIsInZhbHVlIjoicFEwSTVWRVhOenUyMCtYV3R5UldXR0VUNzg0YUZaYzN2T1pBV3pwcVEwUkFKakJIa2hQTVc2c3JxTVVUQlZLc3hKckRqRWVMQmFaNExpTmEzMlZSc0dtOFdEZ2Q0L0ltcWpxK2VlRWF4YW1PdnBDNWNwZkJGVlFzUHBrK0FWckIiLCJtYWMiOiIzMmZjMzU1NGIwOWJmOThmYzU2YzBlMDc1OWI2NDcxZGMwMzEwMmYxNTY5ZWY2YWNhNWJkZmM0OGU2NGFlMWMxIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:17:42', '2023-04-14 10:17:42'),
	(150, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImpTQTFlcDVXejJOa3RCWWQrbUYyUFE9PSIsInZhbHVlIjoicFEwSTVWRVhOenUyMCtYV3R5UldXR0VUNzg0YUZaYzN2T1pBV3pwcVEwUkFKakJIa2hQTVc2c3JxTVVUQlZLc3hKckRqRWVMQmFaNExpTmEzMlZSc0dtOFdEZ2Q0L0ltcWpxK2VlRWF4YW1PdnBDNWNwZkJGVlFzUHBrK0FWckIiLCJtYWMiOiIzMmZjMzU1NGIwOWJmOThmYzU2YzBlMDc1OWI2NDcxZGMwMzEwMmYxNTY5ZWY2YWNhNWJkZmM0OGU2NGFlMWMxIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:17:42', '2023-04-14 10:17:42'),
	(151, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IlN1UzRadC9RTFA0Mjh5SGJUUE9CS1E9PSIsInZhbHVlIjoieHJLaEhVVGxjdS85R2FPMlV2MVdtOE81cHU3NjVCVFljNWpLUlRWdHdGKzhacjVqYXhab3F6L1NUU0pIMkV1OE5PcXVTcFdjOXB6clZvc0tTTnFiakV6bDV1a2Fjb3dlU2RaRmpFR3MzWlRtaUZ0ZFFQNUpYd01zSVFFSzh3U3giLCJtYWMiOiI5MThlYTcwNDViMzc4NWJmNTAyM2FjZDE4ZGVkZGQwM2QwZDFlMjUyZmY3Yzc3OGZjMjM3ODY5Yjg0N2U4Mzk1IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:17:49', '2023-04-14 10:17:49'),
	(152, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IlN1UzRadC9RTFA0Mjh5SGJUUE9CS1E9PSIsInZhbHVlIjoieHJLaEhVVGxjdS85R2FPMlV2MVdtOE81cHU3NjVCVFljNWpLUlRWdHdGKzhacjVqYXhab3F6L1NUU0pIMkV1OE5PcXVTcFdjOXB6clZvc0tTTnFiakV6bDV1a2Fjb3dlU2RaRmpFR3MzWlRtaUZ0ZFFQNUpYd01zSVFFSzh3U3giLCJtYWMiOiI5MThlYTcwNDViMzc4NWJmNTAyM2FjZDE4ZGVkZGQwM2QwZDFlMjUyZmY3Yzc3OGZjMjM3ODY5Yjg0N2U4Mzk1IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:17:49', '2023-04-14 10:17:49'),
	(153, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImlEbW9Gb0ZRRm02VHlwMUpvUmNVM3c9PSIsInZhbHVlIjoiQU1mcjhSV2sybmtkbThRNWR6aGJQcnFXRVNOZjhuakxmQXpLbkZkSHV2MG1uM1U5YWpyZlp2cGIrQ1F3Q0xyV2lUTXlZM3FZWnFtbjJOZDA0Vng5cGpHTWU5OFhrNjk3ZTRSRVA3Smp1NzJlUzlOdkNsMzB3Rit6bkpBb1o3NUkiLCJtYWMiOiJhNmFmOTZlODlkZWE0M2VlZmZmMDUwNzQ0N2NiY2I1N2ZiYzA1MWFjOTUzZWRkOGEyZjBhZmM5YWE3YzRlMWRjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:18:35', '2023-04-14 10:18:35'),
	(154, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImlEbW9Gb0ZRRm02VHlwMUpvUmNVM3c9PSIsInZhbHVlIjoiQU1mcjhSV2sybmtkbThRNWR6aGJQcnFXRVNOZjhuakxmQXpLbkZkSHV2MG1uM1U5YWpyZlp2cGIrQ1F3Q0xyV2lUTXlZM3FZWnFtbjJOZDA0Vng5cGpHTWU5OFhrNjk3ZTRSRVA3Smp1NzJlUzlOdkNsMzB3Rit6bkpBb1o3NUkiLCJtYWMiOiJhNmFmOTZlODlkZWE0M2VlZmZmMDUwNzQ0N2NiY2I1N2ZiYzA1MWFjOTUzZWRkOGEyZjBhZmM5YWE3YzRlMWRjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:18:35', '2023-04-14 10:18:35'),
	(155, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IkZ1ZnYvL2szUjNXS3FqTEZ0Y2JIb2c9PSIsInZhbHVlIjoidldpOFV2M0pmeVZjM0krZzJ4SW5NVzU2NkcvWEhENFI4RklXSjFPQWFEVllUcG51UDlXc2daUjFtKzB1a24vK2ZqUFlCZWp1WWJ5Z21RVEx4T2paWlZIWEZMREdjQkhvVmJ3aUVVRWkyenQwL0I5Y05rWHZjczcvYnFkdGZ4TU8iLCJtYWMiOiI2NzQ3M2NjNjA5Mzc0ZDVhYWE0MzE0YzU0ZTMwM2IwZmNiZjFjYTA2MjdjNDVmYTA2ZWEzNmZjMTRiZmYyZDVmIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:18:42', '2023-04-14 10:18:42'),
	(156, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IkZ1ZnYvL2szUjNXS3FqTEZ0Y2JIb2c9PSIsInZhbHVlIjoidldpOFV2M0pmeVZjM0krZzJ4SW5NVzU2NkcvWEhENFI4RklXSjFPQWFEVllUcG51UDlXc2daUjFtKzB1a24vK2ZqUFlCZWp1WWJ5Z21RVEx4T2paWlZIWEZMREdjQkhvVmJ3aUVVRWkyenQwL0I5Y05rWHZjczcvYnFkdGZ4TU8iLCJtYWMiOiI2NzQ3M2NjNjA5Mzc0ZDVhYWE0MzE0YzU0ZTMwM2IwZmNiZjFjYTA2MjdjNDVmYTA2ZWEzNmZjMTRiZmYyZDVmIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:18:42', '2023-04-14 10:18:42'),
	(157, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IkZ1ZnYvL2szUjNXS3FqTEZ0Y2JIb2c9PSIsInZhbHVlIjoidldpOFV2M0pmeVZjM0krZzJ4SW5NVzU2NkcvWEhENFI4RklXSjFPQWFEVllUcG51UDlXc2daUjFtKzB1a24vK2ZqUFlCZWp1WWJ5Z21RVEx4T2paWlZIWEZMREdjQkhvVmJ3aUVVRWkyenQwL0I5Y05rWHZjczcvYnFkdGZ4TU8iLCJtYWMiOiI2NzQ3M2NjNjA5Mzc0ZDVhYWE0MzE0YzU0ZTMwM2IwZmNiZjFjYTA2MjdjNDVmYTA2ZWEzNmZjMTRiZmYyZDVmIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:18:50', '2023-04-14 10:18:50'),
	(158, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IkZ1ZnYvL2szUjNXS3FqTEZ0Y2JIb2c9PSIsInZhbHVlIjoidldpOFV2M0pmeVZjM0krZzJ4SW5NVzU2NkcvWEhENFI4RklXSjFPQWFEVllUcG51UDlXc2daUjFtKzB1a24vK2ZqUFlCZWp1WWJ5Z21RVEx4T2paWlZIWEZMREdjQkhvVmJ3aUVVRWkyenQwL0I5Y05rWHZjczcvYnFkdGZ4TU8iLCJtYWMiOiI2NzQ3M2NjNjA5Mzc0ZDVhYWE0MzE0YzU0ZTMwM2IwZmNiZjFjYTA2MjdjNDVmYTA2ZWEzNmZjMTRiZmYyZDVmIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:18:50', '2023-04-14 10:18:50'),
	(159, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IjlXTDR1U0FHSkxaMXJjNHdtYkNlZGc9PSIsInZhbHVlIjoiMlk5d2ZBWVlEY2pON2wyYjQ0ZTB3MUJsaHpZUVIyTUwzNTZONnNRVHlTeXNoODdBWWw1OUJLajRneWNENWRUbVJ1ZDVaOWJyYzdEdHZyUlJodkRwK1NsQjdOUlgyUENIQVZieEhVckMwZDZ4bS9ycVZKYXl1emQyeVZzV3Y5UmsiLCJtYWMiOiJhOTAzYjhhMTJiM2NjMDA4YTdmMjQzMjcyZjc4NGVkNThiZTc5Y2Y4MTI3ZTUwODliNGI0Yzc4MDkzOWZjMDJmIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:18:54', '2023-04-14 10:18:54'),
	(160, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IjlXTDR1U0FHSkxaMXJjNHdtYkNlZGc9PSIsInZhbHVlIjoiMlk5d2ZBWVlEY2pON2wyYjQ0ZTB3MUJsaHpZUVIyTUwzNTZONnNRVHlTeXNoODdBWWw1OUJLajRneWNENWRUbVJ1ZDVaOWJyYzdEdHZyUlJodkRwK1NsQjdOUlgyUENIQVZieEhVckMwZDZ4bS9ycVZKYXl1emQyeVZzV3Y5UmsiLCJtYWMiOiJhOTAzYjhhMTJiM2NjMDA4YTdmMjQzMjcyZjc4NGVkNThiZTc5Y2Y4MTI3ZTUwODliNGI0Yzc4MDkzOWZjMDJmIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:18:54', '2023-04-14 10:18:54'),
	(161, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IjlXTDR1U0FHSkxaMXJjNHdtYkNlZGc9PSIsInZhbHVlIjoiMlk5d2ZBWVlEY2pON2wyYjQ0ZTB3MUJsaHpZUVIyTUwzNTZONnNRVHlTeXNoODdBWWw1OUJLajRneWNENWRUbVJ1ZDVaOWJyYzdEdHZyUlJodkRwK1NsQjdOUlgyUENIQVZieEhVckMwZDZ4bS9ycVZKYXl1emQyeVZzV3Y5UmsiLCJtYWMiOiJhOTAzYjhhMTJiM2NjMDA4YTdmMjQzMjcyZjc4NGVkNThiZTc5Y2Y4MTI3ZTUwODliNGI0Yzc4MDkzOWZjMDJmIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:20:10', '2023-04-14 10:20:10'),
	(162, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IjlXTDR1U0FHSkxaMXJjNHdtYkNlZGc9PSIsInZhbHVlIjoiMlk5d2ZBWVlEY2pON2wyYjQ0ZTB3MUJsaHpZUVIyTUwzNTZONnNRVHlTeXNoODdBWWw1OUJLajRneWNENWRUbVJ1ZDVaOWJyYzdEdHZyUlJodkRwK1NsQjdOUlgyUENIQVZieEhVckMwZDZ4bS9ycVZKYXl1emQyeVZzV3Y5UmsiLCJtYWMiOiJhOTAzYjhhMTJiM2NjMDA4YTdmMjQzMjcyZjc4NGVkNThiZTc5Y2Y4MTI3ZTUwODliNGI0Yzc4MDkzOWZjMDJmIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:20:10', '2023-04-14 10:20:10'),
	(163, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IjlXTDR1U0FHSkxaMXJjNHdtYkNlZGc9PSIsInZhbHVlIjoiMlk5d2ZBWVlEY2pON2wyYjQ0ZTB3MUJsaHpZUVIyTUwzNTZONnNRVHlTeXNoODdBWWw1OUJLajRneWNENWRUbVJ1ZDVaOWJyYzdEdHZyUlJodkRwK1NsQjdOUlgyUENIQVZieEhVckMwZDZ4bS9ycVZKYXl1emQyeVZzV3Y5UmsiLCJtYWMiOiJhOTAzYjhhMTJiM2NjMDA4YTdmMjQzMjcyZjc4NGVkNThiZTc5Y2Y4MTI3ZTUwODliNGI0Yzc4MDkzOWZjMDJmIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:22:19', '2023-04-14 10:22:19'),
	(164, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IjlXTDR1U0FHSkxaMXJjNHdtYkNlZGc9PSIsInZhbHVlIjoiMlk5d2ZBWVlEY2pON2wyYjQ0ZTB3MUJsaHpZUVIyTUwzNTZONnNRVHlTeXNoODdBWWw1OUJLajRneWNENWRUbVJ1ZDVaOWJyYzdEdHZyUlJodkRwK1NsQjdOUlgyUENIQVZieEhVckMwZDZ4bS9ycVZKYXl1emQyeVZzV3Y5UmsiLCJtYWMiOiJhOTAzYjhhMTJiM2NjMDA4YTdmMjQzMjcyZjc4NGVkNThiZTc5Y2Y4MTI3ZTUwODliNGI0Yzc4MDkzOWZjMDJmIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:22:19', '2023-04-14 10:22:19'),
	(165, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IlFEM3lJRmJhSG1vRHR4L3JINXBpQmc9PSIsInZhbHVlIjoiN3lvdEZHdjB1VFJEa1U2WlBPR0poSEJoNmU4UEcyQjNGODh5dkpHTkdpKzkrcnUzeTUrR1RudFNHdk5GT21tNGpBTFZOWDVPZWZkb2NQV3VFb09uWHpoVFQ3OGtCbS9MOGpnTW90bDkzamdPS1Y4N3kwUWJRN0t0akplN1BOa2YiLCJtYWMiOiJjNjM0NmY2Mzg4NmI0NGM5OTJjYmM1N2MzOThlMjE4MzFiZjZkOTdiY2Y1YjUzNGY1NTBjMjlkOGRmZmYxZjAwIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:22:42', '2023-04-14 10:22:42'),
	(166, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IlFEM3lJRmJhSG1vRHR4L3JINXBpQmc9PSIsInZhbHVlIjoiN3lvdEZHdjB1VFJEa1U2WlBPR0poSEJoNmU4UEcyQjNGODh5dkpHTkdpKzkrcnUzeTUrR1RudFNHdk5GT21tNGpBTFZOWDVPZWZkb2NQV3VFb09uWHpoVFQ3OGtCbS9MOGpnTW90bDkzamdPS1Y4N3kwUWJRN0t0akplN1BOa2YiLCJtYWMiOiJjNjM0NmY2Mzg4NmI0NGM5OTJjYmM1N2MzOThlMjE4MzFiZjZkOTdiY2Y1YjUzNGY1NTBjMjlkOGRmZmYxZjAwIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:22:42', '2023-04-14 10:22:42'),
	(167, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6InIyVzlmQkYvNUMvWFhPYzd3VjVuYmc9PSIsInZhbHVlIjoiSXo5dkp1MGowNlRuTm5uNXhadlBlY1lpWVFWcms0K0E4Q29OZ3RSc0FHQ3BPNm9VaUxidXRlMmZadVVXZG1KaTV5ZUNUcGxwMTVTQm9ncUJRRzNjUTZ1dFduV21tbWhqRUg2MnV5WWh0UDVUVDVUczQ2MDNyWHpqTmxCdHNnT3kiLCJtYWMiOiI5ODA1ZjY1YjE5NWYzZjc5Y2NmNDJhNzhlNTljODc4MWFlY2M5NWRlOTNhNmI4ZTY1OWI3NTA2MGI5MmRjMDhhIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:23:12', '2023-04-14 10:23:12'),
	(168, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6InIyVzlmQkYvNUMvWFhPYzd3VjVuYmc9PSIsInZhbHVlIjoiSXo5dkp1MGowNlRuTm5uNXhadlBlY1lpWVFWcms0K0E4Q29OZ3RSc0FHQ3BPNm9VaUxidXRlMmZadVVXZG1KaTV5ZUNUcGxwMTVTQm9ncUJRRzNjUTZ1dFduV21tbWhqRUg2MnV5WWh0UDVUVDVUczQ2MDNyWHpqTmxCdHNnT3kiLCJtYWMiOiI5ODA1ZjY1YjE5NWYzZjc5Y2NmNDJhNzhlNTljODc4MWFlY2M5NWRlOTNhNmI4ZTY1OWI3NTA2MGI5MmRjMDhhIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:23:12', '2023-04-14 10:23:12'),
	(169, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IjNIRFBSQnRESlR5UTFwOG1OUjhqQlE9PSIsInZhbHVlIjoiRnc3ZWFRd1JBNUhyUGFUZkNwOUlDbG1NVzU1Zk04R1RSWHBaTDFnSVJ6cWZQeGlHekIydmJLdTlnZE95MzlOWXJMT2dxZlFSYW9GOXR5N3lob2psOTJiZjl1T09HemhIbzdpelQ3S3hLRG9CM2ZVWVlTU2FYRk5hL3djOUZrMG8iLCJtYWMiOiIwMzkxZDkzZmRiODVjZGM0YzUzZjM5NDQ2ZmU2OGM3NDg5YWQxNjY4N2RjMGU4YTAxNDBmOTljZGJhY2NjYjg2IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:24:45', '2023-04-14 10:24:45'),
	(170, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IjNIRFBSQnRESlR5UTFwOG1OUjhqQlE9PSIsInZhbHVlIjoiRnc3ZWFRd1JBNUhyUGFUZkNwOUlDbG1NVzU1Zk04R1RSWHBaTDFnSVJ6cWZQeGlHekIydmJLdTlnZE95MzlOWXJMT2dxZlFSYW9GOXR5N3lob2psOTJiZjl1T09HemhIbzdpelQ3S3hLRG9CM2ZVWVlTU2FYRk5hL3djOUZrMG8iLCJtYWMiOiIwMzkxZDkzZmRiODVjZGM0YzUzZjM5NDQ2ZmU2OGM3NDg5YWQxNjY4N2RjMGU4YTAxNDBmOTljZGJhY2NjYjg2IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:24:45', '2023-04-14 10:24:45'),
	(171, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Im9UQm05L0NwSUs0NGJTUzJKMEY0cVE9PSIsInZhbHVlIjoia01Pb1J2RGYxRC80bHNqaE1ZcnVZMnhZK0t6eW9hRkREN3dJajhmU1h2ZjNCTk9oM3VZRlBzN0RMLzVENVBxRTBlM256VFJiRFgwNHlpNUw2MklXOUVScVU5WDhxcVFVSWJnZnpnRysyNmJLMGZyTERwVWhUYjd6VENiLzlFZGwiLCJtYWMiOiI0YTM5MDE0NDg5NTdmZTc2OWI4ODg5ZmIwODVkNTdmNTMwN2QwZjU2M2ZjMGU0YTdiMDAzYmU4ODQxOGVkYzZkIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:26:04', '2023-04-14 10:26:04'),
	(172, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Im9UQm05L0NwSUs0NGJTUzJKMEY0cVE9PSIsInZhbHVlIjoia01Pb1J2RGYxRC80bHNqaE1ZcnVZMnhZK0t6eW9hRkREN3dJajhmU1h2ZjNCTk9oM3VZRlBzN0RMLzVENVBxRTBlM256VFJiRFgwNHlpNUw2MklXOUVScVU5WDhxcVFVSWJnZnpnRysyNmJLMGZyTERwVWhUYjd6VENiLzlFZGwiLCJtYWMiOiI0YTM5MDE0NDg5NTdmZTc2OWI4ODg5ZmIwODVkNTdmNTMwN2QwZjU2M2ZjMGU0YTdiMDAzYmU4ODQxOGVkYzZkIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:26:04', '2023-04-14 10:26:04'),
	(173, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IkVGbGxhZkdHY0JRWVQ0YjhucEovWVE9PSIsInZhbHVlIjoiNGlpWjlKbGVyZEd3akdFT2xLbm9vV2ZDa1BrRFVMOWxqV3lyTkZmWE9kKzRhTGFEZkJlWkhSQ1h3c0FGSGtSOEJiaHlKN0g1cDNHV1pVcTdndHZmYlhIREVGWlI2a2lTMUIyQzhhSHRuNFpzdzIvdnNVRnNtRk16K0JOWmNWVkYiLCJtYWMiOiI0NDFmM2RkODFhODNhNTBmZDM0NjYyNjBlNDgwZGM0NjA0NmE4NTI0MTZmYWU5NDZiYjE2N2Q1YmM5ODllNjYyIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:26:13', '2023-04-14 10:26:13'),
	(174, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IkVGbGxhZkdHY0JRWVQ0YjhucEovWVE9PSIsInZhbHVlIjoiNGlpWjlKbGVyZEd3akdFT2xLbm9vV2ZDa1BrRFVMOWxqV3lyTkZmWE9kKzRhTGFEZkJlWkhSQ1h3c0FGSGtSOEJiaHlKN0g1cDNHV1pVcTdndHZmYlhIREVGWlI2a2lTMUIyQzhhSHRuNFpzdzIvdnNVRnNtRk16K0JOWmNWVkYiLCJtYWMiOiI0NDFmM2RkODFhODNhNTBmZDM0NjYyNjBlNDgwZGM0NjA0NmE4NTI0MTZmYWU5NDZiYjE2N2Q1YmM5ODllNjYyIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:26:13', '2023-04-14 10:26:13'),
	(175, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6InJURm1hcmprR0dZR0JIZHptclR6SUE9PSIsInZhbHVlIjoiOERCbWNyeVNkamVjZGx2V1BFV01LMWU0SkN6eTY1Ykplck8rRldlUHBlNXMrZGhRRXVJWTVuWGZZYTNFWXl0THJFZUpKdGFjbHd0T1ZCbTBLTTVCY2UxTjZST3FFWFhSK0VQMnJqVVpZZml1dWlmNlgxdDdvTm10NWZVVmxCakQiLCJtYWMiOiJjYzYwMmYwNjBmNDVlNDY4ODgwZGZkMDQ2OTE2OTk4NTNhNjcxZWE0NDgxNTA1YThjY2M2YWJjNTI0YzBmMmFjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:26:19', '2023-04-14 10:26:19'),
	(176, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6InJURm1hcmprR0dZR0JIZHptclR6SUE9PSIsInZhbHVlIjoiOERCbWNyeVNkamVjZGx2V1BFV01LMWU0SkN6eTY1Ykplck8rRldlUHBlNXMrZGhRRXVJWTVuWGZZYTNFWXl0THJFZUpKdGFjbHd0T1ZCbTBLTTVCY2UxTjZST3FFWFhSK0VQMnJqVVpZZml1dWlmNlgxdDdvTm10NWZVVmxCakQiLCJtYWMiOiJjYzYwMmYwNjBmNDVlNDY4ODgwZGZkMDQ2OTE2OTk4NTNhNjcxZWE0NDgxNTA1YThjY2M2YWJjNTI0YzBmMmFjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:26:19', '2023-04-14 10:26:19'),
	(177, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6InJURm1hcmprR0dZR0JIZHptclR6SUE9PSIsInZhbHVlIjoiOERCbWNyeVNkamVjZGx2V1BFV01LMWU0SkN6eTY1Ykplck8rRldlUHBlNXMrZGhRRXVJWTVuWGZZYTNFWXl0THJFZUpKdGFjbHd0T1ZCbTBLTTVCY2UxTjZST3FFWFhSK0VQMnJqVVpZZml1dWlmNlgxdDdvTm10NWZVVmxCakQiLCJtYWMiOiJjYzYwMmYwNjBmNDVlNDY4ODgwZGZkMDQ2OTE2OTk4NTNhNjcxZWE0NDgxNTA1YThjY2M2YWJjNTI0YzBmMmFjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:26:36', '2023-04-14 10:26:36'),
	(178, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6InJURm1hcmprR0dZR0JIZHptclR6SUE9PSIsInZhbHVlIjoiOERCbWNyeVNkamVjZGx2V1BFV01LMWU0SkN6eTY1Ykplck8rRldlUHBlNXMrZGhRRXVJWTVuWGZZYTNFWXl0THJFZUpKdGFjbHd0T1ZCbTBLTTVCY2UxTjZST3FFWFhSK0VQMnJqVVpZZml1dWlmNlgxdDdvTm10NWZVVmxCakQiLCJtYWMiOiJjYzYwMmYwNjBmNDVlNDY4ODgwZGZkMDQ2OTE2OTk4NTNhNjcxZWE0NDgxNTA1YThjY2M2YWJjNTI0YzBmMmFjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:26:36', '2023-04-14 10:26:36'),
	(179, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Imc3RkJuUjh3NGtjMlpCYmxFMEljMWc9PSIsInZhbHVlIjoickwxcTg0bGhhNjFqMlhHdU5IYWprTnlRT0swVXFaUGVxMllWZFQrYjVKalNuWUFmTnpCZnpKbm9EcEFjSDdvNDhyRVA4Q09XUWFQZlM3YmV5MENHMGtnTlFoeldmcUd4Mmw4SXZ5OSt2elFKMUhmLysxekszR3JKeG1POUc5anYiLCJtYWMiOiI4MTgxYWM3NzMwM2IwNWNjOGY3YjAzNDRiMjZmNDZiMWIyZWQ5N2ZlODUzY2FhOTM5MGM0ODViOWY1MmMyNWMwIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:27:43', '2023-04-14 10:27:43'),
	(180, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Imc3RkJuUjh3NGtjMlpCYmxFMEljMWc9PSIsInZhbHVlIjoickwxcTg0bGhhNjFqMlhHdU5IYWprTnlRT0swVXFaUGVxMllWZFQrYjVKalNuWUFmTnpCZnpKbm9EcEFjSDdvNDhyRVA4Q09XUWFQZlM3YmV5MENHMGtnTlFoeldmcUd4Mmw4SXZ5OSt2elFKMUhmLysxekszR3JKeG1POUc5anYiLCJtYWMiOiI4MTgxYWM3NzMwM2IwNWNjOGY3YjAzNDRiMjZmNDZiMWIyZWQ5N2ZlODUzY2FhOTM5MGM0ODViOWY1MmMyNWMwIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:27:43', '2023-04-14 10:27:43'),
	(181, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en;q=0.9"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:28:05', '2023-04-14 10:28:05'),
	(182, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en;q=0.9"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:28:05', '2023-04-14 10:28:05'),
	(183, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Ik51U1pUb0FTQzIybEoyU3paRHg5M1E9PSIsInZhbHVlIjoiLzBzZW1Ud3drWmZjUEo0aTM2TitEeVNNaFJsVzBRU29NdnhNSmtwcTdpcVE0VVJ3VXV0MzRQenVBUm5RbXQ3Y3dyZk85VGVRR3ZUOUVMOHg3UTVwejhBSittdW5XeVc5VVVyVmJLbGpLL2RGb0IxYlY4TWpCRUZxYlV1aW5ISzAiLCJtYWMiOiIwZDZkYjJhY2UwZWE5MmI4YWQ1YjVkZDYyZTdkNjI2MjM5Zjc3M2E4NGU0MmZmZjI0Y2MwMjI2MDU3MmI0MzQyIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:29:51', '2023-04-14 10:29:51'),
	(184, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Ik51U1pUb0FTQzIybEoyU3paRHg5M1E9PSIsInZhbHVlIjoiLzBzZW1Ud3drWmZjUEo0aTM2TitEeVNNaFJsVzBRU29NdnhNSmtwcTdpcVE0VVJ3VXV0MzRQenVBUm5RbXQ3Y3dyZk85VGVRR3ZUOUVMOHg3UTVwejhBSittdW5XeVc5VVVyVmJLbGpLL2RGb0IxYlY4TWpCRUZxYlV1aW5ISzAiLCJtYWMiOiIwZDZkYjJhY2UwZWE5MmI4YWQ1YjVkZDYyZTdkNjI2MjM5Zjc3M2E4NGU0MmZmZjI0Y2MwMjI2MDU3MmI0MzQyIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:29:51', '2023-04-14 10:29:51'),
	(185, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Ik51U1pUb0FTQzIybEoyU3paRHg5M1E9PSIsInZhbHVlIjoiLzBzZW1Ud3drWmZjUEo0aTM2TitEeVNNaFJsVzBRU29NdnhNSmtwcTdpcVE0VVJ3VXV0MzRQenVBUm5RbXQ3Y3dyZk85VGVRR3ZUOUVMOHg3UTVwejhBSittdW5XeVc5VVVyVmJLbGpLL2RGb0IxYlY4TWpCRUZxYlV1aW5ISzAiLCJtYWMiOiIwZDZkYjJhY2UwZWE5MmI4YWQ1YjVkZDYyZTdkNjI2MjM5Zjc3M2E4NGU0MmZmZjI0Y2MwMjI2MDU3MmI0MzQyIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:30:10', '2023-04-14 10:30:10'),
	(186, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Ik51U1pUb0FTQzIybEoyU3paRHg5M1E9PSIsInZhbHVlIjoiLzBzZW1Ud3drWmZjUEo0aTM2TitEeVNNaFJsVzBRU29NdnhNSmtwcTdpcVE0VVJ3VXV0MzRQenVBUm5RbXQ3Y3dyZk85VGVRR3ZUOUVMOHg3UTVwejhBSittdW5XeVc5VVVyVmJLbGpLL2RGb0IxYlY4TWpCRUZxYlV1aW5ISzAiLCJtYWMiOiIwZDZkYjJhY2UwZWE5MmI4YWQ1YjVkZDYyZTdkNjI2MjM5Zjc3M2E4NGU0MmZmZjI0Y2MwMjI2MDU3MmI0MzQyIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:30:10', '2023-04-14 10:30:10'),
	(187, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IktzSldVWDhENHNDZ1N3NnhwUlZMTXc9PSIsInZhbHVlIjoiaytZTUtFM2F6SEE4YWp3eS9qdHhXTnlFZElkanRRbVM3YXZ4UkI0aklTeXVkelJ5U2pXd1k2dHp4OUx2Wm9ORUJMR0RIRFZhTW00c3ZHSVBUKy8ybnd2b3hqUG5DekRTVEJEd3I2RmlpcWNEeUVoSDQ1TThURjRUS1U0dE10L2kiLCJtYWMiOiIyN2MzNDhkZTRiNzM2YjU3ODcxMGIzMzI1YWMwZjMyNzdiMzg5ZjM2YTk2NmU5YmE2ZmU1ZDQ1MGEwYmUyMTA4IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:30:30', '2023-04-14 10:30:30'),
	(188, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IktzSldVWDhENHNDZ1N3NnhwUlZMTXc9PSIsInZhbHVlIjoiaytZTUtFM2F6SEE4YWp3eS9qdHhXTnlFZElkanRRbVM3YXZ4UkI0aklTeXVkelJ5U2pXd1k2dHp4OUx2Wm9ORUJMR0RIRFZhTW00c3ZHSVBUKy8ybnd2b3hqUG5DekRTVEJEd3I2RmlpcWNEeUVoSDQ1TThURjRUS1U0dE10L2kiLCJtYWMiOiIyN2MzNDhkZTRiNzM2YjU3ODcxMGIzMzI1YWMwZjMyNzdiMzg5ZjM2YTk2NmU5YmE2ZmU1ZDQ1MGEwYmUyMTA4IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:30:30', '2023-04-14 10:30:30'),
	(189, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6InloSlRPUUVCcms4dnl2NE1UUGhwUUE9PSIsInZhbHVlIjoiRnVIYVpIRVNzTndiakVQN0plUU9XbkFwYU5aeVlGRTJFeGlhMUhSMDYyYm1PelpiSEIrelJjQjczRlNwU0NMZ1ZiK3BFTW9LVVNLSzV6dmNlOXFVQUpidHpPRXlYTXdaTWZlN2hHWUNwSVBUWjR6dGVvbVNOYnpWcjhGc0k0UVIiLCJtYWMiOiIxMDhkZmJlMDNmNDAwYmNmNzMzM2VmYzZkMTc3ZmY1MzJmMWZmNjk4YTc3NGQyMmRkMDI4YjdlM2U2OWU0NWE2IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:32:39', '2023-04-14 10:32:39'),
	(190, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6InloSlRPUUVCcms4dnl2NE1UUGhwUUE9PSIsInZhbHVlIjoiRnVIYVpIRVNzTndiakVQN0plUU9XbkFwYU5aeVlGRTJFeGlhMUhSMDYyYm1PelpiSEIrelJjQjczRlNwU0NMZ1ZiK3BFTW9LVVNLSzV6dmNlOXFVQUpidHpPRXlYTXdaTWZlN2hHWUNwSVBUWjR6dGVvbVNOYnpWcjhGc0k0UVIiLCJtYWMiOiIxMDhkZmJlMDNmNDAwYmNmNzMzM2VmYzZkMTc3ZmY1MzJmMWZmNjk4YTc3NGQyMmRkMDI4YjdlM2U2OWU0NWE2IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:32:39', '2023-04-14 10:32:39'),
	(191, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImtxVVFrVmNldmVQajF4UHlzN0VHUEE9PSIsInZhbHVlIjoiRVZ5OGwvYVhHVmtpWlJTOFRrSzdRbUNtaTFMWVRvRy9mNW5zczQ2OGRBZkFLWlhoQ21YM2JCU3c1Z1FKNXVpN0p5amxWbmZ5VkpScGYvY2RzQkZpMWtReWorM2tQZXNFSGxuc0ljdlpPOEhITkViRy9wbEc0cFo0NTNQd1ltNnciLCJtYWMiOiI3YmE3ZWQyNjU2MDBmMDIwNzU0NzEyMmU1MjhhNDFmYTkyOTllNDEyNzc0Y2U0MTgzZDg3YjM2ZTQ3ODM5MjRjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:32:54', '2023-04-14 10:32:54'),
	(192, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImtxVVFrVmNldmVQajF4UHlzN0VHUEE9PSIsInZhbHVlIjoiRVZ5OGwvYVhHVmtpWlJTOFRrSzdRbUNtaTFMWVRvRy9mNW5zczQ2OGRBZkFLWlhoQ21YM2JCU3c1Z1FKNXVpN0p5amxWbmZ5VkpScGYvY2RzQkZpMWtReWorM2tQZXNFSGxuc0ljdlpPOEhITkViRy9wbEc0cFo0NTNQd1ltNnciLCJtYWMiOiI3YmE3ZWQyNjU2MDBmMDIwNzU0NzEyMmU1MjhhNDFmYTkyOTllNDEyNzc0Y2U0MTgzZDg3YjM2ZTQ3ODM5MjRjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:32:54', '2023-04-14 10:32:54'),
	(193, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImtxVVFrVmNldmVQajF4UHlzN0VHUEE9PSIsInZhbHVlIjoiRVZ5OGwvYVhHVmtpWlJTOFRrSzdRbUNtaTFMWVRvRy9mNW5zczQ2OGRBZkFLWlhoQ21YM2JCU3c1Z1FKNXVpN0p5amxWbmZ5VkpScGYvY2RzQkZpMWtReWorM2tQZXNFSGxuc0ljdlpPOEhITkViRy9wbEc0cFo0NTNQd1ltNnciLCJtYWMiOiI3YmE3ZWQyNjU2MDBmMDIwNzU0NzEyMmU1MjhhNDFmYTkyOTllNDEyNzc0Y2U0MTgzZDg3YjM2ZTQ3ODM5MjRjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:33:13', '2023-04-14 10:33:13'),
	(194, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImtxVVFrVmNldmVQajF4UHlzN0VHUEE9PSIsInZhbHVlIjoiRVZ5OGwvYVhHVmtpWlJTOFRrSzdRbUNtaTFMWVRvRy9mNW5zczQ2OGRBZkFLWlhoQ21YM2JCU3c1Z1FKNXVpN0p5amxWbmZ5VkpScGYvY2RzQkZpMWtReWorM2tQZXNFSGxuc0ljdlpPOEhITkViRy9wbEc0cFo0NTNQd1ltNnciLCJtYWMiOiI3YmE3ZWQyNjU2MDBmMDIwNzU0NzEyMmU1MjhhNDFmYTkyOTllNDEyNzc0Y2U0MTgzZDg3YjM2ZTQ3ODM5MjRjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:33:13', '2023-04-14 10:33:13'),
	(195, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImtxVVFrVmNldmVQajF4UHlzN0VHUEE9PSIsInZhbHVlIjoiRVZ5OGwvYVhHVmtpWlJTOFRrSzdRbUNtaTFMWVRvRy9mNW5zczQ2OGRBZkFLWlhoQ21YM2JCU3c1Z1FKNXVpN0p5amxWbmZ5VkpScGYvY2RzQkZpMWtReWorM2tQZXNFSGxuc0ljdlpPOEhITkViRy9wbEc0cFo0NTNQd1ltNnciLCJtYWMiOiI3YmE3ZWQyNjU2MDBmMDIwNzU0NzEyMmU1MjhhNDFmYTkyOTllNDEyNzc0Y2U0MTgzZDg3YjM2ZTQ3ODM5MjRjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:38:23', '2023-04-14 10:38:23'),
	(196, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImtxVVFrVmNldmVQajF4UHlzN0VHUEE9PSIsInZhbHVlIjoiRVZ5OGwvYVhHVmtpWlJTOFRrSzdRbUNtaTFMWVRvRy9mNW5zczQ2OGRBZkFLWlhoQ21YM2JCU3c1Z1FKNXVpN0p5amxWbmZ5VkpScGYvY2RzQkZpMWtReWorM2tQZXNFSGxuc0ljdlpPOEhITkViRy9wbEc0cFo0NTNQd1ltNnciLCJtYWMiOiI3YmE3ZWQyNjU2MDBmMDIwNzU0NzEyMmU1MjhhNDFmYTkyOTllNDEyNzc0Y2U0MTgzZDg3YjM2ZTQ3ODM5MjRjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:38:23', '2023-04-14 10:38:23'),
	(197, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImtxVVFrVmNldmVQajF4UHlzN0VHUEE9PSIsInZhbHVlIjoiRVZ5OGwvYVhHVmtpWlJTOFRrSzdRbUNtaTFMWVRvRy9mNW5zczQ2OGRBZkFLWlhoQ21YM2JCU3c1Z1FKNXVpN0p5amxWbmZ5VkpScGYvY2RzQkZpMWtReWorM2tQZXNFSGxuc0ljdlpPOEhITkViRy9wbEc0cFo0NTNQd1ltNnciLCJtYWMiOiI3YmE3ZWQyNjU2MDBmMDIwNzU0NzEyMmU1MjhhNDFmYTkyOTllNDEyNzc0Y2U0MTgzZDg3YjM2ZTQ3ODM5MjRjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:43:43', '2023-04-14 10:43:43'),
	(198, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImtxVVFrVmNldmVQajF4UHlzN0VHUEE9PSIsInZhbHVlIjoiRVZ5OGwvYVhHVmtpWlJTOFRrSzdRbUNtaTFMWVRvRy9mNW5zczQ2OGRBZkFLWlhoQ21YM2JCU3c1Z1FKNXVpN0p5amxWbmZ5VkpScGYvY2RzQkZpMWtReWorM2tQZXNFSGxuc0ljdlpPOEhITkViRy9wbEc0cFo0NTNQd1ltNnciLCJtYWMiOiI3YmE3ZWQyNjU2MDBmMDIwNzU0NzEyMmU1MjhhNDFmYTkyOTllNDEyNzc0Y2U0MTgzZDg3YjM2ZTQ3ODM5MjRjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:43:43', '2023-04-14 10:43:43'),
	(199, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IktlYkVnRXoyRHR3MDRTaGptNW45QVE9PSIsInZhbHVlIjoiUm5Bb1FDRmt4ejFURkNkN3hiMkFNQmx0OGlIZEpORnN3Ynpia1R4M2lxS0JMWUN3amVjbTlLck9UbzFuTjZZcjd0dUVNbjF5dmtnek5PeVRWMS9pU1Jzc0NOV1NxL29mMktoUS9wNlJ5SU1lVWlnSFhxV0p1UHZTRGl1YnJ1dUkiLCJtYWMiOiJhNDU3MTg3Y2NjMDMyNjY4Y2ExNTk2NmNkZDM1N2Q4Njk0NzY3M2QwZDIwNWIxNTg4YWE4ZTAzN2IwNzVhNmNmIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:44:11', '2023-04-14 10:44:11'),
	(200, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IktlYkVnRXoyRHR3MDRTaGptNW45QVE9PSIsInZhbHVlIjoiUm5Bb1FDRmt4ejFURkNkN3hiMkFNQmx0OGlIZEpORnN3Ynpia1R4M2lxS0JMWUN3amVjbTlLck9UbzFuTjZZcjd0dUVNbjF5dmtnek5PeVRWMS9pU1Jzc0NOV1NxL29mMktoUS9wNlJ5SU1lVWlnSFhxV0p1UHZTRGl1YnJ1dUkiLCJtYWMiOiJhNDU3MTg3Y2NjMDMyNjY4Y2ExNTk2NmNkZDM1N2Q4Njk0NzY3M2QwZDIwNWIxNTg4YWE4ZTAzN2IwNzVhNmNmIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:44:11', '2023-04-14 10:44:11'),
	(201, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImY3UXFFZkNRWlRvS1FlZy90K21zelE9PSIsInZhbHVlIjoiK3N6YzNVTno1a01oR1NFTkQ0YUVyUUIrUkcra1RaWHRPZmZQN0dFUWJvWUdPcU13KzZzaTlxYm9OdHFhZ0MxUmY1QVdTZEhMNGRBVTNoSzZkWU11K3c3R3NKOVJZVjcwNEcxWkw5QWt2dzNtaTRNNDdkM285SVhXV3ArR0tUVFEiLCJtYWMiOiJkOTRiNDZjMjZjNDhhMzM1NTQ5MDI1YzA5ZDAzZTEyMTI4OTg2YjkwNThlNTAwY2VjNTQ5ZmRmODgzNGNkMWU5IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:47:09', '2023-04-14 10:47:09'),
	(202, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImY3UXFFZkNRWlRvS1FlZy90K21zelE9PSIsInZhbHVlIjoiK3N6YzNVTno1a01oR1NFTkQ0YUVyUUIrUkcra1RaWHRPZmZQN0dFUWJvWUdPcU13KzZzaTlxYm9OdHFhZ0MxUmY1QVdTZEhMNGRBVTNoSzZkWU11K3c3R3NKOVJZVjcwNEcxWkw5QWt2dzNtaTRNNDdkM285SVhXV3ArR0tUVFEiLCJtYWMiOiJkOTRiNDZjMjZjNDhhMzM1NTQ5MDI1YzA5ZDAzZTEyMTI4OTg2YjkwNThlNTAwY2VjNTQ5ZmRmODgzNGNkMWU5IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:47:09', '2023-04-14 10:47:09'),
	(203, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IkpSYTNsRnMxYi9KcTNEWld5WjdORHc9PSIsInZhbHVlIjoiUTZIVjRzdktCZWJNZ2ozcFhUMXlKckM0V09mejVIa0ZnRHR1L2VvamVoK2pPbFBONGZiRXpkdUJsVUpVaUV1d2VZVzBvQTFjQjNWS2tGSEg1UE1TRm5TcnA5d0JlZ1dnTnc2ZXIvYkRFOUtvaGhSMmJ3R1N0cmg5YzBNL2VLOHIiLCJtYWMiOiJiYTQ4M2JiMWM0YWI0MTM4YTJmMmMxMjIzMWNmMDc2ODYzZDc2ODg3MGQ2ODQ4ZTY1NzIxMGVkZDI1N2ExYzcyIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:50:48', '2023-04-14 10:50:48'),
	(204, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IkpSYTNsRnMxYi9KcTNEWld5WjdORHc9PSIsInZhbHVlIjoiUTZIVjRzdktCZWJNZ2ozcFhUMXlKckM0V09mejVIa0ZnRHR1L2VvamVoK2pPbFBONGZiRXpkdUJsVUpVaUV1d2VZVzBvQTFjQjNWS2tGSEg1UE1TRm5TcnA5d0JlZ1dnTnc2ZXIvYkRFOUtvaGhSMmJ3R1N0cmg5YzBNL2VLOHIiLCJtYWMiOiJiYTQ4M2JiMWM0YWI0MTM4YTJmMmMxMjIzMWNmMDc2ODYzZDc2ODg3MGQ2ODQ4ZTY1NzIxMGVkZDI1N2ExYzcyIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 10:50:48', '2023-04-14 10:50:48'),
	(205, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6InFUcHp4ZmI0VlBRYVdWMVRaZ3pISnc9PSIsInZhbHVlIjoiTmpoVGMyM1drNmZzbXFSOHNDdmFmT1pOWmdvNUhMQ2x1ZzVnWGFLWXV1aUZjbU8vU1Iyd2FLS0JOMEFTYUFTODFOMEFDZXNxKzA1SHlxVi9WNWVnRzlyNDVEWWxYb253TXVFNVFrQkdVb3Y2UkVsVkFvYnVZQitlLzVmcnV3RjQiLCJtYWMiOiIwZTc1ZmI3NTg2ZTczOTU1OTRjMzNjYzkwMTBmMGNlNzU5NjIwMTA5NmMxNDdiZTJjOGM3NTAwMTVmNTk3MzVlIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:09:18', '2023-04-14 11:09:18'),
	(206, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6InFUcHp4ZmI0VlBRYVdWMVRaZ3pISnc9PSIsInZhbHVlIjoiTmpoVGMyM1drNmZzbXFSOHNDdmFmT1pOWmdvNUhMQ2x1ZzVnWGFLWXV1aUZjbU8vU1Iyd2FLS0JOMEFTYUFTODFOMEFDZXNxKzA1SHlxVi9WNWVnRzlyNDVEWWxYb253TXVFNVFrQkdVb3Y2UkVsVkFvYnVZQitlLzVmcnV3RjQiLCJtYWMiOiIwZTc1ZmI3NTg2ZTczOTU1OTRjMzNjYzkwMTBmMGNlNzU5NjIwMTA5NmMxNDdiZTJjOGM3NTAwMTVmNTk3MzVlIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:09:18', '2023-04-14 11:09:18'),
	(207, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6InFUcHp4ZmI0VlBRYVdWMVRaZ3pISnc9PSIsInZhbHVlIjoiTmpoVGMyM1drNmZzbXFSOHNDdmFmT1pOWmdvNUhMQ2x1ZzVnWGFLWXV1aUZjbU8vU1Iyd2FLS0JOMEFTYUFTODFOMEFDZXNxKzA1SHlxVi9WNWVnRzlyNDVEWWxYb253TXVFNVFrQkdVb3Y2UkVsVkFvYnVZQitlLzVmcnV3RjQiLCJtYWMiOiIwZTc1ZmI3NTg2ZTczOTU1OTRjMzNjYzkwMTBmMGNlNzU5NjIwMTA5NmMxNDdiZTJjOGM3NTAwMTVmNTk3MzVlIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:09:19', '2023-04-14 11:09:19'),
	(208, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6InFUcHp4ZmI0VlBRYVdWMVRaZ3pISnc9PSIsInZhbHVlIjoiTmpoVGMyM1drNmZzbXFSOHNDdmFmT1pOWmdvNUhMQ2x1ZzVnWGFLWXV1aUZjbU8vU1Iyd2FLS0JOMEFTYUFTODFOMEFDZXNxKzA1SHlxVi9WNWVnRzlyNDVEWWxYb253TXVFNVFrQkdVb3Y2UkVsVkFvYnVZQitlLzVmcnV3RjQiLCJtYWMiOiIwZTc1ZmI3NTg2ZTczOTU1OTRjMzNjYzkwMTBmMGNlNzU5NjIwMTA5NmMxNDdiZTJjOGM3NTAwMTVmNTk3MzVlIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:09:19', '2023-04-14 11:09:19'),
	(209, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6InFUcHp4ZmI0VlBRYVdWMVRaZ3pISnc9PSIsInZhbHVlIjoiTmpoVGMyM1drNmZzbXFSOHNDdmFmT1pOWmdvNUhMQ2x1ZzVnWGFLWXV1aUZjbU8vU1Iyd2FLS0JOMEFTYUFTODFOMEFDZXNxKzA1SHlxVi9WNWVnRzlyNDVEWWxYb253TXVFNVFrQkdVb3Y2UkVsVkFvYnVZQitlLzVmcnV3RjQiLCJtYWMiOiIwZTc1ZmI3NTg2ZTczOTU1OTRjMzNjYzkwMTBmMGNlNzU5NjIwMTA5NmMxNDdiZTJjOGM3NTAwMTVmNTk3MzVlIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:09:19', '2023-04-14 11:09:19'),
	(210, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6InFUcHp4ZmI0VlBRYVdWMVRaZ3pISnc9PSIsInZhbHVlIjoiTmpoVGMyM1drNmZzbXFSOHNDdmFmT1pOWmdvNUhMQ2x1ZzVnWGFLWXV1aUZjbU8vU1Iyd2FLS0JOMEFTYUFTODFOMEFDZXNxKzA1SHlxVi9WNWVnRzlyNDVEWWxYb253TXVFNVFrQkdVb3Y2UkVsVkFvYnVZQitlLzVmcnV3RjQiLCJtYWMiOiIwZTc1ZmI3NTg2ZTczOTU1OTRjMzNjYzkwMTBmMGNlNzU5NjIwMTA5NmMxNDdiZTJjOGM3NTAwMTVmNTk3MzVlIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:09:19', '2023-04-14 11:09:19'),
	(211, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Ik8yUitQYnRsV0RHQWxDWm9qcTRCU1E9PSIsInZhbHVlIjoiY3YrbXpMRXFNdkRRZm9KbW5pVnR2bHFOMTYwb2xsNEVhRGx4THFJaVN6b29oUEE5VkZKTG00ZUJyRURuMXA0UzBCVlczS3RBNWlTdzlGZDQ1dDF5bjlZMjVFNi9MWXJFOVdQMnN3MEFHdjNBOEJrcTNocDNoVVdRRWx0R2tPc3IiLCJtYWMiOiJiODY2NmY1NWM4YTM0ZGJiZTJlNTBiMTliYjQxMDBlY2IwODZlZTNmMzhjOTA5NTkzZDUzZWJjYjk1NDJiYTU1IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:16:46', '2023-04-14 11:16:46'),
	(212, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Ik8yUitQYnRsV0RHQWxDWm9qcTRCU1E9PSIsInZhbHVlIjoiY3YrbXpMRXFNdkRRZm9KbW5pVnR2bHFOMTYwb2xsNEVhRGx4THFJaVN6b29oUEE5VkZKTG00ZUJyRURuMXA0UzBCVlczS3RBNWlTdzlGZDQ1dDF5bjlZMjVFNi9MWXJFOVdQMnN3MEFHdjNBOEJrcTNocDNoVVdRRWx0R2tPc3IiLCJtYWMiOiJiODY2NmY1NWM4YTM0ZGJiZTJlNTBiMTliYjQxMDBlY2IwODZlZTNmMzhjOTA5NTkzZDUzZWJjYjk1NDJiYTU1IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:16:46', '2023-04-14 11:16:46'),
	(213, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IlliQXd6WWt3QUlPTGlsVng4RUFVcHc9PSIsInZhbHVlIjoiSTdOcWxFd2lHWElCRzZyMHVoaSt5WjFDNWkxOCtMQlJIYnRJOXZOVUhCK0lTZEdCamxlQXdrZ09hQlBPRTk1UUhYVzFONEZ0Tjd5Q1J2RVByM1NQMVBMS2IyenVkUkxxbDNXRnRTcDE0cEFCWERtSDNaNEdvNC9qdm1EcHZka0oiLCJtYWMiOiI2MzJkNDE2OWNjMDkzNTY3MWUwOGJlODllMDQ1ZjM1OGVhMDNlMzNhOWExNGE0OWVmMWY4NGQxZmU4Zjc5ZDNiIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:18:48', '2023-04-14 11:18:48'),
	(214, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IlliQXd6WWt3QUlPTGlsVng4RUFVcHc9PSIsInZhbHVlIjoiSTdOcWxFd2lHWElCRzZyMHVoaSt5WjFDNWkxOCtMQlJIYnRJOXZOVUhCK0lTZEdCamxlQXdrZ09hQlBPRTk1UUhYVzFONEZ0Tjd5Q1J2RVByM1NQMVBMS2IyenVkUkxxbDNXRnRTcDE0cEFCWERtSDNaNEdvNC9qdm1EcHZka0oiLCJtYWMiOiI2MzJkNDE2OWNjMDkzNTY3MWUwOGJlODllMDQ1ZjM1OGVhMDNlMzNhOWExNGE0OWVmMWY4NGQxZmU4Zjc5ZDNiIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:18:48', '2023-04-14 11:18:48'),
	(215, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IlliQXd6WWt3QUlPTGlsVng4RUFVcHc9PSIsInZhbHVlIjoiSTdOcWxFd2lHWElCRzZyMHVoaSt5WjFDNWkxOCtMQlJIYnRJOXZOVUhCK0lTZEdCamxlQXdrZ09hQlBPRTk1UUhYVzFONEZ0Tjd5Q1J2RVByM1NQMVBMS2IyenVkUkxxbDNXRnRTcDE0cEFCWERtSDNaNEdvNC9qdm1EcHZka0oiLCJtYWMiOiI2MzJkNDE2OWNjMDkzNTY3MWUwOGJlODllMDQ1ZjM1OGVhMDNlMzNhOWExNGE0OWVmMWY4NGQxZmU4Zjc5ZDNiIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:24:08', '2023-04-14 11:24:08'),
	(216, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IlliQXd6WWt3QUlPTGlsVng4RUFVcHc9PSIsInZhbHVlIjoiSTdOcWxFd2lHWElCRzZyMHVoaSt5WjFDNWkxOCtMQlJIYnRJOXZOVUhCK0lTZEdCamxlQXdrZ09hQlBPRTk1UUhYVzFONEZ0Tjd5Q1J2RVByM1NQMVBMS2IyenVkUkxxbDNXRnRTcDE0cEFCWERtSDNaNEdvNC9qdm1EcHZka0oiLCJtYWMiOiI2MzJkNDE2OWNjMDkzNTY3MWUwOGJlODllMDQ1ZjM1OGVhMDNlMzNhOWExNGE0OWVmMWY4NGQxZmU4Zjc5ZDNiIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:24:08', '2023-04-14 11:24:08'),
	(217, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IlliQXd6WWt3QUlPTGlsVng4RUFVcHc9PSIsInZhbHVlIjoiSTdOcWxFd2lHWElCRzZyMHVoaSt5WjFDNWkxOCtMQlJIYnRJOXZOVUhCK0lTZEdCamxlQXdrZ09hQlBPRTk1UUhYVzFONEZ0Tjd5Q1J2RVByM1NQMVBMS2IyenVkUkxxbDNXRnRTcDE0cEFCWERtSDNaNEdvNC9qdm1EcHZka0oiLCJtYWMiOiI2MzJkNDE2OWNjMDkzNTY3MWUwOGJlODllMDQ1ZjM1OGVhMDNlMzNhOWExNGE0OWVmMWY4NGQxZmU4Zjc5ZDNiIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:25:14', '2023-04-14 11:25:14'),
	(218, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IlliQXd6WWt3QUlPTGlsVng4RUFVcHc9PSIsInZhbHVlIjoiSTdOcWxFd2lHWElCRzZyMHVoaSt5WjFDNWkxOCtMQlJIYnRJOXZOVUhCK0lTZEdCamxlQXdrZ09hQlBPRTk1UUhYVzFONEZ0Tjd5Q1J2RVByM1NQMVBMS2IyenVkUkxxbDNXRnRTcDE0cEFCWERtSDNaNEdvNC9qdm1EcHZka0oiLCJtYWMiOiI2MzJkNDE2OWNjMDkzNTY3MWUwOGJlODllMDQ1ZjM1OGVhMDNlMzNhOWExNGE0OWVmMWY4NGQxZmU4Zjc5ZDNiIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:25:14', '2023-04-14 11:25:14'),
	(219, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImNKQzZsbkwwZjRtZWppeVVlTU4rbFE9PSIsInZhbHVlIjoiNS9qWVlMMGtuZDFaKzZPcjBITU1BeXdmRXROY0VpMFFkOVpueHhrcG5WNFJkbTNDRzRrWmNMQVNDSjlhdm91U0FGT1J4SHYvUitJZk53c1NwTzNHQXk4djU4cDlMMjR0MWtabTI1VUJGQ05tN1pMNVJ6SEZ1VXNWeVVJcjhjRWEiLCJtYWMiOiI5YTgyNzFjMjU0NTFiNGNlNTZmMGQyNjMyMTUxMDc4NjI3M2ZiMWI2Y2E3ZjI0ZDUzMWY5YTcxYjc4YmI4NWZhIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:25:27', '2023-04-14 11:25:27'),
	(220, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImNKQzZsbkwwZjRtZWppeVVlTU4rbFE9PSIsInZhbHVlIjoiNS9qWVlMMGtuZDFaKzZPcjBITU1BeXdmRXROY0VpMFFkOVpueHhrcG5WNFJkbTNDRzRrWmNMQVNDSjlhdm91U0FGT1J4SHYvUitJZk53c1NwTzNHQXk4djU4cDlMMjR0MWtabTI1VUJGQ05tN1pMNVJ6SEZ1VXNWeVVJcjhjRWEiLCJtYWMiOiI5YTgyNzFjMjU0NTFiNGNlNTZmMGQyNjMyMTUxMDc4NjI3M2ZiMWI2Y2E3ZjI0ZDUzMWY5YTcxYjc4YmI4NWZhIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:25:27', '2023-04-14 11:25:27'),
	(221, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImNKQzZsbkwwZjRtZWppeVVlTU4rbFE9PSIsInZhbHVlIjoiNS9qWVlMMGtuZDFaKzZPcjBITU1BeXdmRXROY0VpMFFkOVpueHhrcG5WNFJkbTNDRzRrWmNMQVNDSjlhdm91U0FGT1J4SHYvUitJZk53c1NwTzNHQXk4djU4cDlMMjR0MWtabTI1VUJGQ05tN1pMNVJ6SEZ1VXNWeVVJcjhjRWEiLCJtYWMiOiI5YTgyNzFjMjU0NTFiNGNlNTZmMGQyNjMyMTUxMDc4NjI3M2ZiMWI2Y2E3ZjI0ZDUzMWY5YTcxYjc4YmI4NWZhIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:28:54', '2023-04-14 11:28:54'),
	(222, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImNKQzZsbkwwZjRtZWppeVVlTU4rbFE9PSIsInZhbHVlIjoiNS9qWVlMMGtuZDFaKzZPcjBITU1BeXdmRXROY0VpMFFkOVpueHhrcG5WNFJkbTNDRzRrWmNMQVNDSjlhdm91U0FGT1J4SHYvUitJZk53c1NwTzNHQXk4djU4cDlMMjR0MWtabTI1VUJGQ05tN1pMNVJ6SEZ1VXNWeVVJcjhjRWEiLCJtYWMiOiI5YTgyNzFjMjU0NTFiNGNlNTZmMGQyNjMyMTUxMDc4NjI3M2ZiMWI2Y2E3ZjI0ZDUzMWY5YTcxYjc4YmI4NWZhIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:28:54', '2023-04-14 11:28:54'),
	(223, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImNKQzZsbkwwZjRtZWppeVVlTU4rbFE9PSIsInZhbHVlIjoiNS9qWVlMMGtuZDFaKzZPcjBITU1BeXdmRXROY0VpMFFkOVpueHhrcG5WNFJkbTNDRzRrWmNMQVNDSjlhdm91U0FGT1J4SHYvUitJZk53c1NwTzNHQXk4djU4cDlMMjR0MWtabTI1VUJGQ05tN1pMNVJ6SEZ1VXNWeVVJcjhjRWEiLCJtYWMiOiI5YTgyNzFjMjU0NTFiNGNlNTZmMGQyNjMyMTUxMDc4NjI3M2ZiMWI2Y2E3ZjI0ZDUzMWY5YTcxYjc4YmI4NWZhIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:29:02', '2023-04-14 11:29:02'),
	(224, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImNKQzZsbkwwZjRtZWppeVVlTU4rbFE9PSIsInZhbHVlIjoiNS9qWVlMMGtuZDFaKzZPcjBITU1BeXdmRXROY0VpMFFkOVpueHhrcG5WNFJkbTNDRzRrWmNMQVNDSjlhdm91U0FGT1J4SHYvUitJZk53c1NwTzNHQXk4djU4cDlMMjR0MWtabTI1VUJGQ05tN1pMNVJ6SEZ1VXNWeVVJcjhjRWEiLCJtYWMiOiI5YTgyNzFjMjU0NTFiNGNlNTZmMGQyNjMyMTUxMDc4NjI3M2ZiMWI2Y2E3ZjI0ZDUzMWY5YTcxYjc4YmI4NWZhIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:29:02', '2023-04-14 11:29:02'),
	(225, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImNKQzZsbkwwZjRtZWppeVVlTU4rbFE9PSIsInZhbHVlIjoiNS9qWVlMMGtuZDFaKzZPcjBITU1BeXdmRXROY0VpMFFkOVpueHhrcG5WNFJkbTNDRzRrWmNMQVNDSjlhdm91U0FGT1J4SHYvUitJZk53c1NwTzNHQXk4djU4cDlMMjR0MWtabTI1VUJGQ05tN1pMNVJ6SEZ1VXNWeVVJcjhjRWEiLCJtYWMiOiI5YTgyNzFjMjU0NTFiNGNlNTZmMGQyNjMyMTUxMDc4NjI3M2ZiMWI2Y2E3ZjI0ZDUzMWY5YTcxYjc4YmI4NWZhIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:29:48', '2023-04-14 11:29:48'),
	(226, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImNKQzZsbkwwZjRtZWppeVVlTU4rbFE9PSIsInZhbHVlIjoiNS9qWVlMMGtuZDFaKzZPcjBITU1BeXdmRXROY0VpMFFkOVpueHhrcG5WNFJkbTNDRzRrWmNMQVNDSjlhdm91U0FGT1J4SHYvUitJZk53c1NwTzNHQXk4djU4cDlMMjR0MWtabTI1VUJGQ05tN1pMNVJ6SEZ1VXNWeVVJcjhjRWEiLCJtYWMiOiI5YTgyNzFjMjU0NTFiNGNlNTZmMGQyNjMyMTUxMDc4NjI3M2ZiMWI2Y2E3ZjI0ZDUzMWY5YTcxYjc4YmI4NWZhIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:29:48', '2023-04-14 11:29:48'),
	(227, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IkljSyt6ZXFRc21KMm1VdnFLbGVUMmc9PSIsInZhbHVlIjoieTJhMDNRVDJlNWZYY2pKVXhVeHU1WFdhbE1lRE9hMWhrWExrTzhlS3BvUHlBREhLU2xPUnZqK3VycUxTMFZ5OVpoM3lUM2RQcUQ4a095aEdaT01abDIrUzhNaEVLcDhVL3V5OTNNdHJqbWd4aGlTYTd2aitzcmplbmZwN2pQeFYiLCJtYWMiOiI0NjRhNGYzYTY4MjkzMzgzYzI3NThkMDhiYTJkY2M5YjQ4ZWRiYzM5NTU5NmZlNWJjNDE0NTYxY2ZmODIyNTg1IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:30:27', '2023-04-14 11:30:27'),
	(228, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IkljSyt6ZXFRc21KMm1VdnFLbGVUMmc9PSIsInZhbHVlIjoieTJhMDNRVDJlNWZYY2pKVXhVeHU1WFdhbE1lRE9hMWhrWExrTzhlS3BvUHlBREhLU2xPUnZqK3VycUxTMFZ5OVpoM3lUM2RQcUQ4a095aEdaT01abDIrUzhNaEVLcDhVL3V5OTNNdHJqbWd4aGlTYTd2aitzcmplbmZwN2pQeFYiLCJtYWMiOiI0NjRhNGYzYTY4MjkzMzgzYzI3NThkMDhiYTJkY2M5YjQ4ZWRiYzM5NTU5NmZlNWJjNDE0NTYxY2ZmODIyNTg1IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:30:27', '2023-04-14 11:30:27'),
	(229, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IkljSyt6ZXFRc21KMm1VdnFLbGVUMmc9PSIsInZhbHVlIjoieTJhMDNRVDJlNWZYY2pKVXhVeHU1WFdhbE1lRE9hMWhrWExrTzhlS3BvUHlBREhLU2xPUnZqK3VycUxTMFZ5OVpoM3lUM2RQcUQ4a095aEdaT01abDIrUzhNaEVLcDhVL3V5OTNNdHJqbWd4aGlTYTd2aitzcmplbmZwN2pQeFYiLCJtYWMiOiI0NjRhNGYzYTY4MjkzMzgzYzI3NThkMDhiYTJkY2M5YjQ4ZWRiYzM5NTU5NmZlNWJjNDE0NTYxY2ZmODIyNTg1IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:30:34', '2023-04-14 11:30:34'),
	(230, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IkljSyt6ZXFRc21KMm1VdnFLbGVUMmc9PSIsInZhbHVlIjoieTJhMDNRVDJlNWZYY2pKVXhVeHU1WFdhbE1lRE9hMWhrWExrTzhlS3BvUHlBREhLU2xPUnZqK3VycUxTMFZ5OVpoM3lUM2RQcUQ4a095aEdaT01abDIrUzhNaEVLcDhVL3V5OTNNdHJqbWd4aGlTYTd2aitzcmplbmZwN2pQeFYiLCJtYWMiOiI0NjRhNGYzYTY4MjkzMzgzYzI3NThkMDhiYTJkY2M5YjQ4ZWRiYzM5NTU5NmZlNWJjNDE0NTYxY2ZmODIyNTg1IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:30:34', '2023-04-14 11:30:34'),
	(231, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImxOcFZDUlhBRDhxaTI5V29ocjNTK0E9PSIsInZhbHVlIjoiQUEzazRjNSsxdStESDBxc3orL1NsemZneGxvQWFpeldBcjJOaUEyMVNwTFhwL0ZiOHB6UVpmRHh3WGhnelk3TTRXWHRkV21SSXBXRDFkYy9mbW1aU0ZEeVhOUnlqcVF3QzZNdjAxRVQyd3VUbVRYTHJBaXpYWmlTK3pTMjM3UTMiLCJtYWMiOiJlOTY0YjIwNzE0MDcxNTMyNjQ3NjJlMGNmMTMzNjQ0ZjYyMTNhMjhlNjFkZjIxNTJhODA2N2ZiZDEzYzdhMWUyIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:33:38', '2023-04-14 11:33:38'),
	(232, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImxOcFZDUlhBRDhxaTI5V29ocjNTK0E9PSIsInZhbHVlIjoiQUEzazRjNSsxdStESDBxc3orL1NsemZneGxvQWFpeldBcjJOaUEyMVNwTFhwL0ZiOHB6UVpmRHh3WGhnelk3TTRXWHRkV21SSXBXRDFkYy9mbW1aU0ZEeVhOUnlqcVF3QzZNdjAxRVQyd3VUbVRYTHJBaXpYWmlTK3pTMjM3UTMiLCJtYWMiOiJlOTY0YjIwNzE0MDcxNTMyNjQ3NjJlMGNmMTMzNjQ0ZjYyMTNhMjhlNjFkZjIxNTJhODA2N2ZiZDEzYzdhMWUyIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:33:38', '2023-04-14 11:33:38'),
	(233, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IktvQVZ5TEluSU1zc1lFaCtPVUJCc1E9PSIsInZhbHVlIjoiNjBPTjlYcDFoVDROdTJrMXh4eXBNTWF1alJWRUZQYUx2b0tycTBFeHVqNFA4bUZ2V0pXZ2orbEFYc1JuNGtXWmVDTmNlUll3bVM3OGg0Y1JVSk1NMUlZK2VWeW9jVWdsQWRsOTh4WGwrYmQrRVBCbzVOWCtLenhad3VTVCs3N2QiLCJtYWMiOiI2MTU3MWE0NzJkNzU2NTAyNDI1Njg3MTRkNmI5YzczNWZhNTc0OTQ3NTJjY2UyZjk4NWRkNTRjYjNkNzE1ZGU0IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:34:01', '2023-04-14 11:34:01'),
	(234, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IktvQVZ5TEluSU1zc1lFaCtPVUJCc1E9PSIsInZhbHVlIjoiNjBPTjlYcDFoVDROdTJrMXh4eXBNTWF1alJWRUZQYUx2b0tycTBFeHVqNFA4bUZ2V0pXZ2orbEFYc1JuNGtXWmVDTmNlUll3bVM3OGg0Y1JVSk1NMUlZK2VWeW9jVWdsQWRsOTh4WGwrYmQrRVBCbzVOWCtLenhad3VTVCs3N2QiLCJtYWMiOiI2MTU3MWE0NzJkNzU2NTAyNDI1Njg3MTRkNmI5YzczNWZhNTc0OTQ3NTJjY2UyZjk4NWRkNTRjYjNkNzE1ZGU0IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:34:01', '2023-04-14 11:34:01'),
	(235, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IlpJQ00ydzEzL0VxN2VCWjNMTi9EVlE9PSIsInZhbHVlIjoiY3VXdGh0RjZwYy8waFFDU0dxT21HMWpYNFVOUXNZUTc1Q0pIT0dKSThzZlFidnJIZ3h0NzBnZDZhbjM1OVBKSVp4ejQzc0plVHhxYmwwUHMyZ0FpaWFVb1UzUzdpWTFuQ3FhZ1k0TVYyZ1hiQ2ZPeUdzdTNDdEpRWGNmK3lmQ2oiLCJtYWMiOiI1MTJlNzJkNTEzNTY0ZmZjOTFkNWIwOGVmNGQxMTAxODc5ZWM5YTQ0MGUyMTk3ZjU2NmNkY2QzMzU1Y2EyMjlmIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:34:03', '2023-04-14 11:34:03'),
	(236, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IlpJQ00ydzEzL0VxN2VCWjNMTi9EVlE9PSIsInZhbHVlIjoiY3VXdGh0RjZwYy8waFFDU0dxT21HMWpYNFVOUXNZUTc1Q0pIT0dKSThzZlFidnJIZ3h0NzBnZDZhbjM1OVBKSVp4ejQzc0plVHhxYmwwUHMyZ0FpaWFVb1UzUzdpWTFuQ3FhZ1k0TVYyZ1hiQ2ZPeUdzdTNDdEpRWGNmK3lmQ2oiLCJtYWMiOiI1MTJlNzJkNTEzNTY0ZmZjOTFkNWIwOGVmNGQxMTAxODc5ZWM5YTQ0MGUyMTk3ZjU2NmNkY2QzMzU1Y2EyMjlmIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:34:03', '2023-04-14 11:34:03'),
	(237, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImQ1dWNOeWx0bUVLaUtKRi9vK1lFMVE9PSIsInZhbHVlIjoiUTNLdDBXV0JQdHFFUXJRRGVYeUZvRDlwN3pyMXN1TmxCRXdLbklPRGNwL1ljOWR5MmFqM09lMlQ5U3lBMjZCL0pHR2c2WFM1a2lXSkpzUzlBY0RWUVFGbklScFdIV2U2c2ZSZ0Q5YzAzaXNCMWJCcGJQTWRWWk9HaWR1RUVkTmwiLCJtYWMiOiI1NGI0YzJiNTNiYWQyOGRjMDMxOGI2NjEwMTYwZWVmMWFlZDlhNGM0MTRjYjdjYTJmZjgwZjRhMzAyMGQ5ZGE3IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:35:10', '2023-04-14 11:35:10'),
	(238, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImQ1dWNOeWx0bUVLaUtKRi9vK1lFMVE9PSIsInZhbHVlIjoiUTNLdDBXV0JQdHFFUXJRRGVYeUZvRDlwN3pyMXN1TmxCRXdLbklPRGNwL1ljOWR5MmFqM09lMlQ5U3lBMjZCL0pHR2c2WFM1a2lXSkpzUzlBY0RWUVFGbklScFdIV2U2c2ZSZ0Q5YzAzaXNCMWJCcGJQTWRWWk9HaWR1RUVkTmwiLCJtYWMiOiI1NGI0YzJiNTNiYWQyOGRjMDMxOGI2NjEwMTYwZWVmMWFlZDlhNGM0MTRjYjdjYTJmZjgwZjRhMzAyMGQ5ZGE3IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:35:10', '2023-04-14 11:35:10'),
	(239, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IjBDZUE5MzhTaU9EL1gyTHNoU3NaZWc9PSIsInZhbHVlIjoiai9INW5UUmQxL0dPTS9Yd1hhV2RrLzJYWk5sUmlNN1dhMERydERvU1ZheTdrOVVFb0JEZ09IWkttVGZQUnlyVjcvR2dETnVRNTM0TUFPVmpkY214S25OcGNncjYrM0l0aHRROW5EakJCZkJwWHZyVlEwckRad01VR0pCYldrNjMiLCJtYWMiOiIzMDc3NWIwMTE4ZDU1N2I4YjE2Zjc4ZDRjOTcwZGQzZGE4MTU5Zjk0Mjg4MDU0MzU3NDk1MGE3MWE5YWUyYjA2IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:37:41', '2023-04-14 11:37:41'),
	(240, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IjBDZUE5MzhTaU9EL1gyTHNoU3NaZWc9PSIsInZhbHVlIjoiai9INW5UUmQxL0dPTS9Yd1hhV2RrLzJYWk5sUmlNN1dhMERydERvU1ZheTdrOVVFb0JEZ09IWkttVGZQUnlyVjcvR2dETnVRNTM0TUFPVmpkY214S25OcGNncjYrM0l0aHRROW5EakJCZkJwWHZyVlEwckRad01VR0pCYldrNjMiLCJtYWMiOiIzMDc3NWIwMTE4ZDU1N2I4YjE2Zjc4ZDRjOTcwZGQzZGE4MTU5Zjk0Mjg4MDU0MzU3NDk1MGE3MWE5YWUyYjA2IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:37:41', '2023-04-14 11:37:41'),
	(241, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IloyZitLUjVUL1d2a216Q0l2cHJ1c2c9PSIsInZhbHVlIjoiODNtUGxwdGZTMForMDRjcmgrcUduNXYvZUV1NXNlWXpMQkRPSzZndmRUN0JKamE3V3ZnWjBvL01mYm9abk1yOENWVmh4YmR1R2N6UGlWQ2hsemNsbHVkSWROVDRqb3NETnQyT3Ewc2VYa3lDN05hdTBXUlNGako5TFlpaU5SNUciLCJtYWMiOiJhMDM3NmRlNzkwYTdjOTEyNDM3ZDc0ZWRlY2RhMDBiZGQwOWQzMjVmMmUwNWY5ZmUxZWI3NTQwOWYwYjliNjg2IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:37:43', '2023-04-14 11:37:43'),
	(242, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IloyZitLUjVUL1d2a216Q0l2cHJ1c2c9PSIsInZhbHVlIjoiODNtUGxwdGZTMForMDRjcmgrcUduNXYvZUV1NXNlWXpMQkRPSzZndmRUN0JKamE3V3ZnWjBvL01mYm9abk1yOENWVmh4YmR1R2N6UGlWQ2hsemNsbHVkSWROVDRqb3NETnQyT3Ewc2VYa3lDN05hdTBXUlNGako5TFlpaU5SNUciLCJtYWMiOiJhMDM3NmRlNzkwYTdjOTEyNDM3ZDc0ZWRlY2RhMDBiZGQwOWQzMjVmMmUwNWY5ZmUxZWI3NTQwOWYwYjliNjg2IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:37:43', '2023-04-14 11:37:43'),
	(243, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IitWQXJNbTU5ZjVxelhzeVhFTVVVcHc9PSIsInZhbHVlIjoiZVFBQ0tseENtYitiYVI4SVlGdVEzQ1A4eERRNzUwSEdLbVhYNjRnUkRqZFlaTS80WVErWXQxVkQvNmZaYkxsaFAxY1FURkVvazlKbmxUbWxSQS9XV3U5cGtUam00WGFQOEZBTmhRczV4OTllbWdmUzZ5S1g5aDErL3BiS2R4ZHoiLCJtYWMiOiI3YmE3MDBjMTQ3N2Q4NGRlZGQyOTU1MDZhNjkxOTQ5YTkzM2RkODI0ODBhYTAyZTM2ODE5ZjAwM2I2ZWFmYzFlIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:37:43', '2023-04-14 11:37:43'),
	(244, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IitWQXJNbTU5ZjVxelhzeVhFTVVVcHc9PSIsInZhbHVlIjoiZVFBQ0tseENtYitiYVI4SVlGdVEzQ1A4eERRNzUwSEdLbVhYNjRnUkRqZFlaTS80WVErWXQxVkQvNmZaYkxsaFAxY1FURkVvazlKbmxUbWxSQS9XV3U5cGtUam00WGFQOEZBTmhRczV4OTllbWdmUzZ5S1g5aDErL3BiS2R4ZHoiLCJtYWMiOiI3YmE3MDBjMTQ3N2Q4NGRlZGQyOTU1MDZhNjkxOTQ5YTkzM2RkODI0ODBhYTAyZTM2ODE5ZjAwM2I2ZWFmYzFlIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:37:43', '2023-04-14 11:37:43'),
	(245, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6InF6cGF5UXZ5UUtlT2ZaSEdIK1ZhZ0E9PSIsInZhbHVlIjoiOXBXN00reW9pNHFsZVE3MlNCMFRkZjFlK1hvMTB2V0FoSE0wQktmY2xKTWtsRzBGNzFwMkJlUE10SjlESGszZmZpRlJyQjNYVTc4ZFZDT0UyRGRPOUE5Ynh2bmxBMXF3ZGovY0V1ZW92aWt5NjA4Y09oSlZLUTRHLzU2bXQ1MTkiLCJtYWMiOiJiZTFlMDljNDJlMTQwNjJmNGEzMDQ1MDM2MTVhYTQ1MjU0MWMzMDYxODlmMTk4OWVkNTZkNWU0YTdhMmE4Njg1IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:37:43', '2023-04-14 11:37:43'),
	(246, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6InF6cGF5UXZ5UUtlT2ZaSEdIK1ZhZ0E9PSIsInZhbHVlIjoiOXBXN00reW9pNHFsZVE3MlNCMFRkZjFlK1hvMTB2V0FoSE0wQktmY2xKTWtsRzBGNzFwMkJlUE10SjlESGszZmZpRlJyQjNYVTc4ZFZDT0UyRGRPOUE5Ynh2bmxBMXF3ZGovY0V1ZW92aWt5NjA4Y09oSlZLUTRHLzU2bXQ1MTkiLCJtYWMiOiJiZTFlMDljNDJlMTQwNjJmNGEzMDQ1MDM2MTVhYTQ1MjU0MWMzMDYxODlmMTk4OWVkNTZkNWU0YTdhMmE4Njg1IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:37:43', '2023-04-14 11:37:43'),
	(247, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IjhDNHp4akFSVW5XeGhSZUJDMlZXc0E9PSIsInZhbHVlIjoiZXliWUk0NzVaSVFDUzQrR2diNnh3ZEpTSHlnM09IUkljaFVlZXl1bCs2NXNiVFllQUE5dzVyRGljdlk3MlpsSlkxU1VYcmNZVkg2SFB2cUNyaTRQeUppbUlPNjIyaENoY1pueUR6ZzdzS3Vzc2ptSmR4MWkzQUxCOEg1K0FIVzMiLCJtYWMiOiJkNzkwNjU4M2NiMDY2OTc4YmNhZmQyNmJlOTk5Y2FhODc2NWZmY2Y0ZjRkNDkyMWU3MGE1MTNlNTk0NjE1MDYxIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:37:44', '2023-04-14 11:37:44'),
	(248, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IjhDNHp4akFSVW5XeGhSZUJDMlZXc0E9PSIsInZhbHVlIjoiZXliWUk0NzVaSVFDUzQrR2diNnh3ZEpTSHlnM09IUkljaFVlZXl1bCs2NXNiVFllQUE5dzVyRGljdlk3MlpsSlkxU1VYcmNZVkg2SFB2cUNyaTRQeUppbUlPNjIyaENoY1pueUR6ZzdzS3Vzc2ptSmR4MWkzQUxCOEg1K0FIVzMiLCJtYWMiOiJkNzkwNjU4M2NiMDY2OTc4YmNhZmQyNmJlOTk5Y2FhODc2NWZmY2Y0ZjRkNDkyMWU3MGE1MTNlNTk0NjE1MDYxIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:37:44', '2023-04-14 11:37:44'),
	(249, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImdHblcxdXNpOFF0TTE0cXF5azhLcEE9PSIsInZhbHVlIjoiSmFEODBZUVEwMGh3TjRWM2FBVStzT1dEQVJMSnNrbDlWTWNnNmRDU3Y1VFpmbmRtUk45LytVZjA2SWR6YTh3endPZTg0ZUxibXRSc2J4Sm9kVGV3ZjJyV3BZTHpmbFgyUXhnNHRrS3VFSVBwa1pTbXRBbVdSL3AxZTZOUlVlNzMiLCJtYWMiOiJlNTJlNWI3NDczY2NmYjc3NGVjNzFkODg1MWVmYTQxYjhkNjU5MjkxZWI3OWYyNzM4NjlhMmE5NzMyODQxNDJiIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:37:44', '2023-04-14 11:37:44'),
	(250, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImdHblcxdXNpOFF0TTE0cXF5azhLcEE9PSIsInZhbHVlIjoiSmFEODBZUVEwMGh3TjRWM2FBVStzT1dEQVJMSnNrbDlWTWNnNmRDU3Y1VFpmbmRtUk45LytVZjA2SWR6YTh3endPZTg0ZUxibXRSc2J4Sm9kVGV3ZjJyV3BZTHpmbFgyUXhnNHRrS3VFSVBwa1pTbXRBbVdSL3AxZTZOUlVlNzMiLCJtYWMiOiJlNTJlNWI3NDczY2NmYjc3NGVjNzFkODg1MWVmYTQxYjhkNjU5MjkxZWI3OWYyNzM4NjlhMmE5NzMyODQxNDJiIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:37:44', '2023-04-14 11:37:44'),
	(251, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImdHblcxdXNpOFF0TTE0cXF5azhLcEE9PSIsInZhbHVlIjoiSmFEODBZUVEwMGh3TjRWM2FBVStzT1dEQVJMSnNrbDlWTWNnNmRDU3Y1VFpmbmRtUk45LytVZjA2SWR6YTh3endPZTg0ZUxibXRSc2J4Sm9kVGV3ZjJyV3BZTHpmbFgyUXhnNHRrS3VFSVBwa1pTbXRBbVdSL3AxZTZOUlVlNzMiLCJtYWMiOiJlNTJlNWI3NDczY2NmYjc3NGVjNzFkODg1MWVmYTQxYjhkNjU5MjkxZWI3OWYyNzM4NjlhMmE5NzMyODQxNDJiIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:37:44', '2023-04-14 11:37:44'),
	(252, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImdHblcxdXNpOFF0TTE0cXF5azhLcEE9PSIsInZhbHVlIjoiSmFEODBZUVEwMGh3TjRWM2FBVStzT1dEQVJMSnNrbDlWTWNnNmRDU3Y1VFpmbmRtUk45LytVZjA2SWR6YTh3endPZTg0ZUxibXRSc2J4Sm9kVGV3ZjJyV3BZTHpmbFgyUXhnNHRrS3VFSVBwa1pTbXRBbVdSL3AxZTZOUlVlNzMiLCJtYWMiOiJlNTJlNWI3NDczY2NmYjc3NGVjNzFkODg1MWVmYTQxYjhkNjU5MjkxZWI3OWYyNzM4NjlhMmE5NzMyODQxNDJiIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:37:44', '2023-04-14 11:37:44'),
	(253, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IkI0NFNWV3Q5eXpybjBRaFQ1WXFPcGc9PSIsInZhbHVlIjoieWdLQ2JiRlZDeUZPdGNCelpaWk5SRElpZnhtRjRrd3dUZXk0NkwvdHJ0US9PKy9ZeUNQYjVuOVVycWNYdjAvVlZuVTFnKzFTYVplYUlOeXp1SVdwMTJyLzR5RGpTcHhtZ0Nvc3NLQW5zRUM4Y2VOMmZ2MUt4YXZqVTBYWEd6TzUiLCJtYWMiOiIxYjZkMzE0OTMxZmEyNmI1MDI5NDE0MTgyNmE5NTU3ZmY1MzIwODA4NzNhNGMwN2RmNjQ4ZmU3NTY4MTYwZTM4IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:38:02', '2023-04-14 11:38:02'),
	(254, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IkI0NFNWV3Q5eXpybjBRaFQ1WXFPcGc9PSIsInZhbHVlIjoieWdLQ2JiRlZDeUZPdGNCelpaWk5SRElpZnhtRjRrd3dUZXk0NkwvdHJ0US9PKy9ZeUNQYjVuOVVycWNYdjAvVlZuVTFnKzFTYVplYUlOeXp1SVdwMTJyLzR5RGpTcHhtZ0Nvc3NLQW5zRUM4Y2VOMmZ2MUt4YXZqVTBYWEd6TzUiLCJtYWMiOiIxYjZkMzE0OTMxZmEyNmI1MDI5NDE0MTgyNmE5NTU3ZmY1MzIwODA4NzNhNGMwN2RmNjQ4ZmU3NTY4MTYwZTM4IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:38:02', '2023-04-14 11:38:02'),
	(255, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IjE4d3hXUTdWbjdYMkxleldWbExSSHc9PSIsInZhbHVlIjoiVUNpWjg1SlBablFvbWV4TXUxMG9jeXloZ01vcTIyRHUrK0VkUWlGTjZGMEY1RGlZdU1VUjcySGFHbXpTWTNtekprN01oOE9uaGNoMFBIdlBWS2svYlFxRVhDYmpHTDRPMWQweDAyd3gzMFlSZEVZZDJMVXRIUDZ1NzdpM1M4KzAiLCJtYWMiOiI0NzhmZGY3MDExNDM3NGZhZGUzZGRhNmI4MWVjMjJmNTg4YTA0ZGJkYzQxZWU4Njk5ZjFiMWE5NDNiODhmOWYxIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:38:52', '2023-04-14 11:38:52'),
	(256, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IjE4d3hXUTdWbjdYMkxleldWbExSSHc9PSIsInZhbHVlIjoiVUNpWjg1SlBablFvbWV4TXUxMG9jeXloZ01vcTIyRHUrK0VkUWlGTjZGMEY1RGlZdU1VUjcySGFHbXpTWTNtekprN01oOE9uaGNoMFBIdlBWS2svYlFxRVhDYmpHTDRPMWQweDAyd3gzMFlSZEVZZDJMVXRIUDZ1NzdpM1M4KzAiLCJtYWMiOiI0NzhmZGY3MDExNDM3NGZhZGUzZGRhNmI4MWVjMjJmNTg4YTA0ZGJkYzQxZWU4Njk5ZjFiMWE5NDNiODhmOWYxIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:38:52', '2023-04-14 11:38:52'),
	(257, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Im5WT0RrbXA3TEd4SE8rdEQ4L2FwM3c9PSIsInZhbHVlIjoic0E1UXBxODRnNjFzRlpmblVqMys0ZWxRakJxMmhoQlJTbUthRVpQcW8xMnkrK0ZQbkk5TDF0MjRjMVUvU0o5WDJTKzI0MlBlR0lidEFPNDl0bGlQZFFhVE5POWlZWWFUc29XU3V0bVhrU3BlRFpLZnZwT2VFeU1lOWhpUDYyMUEiLCJtYWMiOiJkODcwZTMxMTU4N2NiMGIzNzZlYTEzNTA5Mjc3MWUzZmQxZWVkM2NiMjdmZDk1OWY2NTM4MjczM2UzYWJmNDZkIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:41:47', '2023-04-14 11:41:47'),
	(258, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Im5WT0RrbXA3TEd4SE8rdEQ4L2FwM3c9PSIsInZhbHVlIjoic0E1UXBxODRnNjFzRlpmblVqMys0ZWxRakJxMmhoQlJTbUthRVpQcW8xMnkrK0ZQbkk5TDF0MjRjMVUvU0o5WDJTKzI0MlBlR0lidEFPNDl0bGlQZFFhVE5POWlZWWFUc29XU3V0bVhrU3BlRFpLZnZwT2VFeU1lOWhpUDYyMUEiLCJtYWMiOiJkODcwZTMxMTU4N2NiMGIzNzZlYTEzNTA5Mjc3MWUzZmQxZWVkM2NiMjdmZDk1OWY2NTM4MjczM2UzYWJmNDZkIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:41:47', '2023-04-14 11:41:47'),
	(259, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Im1vclVyclBsZE55TFIwMTdTaHdLZEE9PSIsInZhbHVlIjoiczdIM2Vla0hnTjF0WXVVOXYwRlNIRGF2bmpscnhwdFMyRWNGRkpzSWlpbkNvOUFHOFpFSEVxelVYYXJTb2J2THgzSlZ6cEpOVUkvbE5GTFNObWJZTjh2UmhPMnh5L2ZjMzl1d05KdkNPV250QWFNWVlITDVHY1YrQjZtak5qODAiLCJtYWMiOiJiNjQyZGE4YmNkOTEyZDBjZDliZTAyOThhNTAyNDQ4NGI2YzhiNDkwYmUyM2FlM2ZhNDYzN2Q5ZTZiNTQwYmYxIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:44:09', '2023-04-14 11:44:09'),
	(260, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Im1vclVyclBsZE55TFIwMTdTaHdLZEE9PSIsInZhbHVlIjoiczdIM2Vla0hnTjF0WXVVOXYwRlNIRGF2bmpscnhwdFMyRWNGRkpzSWlpbkNvOUFHOFpFSEVxelVYYXJTb2J2THgzSlZ6cEpOVUkvbE5GTFNObWJZTjh2UmhPMnh5L2ZjMzl1d05KdkNPV250QWFNWVlITDVHY1YrQjZtak5qODAiLCJtYWMiOiJiNjQyZGE4YmNkOTEyZDBjZDliZTAyOThhNTAyNDQ4NGI2YzhiNDkwYmUyM2FlM2ZhNDYzN2Q5ZTZiNTQwYmYxIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:44:09', '2023-04-14 11:44:09'),
	(261, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"pragma":["no-cache"],"cache-control":["no-cache"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6InpjQU8zeS9KTVpCRGhhTWN4V3ZyWGc9PSIsInZhbHVlIjoibXRHb1A5ckR4cWRwK2VVMGphNEVGdERSOGxpRHZqa0VhQW1RMmsvNnBObVhRaFZyY3Jhc09LdFNwbTlsR2ovcCtvZmU2UDBmOTR5M1NSSzFnK2lSSFJVeEZTU1d3RzlNNmNzNk5rZEhJWWE1enk0SnJ0VC9mMEVFMXBHajhhRnMiLCJtYWMiOiI1NDZmYTAyYzI5MzhiMjEyOTQxYTRkOWFkZGZmYmZkM2UyYjVlYjQxZDNkZjc3M2EyNDMyNTVlNmFjNWRkMjFhIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:44:11', '2023-04-14 11:44:11'),
	(262, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"pragma":["no-cache"],"cache-control":["no-cache"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6InpjQU8zeS9KTVpCRGhhTWN4V3ZyWGc9PSIsInZhbHVlIjoibXRHb1A5ckR4cWRwK2VVMGphNEVGdERSOGxpRHZqa0VhQW1RMmsvNnBObVhRaFZyY3Jhc09LdFNwbTlsR2ovcCtvZmU2UDBmOTR5M1NSSzFnK2lSSFJVeEZTU1d3RzlNNmNzNk5rZEhJWWE1enk0SnJ0VC9mMEVFMXBHajhhRnMiLCJtYWMiOiI1NDZmYTAyYzI5MzhiMjEyOTQxYTRkOWFkZGZmYmZkM2UyYjVlYjQxZDNkZjc3M2EyNDMyNTVlNmFjNWRkMjFhIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:44:11', '2023-04-14 11:44:11'),
	(263, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IkhjUkNIWGh5dUgzRkczMU1VeWtiWHc9PSIsInZhbHVlIjoiU1FTZXBFUkVoNC9ORk4wUGI0bTNzSnVwTzRHSEZkYmliN2ZDQUlhOTNCU2o5T0x0b1F5dmM3Y0czUUJCb1VJc3BvcG53QVZmeUNhYUllYlltVkc0N3l3azlrZWRLM1YzT0FRdGJtZ2JqVUJnYm9NR3F0TzNHQVVGMmIrTjN0QXEiLCJtYWMiOiIxMGZkNTI2Zjg1NTA2MDE3MWExMTczNjAzM2YwMjA1ZGZmYjRjODE5MTQ3ZTQ3NGVlZWIwMTZiYWFiNGFlZDAyIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:44:23', '2023-04-14 11:44:23'),
	(264, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IkhjUkNIWGh5dUgzRkczMU1VeWtiWHc9PSIsInZhbHVlIjoiU1FTZXBFUkVoNC9ORk4wUGI0bTNzSnVwTzRHSEZkYmliN2ZDQUlhOTNCU2o5T0x0b1F5dmM3Y0czUUJCb1VJc3BvcG53QVZmeUNhYUllYlltVkc0N3l3azlrZWRLM1YzT0FRdGJtZ2JqVUJnYm9NR3F0TzNHQVVGMmIrTjN0QXEiLCJtYWMiOiIxMGZkNTI2Zjg1NTA2MDE3MWExMTczNjAzM2YwMjA1ZGZmYjRjODE5MTQ3ZTQ3NGVlZWIwMTZiYWFiNGFlZDAyIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:44:23', '2023-04-14 11:44:23'),
	(265, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Im94cGtYWEpwOHFqUkJ6b252RlkzSEE9PSIsInZhbHVlIjoiRjgvSVh2enBBNi94MnVkMmRzK1VDdjBmT3FHdnQweXU3bTBNUysrTHpiaVRWQ2s3SGlvdlVlMGFnUmZHS1owT2hCd00wN3ZKWGdRemRiL3J2WXJGeXNxK2o5dm16Mnpod1lwS01FY0JKczArVWdqYTk4U2V5Qmw4SkJnK3haQVMiLCJtYWMiOiI1NGUxYmRlM2I3MzQ2M2ZmNDZhYTYzYTFhOGMyNzExYzNlY2RiMTE3NzM0OGQ4Mzg3NDIyY2VlOGU2NDY1ZmI2IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:44:33', '2023-04-14 11:44:33'),
	(266, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Im94cGtYWEpwOHFqUkJ6b252RlkzSEE9PSIsInZhbHVlIjoiRjgvSVh2enBBNi94MnVkMmRzK1VDdjBmT3FHdnQweXU3bTBNUysrTHpiaVRWQ2s3SGlvdlVlMGFnUmZHS1owT2hCd00wN3ZKWGdRemRiL3J2WXJGeXNxK2o5dm16Mnpod1lwS01FY0JKczArVWdqYTk4U2V5Qmw4SkJnK3haQVMiLCJtYWMiOiI1NGUxYmRlM2I3MzQ2M2ZmNDZhYTYzYTFhOGMyNzExYzNlY2RiMTE3NzM0OGQ4Mzg3NDIyY2VlOGU2NDY1ZmI2IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:44:33', '2023-04-14 11:44:33'),
	(267, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IktRZUJ3b2QwenlybTZUc3R1ZlBxRVE9PSIsInZhbHVlIjoiang0bnVqQWM3NkRSVTNCaUR3UHBsVUFDMmgxMjJoUTNRdzdDNEFJekRwNWNHOHFIV0U5RGhiM3lOem4ySkNGUitkdEdwMTY5YUVnaXpYMTZCNWNxcDNoQVd6TUxMb0hTWW1mb2FGTEpGaG5sVldFR3M3cXBiaGNKNFFlaWVwRFIiLCJtYWMiOiJjYTk5NGZiZDQyNGQxYWEzOTQzY2ZmYWZmNjIxYjI4MTFjNjNmZWQ3Njg0OGVlZWE5MWQ3MTljMGU2YzE4OTQ4IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:45:01', '2023-04-14 11:45:01'),
	(268, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IktRZUJ3b2QwenlybTZUc3R1ZlBxRVE9PSIsInZhbHVlIjoiang0bnVqQWM3NkRSVTNCaUR3UHBsVUFDMmgxMjJoUTNRdzdDNEFJekRwNWNHOHFIV0U5RGhiM3lOem4ySkNGUitkdEdwMTY5YUVnaXpYMTZCNWNxcDNoQVd6TUxMb0hTWW1mb2FGTEpGaG5sVldFR3M3cXBiaGNKNFFlaWVwRFIiLCJtYWMiOiJjYTk5NGZiZDQyNGQxYWEzOTQzY2ZmYWZmNjIxYjI4MTFjNjNmZWQ3Njg0OGVlZWE5MWQ3MTljMGU2YzE4OTQ4IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:45:01', '2023-04-14 11:45:01'),
	(269, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImtkdkozcXBoNGlqS09KTGtjVjQ5ZkE9PSIsInZhbHVlIjoidmUrcnRvdVorcUV0dDV0cE9DWXpuZ09iSmd5U1pWWXdZOG5TOHNwanFCcEhuVnR3cUpxWXNXVHZ4YXpvSi9QcEd6aksxMktyMnBjK0U3TE5xSHBjZnkwTTNHTnZ4ZWxnbWhlNDdPTjVoQkhYMm9NNU1pNlhSZ3FsS1hiQlFTOWoiLCJtYWMiOiIxYmE5ZDQ0YTJiZGUzNDkwYzU3NGQ5Y2JhMzY1MTVjN2YyODRmZWNkNzQ4NTgzOWRjZWU2ZGI5Mjg1Yjk2ZGEyIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:45:28', '2023-04-14 11:45:28'),
	(270, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImtkdkozcXBoNGlqS09KTGtjVjQ5ZkE9PSIsInZhbHVlIjoidmUrcnRvdVorcUV0dDV0cE9DWXpuZ09iSmd5U1pWWXdZOG5TOHNwanFCcEhuVnR3cUpxWXNXVHZ4YXpvSi9QcEd6aksxMktyMnBjK0U3TE5xSHBjZnkwTTNHTnZ4ZWxnbWhlNDdPTjVoQkhYMm9NNU1pNlhSZ3FsS1hiQlFTOWoiLCJtYWMiOiIxYmE5ZDQ0YTJiZGUzNDkwYzU3NGQ5Y2JhMzY1MTVjN2YyODRmZWNkNzQ4NTgzOWRjZWU2ZGI5Mjg1Yjk2ZGEyIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:45:28', '2023-04-14 11:45:28'),
	(271, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IjhiNzhoL3JLbDl0Q3gxOFlUTEFwdWc9PSIsInZhbHVlIjoiblpuZ3pza3h2Z3lxR0szckdsNFRPRWkyV0tsbXhvUENIcDJhU2c5aEt0REFtMTI4V0JCTkpqTG5IUFd1RitvQjVvdVl0enhVVVNndVR5aDFXK3k2MU5tdkFSSlVnNWcvWXEzSStNQnAwLzlENU1SL3dSZ0VveC9FZlByVXVvNkQiLCJtYWMiOiIyNTkzMDNhMTIyMTM0NGIzOGRhOTgwZTA1MzRhYTAyMDkxZjJiNGMyZjAzMzllZmFjYTRlODBmNmMwMDAzY2UwIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:46:12', '2023-04-14 11:46:12'),
	(272, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IjhiNzhoL3JLbDl0Q3gxOFlUTEFwdWc9PSIsInZhbHVlIjoiblpuZ3pza3h2Z3lxR0szckdsNFRPRWkyV0tsbXhvUENIcDJhU2c5aEt0REFtMTI4V0JCTkpqTG5IUFd1RitvQjVvdVl0enhVVVNndVR5aDFXK3k2MU5tdkFSSlVnNWcvWXEzSStNQnAwLzlENU1SL3dSZ0VveC9FZlByVXVvNkQiLCJtYWMiOiIyNTkzMDNhMTIyMTM0NGIzOGRhOTgwZTA1MzRhYTAyMDkxZjJiNGMyZjAzMzllZmFjYTRlODBmNmMwMDAzY2UwIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:46:12', '2023-04-14 11:46:12'),
	(273, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6InV3MVd2KzdRYW5RYzdPZTdXUVpVMGc9PSIsInZhbHVlIjoiYkRvK3phTTdFKzdUYkthb1dnUFRaYWN2WTBhSHQzWG51aUszNy9CN3V2a1lHbkM2Q3pQVGdlMFlBbXBPSHdnT3Exc2l1YTRSMndFMS96YXEraWdTaGFQRkhYUEZCb0VpZms3NnBLZ1hyNEV5N2RHMmRiUm5vVEN6MkFxdGNQaHUiLCJtYWMiOiI1OGUwYzQ4M2Q5NDBkYmI3NTFkMjY3NDEwYjBjMzZjNGNlNTM5MzNhOTQ5OTNlNzJmYmViZmI0NWJkZDhlYWY1IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:46:26', '2023-04-14 11:46:26'),
	(274, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6InV3MVd2KzdRYW5RYzdPZTdXUVpVMGc9PSIsInZhbHVlIjoiYkRvK3phTTdFKzdUYkthb1dnUFRaYWN2WTBhSHQzWG51aUszNy9CN3V2a1lHbkM2Q3pQVGdlMFlBbXBPSHdnT3Exc2l1YTRSMndFMS96YXEraWdTaGFQRkhYUEZCb0VpZms3NnBLZ1hyNEV5N2RHMmRiUm5vVEN6MkFxdGNQaHUiLCJtYWMiOiI1OGUwYzQ4M2Q5NDBkYmI3NTFkMjY3NDEwYjBjMzZjNGNlNTM5MzNhOTQ5OTNlNzJmYmViZmI0NWJkZDhlYWY1IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:46:26', '2023-04-14 11:46:26'),
	(275, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Im5jdS9lT2lKR0ErRE9MSU9SYndZaFE9PSIsInZhbHVlIjoicENDYjRVcDFBdHQ3Ykxvb0ovanc1QTkyeHFhaks3ZzBIWk9SY2haMXZLbEVLWUVVaC8vb2lGMmlPUkZFVDZEdk9PRWtUdDlVdTBsRldPTWR2Q2MyQ0pDVFlXVThnUWhQZ1BEdlpMUVpJaEtDOFZrTEI5cXlyZGVLVFBGY1ZYZzciLCJtYWMiOiI4NDQ3OGU3NDU2ODhkMzhmNmE0OTViODRkYWZiNzI2ZTY1N2MwZGRmYWJjZjYzYTAzMzIwMWJlMWIwMWRiZWMwIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:46:34', '2023-04-14 11:46:34'),
	(276, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Im5jdS9lT2lKR0ErRE9MSU9SYndZaFE9PSIsInZhbHVlIjoicENDYjRVcDFBdHQ3Ykxvb0ovanc1QTkyeHFhaks3ZzBIWk9SY2haMXZLbEVLWUVVaC8vb2lGMmlPUkZFVDZEdk9PRWtUdDlVdTBsRldPTWR2Q2MyQ0pDVFlXVThnUWhQZ1BEdlpMUVpJaEtDOFZrTEI5cXlyZGVLVFBGY1ZYZzciLCJtYWMiOiI4NDQ3OGU3NDU2ODhkMzhmNmE0OTViODRkYWZiNzI2ZTY1N2MwZGRmYWJjZjYzYTAzMzIwMWJlMWIwMWRiZWMwIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:46:34', '2023-04-14 11:46:34'),
	(277, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IlJ6SHNrdjdvcFhGZWRTWHFkN1Nxdmc9PSIsInZhbHVlIjoiY3VLVWtjLzFOOUxuTXJ3ZUZwYTdWNnJHQ1ppR3JiSHJQOEFTaUo3Z01RMWphVUlINU5VcjI2MjZTR1BObkxaVFNBaGpZL0xxTWtxMzlPaTZjajB4Z0FUWE42YzdTL1J3YWdmek5sNXF3ZGJUUmN2RlNmT0VxNG96WU5ZWWEvVlkiLCJtYWMiOiJiNjU0YjY5NGVhYzFmZjIwY2FiYWRiMDY1MDM2OWM4MWNjNGVlZTk2YzliMTlkNDBlY2YyNTk5NWI2Yjk3YWU3IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:46:42', '2023-04-14 11:46:42'),
	(278, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IlJ6SHNrdjdvcFhGZWRTWHFkN1Nxdmc9PSIsInZhbHVlIjoiY3VLVWtjLzFOOUxuTXJ3ZUZwYTdWNnJHQ1ppR3JiSHJQOEFTaUo3Z01RMWphVUlINU5VcjI2MjZTR1BObkxaVFNBaGpZL0xxTWtxMzlPaTZjajB4Z0FUWE42YzdTL1J3YWdmek5sNXF3ZGJUUmN2RlNmT0VxNG96WU5ZWWEvVlkiLCJtYWMiOiJiNjU0YjY5NGVhYzFmZjIwY2FiYWRiMDY1MDM2OWM4MWNjNGVlZTk2YzliMTlkNDBlY2YyNTk5NWI2Yjk3YWU3IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:46:42', '2023-04-14 11:46:42'),
	(279, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IkEraU0zcXNtU21NcDRHbkJMR1RYd2c9PSIsInZhbHVlIjoiRFZNWHJ6YTVkM29vWlFyU0xiRlIwWDNETk5yc25BbGxZdXRpVlN2bkgyQVhvV0xXaDZ0YVMxbEg3Tkh4QnpGWUFHb29wcEJYbEJPQkxMT2pQekZPaXpzcUxCRkx5dmRiRzZacTkydWtURnlvc2d3M3BCTDY2bnJXREhzSHVLZUYiLCJtYWMiOiJkNmM0ODBjZGUzN2Q2OTA5MjIyZDU2MGMzOTBjZjkyYjE2NDVjZWI3OWJlZDQ5NjZhNThkMTE3ZTU2ZTY4YzRjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:49:50', '2023-04-14 11:49:50'),
	(280, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IkEraU0zcXNtU21NcDRHbkJMR1RYd2c9PSIsInZhbHVlIjoiRFZNWHJ6YTVkM29vWlFyU0xiRlIwWDNETk5yc25BbGxZdXRpVlN2bkgyQVhvV0xXaDZ0YVMxbEg3Tkh4QnpGWUFHb29wcEJYbEJPQkxMT2pQekZPaXpzcUxCRkx5dmRiRzZacTkydWtURnlvc2d3M3BCTDY2bnJXREhzSHVLZUYiLCJtYWMiOiJkNmM0ODBjZGUzN2Q2OTA5MjIyZDU2MGMzOTBjZjkyYjE2NDVjZWI3OWJlZDQ5NjZhNThkMTE3ZTU2ZTY4YzRjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:49:50', '2023-04-14 11:49:50'),
	(281, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IkU5WWVIQ3pLVStpODZZRS83RUZSanc9PSIsInZhbHVlIjoiOTZRKzQxZ0l5Zm5PZFo1V21Od3pyanZnYlpGRFN4eEZFNHZXOEp0MVJySDRVbjB6Ulg2dk12Q3psN1o2dWJkbTBWdFJjUVU4ampvTnFyWUdmTkUwMFdOZXlURnV4K1EyRjBMZEt0Y25GT1NFTHhpV0VzYlo0YmF3bCtmUFhWRWQiLCJtYWMiOiIyMzMyYWFlMWYzNGE0Zjk5OTRjODFkN2M5ZjhlM2NlODI2ZmNlMzllMDgwZjBjZWZkZDVhYzg3ZjZiZDk3NWRmIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:50:39', '2023-04-14 11:50:39'),
	(282, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IkU5WWVIQ3pLVStpODZZRS83RUZSanc9PSIsInZhbHVlIjoiOTZRKzQxZ0l5Zm5PZFo1V21Od3pyanZnYlpGRFN4eEZFNHZXOEp0MVJySDRVbjB6Ulg2dk12Q3psN1o2dWJkbTBWdFJjUVU4ampvTnFyWUdmTkUwMFdOZXlURnV4K1EyRjBMZEt0Y25GT1NFTHhpV0VzYlo0YmF3bCtmUFhWRWQiLCJtYWMiOiIyMzMyYWFlMWYzNGE0Zjk5OTRjODFkN2M5ZjhlM2NlODI2ZmNlMzllMDgwZjBjZWZkZDVhYzg3ZjZiZDk3NWRmIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:50:39', '2023-04-14 11:50:39'),
	(283, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImhLaEZEdno2NllOb3F5WTZOTnVZS0E9PSIsInZhbHVlIjoidjBEOHBsQ3hHczYzRkk1cnlTWDdvQnIwZ0Z0Ui9DQlJrcFdKbmIrSytTM2M3SXFIZ3FGSFFYdkJCYlY4cTlob2FRN21nTEtHYmlWQm9GLzVTVlllNDUwcHRjOHlJaVV0Qk9leVJ5cWxVcGRPb2pkcm9yT1JvNWVzNHF0cjJaRnYiLCJtYWMiOiIyNDEzMjI3ZDYzNTBkYjMzNzZhODdlN2Y4MThlNDQ4YzVhOTBlODMyYWMzYmI1MDRmNjQwMjljZmZkZTA2MDM1IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:52:16', '2023-04-14 11:52:16'),
	(284, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImhLaEZEdno2NllOb3F5WTZOTnVZS0E9PSIsInZhbHVlIjoidjBEOHBsQ3hHczYzRkk1cnlTWDdvQnIwZ0Z0Ui9DQlJrcFdKbmIrSytTM2M3SXFIZ3FGSFFYdkJCYlY4cTlob2FRN21nTEtHYmlWQm9GLzVTVlllNDUwcHRjOHlJaVV0Qk9leVJ5cWxVcGRPb2pkcm9yT1JvNWVzNHF0cjJaRnYiLCJtYWMiOiIyNDEzMjI3ZDYzNTBkYjMzNzZhODdlN2Y4MThlNDQ4YzVhOTBlODMyYWMzYmI1MDRmNjQwMjljZmZkZTA2MDM1IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:52:16', '2023-04-14 11:52:16'),
	(285, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/user-cart-item/my-store/cart', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/user-cart-item\\/my-store\\/cart"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IjR5T29aV1NBcG1GS0hMYXVTZjBjd3c9PSIsInZhbHVlIjoiOUFiSm9Ud3ExNkdWZXJ2elBNTGlpdWJncnc5Y2IwTWRENnpHeUpWQkJwWFg5c2JxemFBK3I2U2NzNkFGMFZDMVlNQ1paWEFQWXFBY0NDaFpEbFRJOEVCU0oxT0M2MEtNYndFNk5JRXJGcm5ObmlwMGtLcW5zM21WR0o3R1A4K1ciLCJtYWMiOiJmNTAxMjRhNmI3ZjIzMmQ0MGFiNDRjMDcyYjI2ODM0NmNjMzMzMTlmNTZmZmIwYWU0ZTNjYTVjZjJhNzc1MDlmIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:53:15', '2023-04-14 11:53:15'),
	(286, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/user-cart-item/my-store/cart', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/user-cart-item\\/my-store\\/cart"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IjR5T29aV1NBcG1GS0hMYXVTZjBjd3c9PSIsInZhbHVlIjoiOUFiSm9Ud3ExNkdWZXJ2elBNTGlpdWJncnc5Y2IwTWRENnpHeUpWQkJwWFg5c2JxemFBK3I2U2NzNkFGMFZDMVlNQ1paWEFQWXFBY0NDaFpEbFRJOEVCU0oxT0M2MEtNYndFNk5JRXJGcm5ObmlwMGtLcW5zM21WR0o3R1A4K1ciLCJtYWMiOiJmNTAxMjRhNmI3ZjIzMmQ0MGFiNDRjMDcyYjI2ODM0NmNjMzMzMTlmNTZmZmIwYWU0ZTNjYTVjZjJhNzc1MDlmIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:53:15', '2023-04-14 11:53:15'),
	(287, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/user-cart-item/my-store/cart', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/user-cart-item\\/my-store\\/cart"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IlUwdWFLM0tKN1ZMZHU4L0hvQUVvWFE9PSIsInZhbHVlIjoiY0R3NzJoNXh1NlZjV0ZvbDd3NEJ3U2xMblZFQXdyT0IyclNoWXUrRzNJbUdWM0d0MlR6STNVbkJTQVcvOWJRQWhXU29mN1h4WjlNSUFCMFpmM2FJb0pOWFZSL2gxQlZJbjVla3hkYXdmUklrUzBCZE1ZT1M4S2dGb0VwcTFrU3UiLCJtYWMiOiIxZWU4YzIxNGNjNGNkYTI0MmRjYjNhNjA5ZWFmNThkMDZkMDQ1YjllYTVhZTIwZWE5OTdjMTVlY2Y0ZGRkY2I1IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:55:18', '2023-04-14 11:55:18'),
	(288, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/user-cart-item/my-store/cart', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/user-cart-item\\/my-store\\/cart"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IlUwdWFLM0tKN1ZMZHU4L0hvQUVvWFE9PSIsInZhbHVlIjoiY0R3NzJoNXh1NlZjV0ZvbDd3NEJ3U2xMblZFQXdyT0IyclNoWXUrRzNJbUdWM0d0MlR6STNVbkJTQVcvOWJRQWhXU29mN1h4WjlNSUFCMFpmM2FJb0pOWFZSL2gxQlZJbjVla3hkYXdmUklrUzBCZE1ZT1M4S2dGb0VwcTFrU3UiLCJtYWMiOiIxZWU4YzIxNGNjNGNkYTI0MmRjYjNhNjA5ZWFmNThkMDZkMDQ1YjllYTVhZTIwZWE5OTdjMTVlY2Y0ZGRkY2I1IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:55:18', '2023-04-14 11:55:18'),
	(289, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store/categorie/Start%20shopping', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store\\/categorie\\/Start%20shopping"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IjR1SXN2cU1PYmUwYXp5UlVQNEdKa2c9PSIsInZhbHVlIjoibGtkSlgvZk9sNDQxZ2VIbGpic053eXp6Qzc4LzZJN29tcUg0Zk9YdlRSYno5dVpRa0JBZ2p3UDBwL0JhWG5mRkNlL1BlUGRWU1huQ1F1a09jSzJ4VGxkQ2ZZcTc2OUIyb0hnR2tsY2pDbWYrUVgxYlhSZkJCWHljMjRiUXhpVGEiLCJtYWMiOiIwZDk2ZTJlZDQwMjZiYzEzOGU3M2EwMGU5OWUzM2VkMDMwNDFhZjBhNDdjMGU1NzFjYTUyMWFlNDM0MzdmMjE5IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:55:47', '2023-04-14 11:55:47'),
	(290, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store/categorie/Start%20shopping', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store\\/categorie\\/Start%20shopping"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IjR1SXN2cU1PYmUwYXp5UlVQNEdKa2c9PSIsInZhbHVlIjoibGtkSlgvZk9sNDQxZ2VIbGpic053eXp6Qzc4LzZJN29tcUg0Zk9YdlRSYno5dVpRa0JBZ2p3UDBwL0JhWG5mRkNlL1BlUGRWU1huQ1F1a09jSzJ4VGxkQ2ZZcTc2OUIyb0hnR2tsY2pDbWYrUVgxYlhSZkJCWHljMjRiUXhpVGEiLCJtYWMiOiIwZDk2ZTJlZDQwMjZiYzEzOGU3M2EwMGU5OWUzM2VkMDMwNDFhZjBhNDdjMGU1NzFjYTUyMWFlNDM0MzdmMjE5IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:55:47', '2023-04-14 11:55:47'),
	(291, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store/categorie/Start%20shopping', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store\\/categorie\\/Start%20shopping"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6InRoMTBNcGdlSWNOQ1Y4OUpGZzFTQkE9PSIsInZhbHVlIjoiYU1wdGptMVRxVXZCaEJBYjdoY3ZWbWxCQ0d6eVp3aGdRaUFQbG5ZVUtsSE9TSVROaXUrMHUvMkN0bDdGVXg4eHFoMXUyUzJBdG0wUFlTQ2YzR2tjMTJQM3ZTMVpPbTdydWh1Mnd5TXg5YkdIa2w4WTNPK3lXaUJiREVCQ2NYeGwiLCJtYWMiOiJjYzM0NjE5NGJmNWE5ZjU1YzAzYzIyZjlmNzgyODBiYWMzZGE3MzA3OWI0ODQzZTVlZTJlMjZiZjU3NjM4YjEwIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:55:49', '2023-04-14 11:55:49'),
	(292, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store/categorie/Start%20shopping', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store\\/categorie\\/Start%20shopping"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6InRoMTBNcGdlSWNOQ1Y4OUpGZzFTQkE9PSIsInZhbHVlIjoiYU1wdGptMVRxVXZCaEJBYjdoY3ZWbWxCQ0d6eVp3aGdRaUFQbG5ZVUtsSE9TSVROaXUrMHUvMkN0bDdGVXg4eHFoMXUyUzJBdG0wUFlTQ2YzR2tjMTJQM3ZTMVpPbTdydWh1Mnd5TXg5YkdIa2w4WTNPK3lXaUJiREVCQ2NYeGwiLCJtYWMiOiJjYzM0NjE5NGJmNWE5ZjU1YzAzYzIyZjlmNzgyODBiYWMzZGE3MzA3OWI0ODQzZTVlZTJlMjZiZjU3NjM4YjEwIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:55:49', '2023-04-14 11:55:49'),
	(293, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store/categorie/Start%20shopping', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store\\/categorie\\/Start%20shopping"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Ik5iQWNZUy9lUnB6eWhQVTc4OUpMMWc9PSIsInZhbHVlIjoib29mZS9tWjBKK09nNFQrRkUwMkdXbFdVdWpBS0NQekU1dDhUMGRDSEdXSnVSOUtBdTM5WXVPdU00YjdrWWV5UEFBOEZKbDJuRWdMYlk0Y3dJeW1HMFlPU2tqVjFUdmJaUlh3cDFwRjRSUWdQSUoxUTB0ajNqV1Joa0pHcHVhVUYiLCJtYWMiOiJiYmM0Y2M3YjIxMDg4MjIzMzBhZDhkYjM0NTBkMDgwMTc1NmYwMjliZmMzOTUwOTI1ZTlmYjA4YzViYTM2YWViIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:55:56', '2023-04-14 11:55:56'),
	(294, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store/categorie/Start%20shopping', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store\\/categorie\\/Start%20shopping"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Ik5iQWNZUy9lUnB6eWhQVTc4OUpMMWc9PSIsInZhbHVlIjoib29mZS9tWjBKK09nNFQrRkUwMkdXbFdVdWpBS0NQekU1dDhUMGRDSEdXSnVSOUtBdTM5WXVPdU00YjdrWWV5UEFBOEZKbDJuRWdMYlk0Y3dJeW1HMFlPU2tqVjFUdmJaUlh3cDFwRjRSUWdQSUoxUTB0ajNqV1Joa0pHcHVhVUYiLCJtYWMiOiJiYmM0Y2M3YjIxMDg4MjIzMzBhZDhkYjM0NTBkMDgwMTc1NmYwMjliZmMzOTUwOTI1ZTlmYjA4YzViYTM2YWViIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 11:55:56', '2023-04-14 11:55:56'),
	(295, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store/categorie/Start%20shopping', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store\\/categorie\\/Start%20shopping"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IjVCK0lmbFhhbEx5ejhKWHBraFZLRGc9PSIsInZhbHVlIjoic2NTNFpaaEJHbUVEZmZzUjI0dHk2d2UwdnljUy8wSExJaytLbUdJbis5Z3Fwd3JFQnIwNXkyb0hEMUwySm9EZWZ1a0x5OVRzNlRpdTFaTTcyRzFrSWRxTFBPWXc1dTVPbFphcnlzSUlYdnlEWGJQdnJEbEZkOCtoNG1sWTZyblciLCJtYWMiOiI1NDRhMWMxYmZkMmY0MzJhZTQxYTNiMDMwMWFiNTg0NjE0MjkxYTY5YWJlMTVkMDg2Nzc3YTYwMmY1NDFmY2JjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 12:01:44', '2023-04-14 12:01:44'),
	(296, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store/categorie/Start%20shopping', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store\\/categorie\\/Start%20shopping"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IjVCK0lmbFhhbEx5ejhKWHBraFZLRGc9PSIsInZhbHVlIjoic2NTNFpaaEJHbUVEZmZzUjI0dHk2d2UwdnljUy8wSExJaytLbUdJbis5Z3Fwd3JFQnIwNXkyb0hEMUwySm9EZWZ1a0x5OVRzNlRpdTFaTTcyRzFrSWRxTFBPWXc1dTVPbFphcnlzSUlYdnlEWGJQdnJEbEZkOCtoNG1sWTZyblciLCJtYWMiOiI1NDRhMWMxYmZkMmY0MzJhZTQxYTNiMDMwMWFiNTg0NjE0MjkxYTY5YWJlMTVkMDg2Nzc3YTYwMmY1NDFmY2JjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 12:01:44', '2023-04-14 12:01:44'),
	(297, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store/categorie/Start%20shopping', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store\\/categorie\\/Start%20shopping"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Ik1Uc1JVYmd3TC9DZGZIRk5pd2diVnc9PSIsInZhbHVlIjoibzlZa2pNYjhKRnc4SDllKys0VVFlS3VGQklhOVY3NGwwcTRPenZTWGVZc0p3L25PZ1pENlZlNldJK2FwcTVrcFJyaGNtdlQ2dEszUXhiLzhqVm9WTFdXUnFMUHJlUnBsOUpLZHk0Q3VydUU0WFF3dnNRdlB6V3JGc3h0RklpL0MiLCJtYWMiOiJjNGJiMDdhOTkwNThjOGVlNzJhNTMxODJkMTJmYTczYWU5YzYxZmNlNTA0MzMyYjQ5Yjg3NDY0OWJlZTcyYTAzIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 12:01:50', '2023-04-14 12:01:50'),
	(298, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store/categorie/Start%20shopping', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store\\/categorie\\/Start%20shopping"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Ik1Uc1JVYmd3TC9DZGZIRk5pd2diVnc9PSIsInZhbHVlIjoibzlZa2pNYjhKRnc4SDllKys0VVFlS3VGQklhOVY3NGwwcTRPenZTWGVZc0p3L25PZ1pENlZlNldJK2FwcTVrcFJyaGNtdlQ2dEszUXhiLzhqVm9WTFdXUnFMUHJlUnBsOUpLZHk0Q3VydUU0WFF3dnNRdlB6V3JGc3h0RklpL0MiLCJtYWMiOiJjNGJiMDdhOTkwNThjOGVlNzJhNTMxODJkMTJmYTczYWU5YzYxZmNlNTA0MzMyYjQ5Yjg3NDY0OWJlZTcyYTAzIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 12:01:50', '2023-04-14 12:01:50'),
	(299, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store/categorie/Start%20shopping', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store\\/categorie\\/Start%20shopping"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImFQaE9vSFFVWjdSbmE5bDNyc2lqRnc9PSIsInZhbHVlIjoiN2lWNjRzT2d6dlNzNUhnUEdTUzdOTDZZZVdmdHdjcGx5Yk9RMDhIdUF5czVtUlJ5MGt5Z3ArSTM1MFBkL2MxUlJLUGk0NDY0N2ZJNS9HL2lRSlZ5NENGNDI5K3RXOStlbkFtN01VUndFdnN1d2svaFJLM2ZlNGtacno2cUJOM0ciLCJtYWMiOiI2NTMzMTc0NDliMmUzNjQzYWU5MjM5MDIwMzM4ZWIxNzdkNzkyZjMzMjE3NWQxNTFmMzQ1YzAyNDgyZTA4NWZjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 12:02:27', '2023-04-14 12:02:27'),
	(300, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store/categorie/Start%20shopping', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store\\/categorie\\/Start%20shopping"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6ImFQaE9vSFFVWjdSbmE5bDNyc2lqRnc9PSIsInZhbHVlIjoiN2lWNjRzT2d6dlNzNUhnUEdTUzdOTDZZZVdmdHdjcGx5Yk9RMDhIdUF5czVtUlJ5MGt5Z3ArSTM1MFBkL2MxUlJLUGk0NDY0N2ZJNS9HL2lRSlZ5NENGNDI5K3RXOStlbkFtN01VUndFdnN1d2svaFJLM2ZlNGtacno2cUJOM0ciLCJtYWMiOiI2NTMzMTc0NDliMmUzNjQzYWU5MjM5MDIwMzM4ZWIxNzdkNzkyZjMzMjE3NWQxNTFmMzQ1YzAyNDgyZTA4NWZjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 12:02:27', '2023-04-14 12:02:27'),
	(301, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/user-cart-item/my-store/cart', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/user-cart-item\\/my-store\\/cart"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Imd1Szh6VUkvamRnSXpOMXFveVdXOFE9PSIsInZhbHVlIjoiLzhmRjdVNVhhNjZxNktNYTk3UHZ4N2RaRmRqUlVSaDZBSS9GYWlqVjdqMzY1NEU5TzRTZ0VxWHhDVFBQYlZNYWRaSlBxQVlYVTNCRXZIUWV2Nm5SaDAvL3p1Qnc3d3FoUXN6K3FYc0xxck0wTVE1NEtCZGFQWW5RQ3huVU1SVXIiLCJtYWMiOiI2NTVhMGYzMDQwMWE1ZmZiODdhYWFlNjA5Mjg0YTAxZDBhMTJjNmUzMzFmZGM0ZWI5YWJlMzAwYzU3OGJiZWUzIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 12:02:36', '2023-04-14 12:02:36'),
	(302, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/user-cart-item/my-store/cart', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/user-cart-item\\/my-store\\/cart"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Imd1Szh6VUkvamRnSXpOMXFveVdXOFE9PSIsInZhbHVlIjoiLzhmRjdVNVhhNjZxNktNYTk3UHZ4N2RaRmRqUlVSaDZBSS9GYWlqVjdqMzY1NEU5TzRTZ0VxWHhDVFBQYlZNYWRaSlBxQVlYVTNCRXZIUWV2Nm5SaDAvL3p1Qnc3d3FoUXN6K3FYc0xxck0wTVE1NEtCZGFQWW5RQ3huVU1SVXIiLCJtYWMiOiI2NTVhMGYzMDQwMWE1ZmZiODdhYWFlNjA5Mjg0YTAxZDBhMTJjNmUzMzFmZGM0ZWI5YWJlMzAwYzU3OGJiZWUzIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 12:02:36', '2023-04-14 12:02:36'),
	(303, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store/categorie/Start%20shopping', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store\\/categorie\\/Start%20shopping"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6InNWb1dvM1U0Qkc2aXUxL1V1VTNwc1E9PSIsInZhbHVlIjoiQ29QQitTVGVrOGtkRzZRSXF1ZDhhZ3hUbU5md0tLYmZzWU1qWUpCNVJNbUp3aEhkeWpZVEJ4NUp6MGNGOGU0SnVFZlI5R3VhT1c1ZzQ4RFg4TlhIQUpsZVlwWkJCeThzV0tlbUhGM0lRV2lQWjNxd2EzOVFKVmgrQnduNlJPOXUiLCJtYWMiOiJlMWQ0MzdjNDk3YWI5YmQ2ZDUzYmMyNmMzMjMwYTFhNzA5Yzk2M2Y4YzNlYjJjZjBlNDA5YmZkMjZjZDk1OWI4IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 12:02:41', '2023-04-14 12:02:41'),
	(304, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store/categorie/Start%20shopping', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store\\/categorie\\/Start%20shopping"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6InNWb1dvM1U0Qkc2aXUxL1V1VTNwc1E9PSIsInZhbHVlIjoiQ29QQitTVGVrOGtkRzZRSXF1ZDhhZ3hUbU5md0tLYmZzWU1qWUpCNVJNbUp3aEhkeWpZVEJ4NUp6MGNGOGU0SnVFZlI5R3VhT1c1ZzQ4RFg4TlhIQUpsZVlwWkJCeThzV0tlbUhGM0lRV2lQWjNxd2EzOVFKVmgrQnduNlJPOXUiLCJtYWMiOiJlMWQ0MzdjNDk3YWI5YmQ2ZDUzYmMyNmMzMjMwYTFhNzA5Yzk2M2Y4YzNlYjJjZjBlNDA5YmZkMjZjZDk1OWI4IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 12:02:41', '2023-04-14 12:02:41'),
	(305, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store/categorie/Start%20shopping', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store\\/categorie\\/Start%20shopping"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6InA1bUdhbXBDV0FpMEVjMHgzQXRUUXc9PSIsInZhbHVlIjoiOEpPK21qWjI3RExLL2pxZzU5cFFWYzZYeGZYNTZqLzRNc0V4YW05QWYxMnp6YlM5b1R6ai9GY2I3cE1iaDJvNWVzU1RPd3gxeFVqei9oZUtmam01MVR3WDQ5YzJrT0J1M1BsK3d4VzRPSUtlMWxNUFgrRE1Lc0xjdWo4ckJCd0YiLCJtYWMiOiIzYTg1ZmJkMGM5ZTZjZGEyOWFjMmQ1Y2UwNDMwMjI0YTg0OWZhYjU3MGVjMGQwNGQ3Y2MxYmY0MjEwMWVjNDdkIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 12:03:21', '2023-04-14 12:03:21'),
	(306, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store/categorie/Start%20shopping', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store\\/categorie\\/Start%20shopping"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6InA1bUdhbXBDV0FpMEVjMHgzQXRUUXc9PSIsInZhbHVlIjoiOEpPK21qWjI3RExLL2pxZzU5cFFWYzZYeGZYNTZqLzRNc0V4YW05QWYxMnp6YlM5b1R6ai9GY2I3cE1iaDJvNWVzU1RPd3gxeFVqei9oZUtmam01MVR3WDQ5YzJrT0J1M1BsK3d4VzRPSUtlMWxNUFgrRE1Lc0xjdWo4ckJCd0YiLCJtYWMiOiIzYTg1ZmJkMGM5ZTZjZGEyOWFjMmQ1Y2UwNDMwMjI0YTg0OWZhYjU3MGVjMGQwNGQ3Y2MxYmY0MjEwMWVjNDdkIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 12:03:21', '2023-04-14 12:03:21'),
	(307, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store/categorie/Start%20shopping', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store\\/categorie\\/Start%20shopping"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IkFKak0zNEV6YlI4ZmFaVnVFL09oc0E9PSIsInZhbHVlIjoiTWtDWTBXZFI5UTVzK3UvQVE2OWJGdkZ3V2cvaE1mVndIeUdVZU50ZklYL2ZYb3BiUE5waHJMUFp4UFhsazQyNzYvalVtbG1kNWp1RUZFY0FHL3J5bHdaY1EwazkxWVRUWXpPSUh5Z2ZSb3hnNVlhTmhReUd4WDdCU2ZnbHcwNVAiLCJtYWMiOiJjYzg2OWRkNjAxZDMwYzM2Y2U0NThkOWI4ZDcyNDY1MDZhYjcxZDdlOWEyZWMyMTQ4ZmEzYjBkMjQzNWEyYmVjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 12:04:56', '2023-04-14 12:04:56'),
	(308, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store/categorie/Start%20shopping', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store\\/categorie\\/Start%20shopping"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6IkFKak0zNEV6YlI4ZmFaVnVFL09oc0E9PSIsInZhbHVlIjoiTWtDWTBXZFI5UTVzK3UvQVE2OWJGdkZ3V2cvaE1mVndIeUdVZU50ZklYL2ZYb3BiUE5waHJMUFp4UFhsazQyNzYvalVtbG1kNWp1RUZFY0FHL3J5bHdaY1EwazkxWVRUWXpPSUh5Z2ZSb3hnNVlhTmhReUd4WDdCU2ZnbHcwNVAiLCJtYWMiOiJjYzg2OWRkNjAxZDMwYzM2Y2U0NThkOWI4ZDcyNDY1MDZhYjcxZDdlOWEyZWMyMTQ4ZmEzYjBkMjQzNWEyYmVjIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 12:04:56', '2023-04-14 12:04:56'),
	(309, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store/categorie/Start%20shopping?search_data=organce', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store\\/categorie\\/Start%20shopping?search_data=organce"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Im96VlFHd1JVVXZZWGYvS1ZkTUx6VUE9PSIsInZhbHVlIjoiQ3VNZEhSYkJxT0pOZmFLVDVRTlJNTzVkeTAvQTlvdllUNWZVTWVKaEhHbnhYNnVWSDErSmJFSHR3TzB4WEMzSlJCUGVTL1ZBY05Bd29FdUlIdWpLa2NkNjY1T1VEMDV2alZpbmdYQ1hUYnJPWlY1OW9hL3RSQjl6R2JYNWVydU8iLCJtYWMiOiIzNTBjOWY2NGI0N2UyOTEwZDYyOWRkMDVjNDFlYjVhYTBkZjI1MTljYmNlNjk4YjEzNGZlMjlmNjgxM2E1ZGFmIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 12:05:17', '2023-04-14 12:05:17'),
	(310, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store/categorie/Start%20shopping?search_data=organce', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store\\/categorie\\/Start%20shopping?search_data=organce"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Im96VlFHd1JVVXZZWGYvS1ZkTUx6VUE9PSIsInZhbHVlIjoiQ3VNZEhSYkJxT0pOZmFLVDVRTlJNTzVkeTAvQTlvdllUNWZVTWVKaEhHbnhYNnVWSDErSmJFSHR3TzB4WEMzSlJCUGVTL1ZBY05Bd29FdUlIdWpLa2NkNjY1T1VEMDV2alZpbmdYQ1hUYnJPWlY1OW9hL3RSQjl6R2JYNWVydU8iLCJtYWMiOiIzNTBjOWY2NGI0N2UyOTEwZDYyOWRkMDVjNDFlYjVhYTBkZjI1MTljYmNlNjk4YjEzNGZlMjlmNjgxM2E1ZGFmIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 12:05:17', '2023-04-14 12:05:17'),
	(311, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store/categorie/Start%20shopping?search_data=organce', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store\\/categorie\\/Start%20shopping?search_data=organce"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Im5KSVRWVjVONjNEVEVjaGUrWGZDOFE9PSIsInZhbHVlIjoiRUE0NFRhNzhpY1NaNG5Yajhmc0lhRjJnUlI1dzBJUDZxN21rdm1taWp2TU5NcXlmSm9qY1d3RCtNSjZyMEhreXhVTS9RUHgzaFpCcXdvYjNoQW4zRnJvWndadGdibGhPbHNUWm5mWlFHZkR5Uy9FQXcvU2prK1JjYzlmMFdRS1UiLCJtYWMiOiIzMzZkYzcyMjU1MjNjYzBiN2YyNmI0OGIxODYwNjYxNDNiOWMxZDBjYmRkYmM2NGQ3NTJlNTY1NzFlMWRiZjRlIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 12:05:18', '2023-04-14 12:05:18'),
	(312, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/store/my-store/categorie/Start%20shopping?search_data=organce', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/store\\/my-store\\/categorie\\/Start%20shopping?search_data=organce"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=VL0k45gUadQOMZg0qWtY3BnshG94Hp3Rbsr6m3jZ; XSRF-TOKEN=eyJpdiI6Im5KSVRWVjVONjNEVEVjaGUrWGZDOFE9PSIsInZhbHVlIjoiRUE0NFRhNzhpY1NaNG5Yajhmc0lhRjJnUlI1dzBJUDZxN21rdm1taWp2TU5NcXlmSm9qY1d3RCtNSjZyMEhreXhVTS9RUHgzaFpCcXdvYjNoQW4zRnJvWndadGdibGhPbHNUWm5mWlFHZkR5Uy9FQXcvU2prK1JjYzlmMFdRS1UiLCJtYWMiOiIzMzZkYzcyMjU1MjNjYzBiN2YyNmI0OGIxODYwNjYxNDNiOWMxZDBjYmRkYmM2NGQ3NTJlNTY1NzFlMWRiZjRlIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 12:05:18', '2023-04-14 12:05:18'),
	(313, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/my-store/customer-home', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/my-store\\/customer-home"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=f7KO6AsIt2ELLwmlOElLQ4DsjmCWUy2nuDwR5kr4; XSRF-TOKEN=eyJpdiI6InNOWEhqeXBzbFJsWFE2amRGVzVhWGc9PSIsInZhbHVlIjoiS1NvZHRhN2VpcjdqK3BINENZMjZrUTZTM0YrTVpwVDEzNm84ZGQrMUF2UjNhc0VjTGJXYVZZLzRtbGdmWlVaUk5RV2RWRHZBZnF2VUJaR3B3elBMUktRZXFmdVR6dkN4NXlxaWZ5bVlTdDQ5S1I2cjU1OHBmRW5TdEJ4S3h2LzEiLCJtYWMiOiI5NzY4ZDE3ODIxZDdkOWIwMjE4ZWM4MzM5Y2E5NTBhMWExMjk0ZGVmZmYwMGM3NzY4ZDJjYzFkNDYyMWMzNzhlIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 12:10:42', '2023-04-14 12:10:42'),
	(314, 'GET', '[]', 'http://localhost/company/saas/store/my-store', 'http://localhost/company/saas/my-store/customer-home', '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["same-origin"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"referer":["http:\\/\\/localhost\\/company\\/saas\\/my-store\\/customer-home"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=f7KO6AsIt2ELLwmlOElLQ4DsjmCWUy2nuDwR5kr4; XSRF-TOKEN=eyJpdiI6Ilg0bnhaQ09CR3EreGtqMFNnYVdBZXc9PSIsInZhbHVlIjoiWkRmUC9FZEpXdUJ2OEhBbHR0aTFDekx1NkFQbWdqT2d4WEtoRjBrd3EzOXArNlZCaWpkdHhUSzdWS0RlVzhmK1ZVVEJvSEdGcWV2dThrbE9wNXZpSGNQKzJGMHIwdStVc1N2bkhyRFpYY2tDN0paRlpmL01VUGFreDB5T2U1TzkiLCJtYWMiOiJmZDM5NzNkMzEyMTMwYmE1NTQwNWJmODFjYTA2N2MyMTY2YWRkZDg4ODE1ZDA2MDBiMDFlY2FmZWJlMDEzODU1IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, NULL, NULL, '2023-04-14 12:10:59', '2023-04-14 12:10:59'),
	(315, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=xXtqAm1wlozIZOc9UQRoe8SSLMBfvfh5redc5Krc; XSRF-TOKEN=eyJpdiI6IkN1eXlHc1l5Q3U3MVU5VklES0w3UlE9PSIsInZhbHVlIjoiaDhyekp2dzUxRWZzUmxMSWJ2TFNIWkdvOUVIZ2RkRDBKSGNhYnc3UHY3M3Q3aURBV0xlS1ZCZGJNRFBrTi9pUDI5bW9xZEdUbXdMTHE3N0VlbS9xRWNhSHpLbzlVT1Z6VURQWFFnODAxbE1mem1lOSszU2gyODI3UVVod3ovY28iLCJtYWMiOiI0YzA4NmQwZDgwYTZkMjhmN2VhYTg0ZWU0NjM5N2FmOTllODY1ZGM2OGI3OTQyZGFhN2YwYjBjOWZiNmI3ZDQ2IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, 'App\\Models\\User', 2, '2023-04-15 02:19:46', '2023-04-15 02:19:46'),
	(316, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=xXtqAm1wlozIZOc9UQRoe8SSLMBfvfh5redc5Krc; XSRF-TOKEN=eyJpdiI6Ik95QUcyWXNKdFVSWlBLWnhHTHJDcmc9PSIsInZhbHVlIjoiajlob0V4cXB5bW1QZEVET3ArZ3dORlRDZ3FubXU3ZTd3UExzK3hCand4NjR3M0JEclpGRDRKWTNqdWhOeHNNQ2FMdnBTcEc4dkFFSG5NdjlVbHRnNDdZTGdTbXFqelpLck9VR1RWbFFQS0hSVmZpcmx0RTlEcHljeVVQV25wTUUiLCJtYWMiOiI2ZGQ1MjhhMjcxNzlkZTU0MzIzOWUwNjE4MmJiNDNiNjIwMjFjNzc5YzM5N2E0NDIyYjZjMTA5NDkyMDdhMGE2IiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, 'App\\Models\\User', 2, '2023-04-15 02:20:25', '2023-04-15 02:20:25'),
	(317, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=xXtqAm1wlozIZOc9UQRoe8SSLMBfvfh5redc5Krc; XSRF-TOKEN=eyJpdiI6InI2L1RvNUg3ZG9nQTJManpIQU5XQWc9PSIsInZhbHVlIjoiYVY2Yy8zMXNMTlRBM0pjVkdyU3ZjYlN4bDMzV094ZE1PL3loV2ltR1BzeDZNV0VCaDJ2dFE5dXdzVWd4THNjTGt5RDZ1SjV2T0lzWXFYcDRGd2xadDZnczh4S1VVempIdlc1M1dpSE9jRVA3MEVJQkViYWFCQXcrUWRGR1daM0kiLCJtYWMiOiI2YTAyNDM5ZTUwMWRjYTBmMTlkNTkwOTQ2ZTc0MWQyOWMzMzZkOWZmN2IwNDFlY2E1MTgxODA4ZGI4NmMwNDRhIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, 'App\\Models\\User', 2, '2023-04-15 02:21:56', '2023-04-15 02:21:56'),
	(318, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"pragma":["no-cache"],"cache-control":["no-cache"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200.4.0.1646768201.0; __utma=111872281.186173073.1642878988.1680622358.1680622358.1; __utmz=111872281.1680622358.1.1.utmcsr=(direct)|utmccn=(direct)|utmcmd=(none); remember_admin_59ba36addc2b2f9401580f014c7f58ea4e30989d=eyJpdiI6IkJidDMyaWFORUVXdllRbnprR3BKM2c9PSIsInZhbHVlIjoiTUlQWHRzUDZ2OWdPNlpURSt0NUpHQTlteU9rcXNEeVpyL1d2UFR6TnpnTU5GaXNaNjlKZDBCZ1lqWGpzT3p0R0ZYWGZlMDhOMWg5amZXblNYMjVhM1A3bnJJWWREcEdBUHNBT09LdGMzT3NGTitVUzltT3R6KzJEbnFqVERrU25yMitxaTRQUjFZNFdyYmJjMndxR3MvVGhCRzZxMkNGbk9NMjFRMldXWDZtY1lEcDNxZnA0WnRscG9MZnc2QjhockRMVTltYzRlRUZCeldzN2luUUJ4dUt2QlBIRFFWS1VHWFBBSjU1ZTQ1VT0iLCJtYWMiOiIyYWNhNTI5Nzg2NjVmYjZlYTdjYjhiMThmMzc5YzVmNDFlZDRjZDAzODM0MTAzNmFkNDhiMGNjNDRjZDhkOWZjIiwidGFnIjoiIn0%3D; ecom_saase_session=xXtqAm1wlozIZOc9UQRoe8SSLMBfvfh5redc5Krc; XSRF-TOKEN=eyJpdiI6IlRBVmR6N1IwbUpUdTkwQmsrL25IK2c9PSIsInZhbHVlIjoieHlBTlZkY0lvZ3ZuV3lmOXBCSmpBYW03RXdNUWY0L0hlQUtCbnNRM0JBWEd6b29rZG55bEdWUjdWeFllK3VKVHlwWnd0eGZTaWdkVncvc3g5NEZybTNkcUwrVG93eWtnMmhER0xoWmZsRnNoVUU5U0hES1Vvc3hSZlQvZWI3UmgiLCJtYWMiOiJiMDAwOWU1Y2M0OWU1MjhlNThiMWI5ZGMzMzI5ZTVjYzIxMmY5NmMwNWQ3YzcwNWY4ZWMzYjA3YWRhOTcxYzJlIiwidGFnIjoiIn0%3D"]}', 'WebKit', 'Windows', 'Chrome', '::1', 'my-store', NULL, NULL, 'App\\Models\\User', 2, '2023-04-15 02:21:57', '2023-04-15 02:21:57'),
	(319, 'GET', '[]', 'http://localhost/company/saas/store/my-store', NULL, '["en-in","en-gb","en-us","en","hi","gu"]', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.0.0 Safari/537.36', '{"host":["localhost"],"connection":["keep-alive"],"cache-control":["max-age=0"],"sec-ch-ua":["\\"Chromium\\";v=\\"112\\", \\"Google Chrome\\";v=\\"112\\", \\"Not:A-Brand\\";v=\\"99\\""],"sec-ch-ua-mobile":["?0"],"sec-ch-ua-platform":["\\"Windows\\""],"upgrade-insecure-requests":["1"],"user-agent":["Mozilla\\/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit\\/537.36 (KHTML, like Gecko) Chrome\\/112.0.0.0 Safari\\/537.36"],"accept":["text\\/html,application\\/xhtml+xml,application\\/xml;q=0.9,image\\/avif,image\\/webp,image\\/apng,*\\/*;q=0.8,application\\/signed-exchange;v=b3;q=0.7"],"sec-fetch-site":["none"],"sec-fetch-mode":["navigate"],"sec-fetch-user":["?1"],"sec-fetch-dest":["document"],"accept-encoding":["gzip, deflate, br"],"accept-language":["en-IN,en-GB;q=0.9,en-US;q=0.8,en;q=0.7,hi;q=0.6,gu;q=0.5"],"cookie":["_ga=GA1.1.186173073.1642878988; _ga_84HS5GBJTX=GS1.1.1646768200