@extends('storefront.layout.theme')
@section('page-title')
    {{__('Product Details')}}
@endsection
@section('content')
@php
    if(!empty(session()->get('lang')))
    {
        $currantLang = session()->get('lang');
    }else{
        $currantLang = $store->lang;
    }
    $languages=\App\Models\Utility::languages();
    $storethemesetting=\App\Models\Utility::demoStoreThemeSetting($store->id,$store->theme_dir);
    $cart = session()->get($store->slug);
    $imgpath=\App\Models\Utility::get_file('uploads/is_cover_image/');
    $main_tax = 0;
    $total = 0;

@endphp
<nav aria-label="breadcrumb" class="breadcrumb mb-0">
    <div class="container">
        <ol class="d-flex align-items-center mb-0 p-0">
            <li class="breadcrumb-item"><a href="#" class="text-success">Home</a></li>
            <li class="breadcrumb-item active" aria-current="page">Cart</li>
        </ol>
    </div>
</nav>

<section class="py-4 osahan-main-body">
    <div class="container">
        {{Form::model($cust_details,array('route' => array('store.customer',$store->slug), 'method' => 'POST')) }}
        <div class="row">

            <div class="col-lg-8">
                <div class="accordion" id="accordionExample">

                    <div class="card border-0 osahan-accor rounded shadow-sm overflow-hidden">

                        <div class="card-header bg-white border-0 p-0" id="headingOne">
                            <h2 class="mb-0">
                                <a
                                    class="btn d-flex align-items-center bg-white btn-block text-left btn-lg h5 px-3 py-4 m-0"
                                    type="button" href="{{route('store.cart',$store->slug)}}">
                                    <span class="c-number">1</span> Cart ({{ count($products) }} items)
                            </a>
                            </h2>
                        </div>

                        <div id="collapseOne" class="collapse " aria-labelledby="headingOne"
                            data-parent="#accordionExample">
                            <div class="card-body p-0 border-top">

                            </div>
                        </div>
                    </div>

                    <div class="card border-0 osahan-accor rounded shadow-sm overflow-hidden mt-3">

                        <div class="card-header bg-white border-0 p-0" id="headingtwo">
                            <h2 class="mb-0">
                                <button
                                    class="btn d-flex align-items-center bg-white btn-block text-left btn-lg h5 px-3 py-4 m-0"
                                    type="button">
                                    <span class="c-number">2</span> Order Address
                                </button>
                            </h2>
                        </div>

                        <div id="collapsetwo" class="collapse show" >
                            <div class="card-body p-0 border-top">
                                <div class="osahan-order_address">
                                    <form method="POST" id="shipping_form">
                                        @csrf
                                        <div class="p-3 row">
                                            <div class="customer-info">
                                                <h5>{{__('Billing information')}}</h5>
                                                <p>{{__('Fill the form below so we can send you the orders invoice.')}}</p>
                                            </div>
                                            <div class="row">
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        {{Form::label('name',__('First Name'),array("class"=>"form-control-label")) }}
                                                        <span style="color:red">*</span>
                                                        {{Form::text('name',old('name'),array('class'=>'form-control','placeholder'=>__('Enter Your First Name'),'required'=>'required'))}}
                                                    </div>
                                                </div>
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        {{Form::label('last_name',__('Last Name'),array("class"=>"form-control-label")) }}
                                                        <span style="color:red">*</span>
                                                        {{Form::text('last_name',old('last_name'),array('class'=>'form-control','placeholder'=>__('Enter Your Last Name'),'required'=>'required'))}}
                                                    </div>
                                                </div>
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        {{Form::label('phone',__('Phone'),array("class"=>"form-control-label")) }}
                                                        <span style="color:red">*</span>
                                                        {{Form::text('phone',old('phone'),array('class'=>'form-control','placeholder'=>'(99) 12345 67890','required'=>'required'))}}
                                                    </div>
                                                </div>
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        {{Form::label('email',__('Email'),array("class"=>"form-control-label")) }}
                                                        <span style="color:red">*</span>
                                                        {{Form::email('email',(Utility::CustomerAuthCheck($store->slug) ? Auth::guard('customers')->user()->email : ''),array('class'=>'form-control','placeholder'=>__('Enter Your Email Address')))}}
                                                    </div>
                                                </div>
                                                @if(!empty($store_payment_setting['custom_field_title_1']))
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        {{Form::label('custom_field_title_1',$store_payment_setting['custom_field_title_1'],array("class"=>"form-control-label")) }}
                                                        <span style="color:red">*</span>
                                                        {{Form::text('custom_field_title_1',old('custom_field_title_1'),array('class'=>'form-control','placeholder'=>'Enter '.$store_payment_setting['custom_field_title_1'],'required'=>'required'))}}
                                                    </div>
                                                </div>
                                                @endif
                                                @if(!empty($store_payment_setting['custom_field_title_2']))
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        {{Form::label('custom_field_title_2',$store_payment_setting['custom_field_title_2'],array("class"=>"form-control-label")) }}
                                                        <span style="color:red">*</span>
                                                        {{Form::text('custom_field_title_2',old('custom_field_title_2'),array('class'=>'form-control','placeholder'=>'Enter '.$store_payment_setting['custom_field_title_1'],'required'=>'required'))}}
                                                    </div>
                                                </div>
                                                @endif
                                                @if(!empty($store_payment_setting['custom_field_title_3']))
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        {{Form::label('custom_field_title_3',$store_payment_setting['custom_field_title_3'],array("class"=>"form-control-label")) }}
                                                        <span style="color:red">*</span>
                                                        {{Form::text('custom_field_title_3',old('custom_field_title_3'),array('class'=>'form-control','placeholder'=>'Enter '.$store_payment_setting['custom_field_title_1'],'required'=>'required'))}}
                                                    </div>
                                                </div>
                                                @endif
                                                @if(!empty($store_payment_setting['custom_field_title_4']))
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        {{Form::label('custom_field_title_4',$store_payment_setting['custom_field_title_4'],array("class"=>"form-control-label")) }}
                                                        <span style="color:red">*</span>
                                                        {{Form::text('custom_field_title_4',old('custom_field_title_4'),array('class'=>'form-control','placeholder'=>'Enter '.$store_payment_setting['custom_field_title_1'],'required'=>'required'))}}
                                                    </div>
                                                </div>
                                                @endif
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        {{Form::label('billingaddress',__('Address'),array("class"=>"form-control-label")) }}
                                                        <span style="color:red">*</span>
                                                        {{Form::text('billing_address',old('billing_address'),array('class'=>'form-control','placeholder'=>__('Billing Address'),'required'=>'required'))}}
                                                    </div>
                                                </div>
                                                {{--  @php
                                                    $ip = $_SERVER['REMOTE_ADDR'];
                                                    $freegeoipjson = file_get_contents("http://freegeoip.net/json/". $ip ."");
                                                    $jsondata = json_decode($freegeoipjson);
                                                    if(!empty($jsondata)){
                                                        $countryfromip = $jsondata->country_name;
                                                    }
                                                @endphp       --}}
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        {{Form::label('billing_country',__('Country'),array("class"=>"form-control-label")) }}
                                                        <span style="color:red">*</span>

                                                        {{Form::text('billing_country',old('billing_country'),array('class'=>'form-control','placeholder'=>__('Billing Country'),'required'=>'required'))}}
                                                    </div>
                                                </div>
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        {{Form::label('billing_city',__('City'),array("class"=>"form-control-label")) }}
                                                        <span style="color:red">*</span>
                                                         {{Form::text('billing_city',old('billing_city'),array('class'=>'form-control','placeholder'=>__('Billing City'),'required'=>'required'))}}


                                                    </div>
                                                </div>
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        {{Form::label('billing_postalcode',__('Postal Code'),array("class"=>"form-control-label")) }}
                                                        <span style="color:red">*</span>
                                                        {{Form::text('billing_postalcode',old('billing_postalcode'),array('class'=>'form-control','placeholder'=>__('Billing Postal Code'),'required'=>'required'))}}
                                                    </div>
                                                </div>
                                                @if($store->enable_shipping == "on" && $shippings->count() > 0)
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        {{Form::label('location_id',__('Location'),array("class"=>"form-control-label")) }}
                                                        <span style="color:red">*</span>
                                                        {{ Form::select('location_id', $locations, null,array('class' => 'form-control change_location','required'=>'required')) }}
                                                    </div>
                                                </div>
                                                @endif
                                                <div class="col-md-12 col-12">
                                                    <div class="row align-items-center">
                                                        <div class="col-md-6 col-12">
                                                            <div class="customer-info">
                                                                <h5>{{__('Shipping informations')}}</h5>
                                                                <p>{{__('Fill the form below so we can send you the orders invoice.')}}
                                                                </p>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6 col-12">
                                                            <div class="addres-btn text-right">
                                                                <a class=" btn btn-success" onclick="billing_data()"
                                                                    id="billing_data" data-toggle="tooltip"
                                                                    data-placement="top" title="Same As Billing Address">
                                                                    <span
                                                                        class="btn-inner--text">{{__('Copy Address')}}</span>
                                                                </a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-12 col-12">
                                                    <div class="form-group">
                                                        {{Form::label('shipping_address',__('Address'),array("class"=>"form-control-label")) }}
                                                        {{Form::text('shipping_address',old('shipping_address'),array('class'=>'form-control','placeholder'=>__('Shipping Address')))}}
                                                    </div>
                                                </div>
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        {{Form::label('shipping_country',__('Country'),array("class"=>"form-control-label")) }}
                                                        {{Form::text('shipping_country',old('shipping_country'),array('class'=>'form-control','placeholder'=>__('Shipping Country')))}}
                                                    </div>
                                                </div>
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        {{Form::label('shipping_city',__('City'),array("class"=>"form-control-label")) }}
                                                        {{Form::text('shipping_city',old('shipping_city'),array('class'=>'form-control','placeholder'=>__('Shipping City')))}}
                                                    </div>
                                                </div>
                                                <div class="col-md-6 col-12">
                                                    <div class="form-group">
                                                        {{Form::label('shipping_postalcode',__('Postal Code'),array("class"=>"form-control-label")) }}
                                                        {{Form::text('shipping_postalcode',old('shipping_postalcode'),array('class'=>'form-control','placeholder'=>__('Shipping Postal Code')))}}
                                                    </div>
                                                </div>
                                            </div>
                                            {{-- <a href="#" class="btn btn-success btn-lg btn-block mt-3" type="button"
                                                data-toggle="collapse" data-target="#collapsefour" aria-expanded="true"
                                                aria-controls="collapsefour">Continue</a> --}}
                                            <button class="btn btn-success btn-lg btn-block mt-3" type="submit" id="shipping">Continue</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="card border-0 osahan-accor rounded shadow-sm overflow-hidden mt-3">

                        <div class="card-header bg-white border-0 p-0" id="headingfour">
                            <h2 class="mb-0">
                                <a
                                    class="btn d-flex align-items-center bg-white btn-block text-left btn-lg h5 px-3 py-4 m-0"
                                    href="{{route('store-payment.payment',$store->slug)}}" >
                                    <span class="c-number">3</span> Payment
                            </a>
                            </h2>
                        </div>

                        <div id="collapsefour" class="collapse" aria-labelledby="headingfour"
                            data-parent="#accordionExample">
                            <div class="card-body px-3 pb-3 pt-1 border-top">
                                <div class="schedule">
                                    <ul class="nav nav-tabs justify-content-center nav-fill" id="myTab"
                                        role="tablist">
                                        <li class="nav-item" role="presentation">
                                            <a class="nav-link active text-dark" id="credit-tab" data-toggle="tab"
                                                href="#credit" role="tab" aria-controls="credit"
                                                aria-selected="true">
                                                <p class="mb-0 font-weight-bold"><i
                                                        class="icofont-credit-card mr-2"></i> Credit/Debit Card</p>
                                            </a>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <a class="nav-link text-dark" id="banking-tab" data-toggle="tab"
                                                href="#banking" role="tab" aria-controls="banking"
                                                aria-selected="false">
                                                <p class="mb-0 font-weight-bold"><i class="icofont-globe mr-2"></i>
                                                    Net Banking</p>
                                            </a>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <a class="nav-link text-dark" id="cash-tab" data-toggle="tab"
                                                href="#cash" role="tab" aria-controls="cash" aria-selected="false">
                                                <p class="mb-0 font-weight-bold"><i class="icofont-dollar mr-2"></i>
                                                    Cash on Delivery</p>
                                            </a>
                                        </li>
                                    </ul>
                                    <div class="tab-content bg-white" id="myTabContent">
                                        <div class="tab-pane fade show active" id="credit" role="tabpanel"
                                            aria-labelledby="credit-tab">
                                            <div class="osahan-card-body pt-3">
                                                <h6 class="m-0">Add new card</h6>
                                                <p class="small">WE ACCEPT <span
                                                        class="osahan-card ml-2 font-weight-bold">( Master Card /
                                                        Visa Card / Rupay )</span></p>
                                                <form>
                                                    <div class="form-row">
                                                        <div class="col-md-12 form-group">
                                                            <label class="form-label font-weight-bold small">Card
                                                                number</label>
                                                            <div class="input-group">
                                                                <input placeholder="Card number" type="number"
                                                                    class="form-control">
                                                                <div class="input-group-append"><button
                                                                        id="button-addon2" type="button"
                                                                        class="btn btn-outline-secondary"><i
                                                                            class="icofont-credit-card"></i></button>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-8 form-group"><label
                                                                class="form-label font-weight-bold small">Valid
                                                                through(MM/YY)</label><input
                                                                placeholder="Enter Valid through(MM/YY)"
                                                                type="number" class="form-control"></div>
                                                        <div class="col-md-4 form-group"><label
                                                                class="form-label font-weight-bold small">CVV</label><input
                                                                placeholder="Enter CVV Number" type="number"
                                                                class="form-control"></div>
                                                        <div class="col-md-12 form-group"><label
                                                                class="form-label font-weight-bold small">Name on
                                                                card</label><input placeholder="Enter Card number"
                                                                type="text" class="form-control"></div>
                                                        <div class="col-md-12 form-group">
                                                            <div class="custom-control custom-checkbox">
                                                                <input type="checkbox" id="custom-checkbox1"
                                                                    class="custom-control-input">
                                                                <label title="" type="checkbox"
                                                                    for="custom-checkbox1"
                                                                    class="custom-control-label small pt-1">Securely
                                                                    save this card for a faster checkout next
                                                                    time.</label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                        <div class="tab-pane fade" id="banking" role="tabpanel"
                                            aria-labelledby="banking-tab">
                                            <div class="osahan-card-body pt-3">
                                                <form>
                                                    <div class="btn-group btn-group-toggle w-100"
                                                        data-toggle="buttons">
                                                        <label class="btn btn-outline-secondary active">
                                                            <input type="radio" name="options" id="option1"
                                                                checked=""> HDFC
                                                        </label>
                                                        <label class="btn btn-outline-secondary">
                                                            <input type="radio" name="options" id="option2"> ICICI
                                                        </label>
                                                        <label class="btn btn-outline-secondary">
                                                            <input type="radio" name="options" id="option3"> AXIS
                                                        </label>
                                                    </div>
                                                    <div class="form-row pt-3">
                                                        <div class="col-md-12 form-group">
                                                            <label class="form-label small font-weight-bold">Select
                                                                Bank</label><br>
                                                            <select class="custom-select form-control">
                                                                <option>Bank</option>
                                                                <option>KOTAK</option>
                                                                <option>SBI</option>
                                                                <option>UCO</option>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                        <div class="tab-pane fade" id="cash" role="tabpanel"
                                            aria-labelledby="cash-tab">
                                            <div class="custom-control custom-checkbox pt-3">
                                                <input type="checkbox" class="custom-control-input"
                                                    id="customControlAutosizing">
                                                <label class="custom-control-label" for="customControlAutosizing">
                                                    <b>Cash</b><br>
                                                    <p class="small text-muted m-0">Please keep exact change handy
                                                        to help us serve you better</p>
                                                </label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <a href="checkout.html" class="btn btn-success btn-lg btn-block mt-3"
                                    type="button">Continue</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="sticky_sidebar">
                    <div class="bg-white rounded overflow-hidden shadow-sm mb-3 checkout-sidebar">
                        @if(Auth::guard('customers')->check())
                        <div class="d-flex align-items-center osahan-cart-item-profile border-bottom bg-white p-3">
                            <img alt="{{ Auth::guard('customers')->user()->name }}" src="{{ Utility::get_file('uploads/customerprofile/'.Auth::guard('customers')->user()->avatar) }}" class="mr-3 rounded-circle img-fluid">
                            <div class="d-flex flex-column">
                                <h6 class="mb-1 font-weight-bold">{{ ucFirst(Auth::guard('customers')->user()->name) }}</h6>
                            </div>
                        </div>
                        @endif
                        <div class="align-items-center osahan-cart-item-profile border-bottom bg-white p-3">
                                <label for="stripe_coupon">{{__('Coupon')}}</label>
                                <input type="text" id="stripe_coupon" name="coupon" class="form-control coupon hidd_val" placeholder="{{ __('Enter Coupon Code') }}">
                                <input type="hidden" name="coupon" class="form-control hidden_coupon" value="">
                                <div class="apply-stripe-btn-coupon mt-2 ">
                                    <a href="#" class="btn btn-success apply-coupon btn-sm">{{ __('Apply') }}</a>
                                </div>
                        </div>
                        <div>

                                <div class="card-body pr-4 pl-4 pb-0 pt-2">
                                    @if(!empty($products))
                                        @php
                                            $total = 0;
                                            $sub_tax = 0;
                                            $sub_total= 0;
                                        @endphp
                                        @foreach($products as $product)
                                            @if(isset($product['variant_id']) && !empty($product['variant_id']))
                                                <div class="row delimiter-bottom">
                                                    <div class="col-8">
                                                        <div class="media align-items-center">

                                                            @if(!empty($product['image']))
                                                                <img alt="" src="{{asset(Storage::url('uploads/is_cover_image/'.$product['image']))}}" class="img-fluid" width="42px">
                                                            @else
                                                                <img alt="" src="{{asset(Storage::url('uploads/is_cover_image/default.jpg'))}}" class="img-fluid" width="42px">
                                                            @endif
                                                            <div class="media-body p-2">
                                                                <div class="sum-title lh-100">
                                                                    <small class="font-weight-bold mb-0 TTNorms">{{$product['product_name'].' - ( ' . $product['variant_name'] .' ) '}}</small>

                                                                </div>
                                                                @php
                                                                    $total_tax=0;
                                                                @endphp
                                                                <small class="text-muted s-dim text-primary">
                                                                    {{$product['quantity']}} x {{\App\Models\Utility::priceFormat($product['variant_price'])}}
                                                                    @if(!empty($product['tax']))
                                                                        +
                                                                        @foreach($product['tax'] as $tax)
                                                                            @php
                                                                                $sub_tax = ($product['variant_price'] * $product['quantity'] * $tax['tax']) / 100;
                                                                                $total_tax += $sub_tax;
                                                                            @endphp

                                                                            {{\App\Models\Utility::priceFormat($sub_tax).' ('.$tax['tax_name'].' '.($tax['tax']).'%)'}}
                                                                        @endforeach
                                                                    @endif
                                                                </small>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-4 text-right lh-100">
                                                        <small class="text-muted s-dim text-dark">{{__('Price')}}</small>
                                                        <p class="text-dark s-rate t-black15 text-primary s-rate">
                                                            @php
                                                                $totalprice = $product['variant_price'] * $product['quantity'] + $total_tax;
                                                                $subtotal = $product['variant_price'] * $product['quantity'];
                                                                $sub_total += $subtotal;
                                                            @endphp
                                                            {{\App\Models\Utility::priceFormat($totalprice)}}
                                                        </p>
                                                        @php
                                                            $total += $totalprice;
                                                        @endphp
                                                    </div>
                                                </div>
                                            @else
                                                <div class="row delimiter-bottom">
                                                    <div class="col-8">
                                                        <div class="d-flex  align-items-center">
                                                            @if(!empty($product['image']))
                                                            <img alt="" src="{{asset(Storage::url('uploads/is_cover_image/'.$product['image']))}}" class="img-fluid" width="42px">
                                                        @else
                                                            <img alt="" src="{{asset(Storage::url('uploads/is_cover_image/default.jpg'))}}" class="img-fluid"  width="42px">
                                                        @endif
                                                            <div class="media-body p-2">
                                                                <div class="sum-title lh-100">
                                                                    <small class="font-weight-bold mb-0 TTNorms">{{$product['product_name']}}</small>
                                                                </div>
                                                                @php
                                                                    $total_tax=0;
                                                                @endphp
                                                                <small class="text-muted s-dim">
                                                                    {{$product['quantity']}} x {{\App\Models\Utility::priceFormat($product['price'])}}
                                                                    @if(!empty($product['tax']))
                                                                        +
                                                                        @foreach($product['tax'] as $tax)
                                                                            @php
                                                                                $sub_tax = ($product['price'] * $product['quantity'] * $tax['tax']) / 100;
                                                                                $total_tax += $sub_tax;
                                                                            @endphp

                                                                            {{\App\Models\Utility::priceFormat($sub_tax).' ('.$tax['tax_name'].' '.($tax['tax']).'%)'}}
                                                                        @endforeach
                                                                    @endif
                                                                </small>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="col-4 text-right lh-100">
                                                        <small class="text-muted s-dim text-dark">{{__('Price')}}</small>
                                                        <p class="text-dark s-rate t-black15">
                                                            @php
                                                                $totalprice = $product['price'] * $product['quantity'] + $total_tax;
                                                                $subtotal = $product['price'] * $product['quantity'];
                                                                $sub_total += $subtotal;
                                                            @endphp
                                                            {{\App\Models\Utility::priceFormat($totalprice)}}
                                                        </p>
                                                        @php
                                                            $total += $totalprice;
                                                        @endphp
                                                    </div>
                                                </div>
                                            @endif
                                        @endforeach
                                </div>
                                <div class="card-body pt-0 border-top">
                                    <!-- Tax -->

                                    @foreach($taxArr['tax'] as $k=>$tax)
                                        <div class="row mt-2 pt-2 p-2 border-top">
                                            <div class="col-7 text-right">
                                                <div class="media align-items-center">
                                                    <div class="media-body">
                                                        <div class="text-limit lh-100">
                                                            <small class="font-weight-bold mb-0">{{$tax}}</small>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-5 text-right">
                                                <span class="text-sm t-black15">{{\App\Models\Utility::priceFormat($taxArr['rate'][$k])}}</span>
                                            </div>
                                        </div>
                                    @endforeach



                                    <!-- Shipping -->
                                    @if($store->enable_shipping == "on")
                                        <div class="shipping_price_add" style="display: none">
                                            <div class="row mt-2 pt-2 p-2 border-top">
                                                <div class="col-7 text-right pt-2">
                                                    <div class="media align-items-center">
                                                        <div class="media-body text-dark">
                                                            <div class="font-weight-bold TTNorms">{{__('Shipping Price')}} :</div>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-5 text-right text-dark"><span class="text-sm font-weight-bold shipping_price" data-value=""></span></div>
                                            </div>
                                        </div>
                                    @endif


                                </div>
                                @endif
                            </div>
                            <div class="bg-white p-3 clearfix">

                                <p class="mb-1">Subtotal (Before Tax) <span class="small text-muted">({{$total_item}} item)</span> <span
                                        class="float-right text-dark">{{\App\Models\Utility::priceFormat(!empty($total)?$total:0)}}</span></p>



                                <p class="mb-1">Tax : <span class="float-right text-dark">{{\App\Models\Utility::priceFormat($main_tax)}}</span></p>
                                <p class="mb-1">Coupon : <span class="float-right text-dark dicount_price">{{\App\Models\Utility::priceFormat(0)}}</span></p>
                            </div>
                            <div class="p-3 border-top">
                                <input type="hidden" class="product_total" value="{{$total}}">
                                <input type="hidden" class="total_pay_price" value="{{App\Models\Utility::priceFormat($total)}}">
                                <h5 class="mb-0 ">TO PAY
                                    <span class="final_total_price">
                                        <span class="float-right text-danger pro_total_price"  data-original="{{\App\Models\Utility::priceFormat(!empty($total)?$total:0)}}">{{\App\Models\Utility::priceFormat(!empty($total)?$total:'0')}}</span>
                                    </span>
                                </h5>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        {{Form::close()}}
    </div>
</section>
@endsection
@push('script-page')
{{--<script src="{{asset('assets/theme3/js/all.min.js')}}"></script>--}}
{{-- <script src="{{asset('assets/theme3/js/purpose.core.js')}}"></script> --}}
<script src="{{asset('assets/theme3/js/swiper.min.js')}}"></script>
<script src="{{asset('assets/theme3/js/purpose.js')}}"></script>
<script src="{{asset('custom/js/custom.js')}}"></script>
<script src="{{ asset('custom/libs/bootstrap-notify/bootstrap-notify.min.js')}}"></script>


@stack('script-page')
@if(Session::has('success'))
    <script>
        show_toastr('{{__('Success')}}', '{!! session('success') !!}', 'success');
    </script>
    {{ Session::forget('success') }}
@endif
@if(Session::has('error'))
    <script>
        show_toastr('{{__('Error')}}', '{!! session('error') !!}', 'error');
    </script>
    {{ Session::forget('error') }}
@endif
@php
    $store_settings = \App\Models\Store::where('slug',$store->slug)->first();
@endphp
<script async src="https://www.googletagmanager.com/gtag/js?id={{$store_settings->google_analytic}}"></script>
{!! $store_settings->storejs !!}
<script>
    function billing_data() {
        $("[name='shipping_address']").val($("[name='billing_address']").val());
        $("[name='shipping_city']").val($("[name='billing_city']").val());
        $("[name='shipping_state']").val($("[name='billing_state']").val());
        $("[name='shipping_country']").val($("[name='billing_country']").val());
        $("[name='shipping_postalcode']").val($("[name='billing_postalcode']").val());
    }

    $(document).ready(function () {
        $('.change_location').trigger('change');

        setTimeout(function () {
            var shipping_id = $("input[name='shipping_id']:checked").val();
            getTotal(shipping_id);
        }, 200);
    });

    $(document).on('change', '.shipping_mode', function () {
        var shipping_id = this.value;
        getTotal(shipping_id);
    });

    function getTotal(shipping_id) {
        var pro_total_price = $('.pro_total_price').attr('data-original');
        if (shipping_id == undefined) {
            $('.shipping_price_add').hide();
            return false
        } else {
            $('.shipping_price_add').show();
        }

        $.ajax({
            url: '{{ route('user.shipping', [$store->slug,'_shipping'])}}'.replace('_shipping', shipping_id),
            data: {
                "pro_total_price": pro_total_price,
                "_token": "{{ csrf_token() }}",
            },
            method: 'POST',
            context: this,
            dataType: 'json',

            success: function (data) {
                var price = data.price + pro_total_price;
                $('.shipping_price').html(data.price);
                $('.shipping_price').attr('data-value', data.price);
                $('.pro_total_price').html(data.total_price);
            }
        });
    }

    $(document).on('change', '.change_location', function () {
        var location_id = $('.change_location').val();

        if (location_id == 0) {
            $('#location_hide').hide();

        } else {
            $('#location_hide').show();

        }

        $.ajax({
            url: '{{ route('user.location', [$store->slug,'_location_id'])}}'.replace('_location_id', location_id),
            data: {
                "_token": "{{ csrf_token() }}",
            },
            method: 'POST',
            context: this,
            dataType: 'json',

            success: function (data) {
                var html = '';
                var shipping_id = '{{(isset($cust_details['shipping_id']) ? $cust_details['shipping_id'] : '')}}';
                $.each(data.shipping, function (key, value) {
                    var checked = '';
                    if (shipping_id != '' && shipping_id == value.id) {
                        checked = 'checked';
                    }

                    html += '<div class="shipping_location"><input type="radio" name="shipping_id" data-id="' + value.price + '" value="' + value.id + '" id="shipping_price' + key + '" class="shipping_mode" ' + checked + '>' +
                        ' <label name="shipping_label" for="shipping_price' + key + '" class="shipping_label"> ' + value.name + '</label></div>';

                });
                $('#shipping_location_content').html(html);
            }
        });
    });

    $(document).on('click', '.apply-coupon', function (e) {
        e.preventDefault();

        var ele = $(this);
        var coupon = ele.closest('.row').find('.coupon').val();
        var hidden_field = $('.hidden_coupon').val();
        var price = $('#card-summary .product_total').val();
        var shipping_price = $('#card-summary .shipping_price').attr('data-value');

        if (coupon == hidden_field && coupon != "") {
            show_toastr('Error', 'Coupon Already Used', 'error');
        } else {
            if (coupon != '') {
                $.ajax({
                    url: '{{route('apply.productcoupon')}}',
                    datType: 'json',
                    data: {
                        price: price,
                        shipping_price: shipping_price,
                        store_id: {{$store->id}},
                        coupon: coupon
                    },
                    success: function (data) {
                        $('#stripe_coupon, #paypal_coupon').val(coupon);
                        if (data.is_success) {
                            $('.hidden_coupon').val(coupon);
                            $('.hidden_coupon').attr(data);

                            $('.dicount_price').html(data.discount_price);

                            var html = '';
                            html += '<span class="float-right text-danger pro_total_price" data-original="' + data.final_price_data_value + '">' + data.final_price + '</span>'
                            $('.final_total_price').html(html);


                            // $('.coupon-tr').show().find('.coupon-price').text(data.discount_price);
                            // $('.final-price').text(data.final_price);
                            show_toastr('Success', data.message, 'success');
                        } else {
                            // $('.coupon-tr').hide().find('.coupon-price').text('');
                            // $('.final-price').text(data.final_price);
                            show_toastr('Error', data.message, 'error');
                        }
                    }
                })
            } else {
                $.ajax({
                        url: '{{route('apply.removecoupn')}}',
                        datType: 'json',
                        data: {
                            price: "price",
                            shipping_price: "shipping_price",
                            slug:{{$store->id}} ,
                            coupon: "coupon"
                        },
                        success: function (data) {
                        }
                    });
                    var hidd_cou = $('.hidd_val').val();

                    if(hidd_cou == ""){
                       var total_pa_val =  $(".total_pay_price").val();
                       $(".final_total_price").html(total_pa_val);
                       $(".dicount_price").html(0.00);

                    }
                    show_toastr('Error', '{{__('Invalid Coupon Code.')}}', 'error');
            }
        }

    });
</script>
@endpush
