@extends('storefront.layout.theme')
@section('page-title')
{{ __('Home') }}
@endsection
@push('css-page')
<style>
    .p-tablist .nav-tabs .nav-item .active {
        color: #fff !important;
        background-color: #28a745!important;
    }

    .p-tablist .nav-tabs .nav-item .nav-link {
        border-radius: 25px;
        padding: 10px;

    }

    .nav-tabs {
        border-bottom: none;
    }

</style>
@endpush
@php
$imgpath=\App\Models\Utility::get_file('uploads/is_cover_image/');

@endphp
@section('content')
<!-- Products -->
@if ($products['Start shopping']->count() > 0)
<section class="py-4 osahan-main-body">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="osahan-listing">
                    <div class="d-flex align-items-center mb-3">
                        <h4>{{ __('Products') }}</h4>
                        {{-- <div class="m-0 text-center ml-auto">
                            <a href="#" data-toggle="modal" data-target="#exampleModal"
                                class="btn text-muted bg-white mr-2"><i class="icofont-filter mr-1"></i> Filter</a>
                            <a href="#" data-toggle="modal" data-target="#exampleModal"
                                class="btn text-muted bg-white"><i class="icofont-signal mr-1"></i> Sort</a>
                        </div> --}}
                    </div>
                    <div class="p-tablist">
                        <ul class="nav nav-tabs" id="myTab" role="tablist">
                            @foreach ($categories as $key => $category)
                            <li class="nav-item">
                                <a href="#{!! preg_replace('/[^A-Za-z0-9\-]/', '_', $category) !!}" data-id="{{ $key }}"
                                    class=" {{ $category == $categorie_name ? 'active' : '' }} btn text-muted bg-white mr-2"
                                    id="electronic-tab" data-toggle="tab" role="tab" aria-controls="home"
                                    aria-selected="false">
                                    {{ $category }}
                                </a>
                            </li>
                            @endforeach
                        </ul>
                    </div>
                    <div class="tab-content bestsellers-tabs mt-2" id="myTabContent">
                        @foreach ($products as $key => $items)
                        <div class="tab-pane fade {{ $key == $categorie_name ? 'active show' : '' }}" id="{!! preg_replace('/[^A-Za-z0-9\-]/', '_', $key) !!}" role="tabpanel" aria-labelledby="shopping-tab">
                            <div class="col-lg-12 p-1">
                                <div class="row">
                                    @if ($items->count() > 0)
                                        @foreach ($items as $product)
                                            <div class="col-6 col-md-3 mb-3">
                                                <div class="list-card bg-white h-100 rounded overflow-hidden position-relative shadow-sm">
                                                    <div class="list-card-image">
                                                        <a href="{{ route('store.product.product_view', [$store->slug, $product->id]) }}" class="text-dark">
                                                            <div class="p-3">
                                                                @if (!empty($product->is_cover) &&
                                                                \Storage::exists('uploads/is_cover_image/' . $product->is_cover))
                                                                <img class="img-fluid item-img w-100 mb-3" src="{{ $imgpath . $product->is_cover}}" alt="New collection"
                                                                    title="New collection">
                                                                @else
                                                                <img class="img-fluid item-img w-100 mb-3" src="{{ asset(Storage::url('uploads/is_cover_image/default.jpg')) }}"
                                                                    alt="New collection" title="New collection">
                                                                @endif
                                                                <h6>{{ $product->name }}</h6>
                                                                <div class="d-flex align-items-center">
                                                                    @if ($product['enable_product_variant'] != 'on')
                                                                        <h6 class="price m-0 text-success">{{ \App\Models\Utility::priceFormat($product->price) }}</h6>


                                                                        <a data-toggle="collapse" href="#" role="button"
                                                                        data-id="{{ $product['id'] }}"
                                                                            class="btn btn-success btn-sm ml-auto add_to_cart">
                                                                            +
                                                                        </a>
                                                                    @else
                                                                    <h6 class="price m-0 text-success">{{ __('In Variant') }}</h6>


                                                                    <a  href="{{ route('store.product.product_view', [$store->slug, $product['id']]) }}" role="button"
                                                                    data-id="{{ $product['id'] }}"
                                                                        class="btn btn-success btn-sm ml-auto">
                                                                        +
                                                                    </a>
                                                                    @endif
                                                                </div>
                                                            </div>
                                                        </a>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    @else
                                    <div class="col-12 product-box">
                                        <div class="card card-product">
                                            <h6 class="m-0 text-center no_record"><i class="fas fa-ban"></i>
                                                {{ __('No Record Found') }}</h6>
                                        </div>
                                    </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

@else
<div class="container mt-10 mb-5">
    {{ __('No data found') }}
</div>
@endif
@endsection
@push('script-page')
{!! $storethemesetting['storejs'] !!}

<script>
    $(".productTab").click(function (e) {
        e.preventDefault();
        $('.productTab').removeClass('active')

    });

    $("#pro_scroll").click(function () {
        $('html, body').animate({
            scrollTop: $("#pro_items").offset().top
        }, 1000);
    });

</script>
@endpush
