@extends('storefront.layout.theme')
@section('page-title')
    {{ __('Home') }}
@endsection
@php
$imgpath=\App\Models\Utility::get_file('uploads/');
$productImg = \App\Models\Utility::get_file('uploads/is_cover_image/');
$catimg = \App\Models\Utility::get_file('uploads/product_image/');
$default =\App\Models\Utility::get_file('uploads/theme4/header/brand_logo.png');
$s_logo = \App\Models\Utility::get_file('uploads/store_logo/');
$settings = Utility::settings();

$getStoreThemeSetting = Utility::getStoreThemeSetting($store->id, $store->theme_dir);
$getStoreThemeSetting1 = [];

if (!empty($getStoreThemeSetting['dashboard'])) {
$getStoreThemeSetting = json_decode($getStoreThemeSetting['dashboard'], true);
$getStoreThemeSetting1 = Utility::getStoreThemeSetting($store->id, $store->theme_dir);
}

if (empty($getStoreThemeSetting)) {
$path = storage_path() . '/uploads/' . $store->theme_dir . '/' . $store->theme_dir . '.json';

$getStoreThemeSetting = json_decode(file_get_contents($path), true);
}
$parts = collect($getStoreThemeSetting);
// dd($parts);
@endphp
@section('content')
<section class="py-4 osahan-main-body">

    <div class="container">
       <div class="row">
          <div class="col-lg-12">
             <div class="osahan-home-page">
                <div class="osahan-body">
                    @php
                        $category_section = $parts->where('section_name','Home-Categories')->first();
                    @endphp
                    @if(!empty($category_section) && $category_section['section_enable'] == 'on')
                        <div class="pt-3 pb-2  osahan-categories">
                            <div class="d-flex align-items-center mb-2">
                                <h5 class="m-0">{{  $category_section['inner-list'][0]['field_default_text'] }}</h5>
                            </div>
                            <div class="categories-slider">
                                @foreach ($pro_categories as $key => $pro_categorie)

                                <div class="col-c">
                                    <div class="bg-white shadow-sm rounded text-center my-2 px-2 py-3 c-it">
                                        <a href="{{ route('store.categorie.product', [$store->slug, $pro_categorie->name]) }}">
                                            @if (!empty($pro_categorie->categorie_img) )
                                            <img src="{{ $catimg . (!empty($pro_categorie->categorie_img) ? $pro_categorie->categorie_img : 'default.jpg') }}"
                                                class="img-fluid px-2 mx-auto">
                                            @else
                                            <img src="{{ asset(Storage::url('uploads/product_image/default.jpg')) }}"
                                                class="img-fluid px-2 mx-auto">
                                            @endif
                                            <p class="m-0 pt-2 text-muted text-center">{{ $pro_categorie->name }}</p>
                                        </a>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        </div>
                    @endif


                    @php
                    $Promotions_section = $parts->where('section_name','Home-Promotions');
                    // dd($Promotions_section);
                    @endphp
                    @if(!empty($Promotions_section) && $Promotions_section[2]['section_enable'] == 'on')
                    <div class="py-3 osahan-promos">
                        <div class="d-flex align-items-center mb-3">
                            <h5 class="m-0">{{ $Promotions_section[2]['inner-list'][0]['field_default_text'] }}</h5>
                            <a href="promos.html" class="ml-auto btn btn-outline-success btn-sm">See more</a>
                        </div>
                        <div class="promo-slider pb-0 mb-0">
                            @foreach ($Promotions_section[3]['homepage-promotions-images'] as $images)

                            <div class="osahan-slider-item mx-2">
                                <a >
                                    <img src=" {{ asset(Storage::url('uploads/'.$images['field_prev_text'])) }}" class="img-fluid mx-auto rounded" alt="Responsive image">
                                </a>
                            </div>
                            @endforeach
                        </div>
                    </div>
                    @endif

                    @php
                    $latest_section = $parts->where('section_name','Home-Latest')->first();

                    @endphp
                    @if(!empty($latest_section) && $latest_section['section_enable'] == 'on')
                   <div class="title d-flex align-items-center py-3">
                      <h5 class="m-0">{{ $latest_section['inner-list'][0]['field_default_text'] }}</h5>
                   </div>
                   <div class="pick_today">
                      <div class="row">
                        @foreach ($latestProduct1 as $product)
                        <div class="col-6 col-md-3 mb-3">
                            <div class="list-card bg-white h-100 rounded overflow-hidden position-relative shadow-sm">
                                <div class="list-card-image">
                                    <a href="{{ route('store.product.product_view', [$store->slug,$product->id]) }}" class="text-dark">
                                        <div class="p-3">
                                            @if (!empty($product->is_cover))
                                                <img alt="Image placeholder" src="{{ $productImg . $product->is_cover }}" class="img-fluid item-img w-100 mb-3">
                                            @else
                                                <img alt="Image placeholder" src="{{ asset(Storage::url('uploads/is_cover_image/default.jpg')) }}" class="img-fluid item-img w-100 mb-3">
                                            @endif

                                            <h6>{{ $product->name }}</h6>
                                            <div class="d-flex align-items-center">
                                                <h6 class="price m-0 text-success">
                                                @if ($product->enable_product_variant != 'on')
                                                    {{ \App\Models\Utility::priceFormat($product->price) }}
                                                </h6>
                                                    <a href="#" class="btn btn-success btn-sm ml-auto add_to_cart" data-id="{{ $product->id }}">+</a>
                                                @else
                                                    {{ __('In variant') }}
                                                </h6>
                                                    <a href="{{ route('store.product.product_view', [$store->slug, $product['id']]) }}" class="btn btn-success btn-sm ml-auto">+</a>
                                                @endif



                                            </div>
                                        </div>
                                    </a>
                                </div>
                            </div>
                        </div>
                        @endforeach


                      </div>
                   </div>
                   @endif
                </div>
             </div>
          </div>
       </div>
    </div>
 </section>


@endsection
@push('script-page')
@endpush
