@extends('storefront.layout.theme')
@section('page-title')
    {{ __('Cart') }}
@endsection
@section('content')
@section('head-title')
    {{ __('Welcome') . ', ' . \Illuminate\Support\Facades\Auth::guard('customers')->user()->name }}
@endsection
@section('content')
@php
$cart = session()->get($store->slug);
$imgpath=\App\Models\Utility::get_file('uploads/is_cover_image/');
$s_logo = \App\Models\Utility::get_file('uploads/store_logo/');

@endphp

<nav aria-label="breadcrumb" class="breadcrumb mb-0">
    <div class="container">
        <ol class="d-flex align-items-center mb-0 p-0">
            <li class="breadcrumb-item"><a href="{{ url('/') }}" class="text-success">Home</a></li>
            <li class="breadcrumb-item active" aria-current="page">My Cart</li>
        </ol>
    </div>
</nav>

<section class="py-4 osahan-main-body">
    <div class="container">
        <div class="row">
            <div class="col-lg-4">
                @include('storefront.theme.customer.sidebar')
            </div>
            <div class="col-lg-8 p-4 bg-white rounded shadow-sm">
                <h4 class="mb-4 profile-title">My account</h4>
                <div id="edit_profile">
                    <div class="p-0">
                        @php
                            $profile=asset(Storage::url('uploads/profile/'));
                        @endphp
                        {{Form::model($userDetail,array('route' => array('customer.profile.update',$slug,$userDetail), 'method' => 'put', 'enctype' => "multipart/form-data"))}}

                            <div class="form-group">
                                <label for="exampleInputName1">Full Name</label>
                                {{Form::text('name',null,array('placeholder'=>__('Enter User Email'),'class'=>'form-control'))}}
                                @error('name')
                                    <span class="invalid-name" role="alert">
                                        <strong class="text-danger">{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            <div class="form-group">
                                <label for="exampleInputNumber1">Mobile Number</label>
                                {{Form::text('phone_number',null,array('placeholder'=>__('Enter User number'),'class'=>'form-control'))}}
                            </div>
                            <div class="form-group">
                                <label for="exampleInputEmail1">Email</label>
                                {{Form::text('email',null,array('placeholder'=>__('Enter User Email'),'class'=>'form-control'))}}
                            </div>
                            <div class="form-group">
                                <label for="exampleInputEmail1">Avatar</label>
                                <input type="file" name="profile" id="file-1" class="form-control">
                            </div>
                            <h4 class="mb-4 profile-title">Change Password</h4>
                            <div id="change_password">
                                <div class="p-0">
                                    <div class="form-group">
                                        <label for="current_password">{{__('Current Password')}}</label>
                                        {{Form::password('current_password',array('class'=>'form-control','placeholder'=>__('Enter Current Password')))}}
                                    </div>
                                    <div class="form-group">
                                        <label for="new_password">{{__('New Password')}}</label>
                                        {{Form::password('new_password',array('class'=>'form-control','placeholder'=>__('Enter New Password')))}}
                                        @error('new_password')
                                        <span class="invalid-new_password" role="alert">
                                            <strong class="text-danger">{{ $message }}</strong>
                                        </span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="confirm_password">{{__('Re-type New Password')}}</label>
                                        {{Form::password('confirm_password',array('class'=>'form-control','placeholder'=>__('Enter Re-type New Password')))}}
                                        @error('confirm_password')
                                        <span class="invalid-confirm_password" role="alert">
                                                <strong class="text-danger">{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                            </div>

                            <div class="text-center">
                                <button type="submit" class="btn btn-success btn-block btn-lg">Save Changes</button>
                            </div>
                        </form>
                    </div>

                </div>
            </div>
        </div>
    </div>
</section>

    @endsection

    @push('scripts')


    @endpush
