@extends('storefront.layout.theme')
@section('page-title')
    {{ __('Cart') }}
@endsection
@section('content')
@section('head-title')
    {{ __('Welcome') . ', ' . \Illuminate\Support\Facades\Auth::guard('customers')->user()->name }}
@endsection
@section('content')
<nav aria-label="breadcrumb" class="breadcrumb mb-0">
    <div class="container">
        <ol class="d-flex align-items-center mb-0 p-0">
            <li class="breadcrumb-item"><a href="{{ route('store.slug', $store->slug) }}" class="text-success">Home</a></li>
            <li class="breadcrumb-item active" aria-current="page">{{ __('My Orders') }}</li>
        </ol>
    </div>
</nav>

<section class="py-4 osahan-main-body">
    <div class="container">
        <div class="row">
            <div class="col-lg-4">
                @include('storefront.theme.customer.sidebar')
            </div>
            <div class="col-lg-8 ">
                <div class="tab-pane fade show active" id="completed" >
                    <div class="order-body">
                        @if (!empty($orders) && count($orders) > 0)
                            @foreach ($orders as $order)
                            <div class="pb-3">
                                <a href="{{ route('customer.order', [$store->slug, Crypt::encrypt($order->id)]) }}" class="text-decoration-none text-dark">
                                    <div class="p-3 rounded shadow-sm bg-white">
                                        <div class="d-flex align-items-center mb-3">
                                            @if ($order->status != 'Cancel Order')
                                            <p class=" {{ $order->status == 'pending' ? 'bg-warning ' : 'bg-success' }} text-white py-1 px-2 mb-0 rounded small">
                                                @if ($order->status == 'pending')
                                                    {{ __('Pending') }}
                                                @else
                                                    {{ __('Delivered') }}
                                                @endif
                                            </p>
                                            <p class="text-muted ml-auto small mb-0"><i class="icofont-clock-time"></i>
                                                @if ($order->status == 'pending')
                                                {{ \App\Models\Utility::dateFormat($order->created_at) }}
                                                @else
                                                {{ \App\Models\Utility::dateFormat($order->updated_at) }}
                                                @endif
                                            </p>

                                            @else
                                            <p class="bg-danger  {{ $order->status == 'pending' ? 'btn-soft-info' : 'btn-soft-success' }} text-white py-1 px-2 mb-0 rounded small">
                                                {{ __('Cancel Order') }}:
                                            </p>
                                            <p class="text-muted ml-auto small mb-0"><i class="icofont-clock-time"></i>
                                                {{ \App\Models\Utility::dateFormat($order->created_at) }}
                                            </p>
                                            @endif
                                        </div>




                                        <div class="d-flex">
                                            <p class="text-muted m-0">{{ __('Order') }}<br>
                                                <span class="text-dark font-weight-bold"><a href="{{ route('customer.order', [$store->slug, Crypt::encrypt($order->id)]) }}"
                                                    class=" text-dark">
                                                    <span class="btn-inner--text">{{ '#' . $order->order_id }}</span>
                                                </a></span>
                                            </p>
                                            <p class="text-muted m-0 ml-auto">{{ __('Date') }}<br>
                                                <span class="text-dark font-weight-bold">{{ \App\Models\Utility::dateFormat($order->created_at) }}</span>
                                            </p>
                                            <p class="text-muted m-0 ml-auto">{{ __('Value') }}<br>
                                                <span class="text-dark font-weight-bold">{{ \App\Models\Utility::priceFormat($order->price) }}</span>
                                            </p>
                                            <p class="text-muted m-0 ml-auto">{{ __('Payment Type') }}<br>
                                                <span class="text-dark font-weight-bold">{{ $order->payment_type }}</span>
                                            </p>
                                        </div>
                                    </div>
                                </a>
                            </div>
                            @endforeach
                        @else
                        <div class="my-5 py-5 px-3 text-center">
                            <h4>{{ __('Opps...') }}</h4>
                            <p>{!! __('No data Found.') !!} </p>
                        </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection
@push('script-page')
@endpush
