@extends('storefront.layout.theme')
@section('page-title')
    {{__('Product Details')}}
@endsection
@section('content')
    @php
        $cart = session()->get($store->slug);
        $imgpath=\App\Models\Utility::get_file('uploads/is_cover_image/');
    @endphp
  <nav aria-label="breadcrumb" class="breadcrumb mb-0">
        <div class="container">
            <ol class="d-flex align-items-center mb-0 p-0">
                <li class="breadcrumb-item"><a href="#" class="text-success">Home</a></li>
                <li class="breadcrumb-item active" aria-current="page">Cart</li>
            </ol>
        </div>
    </nav>

    <section class="py-4 osahan-main-body">
        <div class="container">
            @if(!empty($cart['products']) || $cart['products'] = [])
            <div class="row">
                <div class="col-lg-8">
                    <div class="accordion" id="accordionExample">

                        <div class="card border-0 osahan-accor rounded shadow-sm overflow-hidden">

                            <div class="card-header bg-white border-0 p-0" id="headingOne">
                                <h2 class="mb-0">
                                    <a
                                        class="btn d-flex align-items-center bg-white btn-block text-left btn-lg h5 px-3 py-4 m-0"
                                        type="button" href="{{route('store.cart',$store->slug)}}">
                                        <span class="c-number">1</span> Cart ({{ count($cart['products']) }} items)
                                </a>
                                </h2>
                            </div>

                            <div id="collapseOne" class="collapse show" aria-labelledby="headingOne"
                                data-parent="#accordionExample">
                                <div class="card-body p-0 border-top">
                                    <div class="osahan-cart">
                                        @if(!empty($products))
                                            @php
                                                $sub_tax = 0;
                                                $total = 0;
                                                $main_tax = 0;
                                            @endphp
                                            @foreach($products['products'] as $key => $product)
                                                @if($product['variant_id'] != 0 )

                                                 <div class="cart-items bg-white position-relative border-bottom" data-id="{{$key}}">
                                                    <div class="d-flex  align-items-center p-3">
                                                        <a href="{{route('store.product.product_view',[$store->slug,$product['id']])}}">
                                                            @if(!empty($product['image']))
                                                                <img alt="" src="{{$imgpath.$product['image']}}" class="img-fluid">
                                                            @else
                                                                <img alt="" src="{{asset(Storage::url('uploads/is_cover_image/default.jpg'))}}" class="img-fluid" >
                                                            @endif
                                                        </a>
                                                        <a href="{{route('store.product.product_view',[$store->slug,$product['id']])}}" class="ml-3 text-dark text-decoration-none w-100">

                                                            <div class="d-flex align-items-center" data-id="{{$key}}">
                                                                <h5 class="mb-1">{{$product['product_name'] .' - '. $product['variant_name']}}</h5>
                                                                <div id='myform'
                                                        class="cart-items-number d-flex ml-auto qty-spinner" data-id="{{$key}}">
                                                        <input type='button' value='-'
                                                            class='qtyminus btn btn-success btn-sm quantity-decrement qty-minus product_qty'
                                                            field='quantity' />
                                                        <input type='text' name='quantity'
                                                            class='qty form-control quantity product_qty_input bx-cart-qty'
                                                            data-cke-saved-name="quantity"
                                                            data-id="{{$product['product_id']}}"
                                                            value="{{$product['quantity']}}" id="product_qty" />
                                                        <input type='button' value='+'
                                                            class='qtyplus btn btn-success btn-sm quantity-increment qty-plus product_qty'
                                                            field='quantity' />
                                                            </div>
                                                            </div>
                                                            <p class="text-muted mb-1">TAX :
                                                                @php
                                                                $total_tax=0;
                                                                @endphp
                                                                @if(!empty($product['tax']))
                                                                    @foreach($product['tax'] as $tax)
                                                                        @php
                                                                            $sub_tax = ($product['variant_price']* $product['quantity'] * $tax['tax']) / 100;
                                                                            $total_tax += $sub_tax;
                                                                        @endphp
                                                                        <p class="t-gray p-title mb-0">
                                                                            {{$tax['tax_name'].' '.$tax['tax'].'%'.' ('.$sub_tax.')'}}
                                                                        </p>
                                                                    @endforeach
                                                                @else
                                                                    -
                                                                @endif
                                                            </p>

                                                            <div class="align-items-center">

                                                            @php
                                                                $totalprice = $product['price'] * $product['quantity'] + $total_tax;
                                                                $total += $totalprice;

                                                                $main_tax += $total_tax;
                                                            @endphp
                                                             <p class="total_price font-weight-bold m-0"> Price : {{\App\Models\Utility::priceFormat($product['price'])}}</p>
                                                             <p class="total_price font-weight-bold m-0"> Total  :{{\App\Models\Utility::priceFormat($totalprice)}}</p>

                                                            </div>
                                                        </a>
                                                    </div>
                                                </div>
                                                @else
                                                <div class="cart-items bg-white position-relative border-bottom" data-id="{{$key}}">
                                                    <div class="d-flex  align-items-center p-3">
                                                        <a href="{{route('store.product.product_view',[$store->slug,$product['id']])}}">
                                                            @if(!empty($product['image']))
                                                                <img alt="" src="{{$imgpath.$product['image']}}" class="img-fluid">
                                                            @else
                                                                <img alt="" src="{{asset(Storage::url('uploads/is_cover_image/default.jpg'))}}" class="img-fluid" >
                                                            @endif
                                                        </a>
                                                        <a href="{{route('store.product.product_view',[$store->slug,$product['id']])}}" class="ml-3 text-dark text-decoration-none w-100">

                                                            <div class="d-flex align-items-center">
                                                                <h5 class="mb-1">{{$product['product_name']}}</h5>
                                                                <div class="cart-items-number d-flex ml-auto qty-spinner"
                                                                data-id="{{$key}}">
                                                                    <input type='button' value='-'
                                                                        class='qtyminus btn btn-success btn-sm quantity-decrement qty-minus product_qty'
                                                                        field='quantity' />
                                                                    <input type='text' name='quantity'
                                                                        class='qty form-control quantity product_qty_input bx-cart-qty'
                                                                        data-cke-saved-name="quantity"
                                                                        data-id="{{$product['product_id']}}"
                                                                        value="{{$product['quantity']}}" id="product_qty" />
                                                                    <input type='button' value='+'
                                                                        class='qtyplus btn btn-success btn-sm quantity-increment qty-plus product_qty'
                                                                        field='quantity' />
                                                            </div>
                                                            </div>
                                                            <p class="text-muted mb-1">TAX :
                                                                @php
                                                                $total_tax=0;
                                                                @endphp
                                                                @if(!empty($product['tax']))
                                                                    @foreach($product['tax'] as $tax)
                                                                        @php
                                                                            $sub_tax = ($product['price']* $product['quantity'] * $tax['tax']) / 100;
                                                                            $total_tax += $sub_tax;
                                                                        @endphp
                                                                        <p class="t-gray p-title mb-0">
                                                                            {{$tax['tax_name'].' '.$tax['tax'].'%'.' ('.$sub_tax.')'}}
                                                                        </p>
                                                                    @endforeach
                                                                @else
                                                                    -
                                                                @endif
                                                            </p>

                                                            <div class="align-items-center">

                                                            @php
                                                                $totalprice = $product['price'] * $product['quantity'] + $total_tax;
                                                                $total += $totalprice;
                                                            @endphp
                                                             <p class="total_price font-weight-bold m-0"> Price : {{\App\Models\Utility::priceFormat($product['price'])}}</p>
                                                             <p class="total_price font-weight-bold m-0"> Total  :{{\App\Models\Utility::priceFormat($totalprice)}}</p>

                                                            </div>
                                                        </a>
                                                    </div>
                                                </div>
                                                @endif
                                            @endforeach
                                                <div>

                                                    @if($store_settings['is_checkout_login_required'] == null || $store_settings['is_checkout_login_required'] == 'off' && !Auth::guard('customers')->user())

                                                    <a href="#" class="text-decoration-none btn btn-block p-3" type="button" ddata-toggle="modal" data-target="#checkoutModal">
                                                        <div
                                                            class="rounded shadow bg-success d-flex align-items-center p-3 text-white">
                                                            <div class="more">
                                                                <h6 class="m-0">Total  {{\App\Models\Utility::priceFormat(!empty($total)?$total:0)}}</h6>
                                                                <p class="small m-0">{{__('Proceed to checkout')}}</p>
                                                            </div>
                                                            <div class="ml-auto"><i class="icofont-simple-right"></i></div>
                                                        </div>
                                                    </a>
                                                    @else
                                                    <a href="{{route('user-address.useraddress',$store->slug)}}" class="text-decoration-none btn btn-block p-3" type="button" >
                                                        <div
                                                            class="rounded shadow bg-success d-flex align-items-center p-3 text-white">
                                                            <div class="more">
                                                                <h6 class="m-0">Total  {{\App\Models\Utility::priceFormat(!empty($total)?$total:0)}}</h6>
                                                                <p class="small m-0">{{__('Proceed to checkout')}}</p>
                                                            </div>
                                                            <div class="ml-auto"><i class="icofont-simple-right"></i></div>
                                                        </div>
                                                    </a>
                                                    @endif

                                                </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>



                        <div class="card border-0 osahan-accor rounded shadow-sm overflow-hidden mt-3">

                            <div class="card-header bg-white border-0 p-0" id="headingthree">
                                <h2 class="mb-0">
                                    @if($store_settings['is_checkout_login_required'] == null || $store_settings['is_checkout_login_required'] == 'off' && !Auth::guard('customers')->user())
                                    <a class="btn d-flex align-items-center bg-white btn-block text-left btn-lg h5 px-3 py-4 m-0"
                                            href="">
                                            <span class="c-number">2</span> Delivery Time
                                    </a>
                                    @else
                                    <a class="btn d-flex align-items-center bg-white btn-block text-left btn-lg h5 px-3 py-4 m-0"
                                            href="{{route('user-address.useraddress',$store->slug)}}">
                                            <span class="c-number">2</span> Delivery Time
                                    </a>

                                    @endif
                                </h2>
                            </div>
                        </div>

                        <div class="card border-0 osahan-accor rounded shadow-sm overflow-hidden mt-3">

                            <div class="card-header bg-white border-0 p-0" id="headingfour">
                                <h2 class="mb-0">
                                    <a
                                        class="btn d-flex align-items-center bg-white btn-block text-left btn-lg h5 px-3 py-4 m-0"
                                        href="{{route('store-payment.payment',$store->slug)}}" >
                                        <span class="c-number">3</span> Payment
                                </a>
                                </h2>
                            </div>


                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="sticky_sidebar">
                        <div class="bg-white rounded overflow-hidden shadow-sm mb-3 checkout-sidebar">
                            @if(Auth::guard('customers')->check())
                            <div class="d-flex align-items-center osahan-cart-item-profile border-bottom bg-white p-3">
                                <img alt="{{ Auth::guard('customers')->user()->name }}" src="{{ Utility::get_file('uploads/customerprofile/'.Auth::guard('customers')->user()->avatar) }}" class="mr-3 rounded-circle img-fluid">
                                <div class="d-flex flex-column">
                                    <h6 class="mb-1 font-weight-bold">{{ ucFirst(Auth::guard('customers')->user()->name) }}</h6>
                                </div>
                            </div>
                            @endif
                            <div>
                                <div class="bg-white p-3 clearfix">
                                    <p class="font-weight-bold small mb-2">Bill Details</p>
                                    <p class="mb-1">Item Total <span class="small text-muted">({{$total_item}} item)</span> <span
                                            class="float-right text-dark">{{\App\Models\Utility::priceFormat(!empty($total)?$total:0)}}</span></p>



                                    <p class="mb-1">Tax : <span class="float-right text-dark">{{\App\Models\Utility::priceFormat($main_tax)}}</span></p>

                                </div>
                                <div class="p-3 border-top">
                                    <h5 class="mb-0">TO PAY <span class="float-right text-danger">{{\App\Models\Utility::priceFormat(!empty($total+$main_tax)?$total:'0')}}</span></h5>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @else

            @endif
        </div>
    </section>







@endsection
{{-- checkout modal --}}
<div class="modal fade" id="checkoutModal" tabindex="-1" role="dialog" aria-labelledby="checkoutModal" aria-hidden="true">
    <div class="modal-dialog modal-md rounded-pill " >
      <div class="modal-content ">
        <div class="modal-header">
            <h5 class="modal-title">Checkout As Guest Or Login</h5>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close">
            <span aria-hidden="true">&times;</span>
          </button>
        </div>
        <div class="modal-body row">
            <div class="form-group col-6 d-flex justify-content-center col-form-label mb-0">
                <a href="{{route('customer.login',$store->slug)}}" class="btn btn-secondary btn-light rounded-pill">{{__('Countinue to sign in')}}</a>
            </div>
            <div class="form-group col-6 d-flex justify-content-center col-form-label mb-0">
                <a href="{{route('user-address.useraddress',$store->slug)}}" class="btn btn-primary ms-2 rounded-pill">{{__('Countinue as guest')}}</a>
            </div>
        </div>
      </div>
    </div>
  </div>

@push('script-page')
    <script>
        $(document).on('click', '.product_qty', function (e) {
            e.preventDefault();
            var currEle = $(this);
            var product_id = $(this).siblings(".bx-cart-qty").attr('data-id');
            var arrkey = $(this).parents('div').attr('data-id');

            setTimeout(function () {
                if (currEle.hasClass('qty-minus') == true) {
                    qty_id = currEle.next().val()
                } else {
                    qty_id = currEle.prev().val()
                }

                if (qty_id == 0 || qty_id == '' || qty_id < 0) {
                    location.reload();
                    return false;
                }

                $.ajax({
                    url: '{{route('user-product_qty.product_qty',['__product_id',$store->slug,'arrkeys'])}}'.replace('__product_id', product_id).replace('arrkeys', arrkey),
                    type: "post",
                    headers: {
                        'x-csrf-token': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: {
                        "product_qty": qty_id,
                    },
                    success: function (response) {
                        if (response.status == "Error") {
                            show_toastr('Error', response.error, 'error');
                            setTimeout(function () {
                                location.reload();
                            }, 1000);
                        } else {
                            location.reload(); // then reload the page.(3)
                        }
                    },
                    error: function (result) {
                        console.log('error12');
                    }
                });
            }, 100);
        })

        $(".product_qty_input").on('blur', function (e) {
            e.preventDefault();

            var product_id = $(this).attr('data-id');

            var arrkey = $(this).closest('div').attr('data-id');
            var qty_id = $(this).val();
            console.log(product_id, arrkey, qty_id);

            setTimeout(function () {
                if (qty_id == 0 || qty_id == '' || qty_id < 0) {
                    location.reload();
                    return false;
                }

                $.ajax({
                    url: '{{route('user-product_qty.product_qty',['__product_id',$store->slug,'arrkeys'])}}'.replace('__product_id', product_id).replace('arrkeys', arrkey),
                    type: "post",
                    headers: {
                        'x-csrf-token': $('meta[name="csrf-token"]').attr('content')
                    },
                    data: {
                        "product_qty": qty_id,
                    },
                    success: function (response) {
                        if (response.status == "Error") {
                            show_toastr('Error', response.error, 'error');
                            setTimeout(function () {
                                location.reload();
                            }, 1000);
                        } else {
                            location.reload(); // then reload the page.(3)
                        }
                    },
                    error: function (result) {
                        // console.log('error12');
                    }
                });
            }, 500);
        });

        function qtyChange(product_id, arrkey, qty_id) {

        }

        // $(document).on('click', '.qty-plus', function () {
        //     $(this).prev().val(+$(this).prev().val() + 1);
        // });

        // $(document).on('click', '.qty-minus', function () {
        //     if ($(this).next().val() > 1) $(this).next().val(+$(this).next().val() - 1);
        // });
    </script>
@endpush
