@extends('layouts.admin')
@section('page-title')
    {{ __('Services') }}
@endsection
@section('title')
    <div class="d-inline-block">
        <h5 class="h4 d-inline-block text-white font-weight-bold mb-2">{{ __('Service') }}</h5>
    </div>
@endsection
@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Home') }}</a></li>
    <li class="breadcrumb-item active" aria-current="page">{{ __('Services') }}</li>
@endsection
@section('action-btn')
    <div class="pr-2">
        <a href="{{ route('service.create') }}" class="btn btn-sm btn-primary btn-icon m-1" data-bs-toggle="tooltip"
            data-bs-placement="top" title="{{ __('Create') }}"><i class="ti ti-plus"></i> Create</a>
    </div>
@endsection
@php
    $logo = \App\Models\Utility::get_file('uploads/service_logo/');
@endphp
@section('filter')
@endsection
@push('css-page')
    <link rel="stylesheet" href="{{ asset('custom/libs/summernote/summernote-bs4.css') }}">
@endpush
@push('script-page')
    <script src="{{ asset('custom/libs/summernote/summernote-bs4.js') }}"></script>
@endpush
@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body table-border-style">
                    <div class="table-responsive">
                        <table class="table mb-0 dataTable">
                            <thead>
                                <tr>
                                    <th>{{ __('Logo') }}</th>
                                    <th>{{ __('Title') }}</th>
                                    <th>{{ __('Created at') }}</th>
                                    <th class="text-right">{{ __('Action') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($services as $service)
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                @if (!empty($service->logo))
                                                    {{-- <a href="{{ asset(Storage::url('uploads/is_cover_image/' . $service->is_cover)) }}" target="_blank">
                                                            <img alt="Image placeholder" src="{{ asset(Storage::url('uploads/is_cover_image/' . $service->is_cover)) }}"
                                                            class="rounded-circle" alt="images">
                                                        </a> --}}
                                                    <a href="{{ $logo . (isset($service->logo) && !empty($service->logo) ? $service->logo : 'is_cover_image.png') }}"
                                                        target="_blank">
                                                        <img alt="Image placeholder" alt="your image"
                                                            src="{{ $logo . (isset($service->logo) && !empty($service->logo) ? $service->logo : 'is_cover_image.png') }}"
                                                            class="rounded-circle" alt="images">
                                                    </a>
                                                @else
                                                    <a href="{{ $logo . (isset($service->logo) && !empty($service->logo) ? $service->logo : 'is_cover_image.png') }}"
                                                        target="_blank">
                                                        <img alt="Image placeholder" alt="your image"
                                                            src="{{ $logo . (isset($service->logo) && !empty($service->logo) ? $service->logo : 'is_cover_image.png') }}"
                                                            class="rounded-circle" alt="images">
                                                    </a>
                                                @endif

                                            </div>
                                        </td>
                                        <td> {{ $service->title }}
                                        </td>
                                        <td>
                                            {{ \App\Models\Utility::dateFormat($service->created_at) }}
                                        </td>
                                        <td>
                                            <div class="action-btn  bg-info ms-2">
                                                    <a href="{{ route('service.edit', $service->id) }}"
                                                        class="mx-3 btn btn-sm d-inline-flex align-items-center"
                                                        data-bs-toggle="tooltip" data-bs-placement="top"
                                                        title="{{ __('Edit') }}"><i
                                                            class="ti ti-pencil text-white"></i></a>
                                                </div>
                                                <div class="action-btn  bg-primary ms-2">
                                                    <a href="{{ route('service.form.design', $service->id) }}"
                                                        class="mx-3 btn btn-sm d-inline-flex align-items-center"
                                                        data-bs-toggle="tooltip" data-bs-placement="top"
                                                        title="{{ __('Design') }}"><i
                                                            class="fa fa-paint-brush text-white"></i></a>
                                                </div>
                                                 @if ($service->json && empty($service->ServiceValue))
                                                 <div class="action-btn  bg-warning ms-2">
                                                    <a href="{{ route('service.form.fill', $service->id) }}"
                                                        class="mx-3 btn btn-sm d-inline-flex align-items-center"
                                                        data-bs-toggle="tooltip" data-bs-placement="top"
                                                        title="{{ __('Fill') }}"><i
                                                            class="fa fa-list text-white"></i></a>
                                                </div>
                                                 @endif
                                                <div class="action-btn bg-danger ms-2">
                                                    <a class="bs-pass-para align-items-center btn btn-sm d-inline-flex" href="#"
                                                        data-title="{{ __('Delete Lead') }}"
                                                        data-confirm="{{ __('Are You Sure?') }}"
                                                        data-text="{{ __('This action can not be undone. Do you want to continue?') }}"
                                                        data-confirm-yes="delete-form-{{ $service->id }}"
                                                        data-bs-toggle="tooltip" data-bs-placement="top"
                                                        title="{{ __('Delete') }}">
                                                        <i class="ti ti-trash"></i>
                                                    </a>
                                                    {!! Form::open(['method' => 'DELETE', 'route' => ['service.destroy', $service->id], 'id' => 'delete-form-' . $service->id]) !!}
                                                    {!! Form::close() !!}
                                                </div>
                                        </td>

                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('script-page')
    <script>
        $(document).on('click', '#billing_data', function() {
            $("[name='shipping_address']").val($("[name='billing_address']").val());
            $("[name='shipping_city']").val($("[name='billing_city']").val());
            $("[name='shipping_state']").val($("[name='billing_state']").val());
            $("[name='shipping_country']").val($("[name='billing_country']").val());
            $("[name='shipping_postalcode']").val($("[name='billing_postalcode']").val());
        })
    </script>
@endpush
