@extends('layouts.admin')
@section('page-title')
    {{ __('Service') }}
@endsection
@section('title')
    <div class="d-inline-block">
        <h5 class="h4 d-inline-block text-white font-weight-bold mb-0 ">{{ __('Service') }}</h5>
    </div>
@endsection
@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Home') }}</a></li>
    <li class="breadcrumb-item"><a href="{{ route('service.index') }}">{{ __('Service') }}</a></li>
    <li class="breadcrumb-item active" aria-current="page">{{ __('Edit') }}</li>
@endsection
@section('action-btn')
@endsection
@section('filter')
@endsection
@push('css-page')
    <link rel="stylesheet" href="{{ asset('custom/libs/summernote/summernote-bs4.css') }}">
@endpush
@php
$logo=\App\Models\Utility::get_file('uploads/service_logo/');


@endphp
@push('script-page')
    <script src="{{ asset('custom/libs/summernote/summernote-bs4.js') }}"></script>
    <script>
     
       

     
    </script>
@endpush
@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    {{ Form::model($service, ['route' => ['service.update', $service->id],'method' => 'PUT', 'id' => 'frmTarget', 'enctype' => 'multipart/form-data']) }}
                    <div class="row">
                        <div class="col-12">
                            <div class="form-group">
                                {{ Form::label('title', __('Name'), ['class' => 'col-form-label']) }}
                                {!! Form::text('title', null, ['class' => 'form-control', 'placeholder' => __('Enter Name')]) !!}
                            </div>
                        </div>
                        <div class="row">
                        <div class="col-6">
                            <div class="form-group">
                                {{ Form::label('description', __('Description'), ['class' => 'col-form-label']) }}
                                {{ Form::textarea('description', null, ['class' => 'form-control','placeholder' => __('Enter dDescription'),'required' => 'required']) }}
                            </div>
                        </div>
                    </div>
                         <div class="col-12">
                                    <div class="form-group">
                                        <label for="image"
                                            class="col-form-label">{{ __('Upload Image') }}</label>
                                        {{-- <input type="file" name="image" id="image"
                                            class="form-control custom-input-file"> --}}
                                            <input type="file" name="logo" id="logo" class="form-control custom-input-file" onchange="document.getElementById('upcoverImg').src = window.URL.createObjectURL(this.files[0])" >
                                            <img class="rounded mt-3"
                                                                src=" {{ $logo . $service->logo }}"
                                                                width="70px" alt="Image placeholder" data-dz-thumbnail>
                                    </div>
                                </div>
                        
                    <div class="form-group col-12 d-flex justify-content-end col-form-label">
                        <a href="{{ route('service.index') }}"
                            class="btn btn-secondary btn-light">{{ __('Cancel') }}</a>
                        <input type="submit" id="submit-all" value="{{ __('Update') }}" class="btn btn-primary ms-2">
                    </div>
                </div>
                {{ Form::close() }}
            </div>
        </div>
    </div>
@endsection

