@extends('layouts.admin')
@section('page-title')
    {{ __('Service') }}
@endsection
@section('title')
    <div class="d-inline-block">
        <h5 class="h4 d-inline-block text-white font-weight-bold mb-0 ">{{ __('Service') }}</h5>
    </div>
@endsection
@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Home') }}</a></li>
    <li class="breadcrumb-item"><a href="{{ route('service.index') }}">{{ __('Service') }}</a></li>
    <li class="breadcrumb-item active" aria-current="page">{{ __('Design') }}</li>
@endsection
@section('action-btn')
@endsection
@section('filter')
@endsection
@push('css-page')
    <link rel="stylesheet" href="{{ asset('custom/libs/summernote/summernote-bs4.css') }}">
@endpush
@push('script-page')
    <script src="{{ asset('custom/libs/summernote/summernote-bs4.js') }}"></script>
    <script></script>
@endpush
@section('content')
    <!-- [ Main Content ] start -->
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    {{ Form::model($service, ['route' => ['service.design.update', $service->id], 'method' => 'PUT', 'id' => 'design-form']) }}
                    <div class="row">
                        <div class="col-md-12">
                            @php
                                $array = json_decode($service->json);
                            @endphp
                            <ul id="tabs">
                                @if (!empty($service->json))
                                    @foreach ($array as $key => $data)
                                        <li><a href="#page-{{ $key + 1 }}">{{ __('Page') . ($key + 1) }}</a>
                                        </li>
                                    @endforeach
                                @else
                                    <li><a href="#page-1">{{ __('Page') }}1</a></li>
                                @endif
                                <li id="add-page-tab"><a href="#new-page">+ {{ __('Page') }}</a>
                                </li>
                            </ul>
                            @if (!empty($service->json))
                                @foreach ($array as $key => $data)
                                    <div id="page-{{ $key + 1 }}" class="build-wrap">
                                    </div>
                                @endforeach
                            @else
                                <div id="page-1" class="build-wrap"></div>
                            @endif
                            <div id="new-page"></div>
                            <input type="hidden" name="json" value="{{ $service->json }}">
                            <br>
                            <div class="action-buttons">
                                <button id="showData" class="d-none" type="button">{{ __('Show Data') }}</button>
                                <button id="clearFields" class="d-none"
                                    type="button">{{ __('Clear All Fields') }}</button>
                                <button id="getData" class="d-none" type="button">{{ __('Get Data') }}</button>
                                <button id="getXML" class="d-none" type="button">{{ __('Get XML Data') }}</button>
                                <button id="getJSON" class="btn btn-primary" type="button">{{ __('Update') }}</button>
                                <button id="getJSONs" class="d-none" onClick="javascript:history.go(-1)"
                                    type="button">{{ __('Back') }}</button>
                                <button id="getJS" class="d-none" type="button">{{ __('Get JS Data') }}</button>
                                <button id="setData" class="d-none" type="button">{{ __('Set Data') }}</button>
                                <button id="addField" class="d-none" type="button">{{ __('Add Field') }}</button>
                                <button id="removeField" class="d-none" type="button">{{ __('Remove Field') }}</button>
                                <button id="testSubmit" class="d-none" type="submit">{{ __('Test Submit') }}</button>
                                <button id="resetDemo" class="d-none" type="button">{{ __('Reset Demo') }}</button>
                            </div>
                        </div>
                    </div>
                    {{ Form::close() }}

                </div>
            </div>
        </div>
    </div>
    <!-- [ Main Content ] end -->
@endsection
@push('css-page')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/jqueryform/css/demo.css') }}">
    <link href="{{ asset('assets/jqueryform/css/jquery.rateyo.min.css') }}" rel="stylesheet" />
    <link href="https://code.jquery.com/ui/1.11.4/themes/smoothness/jquery-ui.css" rel="stylesheet" />
@endpush
@push('script-page')
<script>
        var lang = '{{ app()->getLocale() }}';
        var lang_other = '{{ __('Other') }}';
        var lang_other_placeholder = '{{ __('Enter please') }}';
        var lang_Page = '{{ __('Page') }}';
        var lang_Custom_Autocomplete = '{{ __('Custom Autocomplete') }}';
    </script>
    <script src="{{ asset('assets/jqueryform/js/vendor.js') }}"></script>
    <script src="{{ asset('assets/modules/nicescroll/jquery.nicescroll.min.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.11.4/jquery-ui.min.js"></script>
    <script src="{{ asset('assets/jqueryform/js/form-builder.min.js') }}"></script>
    <script src="{{ asset('assets/jqueryform/js/form-render.min.js') }}"></script>
    <script src="{{ asset('assets/jqueryform/js/demoFirst.js') }}"></script>
    <script src="{{ asset('assets/jqueryform/js/jquery.rateyo.min.js') }}"></script>
@endpush

