@extends('layouts.admin')
@section('page-title')
    {{ __('Service') }}
@endsection
@section('title')
    <div class="d-inline-block">
        <h5 class="h4 d-inline-block text-white font-weight-bold mb-0 ">{{ __('Service') }}</h5>
    </div>
@endsection
@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Home') }}</a></li>
    <li class="breadcrumb-item"><a href="{{ route('service.index') }}">{{ __('Service') }}</a></li>
    <li class="breadcrumb-item active" aria-current="page">{{ __('Create') }}</li>
@endsection
@section('action-btn')
@endsection
@section('filter')
@endsection
@push('css-page')
    <link rel="stylesheet" href="{{ asset('custom/libs/summernote/summernote-bs4.css') }}">
@endpush
@push('script-page')
    <script src="{{asset('custom/libs/summernote/summernote-bs4.js')}}"></script>
    <script>
     

     

      

        
    </script>
@endpush
@section('content')
    <!-- [ Main Content ] start -->
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    {{ Form::open(['method' => 'POST', 'route'=> 'service.store' ,'id' => 'frmTarget', 'enctype' => 'multipart/form-data']) }}
                    <div class="row">
                        <div class="col-6">
                            <div class="form-group">
                                {{ Form::label('title', __('Name'), ['class' => 'col-form-label']) }}
                                {{ Form::text('title', null, ['class' => 'form-control','placeholder' => __('Enter Name'),'required' => 'required']) }}
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-6">
                            <div class="form-group">
                                {{ Form::label('description', __('Description'), ['class' => 'col-form-label']) }}
                                {{ Form::textarea('description', null, ['class' => 'form-control','placeholder' => __('Enter dDescription'),'required' => 'required']) }}
                            </div>
                        </div>
                    </div>
                      <div class="col-6">
                                    <div class="form-group">
                                        <label for="image"
                                            class="col-form-label">{{ __('Upload Image') }}</label>
                                        {{-- <input type="file" name="image" id="image"
                                            class="form-control custom-input-file"> --}}
                                            <input type="file" name="logo" id="logo" class="form-control custom-input-file" onchange="document.getElementById('upcoverImg').src = window.URL.createObjectURL(this.files[0])" >
                                            <img id="upcoverImg" src="" width="20%" class="mt-2"/>
                                    </div>
                                </div>
                    <div class="form-group col-12 d-flex justify-content-end col-form-label">
                        <a href="{{ route('service.index') }}"
                            class="btn btn-secondary btn-light">{{ __('Cancel') }}</a>
                        <input type="submit" id="submit-all" value="{{ __('Save') }}" class="btn btn-primary ms-2">
                    </div>

                    {{-- <div class="w-100 text-right">
                            <button type="button" class="btn btn-sm btn-primary rounded-pill mr-auto"
                                id="submit-all">{{ __('Save') }}</button>
                        </div> --}}
                </div>
                {{ Form::close() }}

            </div>
        </div>
    </div>
    <!-- [ Main Content ] end -->
@endsection
