{{ Form::model($productTax, ['route' => ['product_tax.update', $productTax->id], 'method' => 'PUT']) }}
<div class="row">
    <div class="col-12">
        <div class="form-group">
            {{ Form::label('tax_type', __('Select Tax Type'), ['class' => 'col-form-label']) }}
            <select name="tax_type" id="tax_type" readonly class="form-control" >
                <option value="">{{ __('Select Type') }}</option>
                <option {{ $productTax->tax_type == 'local' ? 'selected' : '' }} value="local">{{ __('Local') }}</option>
                <option {{ $productTax->tax_type == 'global' ? 'selected' : '' }} value="global">{{ __('Global') }}
                </option>
            </select>
        </div>
    </div>
    @if ($productTax->tax_type == 'local')
        <div class="col-12 ">
            <div class="form-group">
                {{ Form::label('state', __('State'), ['class' => 'col-form-label']) }}
                <select name="state" id="state" class="form-control">
                    <option value="">{{ __('Select state') }}</option>
                    @foreach ($cities as $city)
                        <option {{ $city == $productTax->state ? 'selected' : '' }} value="{{ $city }}">
                            {{ __($city) }}</option>
                    @endforeach
                </select>
            </div>
        </div>
    @endif
    <div class="col-12 sgst">
        <div class="form-group">
            {{ Form::label('sgst_rate', __('SGST Rate'), ['class' => 'col-form-label']) }}
            {{ Form::text('sgst_rate', null, ['class' => 'form-control', 'placeholder' => __('Enter Rate')]) }}
        </div>
    </div>
    @if ($productTax->tax_type == 'local')
        <div class="col-12 cgst">
            <div class="form-group">
                {{ Form::label('cgst_rate', __('CGST Rate') . __(' (%)'), ['class' => 'col-form-label']) }}
                {{ Form::text('cgst_rate', null, ['class' => 'form-control', 'placeholder' => __('Enter Rate')]) }}
            </div>
        </div>
    @endif
    @if($productTax->tax_type == 'global')
    <div class="col-12 igst">
        <div class="form-group">
            {{ Form::label('igst_rate', __('IGST Rate') . __(' (%)'), ['class' => 'col-form-label']) }}
            {{ Form::text('igst_rate', null, ['class' => 'form-control', 'placeholder' => __('Enter Rate')]) }}
        </div>
    </div>
    @endif
    <div class="col-12">
        <div class="form-group">
            {{ Form::label('rounding', __('Round tax at subtotal level'), ['class' => 'col-form-label']) }}
            {{ Form::checkbox('rounding', $productTax->rounding == 1 ? true : false, ['class' => 'form-control', 'required' => 'required']) }}
            @error('rounding')
                <span class="invalid-rate" role="alert">
                    <strong class="text-danger">{{ $message }}</strong>
                </span>
            @enderror
        </div>
    </div>
    <div class="col-12">
        <div class="form-group">
            {{ Form::label('shop_price', __('Display Price In shop'), ['class' => 'col-form-label']) }}
            <select name="shop_price" id="shop_price" class="form-control" required>
                <option {{ $productTax->shop_price == 'including' ? 'selected' : '' }} value="including">
                    {{ __('Including Tax') }}</option>
                <option {{ $productTax->shop_price == 'exclusing' ? 'selected' : '' }} value="exclusing">
                    {{ __('Exclusing Tax') }}</option>
            </select>
            @error('shop_price')
                <span class="invalid-rate" role="alert">
                    <strong class="text-danger">{{ $message }}</strong>
                </span>
            @enderror
        </div>
    </div>
    <div class="col-12">
        <div class="form-group">
            {{ Form::label('cart_price', __('Display Price In Cart'), ['class' => 'col-form-label']) }}
            <select name="cart_price" id="cart_price" class="form-control" required>
                <option {{ $productTax->cart_price == 'including' ? 'selected' : '' }} value="including">
                    {{ __('Including Tax') }}</option>
                <option {{ $productTax->cart_price == 'exclusing' ? 'selected' : '' }} value="exclusing">
                    {{ __('Exclusing Tax') }}</option>
            </select>
            @error('cart_price')
                <span class="invalid-rate" role="alert">
                    <strong class="text-danger">{{ $message }}</strong>
                </span>
            @enderror
        </div>
    </div>
</div>
<div class="form-group col-12 d-flex justify-content-end col-form-label">
    <input type="button" value="{{ __('Cancel') }}" class="btn btn-secondary btn-light" data-bs-dismiss="modal">
    <input type="submit" value="{{ __('Update') }}" class="btn btn-primary ms-2">
</div>
{{ Form::close() }}
