{{ Form::model($productSubcategorie, ['route' => ['product_subcategorie.update', $productSubcategorie->id],'method' => 'PUT','enctype' => 'multipart/form-data']) }}
<div class="row">
    <div class="col-12">
        <div class="form-group">
            {{ Form::label('category_id', __('Select Category'), ['class' => 'col-form-label']) }}
            {!! Form::select('category_id', $product_categorie, null, [
                'class' => 'form-control multi-select',
            ]) !!}
            @if (count($product_categorie) == 0)
                {{ __('Add product category') }}
                <a href="{{ route('product_categorie.index') }}">
                    {{ __('Click here') }}
                </a>
            @endif
        </div>
        <div class="form-group">
            {{ Form::label('name', __('Name'), ['class' => 'col-form-label']) }}
            {{ Form::text('name', null, ['class' => 'form-control', 'placeholder' => __('Enter Product Category')]) }}
            @error('name')
                <span class="invalid-name" role="alert">
                    <strong class="text-danger">{{ $message }}</strong>
                </span>
            @enderror
        </div>
        <div class="form-group">
            <label for="categorie_img" class="col-form-label">{{ __('Upload Category Image') }}</label>
            {{-- <input type="file" name="categorie_img" id="categorie_img" class="form-control"> --}}
            <input type="file" name="categorie_img" id="categorie_img" class="form-control" onchange="document.getElementById('catImg').src = window.URL.createObjectURL(this.files[0])" multiple>
            <img id="catImg" src="" width="20%" class="mt-2"/>
        </div>
    </div>
</div>
<div class="form-group col-12 d-flex justify-content-end col-form-label">
    <input type="button" value="{{ __('Cancel') }}" class="btn btn-secondary btn-light" data-bs-dismiss="modal">
    <input type="submit" value="{{ __('Update') }}" class="btn btn-primary ms-2">
</div>
{{ Form::close() }}
