@extends('layouts.admin')
@section('page-title')
    {{ __('Import  Product') }}
@endsection
@section('title')
    <div class="d-inline-block">
        <h5 class="h4 d-inline-block text-white font-weight-bold mb-0 ">{{ __('Import Product') }}</h5>
    </div>
@endsection
@section('breadcrumb')
    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">{{ __('Home') }}</a></li>
    <li class="breadcrumb-item active" aria-current="page">{{ __('Import Existing Product') }}</li>
@endsection
@section('action-btn')
@endsection
@section('filter')
@endsection
@section('content')
{{ Form::open(['method' => 'POST', 'route' => 'import.product', 'id' => 'frmTvfvarget', 'enctype' => 'multipart/form-data']) }}
    <div class="row">
                                    <div class="col-4">
                                        <div class="form-group">
                                            {!! Form::select('new_product_categorie', $product_categorie, null, [
                                                'class' => 'form-control custom_select multi-select',
                                                'id' => 'new_product_categorie',
                                            ]) !!}
                                        </div>
                                    </div>

                                    <div class="col-4">

                                        <div class="form-group">
                                            {!! Form::select('new_product_subcategorie', $product_subcategorie, null, [
                                                'class' => 'product_subcategorie form-control custom_select multi-select',
                                                'id' => 'new_product_subcategorie',
                                            ]) !!}
                                        </div>
                                    </div>




                                    <div class="col-4">

                                        <div class="form-group">
                                            <div class="form-group">
                                                <input type="text" name="search" id="search"
                                                    class="form-control " placeholder="Search Product...">
                                                {{ Form::label('', '', ['id' => 'store_link', 'class' => 'form-label']) }}
                                                {{ Form::hidden('slug', null, ['class' => 'form-control', 'id' => 'slug', 'placeholder' => __('Enter Store name')]) }}

                                            </div>
                                        </div>
                                    </div>
                                </div>

    <div class="row product_list">
        @foreach ($products as $key => $product)
        
            <div class="col-lg-3 col-sm-6 col-md-6">
                <div class="card text-white text-center">
                    <div class="card-header border-0 pb-0">
                        <div class="card-header-right">
                            <div class="btn-group card-option">
                                <div class="form-check  mb-3   " style="    right: -22px;position:absolute;  top: -5px;">
                                    @if (in_array($product->name, $company_products)) 
                                    <input type="checkbox" id="customRadio5" name="selected_product[]" value="{{ $product->id }}"
                                        class="form-check-input" checked="">
                                        @else
                                        <input type="checkbox" id="customRadio5" name="selected_product[]" value="{{ $product->id }}"
                                        class="form-check-input">
                                        @endif
                                    <label class="form-check-label" for="customRadio5">Pre</label>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="card-body product_card">
                        @if (!empty($product->is_cover))
                            <a href="{{ asset(Storage::url('uploads/is_cover_image/' . $product->is_cover)) }}"
                                target="_blank">
                                <img alt="Image placeholder"
                                    src="{{ asset(Storage::url('uploads/is_cover_image/' . $product->is_cover)) }}"
                                    class="img-fluid rounded-circle card-avatar" alt="images">
                            </a>
                        @else
                            <a href="{{ asset(Storage::url('uploads/is_cover_image/default.jpg')) }}" target="_blank">
                                <img alt="Image placeholder"
                                    src="{{ asset(Storage::url('uploads/is_cover_image/default.jpg')) }}"
                                    class="img-fluid rounded-circle card-avatar" alt="images">
                            </a>
                        @endif
                        <h4 class="text-primary mt-2"> <a href="#">{{ $product->name }}</a></h4>
                        <h4 class="text-muted">
                            <small>{{ \App\Models\Utility::priceFormat($product->price) }}</small>
                        </h4>
                        @if ($product->enable_product_variant != 'on')
                            @if ($product->quantity == 0)
                                <span class="badge bg-danger p-2 px-3 rounded">
                                    {{ __('Out of stock') }}
                                </span>
                            @else
                                <span class="badge bg-primary p-2 px-3 rounded">
                                    {{ __('In stock') }}
                                </span>
                            @endif
                        @endif
                        <div class="row mt-1">
                            <div class="col-12 col-sm-12">
                                <div>
                                    @for ($i = 1; $i <= 5; $i++)
                                        @php
                                            $icon = 'fa-star';
                                            $color = '';
                                            $newVal1 = $i - 0.5;
                                            if ($product->product_rating() < $i && $product->product_rating() >= $newVal1) {
                                                $icon = 'fa-star-half-alt';
                                            }
                                            if ($product->product_rating() >= $newVal1) {
                                                $color = 'text-warning';
                                            } else {
                                                $color = 'text-black';
                                            }
                                        @endphp
                                        <i class="fas {{ $icon . ' ' . $color }}"></i>
                                    @endfor
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        @endforeach
       

    </div>
    <div class="row">
     <div class="form-group col-12 d-flex justify-content-end col-form-label">
            <button type="submit" id="submit-all" class="btn btn-primary me-2"><i class="ti ti-file-import"></i>
                Import</button>
            <a href="{{ route('product.create') }}" class="btn  btn-primary btn-light"> <i
                    class="ti ti-plus">{{ __('Create Product') }}</i> Create
            </a>
        </div>
    </div>
  {{ Form::close() }}
@endsection
@push('script-page')
<script>

        $("#new_product_subcategorie").change(function() {
            var subcat_id = $(this).val();
            var cat_id = $('#new_product_categorie').val();

             $.ajax({
                type: "POST",
                dataType: "JSON",
                url: '{{ route('categorie.products.grid') }}',
                data: {
                    cat_id: cat_id,
                    subcat_id: subcat_id,
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            }).done(function(msg) {
                if (msg.status == 'success') {
                    // $('#loader_form').hide();
                    $('.product_list').html(msg.output);
                    // $('#slug').val(msg.data.slug);
                }
            });


        });
        $("#new_product_categorie").change(function() {
            // alert('here');
            var cat_id = $(this).val();
            // $('#loader_form').show();

            $.ajax({

                url: "{{ route('get-sub-category-by-category') }}",
                type: 'POST',
                data: {
                    _token: '{{ csrf_token() }}',
                    product_categorie: cat_id
                },
                success: function(data) {
                    $('#loader_form').hide();
                    // alert('here');
                    // $('#sub_category_div').show();
                    $("#new_product_subcategorie").html(
                    '<option value="">Select Sub Category</option>');

                    $.each(data, function(index, val) {
                        $("#new_product_subcategorie").append('<option value="' + index + '">' +
                            val + '</option>');
                    });
                    $('.custom_select').select2();
                }
            })

            var subcat_id = $('#new_product_subcategorie').val();

                



            $.ajax({
                type: "POST",
                dataType: "JSON",
                url: '{{ route('categorie.products.grid') }}',
                data: {
                    cat_id: cat_id,
                    subcat_id: subcat_id,
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            }).done(function(msg) {
                if (msg.status == 'success') {
                    // $('#loader_form').hide();
                    $('.product_list').html(msg.output);
                    // $('#slug').val(msg.data.slug);
                }
            });


        });

        $("#search").on('keyup', function(e) {
            // $('#loader_form').show();
            var search = $(this).val();
           
            
            cat_id = $('#new_product_categorie').val();
            subcat_id = $('#new_product_subcategorie').val();
                


            $.ajax({
                type: "POST",
                dataType: "JSON",
                url: '{{ route('categorie.products.grid') }}',
                data: {
                    cat_id: cat_id,
                    subcat_id: subcat_id,
                    search: search,
                },
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            }).done(function(msg) {
                if (msg.status == 'success') {
                    // $('#loader_form').hide();
                    $('.product_list').html(msg.output);
                    // $('#slug').val(msg.data.slug);
                }
            });
        })

</script>
@endpush
