<form method="post" action="{{ route('product-coupon.update', $productCoupon->id) }}" id="product-coupon-store">
    @csrf
    @method('PUT')
    <div class="row">
        <div class="form-group col-md-12">
            {{Form::label('name',__('Name'),array('class'=>'form-label'))}}
            {{Form::text('name',$productCoupon->name,array('class'=>'form-control','placeholder'=>__('Enter Name'),'required'=>'required'))}}
        </div>
        <div class="form-group col-md-12">
            <div class="form-check form-switch">
                <input type="checkbox" class="form-check-input" name="enable_flat" id="enable_flat" {{ ($productCoupon['enable_flat'] == 'on') ? 'checked=checked' : '' }}>
                {{-- <label class="custom-control-label col-form-label" for="enable_flat"></label> --}}
                {{Form::label('enable_flat',__('Flat Discount'),array('class'=>'form-check-label mb-3')) }}
            </div>
        </div>

        <div class="form-group col-md-12 nonflat_discount">
            {{ Form::label('discount', __('Discount'), ['class' => 'col-form-label']) }}
            {{ Form::number('discount', null, ['class' => 'form-control', 'step' => '0.01', 'placeholder' => __('Enter Discount')]) }}
            <span class="small">{{ __('Note: Discount in Percentage') }}</span>
        </div>
        <div class="form-group col-md-12 flat_discount" style="display: none;">
            {{ Form::label('pro_flat_discount', __('Flat Discount'), ['class' => 'col-form-label']) }}
            {{ Form::number('pro_flat_discount', null, ['class' => 'form-control', 'step' => '0.01', 'placeholder' => __('Enter Flat Discount')]) }}
            <span class="small">{{ __('Note: Discount in Value') }}</span>
        </div>
        <div class="form-group col-md-6">
            {{ Form::label('user_limit', __('Maximum user Limit'), ['class' => 'col-form-label']) }}
            {{ Form::number('user_limit', null, ['class' => 'form-control', 'placeholder' => __('Enter  User Limit'), 'required' => 'required']) }}
            <span class="small">{{ __('Note: Number of User count') }}</span>
        </div>
        <div class="form-group col-md-6">
            {{ Form::label('limit', __('Coupon Limit'), ['class' => 'col-form-label']) }}
            {{ Form::number('limit', null, ['class' => 'form-control', 'placeholder' => __('Enter Coupon Limit'), 'required' => 'required']) }}
            <span class="small">{{ __('Note: Number of coupon uses') }}</span>
        </div>
         <div class="form-group col-md-6">
            {{ Form::label('minimum_spend', __('Minimum Spend'), ['class' => 'col-form-label']) }}
            {{ Form::number('minimum_spend', $productCoupon->minimum_spend, ['class' => 'form-control', 'step' => '100', 'placeholder' => __('Enter Amount'), 'required' => 'required']) }}
            <span class="small">{{ __('Note: Minimum purchase') }}</span>
        </div>
        <div class="form-group col-md-6">
            {{ Form::label('maximum_spend', __('Maximum Spend'), ['class' => 'col-form-label']) }}
            {{ Form::number('maximum_spend', $productCoupon->maximum_spend, ['class' => 'form-control', 'step' => '500', 'placeholder' => __('Enter Amount')]) }}
            <span class="small">{{ __('Note: Maximum purchase') }}</span>
        </div>
         <div class="form-group col-md-12">
            {{ Form::label('coupon_expiry', __('Coupon Expiry'), ['class' => 'col-form-label']) }}
            {{ Form::date('coupon_expiry',  $productCoupon->coupon_expiry, ['class' => 'form-control','min' => date("Y-m-d"),'required' => 'required']) }}
        </div>
        <div class="form-group col-md-12">
            {{ Form::label('coupon_products', __('Products'), ['class' => 'col-form-label']) }}
            {{ Form::select('coupon_products[]', $all_products, explode(',',$productCoupon->coupon_products), ['class' => 'form-control multi-select', 'id' => 'choices-multiple1', 'multiple']) }}
        </div>
        <div class="form-group col-md-12">
            {{ Form::label('exclude_products', __('Exclude Products'), ['class' => 'col-form-label']) }}
            {{ Form::select('exclude_products[]', $all_products, explode(',',$productCoupon->exclude_products), ['class' => 'form-control multi-select', 'id' => 'choices-multiple2', 'multiple']) }}
        </div>
        <div class="form-group col-md-12" id="auto">
            {{Form::label('limit',__('Code') ,array('class'=>'col-form-label'))}}
            <div class="input-group">
                {{Form::text('code',$productCoupon->code,array('class'=>'form-control','id'=>'auto-code','required'=>'required'))}}
                <button class="btn btn-outline-secondary" type="button" id="code-generate"><i class="fa fa-history pr-1"></i>{{__(' Generate')}}</button>
            </div>
        </div>
        <div class="form-group col-12 d-flex justify-content-end col-form-label">
            <input type="button" value="{{__('Cancel')}}" class="btn btn-secondary btn-light" data-bs-dismiss="modal">
            <input type="submit" value="{{__('Update')}}" class="btn btn-primary ms-2">
        </div>
    </div>
</form>

