<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('product_coupons', function (Blueprint $table) {
            $table->float('minimum_spend')->after('limit');
            $table->float('maximum_spend')->after('minimum_spend');
            $table->string('coupon_products')->nullable()->after('maximum_spend');
            $table->string('exclude_products')->nullable()->after('coupon_products');
            $table->date('coupon_expiry')->nullable()->after('exclude_products');
            
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('product_coupons', function (Blueprint $table) {
            //
        });
    }
};
