<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('product_taxes', function (Blueprint $table) {
            $table->string('tax_type')->after('id');
            $table->string('state')->after('tax_type');
            $table->float('sgst_rate')->default(0)->after('state');
            $table->float('cgst_rate')->default(0)->after('sgst_rate');
            $table->float('igst_rate')->default(0)->after('cgst_rate');
            $table->integer('rounding')->default(0)->after('igst_rate');
            $table->string('shop_price')->after('rounding');
            $table->string('cart_price')->after('shop_price');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('product_taxes', function (Blueprint $table) {
            //
        });
    }
};
