<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Service extends Model
{
    use HasFactory;
    public $fillable = [
        'title', 'description', 'json', 'html', 'logo','created_by'
    ];

    public function getFormArray()
    {
        return json_decode($this->json);
    }
    public function ServiceValue()
    {
        return $this->hasMany('App\Models\ServiceValues', 'service_id', 'id');
    }
}
