<?php

namespace App\Http\Controllers;
use App\Models\Utility;
use App\Models\Plan;
use App\Models\Coupon;
use App\Models\UserCoupon;
use App\Models\Order;
use App\Models\Product;
use App\Models\ProductCoupon;
use App\Models\ProductVariantOption;
use App\Models\PurchasedProducts;
use App\Models\Shipping;
use App\Models\Store;
use App\Models\User;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Crypt;
use Symfony\Component\Console\Input\Input;
use Throwable;

class StoreOneMoneyPaymentController extends Controller
{
    const BASE_URL_SANDBOX = "https://sandbox-icp-api.bankopen.co/api";
    const BASE_URL_UAT = "https://icp-api.bankopen.co/api";

    public $access_key;
    public $secret_key;
    public $mode;


    public function setPaymentKey(){

        $slug = request('slug');
        $store    = Store::where('slug', $slug)->first();
        if(\Auth::check()){
            $payment_setting = Utility::getAdminPaymentSetting();
        }else{
            $payment_setting = Utility::getPaymentSetting($store->id);
        }
        $this->secret_key = isset($payment_setting['onemoney_secret_key']) ? $payment_setting['onemoney_secret_key'] : '';
        $this->access_key = isset($payment_setting['onemoney_public_key']) ? $payment_setting['onemoney_public_key'] : '';
        $this->mode = isset($payment_setting['onemony_mode']) ? $payment_setting['onemony_mode'] : 'sandbox';

        return $this;
    }


    public function create_payment_token($data){

        $this->setPaymentKey();
        try {
            $pay_token_request_data = array(
                'amount'   			=> (!empty($data['amount']))? $data['amount'] : NULL,
                'currency' 			=> (!empty($data['currency']))? $data['currency'] : NULL,
                'name'     			=> (!empty($data['name']))? $data['name'] : NULL,
                'email_id' 			=> (!empty($data['email_id']))? $data['email_id'] : NULL,
                'contact_number' 	=> (!empty($data['contact_number']))?  $data['contact_number'] : NULL,
                'mtx'    			=> (!empty($data['mtx']))? $data['mtx'] : NULL,
                'udf'    			=> (!empty($data['udf']))? $data['udf'] : NULL,
            );

            $pay_token_data = $this->http_post($pay_token_request_data,"payment_token");

            return $pay_token_data;
        } catch (Exception $e){
            return [
                'error' => $e->getMessage()
            ];

        } catch (Throwable $e){

			return [
                'error' => $e->getMessage()
            ];
        }
    }

    public function get_payment_token($payment_token_id){

        if(empty($payment_token_id)){

            throw new Exception("payment_token_id cannot be empty.");
        }

        try {

            return $this->http_get("payment_token/".$payment_token_id);

        } catch (Exception $e){

            return [
                'error' => $e->getMessage()
            ];

        } catch (Throwable $e){

            return [
                'error' => $e->getMessage()
            ];
        }

    }

    public function get_payment_details($payment_id){

        if(empty($payment_id)){

            throw new Exception("payment_id cannot be empty.");
        }

        try {

            return $this->http_get("payment/".$payment_id);

        } catch (Exception $e){

            return [
                'error' => $e->getMessage()
            ];

        } catch (Throwable $e){

            return [
                'error' => $e->getMessage()
            ];
        }

    }


    public function build_auth(){
        $this->setPaymentKey();


        return array(
            'Content-Type: application/json',
            'Authorization: Bearer '.$this->access_key.':'.$this->secret_key
        );

    }
    function http_post($data,$route){
        $this->setPaymentKey();
        foreach (@$data as $key=>$value){

            if(empty($data[$key])){

                unset($data[$key]);
            }
        }

        if($this->mode == 'live'){

            $url = self::BASE_URL_UAT."/".$route;

        } else {

            $url = self::BASE_URL_SANDBOX."/".$route;
        }


        $header = $this->build_auth();

        try
        {
            $curl = curl_init();
		    curl_setopt($curl, CURLOPT_URL, $url);
		    curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
		    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
		    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
		    curl_setopt($curl, CURLOPT_SSLVERSION, 6);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl, CURLOPT_MAXREDIRS,10);
		    curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);
		    curl_setopt($curl, CURLOPT_ENCODING, '');
		    curl_setopt($curl, CURLOPT_TIMEOUT, 60);
            curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'POST');
            curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data, JSON_HEX_APOS|JSON_HEX_QUOT ));

		    $response = curl_exec($curl);
            $curlerr = curl_error($curl);

            if($curlerr != '')
            {
                return [
                    "error" => "Http Post failed.",
                    "error_data" => $curlerr,
                ];
            }
            return json_decode($response,true);
        }
        catch(Exception $e)
        {
            return [
                "error" => "Http Post failed.",
                "error_data" => $e->getMessage(),
            ];
        }

    }

    function http_get($route){

        if($this->mode == 'live'){

            $url = self::BASE_URL_UAT."/".$route;

        } else {

            $url = self::BASE_URL_SANDBOX."/".$route;
        }


        $header = $this->build_auth();

        try
        {

            $curl = curl_init();
		    curl_setopt($curl, CURLOPT_URL, $url);
		    curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
		    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
		    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
		    curl_setopt($curl, CURLOPT_SSLVERSION, 6);
		    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		    curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);
		    curl_setopt($curl, CURLOPT_ENCODING, '');
		    curl_setopt($curl, CURLOPT_TIMEOUT, 60);
            $response = curl_exec($curl);
            $curlerr = curl_error($curl);
            if($curlerr != '')
            {
                return [
                    "error" => "Http Get failed.",
                    "error_data" => $curlerr,
                ];
            }
            return json_decode($response,true);
        }
        catch(Exception $e)
        {
            return [
                "error" => "Http Get failed.",
                "error_data" => $e->getMessage(),
            ];
        }
    }



    public function create_hash($data,$accesskey,$secretkey){
        ksort($data);
        $hash_string = $accesskey;
        foreach ($data as $key=>$value){
            $hash_string .= '|'.$value;
        }
        return hash_hmac("sha256",$hash_string,$secretkey);
    }

    public function verify_hash($data,$rec_hash,$accesskey,$secretkey){
        $gen_hash = self::create_hash($data,$accesskey,$secretkey);
        if($gen_hash === $rec_hash){
            return true;
        }
        return false;
    }




    public function onemoneystoresession(Request $request, $slug)
    {

        $this->setPaymentKey();
        $store    = Store::where('slug', $slug)->first();

        $products = '';
        $cart     = session()->get($slug);

        $accesskey = $this->access_key;
        $secretkey = $this->secret_key;
        $cust_details = $cart['customer'];
        // dd($cust_details);

        if(!empty($cart))
        {
            $products = $cart['products'];
        }
        else
        {
            return redirect()->back()->with('error',  'Cart is empty');
        }

        if(isset($cart['coupon']['data_id']))
        {
            $coupon = ProductCoupon::where('id', $cart['coupon']['data_id'])->first();
        }
        else
        {
            $coupon = '';
        }
        $product_name = [];
        $product_id   = [];
        $tax_name     = [];
        $totalprice   = 0;
        foreach($products as $key => $product)
        {
            if($product['variant_id'] == 0)
            {
                $new_qty                = $product['originalquantity'] - $product['quantity'];
                $product_edit           = Product::find($product['product_id']);
                $product_edit->quantity = $new_qty;
                $product_edit->save();
                $tax_price = 0;
                if(!empty($product['tax']))
                {
                    foreach($product['tax'] as $key => $taxs)
                    {
                        $tax_price += $product['price'] * $product['quantity'] * $taxs['tax'] / 100;
                    }
                }
                $totalprice     += $product['price'] * $product['quantity'] ;
                $product_name[] = $product['product_name'];
                $product_id[]   = $product['id'];
            }
            elseif($product['variant_id'] != 0)
            {
                $new_qty                   = $product['originalvariantquantity'] - $product['quantity'];
                $product_variant           = ProductVariantOption::find($product['variant_id']);
                $product_variant->quantity = $new_qty;
                $product_variant->save();
                $tax_price = 0;
                if(!empty($product['tax']))
                {
                    foreach($product['tax'] as $key => $taxs)
                    {
                        $tax_price += $product['variant_price'] * $product['quantity'] * $taxs['tax'] / 100;
                    }
                }
                $totalprice     += $product['variant_price'] * $product['quantity'] ;
                $product_name[] = $product['product_name'];
                $product_id[]   = $product['id'];
            }
        }
        $price=$totalprice+$tax_price;
        if(isset($cart['coupon']))
        {
            if($cart['coupon']['coupon']['enable_flat'] == 'off')
            {
                $discount_value = ($price / 100) * $cart['coupon']['coupon']['discount'];
                $price          = $price - $discount_value;
            }
            else
            {
                $discount_value = $cart['coupon']['coupon']['flat_discount'];
                $price          = $price - $discount_value;
            }
        }
        if(isset($cart['shipping']) && isset($cart['shipping']['shipping_id']) && !empty($cart['shipping']))
        {
            $shipping = Shipping::find($cart['shipping']['shipping_id']);

            $totalprice     = $price + $shipping->price;
            $shipping_name  = $shipping->name;
            $shipping_price = $shipping->price;
            $shipping_data  = json_encode(
                [
                    'shipping_name' => $shipping_name,
                    'shipping_price' => $shipping_price,
                    'location_id' => $cart['shipping']['location_id'],
                ]
            );
        }
        else
        {
            $shipping_data = '';
        }


        if($products)
        {
            $sample_data = [
                'amount' => $totalprice,
                'currency' => $store->currency_code,
                'name'  => $cust_details['name'],
                'email_id' => $cust_details['email'],
                'contact_number' => $cust_details['phone'],
                'mtx' => ''
            ];
            $remote_script = "https://sandbox-payments.open.money/layer";
            //for production
            //$remote_script = "https://payments.open.money/layer";

            //Hash functions requried in both request and response


            $tranid= time();

            $sample_data['mtx']= $tranid; //unique transaction id to be passed for each transaction
            $layer_payment_token_data = $this->create_payment_token($sample_data);
            $error = '';
            if(empty($error) && isset($layer_payment_token_data['error'])){
                $error = 'E55 Payment error. ' . ucfirst($layer_payment_token_data['error']);
                if(isset($layer_payment_token_data['error_data']))
                {
                    foreach($layer_payment_token_data['error_data'] as $d)
                        $error .= " ".ucfirst($d[0]);
                }
                return redirect()->back()->with('error',  $error);
            }

            if(empty($error) && (!isset($layer_payment_token_data["id"]) || empty($layer_payment_token_data["id"]))){
                $error = 'Payment error. ' . 'Layer token ID cannot be empty.';
                return redirect()->back()->with('error',  $error);
            }

            if(!empty($layer_payment_token_data["id"]))
                $payment_token_data = $this->get_payment_token($layer_payment_token_data["id"]);

            if(empty($error) && !empty($payment_token_data)){
                if(isset($layer_payment_token_data['error'])){
                    $error = 'E56 Payment error. ' . $payment_token_data['error'];
                    return redirect()->back()->with('error',  $error);
                }

                if(empty($error) && $payment_token_data['status'] == "paid"){
                    $error = "Layer: this order has already been paid.";
                    return redirect()->back()->with('error',  $error);
                }

                if(empty($error) && $payment_token_data['amount'] != $sample_data['amount']){
                    $error = "Layer: an amount mismatch occurred.";
                    return redirect()->back()->with('error',  $error);
                }

                $jsdata['payment_token_id'] = html_entity_decode((string) $payment_token_data['id'],ENT_QUOTES,'UTF-8');
                $jsdata['accesskey']  = html_entity_decode((string) $accesskey,ENT_QUOTES,'UTF-8');

                $hash = $this->create_hash(array(
                    'layer_pay_token_id'    => $payment_token_data['id'],
                    'layer_order_amount'    => $payment_token_data['amount'],
                    'tranid'    => $tranid,
                ),$accesskey,$secretkey);

                $html =  "<form action='".route('onemoney.check.payment',$slug)."' method='post' style='display: none' name='layer_payment_int_form'>
                    <input type='hidden' name='_token' value='".csrf_token()."'>
                    <input type='hidden' name='plan' value='".$request->plan_id."'>
                    <input type='hidden' name='layer_pay_token_id' value='".$payment_token_data['id']."'>
                    <input type='hidden' name='tranid' value='".$tranid."'>
                    <input type='hidden' name='layer_order_amount' value='".$payment_token_data['amount']."'>
                    <input type='hidden' id='layer_payment_id' name='layer_payment_id' value=''>
                    <input type='hidden' id='fallback_url' name='fallback_url' value=''>
                    <input type='hidden' name='hash' value='".$hash."'>
                    </form>";
                $html .= "<script>";
                $html .= "var layer_params = " . json_encode( $jsdata ) . ';';

                $html .="</script>";
                $html .= '<script src="./layer_checkout.js"></script>';

                return view('plans.onepayment',compact('html','remote_script','error'));
            }
        }
        else
        {
            return redirect()->back()->with('error',  'Cart is empty');
        }

    }

    public function onemoneyCheckpayment(Request $request,$slug){
        $store    = Store::where('slug', $slug)->first();
        $products = '';
        $cart     = session()->get($slug);
        if(\Auth::check())
        {
            $store_payment_setting = Utility::getPaymentSetting();
        }
        else
        {
            $store_payment_setting = Utility::getPaymentSetting($store->id);
        }
        $cust_details = $cart['customer'];

        if(!empty($cart))
        {
            $products = $cart['products'];
        }
        else
        {
            $res['flag'] = 2;
            $res['slug'] = $slug;
            return $res;
        }

        if(isset($cart['coupon']['data_id']))
        {
            $coupon = ProductCoupon::where('id', $cart['coupon']['data_id'])->first();
        }
        else
        {
            $coupon = '';
        }
        $product_name = [];
        $product_id   = [];
        $tax_name     = [];
        $totalprice   = 0;
        foreach($products as $key => $product)
        {
            if($product['variant_id'] == 0)
            {
                $new_qty                = $product['originalquantity'] - $product['quantity'];
                $product_edit           = Product::find($product['product_id']);
                $product_edit->quantity = $new_qty;
                $product_edit->save();
                $tax_price = 0;
                if(!empty($product['tax']))
                {
                    foreach($product['tax'] as $key => $taxs)
                    {
                        $tax_price += $product['price'] * $product['quantity'] * $taxs['tax'] / 100;
                    }
                }
                $totalprice     += $product['price'] * $product['quantity'] ;
                $product_name[] = $product['product_name'];
                $product_id[]   = $product['id'];
            }
            elseif($product['variant_id'] != 0)
            {
                $new_qty                   = $product['originalvariantquantity'] - $product['quantity'];
                $product_variant           = ProductVariantOption::find($product['variant_id']);
                $product_variant->quantity = $new_qty;
                $product_variant->save();
                $tax_price = 0;
                if(!empty($product['tax']))
                {
                    foreach($product['tax'] as $key => $taxs)
                    {
                        $tax_price += $product['variant_price'] * $product['quantity'] * $taxs['tax'] / 100;
                    }
                }
                $totalprice     += $product['variant_price'] * $product['quantity'] ;
                $product_name[] = $product['product_name'];
                $product_id[]   = $product['id'];
            }
        }
        $price=$totalprice+$tax_price;
        if(isset($cart['coupon']))
        {
            if($cart['coupon']['coupon']['enable_flat'] == 'off')
            {
                $discount_value = ($price / 100) * $cart['coupon']['coupon']['discount'];
                $price          = $price - $discount_value;
            }
            else
            {
                $discount_value = $cart['coupon']['coupon']['flat_discount'];
                $price          = $price - $discount_value;
            }
        }
        if(isset($cart['shipping']) && isset($cart['shipping']['shipping_id']) && !empty($cart['shipping']))
        {
            $shipping = Shipping::find($cart['shipping']['shipping_id']);

            $totalprice     = $price + $shipping->price;
            $shipping_name  = $shipping->name;
            $shipping_price = $shipping->price;
            $shipping_data  = json_encode(
                [
                    'shipping_name' => $shipping_name,
                    'shipping_price' => $shipping_price,
                    'location_id' => $cart['shipping']['location_id'],
                ]
            );
        }
        else
        {
            $shipping_data = '';
        }


        if($products)
        {

            $result = array();



            $this->setPaymentKey();
            if(!isset($request->layer_payment_id) || empty($request->layer_payment_id)){
                $error = "Invalid response.";
            }

            $data = array(
                'layer_pay_token_id'    => $request->layer_pay_token_id,
                'layer_order_amount'    => $request->layer_order_amount,
                'tranid'     			=> $request->tranid,
            );

            $orderID = time();

            $user    = \Auth::user();
            $pay_id = $request->layer_payment_id;
            if(empty($error) && self::verify_hash($data,$request->hash,$this->access_key,$this->secret_key) && !empty($data['tranid'])){


                $payment_data = $this->get_payment_details($request->layer_payment_id);


                if(isset($payment_data['error'])){
                    $error = "Layer: an error occurred E14".$payment_data['error'];
                }


                if(empty($error) && isset($payment_data['id']) && !empty($payment_data)){
                    if($payment_data['payment_token']['id'] != $data['layer_pay_token_id']){
                        $error = "Layer: received layer_pay_token_id and collected layer_pay_token_id doesnt match";
                    }
                    elseif($data['layer_order_amount'] != $payment_data['amount']){
                        $error = "Layer: received amount and collected amount doesnt match";
                    }
                    else {

                        switch ($payment_data['status']){
                            case 'authorized':
                                if (Utility::CustomerAuthCheck($store->slug)) {
                                    $customer = Auth::guard('customers')->user()->id;
                                }else{
                                    $customer = 0;
                                }
                                $customer               = Auth::guard('customers')->user();
                                $order                  = new Order();
                                $order->order_id        = time();
                                $order->name            = $cust_details['name'];
                                $order->email           = $cust_details['email'];
                                $order->card_number     = '';
                                $order->card_exp_month  = '';
                                $order->card_exp_year   = '';
                                $order->status          = 'pending';
                                $order->user_address_id = $cust_details['id'];
                                $order->shipping_data   = $shipping_data;
                                $order->product_id      = implode(',', $product_id);
                                $order->price           = $price;
                                $order->coupon          = isset($cart['coupon']['data_id']) ? $cart['coupon']['data_id'] : '';
                                $order->coupon_json     = json_encode($coupon);
                                $order->discount_price  = isset($cart['coupon']['discount_price']) ? $cart['coupon']['discount_price'] : '';
                                $order->product         = json_encode($products);
                                $order->price_currency  = $store->currency_code;
                                $order->txn_id          = isset($tran_id) ? $tran_id : '';
                                $order->payment_type    = 'flutterwave';
                                $order->payment_status  = 'success';
                                $order->receipt         = '';
                                $order->user_id         = $store['id'];
                                $order->customer_id     = isset($customer->id) ? $customer->id : '';
                                $order->save();

                                if ((!empty(Auth::guard('customers')->user()) && $store->is_checkout_login_required == 'on') ){
                                    foreach($products as $product_id)
                                    {
                                        $purchased_products = new PurchasedProducts();
                                        $purchased_products->product_id  = $product_id['product_id'];
                                        $purchased_products->customer_id = $customer->id;
                                        $purchased_products->order_id   = $order->id;
                                        $purchased_products->save();
                                    }
                                }
                                $msg = redirect()->route(
                                    'store-complete.complete', [
                                                                $store->slug,
                                                                Crypt::encrypt($order->id),
                                                            ]
                                )->with('success', __('Transaction has been success'));

                                session()->forget($slug);
                                $order_email = $order->email;
                                $order_id    = Crypt::encrypt($order->id);

                                $owner=User::find($store->created_by);
                                $owner_email=$owner->email;
                                if(isset($store->mail_driver) && !empty($store->mail_driver))
                                {
                                    $dArr = [
                                        'order_name' => $order->name,
                                    ];


                                    $resp = Utility::sendEmailTemplate('Order Created', $order_email, $dArr, $store, $order_id);

                                    $resp1=Utility::sendEmailTemplate('Order Created For Owner', $owner_email, $dArr, $store, $order_id);


                                }
                                if(isset($store->is_twilio_enabled) && $store->is_twilio_enabled=="on")
                                {
                                    Utility::order_create_owner($order,$owner,$store);
                                    Utility::order_create_customer($order,$customer,$store);
                                }

                                return redirect()->route(
                                    'store-complete.complete', [
                                                                 $store->slug,
                                                                 Crypt::encrypt($order->id),
                                                             ]
                                )->with('success', __('Transaction has been success'));

                            case 'captured':
                                if (Utility::CustomerAuthCheck($store->slug)) {
                                    $customer = Auth::guard('customers')->user()->id;
                                }else{
                                    $customer = 0;
                                }
                                $customer               = Auth::guard('customers')->user();
                                $order                  = new Order();
                                $order->order_id        = time();
                                $order->name            = $cust_details['name'];
                                $order->email           = $cust_details['email'];
                                $order->card_number     = '';
                                $order->card_exp_month  = '';
                                $order->card_exp_year   = '';
                                $order->status          = 'pending';
                                $order->user_address_id = $cust_details['id'];
                                $order->shipping_data   = $shipping_data;
                                $order->product_id      = implode(',', $product_id);
                                $order->price           = $price;
                                $order->coupon          = isset($cart['coupon']['data_id']) ? $cart['coupon']['data_id'] : '';
                                $order->coupon_json     = json_encode($coupon);
                                $order->discount_price  = isset($cart['coupon']['discount_price']) ? $cart['coupon']['discount_price'] : '';
                                $order->product         = json_encode($products);
                                $order->price_currency  = $store->currency_code;
                                $order->txn_id          = isset($tran_id) ? $tran_id : '';
                                $order->payment_type    = 'One Money';
                                $order->payment_status  = 'success';
                                $order->receipt         = '';
                                $order->user_id         = $store['id'];
                                $order->customer_id     = isset($customer->id) ? $customer->id : '';
                                $order->save();

                                if ((!empty(Auth::guard('customers')->user()) && $store->is_checkout_login_required == 'on') ){
                                    foreach($products as $product_id)
                                    {
                                        $purchased_products = new PurchasedProducts();
                                        $purchased_products->product_id  = $product_id['product_id'];
                                        $purchased_products->customer_id = $customer->id;
                                        $purchased_products->order_id   = $order->id;
                                        $purchased_products->save();
                                    }
                                }
                                $msg = redirect()->route(
                                    'store-complete.complete', [
                                                                $store->slug,
                                                                Crypt::encrypt($order->id),
                                                            ]
                                )->with('success', __('Transaction has been success'));

                                session()->forget($slug);
                                $order_email = $order->email;
                                $order_id    = Crypt::encrypt($order->id);

                                $owner=User::find($store->created_by);
                                $owner_email=$owner->email;
                                if(isset($store->mail_driver) && !empty($store->mail_driver))
                                {
                                    $dArr = [
                                        'order_name' => $order->name,
                                    ];


                                    $resp = Utility::sendEmailTemplate('Order Created', $order_email, $dArr, $store, $order_id);

                                    $resp1=Utility::sendEmailTemplate('Order Created For Owner', $owner_email, $dArr, $store, $order_id);


                                }
                                if(isset($store->is_twilio_enabled) && $store->is_twilio_enabled=="on")
                                {
                                    Utility::order_create_owner($order,$owner,$store);
                                    Utility::order_create_customer($order,$customer,$store);
                                }

                                return redirect()->route(
                                    'store-complete.complete', [
                                                                 $store->slug,
                                                                 Crypt::encrypt($order->id),
                                                             ]
                                )->with('success', __('Transaction has been success'));
                            case 'failed':
                            case 'cancelled':
                                $status = "Payment cancelled/failed: Payment ID ". $payment_data['id'];

                                break;
                            default:
                                $status = "Payment pending: Payment ID ". $payment_data['id'];
                                exit;
                            break;

                        }


                    }
                }

            }else {

                return redirect()->route('store-payment.payment',$slug)->with('error', 'Oops something wrong wrong');
            }
        }


    }

}
