<?php

namespace App\Http\Controllers;

use App\Models\Service;
use App\Models\ServiceValues;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use App\Models\Store;
use App\Models\Utility;

class ServiceController extends Controller
{

    public function __construct()
    {
        if (Auth::check()) {
            $userlang = \Auth::user()->lang;
            \App::setLocale($userlang);
        }
    }



    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $user             = \Auth::user();
        $store_id         = Store::where('id', $user->current_store)->first();
        $services         = Service::where('created_by', $user->id)->orderBy('id', 'DESC')->get();
        return view('service.index', compact('services'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $user              = \Auth::user();
        $store_id          = Store::where('id', $user->current_store)->first();
        return view('service.create');
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $rules = [
            'title' => 'required',
        ];
        $validator = \Validator::make($request->all(), $rules);

        if ($validator->fails()) {
            $messages = $validator->getMessageBag();
            return redirect()->back()->with('failed', $messages->first());
        }
        $fileAttachment = '';
        if (request()->file('logo')) {
            $filenameWithExt = $request->file('logo')->getClientOriginalName();
            $filename        = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            $extension       = $request->file('logo')->getClientOriginalExtension();
            $fileAttachment  = $filename . '_' . time() . '.' . $extension;
            $dir             = storage_path('uploads/service_logo/');
            if (!file_exists($dir)) {
                mkdir($dir, 0777, true);
            }
            $path = $request->file('logo')->storeAs('uploads/service_logo/', $fileAttachment);
        }

        $user = Auth::user();




        $form = Service::create([

            'title' => $request->title,
            'description' => $request->description,
            'logo' => $fileAttachment,
            'json' => '',
            'html' => '',
            'created_by' => Auth::user()->id,

        ]);



        return redirect()->route('service.index')->with('success', __('Service successfully created!'));
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Service  $service
     * @return \Illuminate\Http\Response
     */
    public function show(Service $service)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Service  $service
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $service = Service::find($id);
        return view('service.edit', compact('service'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Service  $service
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $service_id)
    {
        $service = Service::find($service_id);

        $user     = \Auth::user();
        $store_id = Store::where('id', $user->current_store)->first();

        $validator = \Validator::make(
            $request->all(),
            [
                'title' => 'required|max:120',
            ]
        );

        if (!empty($request->logo)) {
            if (asset(Storage::exists('uploads/service_logo/' . $service->logo))) {
                asset(Storage::delete('uploads/service_logo/' . $service->logo));
            }

            $filenameWithExt = $request->file('logo')->getClientOriginalName();
            $filename        = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            $extension       = $request->file('logo')->getClientOriginalExtension();
            $fileAttachment  = $filename . '_' . time() . '.' . $extension;
            $settings = Utility::getStorageSetting();

            if ($settings['storage_setting'] == 'local') {
                $dir        = 'uploads/service_logo/';
            } else {
                $dir        = 'uploads/service_logo/';
            }
            $path = Utility::upload_file($request, 'logo', $fileAttachment, $dir, []);

            if ($path['flag'] == 1) {
                $url = $path['url'];
            } else {
                return redirect()->back()->with('error', __($path['msg']));
            }
        }

        $service['logo']             = !empty($request->logo) ? $fileAttachment : '';
        $service['title'] = $request->title;
        $service['description'] = $request->description;
        $service->save();


        return redirect()->route('service.index')->with('success', __('Service successfully updated!'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Service  $service
     * @return \Illuminate\Http\Response
     */
    public function destroy(Service $service)
    {
        $service->delete();
        return redirect()->back()->with('success', __('Service successfully deleted!'));
    }

    public function design($id)
    {
        $service = Service::find($id);
        if ($service) {
            return view('service.design', compact('service'));
        } else {
            return redirect()->back()->with('failed', __('Service not found'));
        }
    }
    public function designUpdate(Request $request, $id)
    {
        $service = Service::find($id);
        if ($service) {
            $service->json = $request->json;
            $service->save();

            return redirect()->route('service.index')->with('success', __('Service Form successfully updated!'));
        } else {
            return redirect()->back()->with('failed', __('Service not found'));
        }
    }

    public function fill($id)
    {

        $service = Service::find($id);
        $user = \Auth::user();
        $service_value = null;
        if ($service) {

            $array = $service->getFormArray();
            return view('service.fill', compact('service', 'service_value', 'array'));
        } else {
            return redirect()->back()->with('failed', __('Service not found'));
        }
    }

    public function fillStore(Request $request, $id)
    {
        // dd($request->all());
        $service = Service::find($id);
        
            
        if ($service) {
            $questions = [];
            $client_emails = [];
            if ($request->form_value_id) {
                $form_value = ServiceValues::find($request->form_value_id);
                $array = json_decode($form_value->json);
            } else {
                $array = $service->getFormArray();
            }

            foreach ($array as &$rows) {
                foreach ($rows as &$row) {
                    if ($row->type == 'checkbox-group') {
                        foreach ($row->values as &$value) {
                            if (is_array($request->{$row->name}) && in_array($value->value, $request->{$row->name})) {
                                $value->selected = 1;
                            } else {
                                if (isset($value->selected)) {
                                    unset($value->selected);
                                }
                            }
                        }
                    } elseif ($row->type == 'file') {
                        if (isset($row->multiple)) {

                            if ($request->hasFile($row->name)) {
                                $values = [];
                                $allowedfileExtension = ['jpeg', 'jpg', 'png'];
                                $files = $request->file($row->name);
                                foreach ($files as $file) {
                                    $extension = $file->getClientOriginalExtension();
                                    $check = in_array($extension, $allowedfileExtension);
                                    if ($check) {
                                        $filename = $file->store('form_values/' . $service->id);
                                        $values[] = $filename;
                                    } else {
                                        if (isset($request->ajax)) {
                                            return response()->json(['is_success' => false, 'message' => __('Invalid File type, Please upload jpeg, jpg, png files')], 200);
                                        } else {
                                            return redirect()->back()->with('failed', __('Invalid File type, Please upload jpeg, jpg, png files'));
                                        }
                                    }
                                }
                                $row->value = $values;
                            }
                        } else {

                            if ($request->hasFile($row->name)) {
                                $values = '';
                                $allowedfileExtension = ['jpeg', 'jpg', 'png'];
                                $file = $request->file($row->name);
                                $extension = $file->getClientOriginalExtension();
                                $check = in_array($extension, $allowedfileExtension);
                                if ($check) {
                                    $filename = $file->store('form_values/' . $service->id);
                                    $values = $filename;
                                } else {
                                    if (isset($request->ajax)) {
                                        return response()->json(['is_success' => false, 'message' => __('Invalid File type, Please upload jpeg, jpg, png files')], 200);
                                    } else {
                                        return redirect()->back()->with('failed', __('Invalid File type, Please upload jpeg, jpg, png files'));
                                    }
                                }
                                $row->value = $values;
                            }
                        }
                    } elseif ($row->type == 'radio-group') {
                        foreach ($row->values as &$value) {
                            if ($value->value == $request->{$row->name}) {
                                $value->selected = 1;
                            } else {
                                if (isset($value->selected)) {
                                    unset($value->selected);
                                }
                            }
                        }
                    } elseif ($row->type == 'autocomplete') {
                        if (isset($row->multiple)) {
                            foreach ($row->values as &$value) {
                                if (is_array($request->{$row->name}) && in_array($value->value, $request->{$row->name})) {
                                    $value->selected = 1;
                                } else {
                                    if (isset($value->selected)) {
                                        unset($value->selected);
                                    }
                                }
                            }
                        } else {


                            foreach ($row->values as &$value) {
                                if ($value->value == $request->{$row->name}) {
                                    $value->selected = 1;
                                } else {
                                    if (isset($value->selected)) {
                                        unset($value->selected);
                                    }
                                }
                            }
                        }
                    } elseif ($row->type == 'select') {
                        // d($row
                        if (isset($row->multiple) & !empty($row->multiple)) {
                            foreach ($row->values as &$value) {

                                if (is_array($request->{$row->name}) && in_array($value->value, $request->{$row->name})) {
                                    $value->selected = 1;
                                } else {
                                    if (isset($value->selected)) {
                                        unset($value->selected);
                                    }
                                }
                            }
                        } else {


                            foreach ($row->values as &$value) {
                                if ($value->value == $request->{$row->name}) {
                                    $value->selected = 1;
                                } else {
                                    if (isset($value->selected)) {
                                        unset($value->selected);
                                    }
                                }
                            }
                        }
                    } elseif ($row->type == 'date') {
                        $row->value = $request->{$row->name};
                    } elseif ($row->type == 'number') {
                        $row->value = $request->{$row->name};
                    } elseif ($row->type == 'textarea') {
                        $row->value = $request->{$row->name};
                    } elseif ($row->type == 'text') {
                        $client_email = '';

                        if ($row->subtype == 'email') {
                            if (isset($row->is_client_email) && $row->is_client_email) {

                                $client_emails[] = $request->{$row->name};
                            }
                        }
                        $row->value = $request->{$row->name};
                    } elseif ($row->type == 'starRating') {
                        $row->value = $request->{$row->name};
                    }
                }
            }

            if ($request->form_value_id) {
                $form_value->json = json_encode($array);
                $form_value->save();
                // dd($client_email);
            } else {
                if (\Auth::user()) {
                    $user_id = \Auth::user()->id;
                } else {
                    $user_id = NULL;
                }
                $data = [];
               

                $data['service_id'] = $service->id;
                $data['user_id'] = $user_id;
                $data['json'] = json_encode($array);
                $form_value = ServiceValues::create($data);
            }


          
           
           
            if (isset($request->ajax)) {
                return response()->json(['is_success' => true, 'message' => 'Service Save Successfully', 'redirect' => route('edit.service.values', $form_value->id)], 200);
            } else {
                return redirect()->back()->with('success', 'Service Save Successfully');
            }
        } else {
            if (isset($request->ajax)) {
                return response()->json(['is_success' => false, 'message' => __('Form not found')], 200);
            } else {
                return redirect()->back()->with('failed', __('Form not found'));
            }
        }
    }

    public function upload(Request $request)
    {
        if ($request->hasFile('upload')) {
            $originName = $request->file('upload')->getClientOriginalName();
            $fileName = pathinfo($originName, PATHINFO_FILENAME);
            $extension = $request->file('upload')->getClientOriginalExtension();
            $fileName = $fileName . '_' . time() . '.' . $extension;

            $request->file('upload')->move(public_path('images'), $fileName);

            $CKEditorFuncNum = $request->input('CKEditorFuncNum');
            $url = asset('public/images/' . $fileName);

            $msg = 'Image uploaded successfully';

            $response = "<script>window.parent.CKEDITOR.tools.callFunction($CKEditorFuncNum, '$url', '$msg')</script>";
            @header('Content-type: text/html; charset=utf-8');
            echo $response;
        }
    }
}
