<?php

namespace App\Http\Controllers;

use App\Models\ProductTax;
use Illuminate\Http\Request;

class ProductTaxController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $user         = \Auth::user()->current_store;
        $product_taxs = ProductTax::where('store_id', $user)->where('created_by', \Auth::user()->creatorId())->get();

        return view('producttax.index', compact('product_taxs'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {

        $data = [];
        if (empty($data)) {
            $path = storage_path() . "/uploads/world/" . "world.json";
            $countries = json_decode(file_get_contents($path), true);
        }
        $cities = $countries['India'];


        return view('producttax.create', compact('cities'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = \Validator::make(
            $request->all(),
            [
                'tax_type' => 'required',

            ]
        );
        if ($validator->fails()) {
            $messages = $validator->getMessageBag();

            return redirect()->back()->with('error', $messages->first());
        }
        if ($request['tax_type'] == 'local') {
            $validator = \Validator::make(
                $request->all(),
                [
                    'state' => 'required',
                    'sgst_rate' => 'required',
                    'cgst_rate' => 'required',

                ]
            );
        } else {
            $validator = \Validator::make(
                $request->all(),
                [
                    'igst_rate' => 'required',
                    'sgst_rate' => 'required',

                ]
            );
        }
        if ($validator->fails()) {
            $messages = $validator->getMessageBag();

            return redirect()->back()->with('error', $messages->first());
        }
        $name                     = $request['tax_type'];
        $producttax               = new ProductTax();
        $producttax->state        = $request['state'];
        $producttax->name         = $name;
        $producttax->tax_type         = $request['tax_type'];
        $producttax->sgst_rate         = $request['sgst_rate'];
        $producttax->cgst_rate         = $request['cgst_rate'];
        $producttax->igst_rate         = $request['igst_rate'];
        $producttax->rounding         = isset($request->rounding) ? 1 : 0;
        $producttax->shop_price         = $request['shop_price'];
        $producttax->cart_price         = $request['cart_price'];
        $producttax['store_id']   = \Auth::user()->current_store;
        $producttax['created_by'] = \Auth::user()->creatorId();
        $producttax->save();

        return redirect()->back()->with('success', __('Product Tax added!'));
    }

    /**
     * Display the specified resource.
     *
     * @param \App\ProductTax $productTax
     *
     * @return \Illuminate\Http\Response
     */
    public function show(ProductTax $productTax)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param \App\ProductTax $productTax
     *
     * @return \Illuminate\Http\Response
     */
    public function edit(ProductTax $productTax)
    {
        $data = [];
        if (empty($data)) {
            $path = storage_path() . "/uploads/world/" . "world.json";
            $countries = json_decode(file_get_contents($path), true);
        }
        $cities = $countries['India'];
        return view('producttax.edit', compact('productTax', 'cities'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param \App\ProductTax $productTax
     *
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ProductTax $productTax)
    {
        $validator = \Validator::make(
            $request->all(),
            [
                'tax_type' => 'required',

            ]
        );
        if ($validator->fails()) {
            $messages = $validator->getMessageBag();

            return redirect()->back()->with('error', $messages->first());
        }
        if ($request['tax_type'] == 'local') {
            $validator = \Validator::make(
                $request->all(),
                [
                    'state' => 'required',
                    'sgst_rate' => 'required',
                    'cgst_rate' => 'required',

                ]
            );
        } else {
            $validator = \Validator::make(
                $request->all(),
                [
                    'igst_rate' => 'required',
                    'sgst_rate' => 'required',

                ]
            );
        }
        if ($validator->fails()) {
            $messages = $validator->getMessageBag();

            return redirect()->back()->with('error', $messages->first());
        }
        $productTax['tax_type']       = $request->tax_type;
        $productTax['name']       = $request->tax_type;
        $productTax['state']       = $request->state;
        $productTax['igst_rate']       = $request->igst_rate;
        $productTax['sgst_rate']       = $request->sgst_rate;
        $productTax['cgst_rate']       = $request->cgst_rate;

        $productTax['rounding']       = isset($request->rounding) ? 1 : 0;
        $productTax['shop_price']       = $request->shop_price;
        $productTax['cart_price']       = $request->cart_price;
        $producttax['created_by'] = \Auth::user()->creatorId();
        $productTax->update();

        return redirect()->back()->with(
            'success',
            __('Product Tax updated!')
        );
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param \App\ProductTax $productTax
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy(ProductTax $productTax)
    {
        $productTax->delete();

        return redirect()->back()->with(
            'success',
            __('Product Tax Deleted!')
        );
    }
}
