<?php

namespace App\Http\Controllers;

use App\Models\Product;
use App\Models\ProductCategorie;
use App\Models\ProductSubcategorie;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use App\Models\Utility;

class ProductSubcategorieController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        if (Auth::user()->type == 'super admin') {
            $product_subcategorys = ProductSubcategorie::where('store_id', 0)->get();

            return view('product_subcategory.index', compact('product_subcategorys'));
        }else{

            $user = \Auth::user()->current_store;
            
            $product_subcategorys = ProductSubcategorie::where('store_id', $user)->where('created_by', \Auth::user()->creatorId())->get();
            
            return view('product_subcategory.index', compact('product_subcategorys'));
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $product_categorie = ProductCategorie::where('store_id', 0)->get()->pluck('name', 'id');
        $product_categorie->prepend('Select Category', '');
        return view('product_subcategory.create',compact('product_categorie'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     *
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
         if (Auth::user()->type == 'super admin') {
        $pro_cat = ProductSubcategorie::where('name', $request->name)->where('category_id',$request->category_id)->where('store_id',0)->first();
         }else{
        $pro_cat = ProductSubcategorie::where('name', $request->name)->where('category_id', $request->category_id)->where('store_id',Auth::user()->current_store)->first();

         }

        if(!empty($pro_cat))
        {
            return redirect()->back()->with('error', __('Product Category Already Exist!'));
        }

        if(!empty($request->categorie_img))
        {
            $filenameWithExt  = $request->file('categorie_img')->getClientOriginalName();
            $filename         = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            $extension        = $request->file('categorie_img')->getClientOriginalExtension();
            $fileNameToStores = $filename . '_' . time() . '.' . $extension;
            $settings = Utility::getStorageSetting();
            if($settings['storage_setting']=='local'){
                $dir        = 'uploads/product_image/';
            }
            else{
                    $dir        = 'uploads/product_image/';
            }
            $path = Utility::upload_file($request, 'subcategorie_img',$fileNameToStores,$dir,[]);

            if($path['flag'] == 1){
                $url = $path['url'];
            }else{
                return redirect()->back()->with('error', __($path['msg']));
            }
            // $dir              = storage_path('uploads/product_image/');
            // if(!file_exists($dir))
            // {
            //     mkdir($dir, 0777, true);
            // }
            // $path = $request->file('categorie_img')->storeAs('uploads/product_image/', $fileNameToStores);
        }

        $ProductSubcategorie             = new ProductSubcategorie();
        if (Auth::user()->type == 'super admin') {
            $ProductSubcategorie['store_id'] = 0;
        }else{
            $ProductSubcategorie['store_id'] = \Auth::user()->current_store;
        }
        $ProductSubcategorie['name']     = $request->name;
        $ProductSubcategorie['category_id']     = $request->category_id;
        if(!empty($fileNameToStores))
        {
            $ProductSubcategorie['categorie_img'] = $fileNameToStores;
        }
        $ProductSubcategorie['created_by'] = \Auth::user()->creatorId();
        $ProductSubcategorie->save();

        return redirect()->back()->with('success', __('Product Sub Category added!'));
    }

    /**
     * Display the specified resource.
     *
     * @param \App\ProductSubcategorie $ProductSubcategorie
     *
     * @return \Illuminate\Http\Response
     */

    public function show(ProductSubcategorie $ProductSubcategorie)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param \App\ProductSubcategorie $ProductSubcategorie
     *
     * @return \Illuminate\Http\Response
     */
    public function edit(ProductSubcategorie $productSubcategorie)
    {
        $product_categorie = ProductCategorie::where('store_id', 0)->get()->pluck('name', 'id');
        $product_categorie->prepend('Select Category', '');
        return view('product_subcategory.edit', compact('productSubcategorie', 'product_categorie'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param \Illuminate\Http\Request $request
     * @param \App\ProductSubcategorie $ProductSubcategorie
     *
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, ProductSubcategorie $ProductSubcategorie)
    {
        if (Auth::user()->type == 'super admin') {
            $pro_cat = ProductSubcategorie::where('name', $request->name)->where('category_id', $request->category_id)->where('store_id', 0)->first();
        } else {
            $pro_cat = ProductSubcategorie::where('name', $request->name)->where('category_id', $request->category_id)->where('store_id', Auth::user()->current_store)->first();
        }

        if(!empty($request->categorie_img))
        {
            if(!empty($pro_cat->categorie_img))
            {
                if(asset(Storage::exists('uploads/product_image/' . $pro_cat->categorie_img)))
                {
                    asset(Storage::delete('uploads/product_image/' . $pro_cat->categorie_img));
                }
            }

            $filenameWithExt  = $request->file('categorie_img')->getClientOriginalName();
            $filename         = pathinfo($filenameWithExt, PATHINFO_FILENAME);
            $extension        = $request->file('categorie_img')->getClientOriginalExtension();
            $fileNameToStores = $filename . '_' . time() . '.' . $extension;
            $settings = Utility::getStorageSetting();
            if($settings['storage_setting']=='local'){
                $dir        = 'uploads/product_image/';
            }
            else{
                    $dir        = 'uploads/product_image/';
            }
            $path = Utility::upload_file($request,'subcategorie_img',$fileNameToStores,$dir,[]);

            if($path['flag'] == 1){
                $url = $path['url'];
            }else{
                return redirect()->back()->with('error', __($path['msg']));
            }
            // $dir              = storage_path('uploads/product_image/');
            // if(asset(Storage::exists('uploads/product_image/' . ($ProductSubcategorie['categorie_img']))))
            // {
            //     asset(Storage::delete('uploads/product_image/' . $ProductSubcategorie['categorie_img']));
            // }

            // if(!file_exists($dir))
            // {
            //     mkdir($dir, 0777, true);
            // }

            // $path = $request->file('categorie_img')->storeAs('uploads/product_image/', $fileNameToStores);
        }


        $ProductSubcategorie['name'] = $request->name;
        $ProductSubcategorie['category_id'] = $request->category_id;
        if(!empty($fileNameToStores))
        {
            $ProductSubcategorie['categorie_img'] = $fileNameToStores;
        }
        $ProductSubcategorie['created_by'] = \Auth::user()->creatorId();
        $ProductSubcategorie->update();

        return redirect()->back()->with('success', __('Product Category updated!'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param \App\ProductSubcategorie $ProductSubcategorie
     *
     * @return \Illuminate\Http\Response
     */
    public function destroy(ProductSubcategorie $ProductSubcategorie)
    {
        $product = Product::where('product_subcategorie', $ProductSubcategorie->id)->get();

        if($product->count() != 0)
        {
            return redirect()->back()->with(
                'error', __('Category is used in products!')
            );
        }
        else
        {
            $ProductSubcategorie->delete();

            return redirect()->back()->with(
                'success', __('Product Category Deleted!')
            );
        }
    }
}
