<?php

namespace App\Http\Controllers;
use App\Models\Utility;
use App\Models\Plan;
use App\Models\Coupon;
use App\Models\UserCoupon;
use App\Models\Order;
use App\Models\Product;
use App\Models\ProductCoupon;
use App\Models\ProductVariantOption;
use App\Models\Store;
use Exception;
use Illuminate\Http\Request;
use Throwable;

class OneMoneyPaymentController extends Controller
{
    const BASE_URL_SANDBOX = "https://sandbox-icp-api.bankopen.co/api";
    const BASE_URL_UAT = "https://icp-api.bankopen.co/api";

    public $access_key;
    public $secret_key;
    public $mode;


    public function setPaymentKey(){

        if(\Auth::user()->type == 'super admin'){
            $payment_setting = Utility::getAdminPaymentSetting();
        }else{
            $payment_setting = Utility::getPaymentSetting();
        }

        $this->secret_key = isset($payment_setting['onemoney_secret_key']) ? $payment_setting['onemoney_secret_key'] : '';
        $this->access_key = isset($payment_setting['onemoney_public_key']) ? $payment_setting['onemoney_public_key'] : '';
        $this->mode = isset($payment_setting['onemony_mode']) ? $payment_setting['onemony_mode'] : 'sandbox';

        return $this;
    }


    public function create_payment_token($data){

        $this->setPaymentKey();
        try {
            $pay_token_request_data = array(
                'amount'   			=> (!empty($data['amount']))? $data['amount'] : NULL,
                'currency' 			=> (!empty($data['currency']))? $data['currency'] : NULL,
                'name'     			=> (!empty($data['name']))? $data['name'] : NULL,
                'email_id' 			=> (!empty($data['email_id']))? $data['email_id'] : NULL,
                'contact_number' 	=> (!empty($data['contact_number']))?  $data['contact_number'] : NULL,
                'mtx'    			=> (!empty($data['mtx']))? $data['mtx'] : NULL,
                'udf'    			=> (!empty($data['udf']))? $data['udf'] : NULL,
            );

            $pay_token_data = $this->http_post($pay_token_request_data,"payment_token");

            return $pay_token_data;
        } catch (Exception $e){
            return [
                'error' => $e->getMessage()
            ];

        } catch (Throwable $e){

			return [
                'error' => $e->getMessage()
            ];
        }
    }

    public function get_payment_token($payment_token_id){

        if(empty($payment_token_id)){

            throw new Exception("payment_token_id cannot be empty.");
        }

        try {

            return $this->http_get("payment_token/".$payment_token_id);

        } catch (Exception $e){

            return [
                'error' => $e->getMessage()
            ];

        } catch (Throwable $e){

            return [
                'error' => $e->getMessage()
            ];
        }

    }

    public function get_payment_details($payment_id){

        if(empty($payment_id)){

            throw new Exception("payment_id cannot be empty.");
        }

        try {

            return $this->http_get("payment/".$payment_id);

        } catch (Exception $e){

            return [
                'error' => $e->getMessage()
            ];

        } catch (Throwable $e){

            return [
                'error' => $e->getMessage()
            ];
        }

    }


    public function build_auth(){
        $this->setPaymentKey();
        return array(
            'Content-Type: application/json',
            'Authorization: Bearer '.$this->access_key.':'.$this->secret_key
        );

    }
    function http_post($data,$route){
        $this->setPaymentKey();
        foreach (@$data as $key=>$value){

            if(empty($data[$key])){

                unset($data[$key]);
            }
        }

        if($this->mode == 'live'){

            $url = self::BASE_URL_UAT."/".$route;

        } else {

            $url = self::BASE_URL_SANDBOX."/".$route;
        }


        $header = $this->build_auth();

        try
        {
            $curl = curl_init();
		    curl_setopt($curl, CURLOPT_URL, $url);
		    curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
		    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
		    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
		    curl_setopt($curl, CURLOPT_SSLVERSION, 6);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($curl, CURLOPT_MAXREDIRS,10);
		    curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);
		    curl_setopt($curl, CURLOPT_ENCODING, '');
		    curl_setopt($curl, CURLOPT_TIMEOUT, 60);
            curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'POST');
            curl_setopt($curl, CURLOPT_POSTFIELDS, json_encode($data, JSON_HEX_APOS|JSON_HEX_QUOT ));

		    $response = curl_exec($curl);
            $curlerr = curl_error($curl);

            if($curlerr != '')
            {
                return [
                    "error" => "Http Post failed.",
                    "error_data" => $curlerr,
                ];
            }
            return json_decode($response,true);
        }
        catch(Exception $e)
        {
            return [
                "error" => "Http Post failed.",
                "error_data" => $e->getMessage(),
            ];
        }

    }

    function http_get($route){

        if($this->mode == 'live'){

            $url = self::BASE_URL_UAT."/".$route;

        } else {

            $url = self::BASE_URL_SANDBOX."/".$route;
        }


        $header = $this->build_auth();

        try
        {

            $curl = curl_init();
		    curl_setopt($curl, CURLOPT_URL, $url);
		    curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
		    curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
		    curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);
		    curl_setopt($curl, CURLOPT_SSLVERSION, 6);
		    curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
		    curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);
		    curl_setopt($curl, CURLOPT_ENCODING, '');
		    curl_setopt($curl, CURLOPT_TIMEOUT, 60);
            $response = curl_exec($curl);
            $curlerr = curl_error($curl);
            if($curlerr != '')
            {
                return [
                    "error" => "Http Get failed.",
                    "error_data" => $curlerr,
                ];
            }
            return json_decode($response,true);
        }
        catch(Exception $e)
        {
            return [
                "error" => "Http Get failed.",
                "error_data" => $e->getMessage(),
            ];
        }
    }


    public function onemoney(Request $request){


        $this->setPaymentKey();
        $error = '';
        $tranid=date("ymd").'-'.rand(1,100000);
        $user    = \Auth::user();

        $planID    = \Illuminate\Support\Facades\Crypt::decrypt($request->plan_id);
        $plan      = Plan::find($planID);
        $authuser  = \Auth::user();
        $coupon_id = '';


        if($plan)
        {

            $price = $plan->price;
            if(isset($request->coupon) && !empty($request->coupon))
            {
                $request->coupon = trim($request->coupon);
                $coupons         = Coupon::where('code', strtoupper($request->coupon))->where('is_active', '1')->first();
                if(!empty($coupons))
                {
                    $usedCoupun             = $coupons->used_coupon();
                    $discount_value         = ($price / 100) * $coupons->discount;
                    $plan->discounted_price = $price - $discount_value;

                    if($usedCoupun >= $coupons->limit)
                    {
                        return redirect()->back()->with('error', __('This coupon code has expired.'));
                    }
                    $price     = $price - $discount_value;
                    $coupon_id = $coupons->id;
                }
                else
                {
                    return redirect()->back()->with('error', __('This coupon code is invalid or has expired.'));
                }
            }

            if($price <= 0)
            {
                $authuser->plan = $plan->id;
                $authuser->save();

                $assignPlan = $authuser->assignPlan($plan->id);

                if($assignPlan['is_success'] == true && !empty($plan))
                {

                    $orderID = strtoupper(str_replace('.', '', uniqid('', true)));
                    Order::create(
                        [
                            'order_id' => $orderID,
                            'name' => null,
                            'email' => null,
                            'card_number' => null,
                            'card_exp_month' => null,
                            'card_exp_year' => null,
                            'plan_name' => $plan->name,
                            'plan_id' => $plan->id,
                            'price' => $price == null ? 0 : $price,
                            'price_currency' => !empty(env('CURRENCY')) ? env('CURRENCY') : 'USD',
                            'txn_id' => '',
                            'payment_type' => 'One Money',
                            'payment_status' => 'succeeded',
                            'receipt' => null,
                            'user_id' => $authuser->id,
                        ]
                    );
                    return redirect()->route('plans.index')->with('success', __('Plan activated Successfully!'));

                }
                else
                {
                    return redirect()->route('plans.index')->with('error', __('Plan fail to upgrade.'));
                }
            }


        $sample_data = [
            'amount' => $price,
            'currency' => !empty(env('CURRENCY')) ? env('CURRENCY') : 'USD',
            'name'  => $user->name,
            'email_id' => $user->email,
            'contact_number' => '9999999999',
            'mtx' => ''
        ];
        $remote_script = "https://sandbox-payments.open.money/layer";
        //for production
        //$remote_script = "https://payments.open.money/layer";

        //Hash functions requried in both request and response
        $accesskey = $this->access_key;
        $secretkey = $this->secret_key;




        $sample_data['mtx']=$tranid; //unique transaction id to be passed for each transaction
        $layer_payment_token_data = $this->create_payment_token($sample_data);

        if(empty($error) && isset($layer_payment_token_data['error'])){
            $error = 'E55 Payment error. ' . ucfirst($layer_payment_token_data['error']);
            if(isset($layer_payment_token_data['error_data']))
            {
                foreach($layer_payment_token_data['error_data'] as $d)
                    $error .= " ".ucfirst($d[0]);
            }
            return redirect()->route('plans.index')->with('error',  $error);
        }

        if(empty($error) && (!isset($layer_payment_token_data["id"]) || empty($layer_payment_token_data["id"]))){
            $error = 'Payment error. ' . 'Layer token ID cannot be empty.';
            return redirect()->route('plans.index')->with('error',  $error);
        }

        if(!empty($layer_payment_token_data["id"]))
            $payment_token_data = $this->get_payment_token($layer_payment_token_data["id"]);

        if(empty($error) && !empty($payment_token_data)){
            if(isset($layer_payment_token_data['error'])){
                $error = 'E56 Payment error. ' . $payment_token_data['error'];
                return redirect()->route('plans.index')->with('error',  $error);
            }

            if(empty($error) && $payment_token_data['status'] == "paid"){
                $error = "Layer: this order has already been paid.";
                return redirect()->route('plans.index')->with('error',  $error);
            }

            if(empty($error) && $payment_token_data['amount'] != $sample_data['amount']){
                $error = "Layer: an amount mismatch occurred.";
                return redirect()->route('plans.index')->with('error',  $error);
            }

            $jsdata['payment_token_id'] = html_entity_decode((string) $payment_token_data['id'],ENT_QUOTES,'UTF-8');
            $jsdata['accesskey']  = html_entity_decode((string) $accesskey,ENT_QUOTES,'UTF-8');

            $hash = $this->create_hash(array(
                'layer_pay_token_id'    => $payment_token_data['id'],
                'layer_order_amount'    => $payment_token_data['amount'],
                'tranid'    => $tranid,
            ),$accesskey,$secretkey);

            $html =  "<form action='".route('confirm.plan.pay.with.onemoney')."' method='post' style='display: none' name='layer_payment_int_form'>
                <input type='hidden' name='_token' value='".csrf_token()."'>
                <input type='hidden' name='plan' value='".$request->plan_id."'>
                <input type='hidden' name='layer_pay_token_id' value='".$payment_token_data['id']."'>
                <input type='hidden' name='tranid' value='".$tranid."'>
                <input type='hidden' name='layer_order_amount' value='".$payment_token_data['amount']."'>
                <input type='hidden' id='layer_payment_id' name='layer_payment_id' value=''>
                <input type='hidden' id='fallback_url' name='fallback_url' value=''>
                <input type='hidden' name='hash' value='".$hash."'>
                </form>";
            $html .= "<script>";
            $html .= "var layer_params = " . json_encode( $jsdata ) . ';';

            $html .="</script>";
            $html .= '<script src="./layer_checkout.js"></script>';

            return view('plans.onepayment',compact('html','remote_script','error'));
        }
        }
        else
        {
            return redirect()->route('plans.index')->with('error',__('Plan is deleted.'));
        }


    }
    public function create_hash($data,$accesskey,$secretkey){
        ksort($data);
        $hash_string = $accesskey;
        foreach ($data as $key=>$value){
            $hash_string .= '|'.$value;
        }
        return hash_hmac("sha256",$hash_string,$secretkey);
    }

    public function verify_hash($data,$rec_hash,$accesskey,$secretkey){
        $gen_hash = self::create_hash($data,$accesskey,$secretkey);
        if($gen_hash === $rec_hash){
            return true;
        }
        return false;
    }

    public function planPayWithOneMoney(Request $request){
        $this->setPaymentKey();
        if(!isset($request->layer_payment_id) || empty($request->layer_payment_id)){
            $error = "Invalid response.";
        }
        try {
            $data = array(
                'layer_pay_token_id'    => $request->layer_pay_token_id,
                'layer_order_amount'    => $request->layer_order_amount,
                'tranid'     			=> $request->tranid,
            );

            $orderID = time();
            $planID  = \Illuminate\Support\Facades\Crypt::decrypt($request->plan);
            $plan    = Plan::find($planID);

            $user    = \Auth::user();
            $pay_id = $request->layer_payment_id;

            if(empty($error) && self::verify_hash($data,$request->hash,$this->access_key,$this->secret_key) && !empty($data['tranid'])){

                $payment_data = $this->get_payment_details($request->layer_payment_id);


                if(isset($payment_data['error'])){
                    $error = "Layer: an error occurred E14".$payment_data['error'];
                }


                if(empty($error) && isset($payment_data['id']) && !empty($payment_data)){
                    if($payment_data['payment_token']['id'] != $data['layer_pay_token_id']){
                        $error = "Layer: received layer_pay_token_id and collected layer_pay_token_id doesnt match";
                    }
                    elseif($data['layer_order_amount'] != $payment_data['amount']){
                        $error = "Layer: received amount and collected amount doesnt match";
                    }
                    else {

                        switch ($payment_data['status']){
                            case 'authorized':
                                if($request->has('coupon_id') && $request->coupon_id != '')
                                {
                                    $coupons = Coupon::find($request->coupon_id);
                                    if(!empty($coupons))
                                    {
                                        $userCoupon         = new UserCoupon();
                                        $userCoupon->user   = $user->id;
                                        $userCoupon->coupon = $coupons->id;
                                        $userCoupon->order  = $orderID;
                                        $userCoupon->save();


                                        $usedCoupun = $coupons->used_coupon();
                                        if($coupons->limit <= $usedCoupun)
                                        {
                                            $coupons->is_active = 0;
                                            $coupons->save();
                                        }
                                    }
                                }

                                $order                 = new Order();
                                $order->order_id       = $orderID;
                                $order->name           = $user->name;
                                $order->card_number    = '';
                                $order->card_exp_month = '';
                                $order->card_exp_year  = '';
                                $order->plan_name      = $plan->name;
                                $order->plan_id        = $plan->id;
                                $order->price          = isset($request->layer_order_amount) ? $request->layer_order_amount : 0;
                                $order->price_currency = env('CURRENCY');
                                $order->txn_id         = isset($request->tranid) ? $request->tranid : $pay_id;
                                $order->payment_type   = __('One money');
                                $order->payment_status = 'success';
                                $order->receipt        = '';
                                $order->user_id        = $user->id;
                                $order->save();


                                $assignPlan = $user->assignPlan($plan->id, $plan->duration);

                                if($assignPlan['is_success'])
                                {
                                    return redirect()->route('plans.index')->with('success', __('Plan activated Successfully!'));
                                }
                                else
                                {
                                    return redirect()->route('plans.index')->with('error', __($assignPlan['error']));
                                }
                            case 'captured':
                                if($request->has('coupon_id') && $request->coupon_id != '')
                                {
                                    $coupons = Coupon::find($request->coupon_id);
                                    if(!empty($coupons))
                                    {
                                        $userCoupon         = new UserCoupon();
                                        $userCoupon->user   = $user->id;
                                        $userCoupon->coupon = $coupons->id;
                                        $userCoupon->order  = $orderID;
                                        $userCoupon->save();


                                        $usedCoupun = $coupons->used_coupon();
                                        if($coupons->limit <= $usedCoupun)
                                        {
                                            $coupons->is_active = 0;
                                            $coupons->save();
                                        }
                                    }
                                }

                                $order                 = new Order();
                                $order->order_id       = $orderID;
                                $order->name           = $user->name;
                                $order->card_number    = '';
                                $order->card_exp_month = '';
                                $order->card_exp_year  = '';
                                $order->plan_name      = $plan->name;
                                $order->plan_id        = $plan->id;
                                $order->price          = isset($request->layer_order_amount) ? $request->layer_order_amount : 0;
                                $order->price_currency = env('CURRENCY');
                                $order->txn_id         = isset($request->tranid) ? $request->tranid : $pay_id;
                                $order->payment_type   = __('One money');
                                $order->payment_status = 'success';
                                $order->receipt        = '';
                                $order->user_id        = $user->id;
                                $order->save();


                                $assignPlan = $user->assignPlan($plan->id, $request->payment_frequency);

                                if($assignPlan['is_success'])
                                {
                                    return redirect()->route('plans.index')->with('success', __('Plan activated Successfully!'));
                                }
                                else
                                {
                                    return redirect()->route('plans.index')->with('error', __($assignPlan['error']));
                                }
                                break;
                            case 'failed':
                            case 'cancelled':
                                $status = "Payment cancelled/failed: Payment ID ". $payment_data['id'];

                                break;
                            default:
                                $status = "Payment pending: Payment ID ". $payment_data['id'];
                                exit;
                            break;
                            return redirect()->route('plans.index')->with('error', $status);
                        }
                    }

                } else {
                    $error = "invalid payment data received E98";
                    return redirect()->route('plans.index')->with('error', $error);
                }
            } else {
                $error = "hash validation failed";
                return redirect()->route('plans.index')->with('error', $error);
            }


        } catch (Throwable $exception){

           $error =  "Layer: an error occurred " . $exception->getMessage();
           return redirect()->route('plans.index')->with('error', $error);
        }

    }

}
