<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Plan;
use App\Models\Product;
use App\Models\Product_images;
use App\Models\ProductCategorie;
use App\Models\ProductSubcategorie;
use App\Models\ProductVariantOption;
use App\Models\Utility;
use App\Providers\RouteServiceProvider;
use Illuminate\Auth\Events\Registered;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Validation\Rules;
use Spatie\Permission\Models\Role;
use App\Models\Store;
use DB;
use App\Models\UserStore;
use Carbon\Carbon;

class RegisteredUserController extends Controller
{
    /**
     * Display the registration view.
     *
     * @return \Illuminate\View\View
     */

    public function __construct()
    {
        $this->middleware('guest');
    }

    public function create()
    {
        if (Utility::getValByName('signup_button') == 'on') {
            return view('auth.register');
        } else {
            return abort('404', 'Page not found');
        }
    }


    /**
     * Handle an incoming registration request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\RedirectResponse
     *
     * @throws \Illuminate\Validation\ValidationException
     */
    public function checkEmail(Request $request)
    {

        $user = User::where('email', $request->email)->first();

        if ($user) {
            return true;
        } else {
            return false;
        }
    }

    function updateProduct(Request $request){
        $validator = \Validator::make(
            $request->all(),
            [
                'price' => 'required|numeric',
                'quantity' => 'required|numeric',
                

            ]
        );

        if ($validator->fails()) {
            $messages = $validator->getMessageBag();
            return response()->json(
                [
                    'status' => 'error',
                    'message' => __($messages->first()),

                ]
            );
        }

        if (!empty($request->product_id)) {
            $product = Product::find($request->product_id);
            if ($product->enable_product_variant == 'on') {
                $price= 'In Variant';
                $quantity= 'In Variant';
            }else{
                $price = \App\Models\Utility::priceFormat($request->price, '', $request->symbol);
                $quantity = $request->quantity;
                $product->price = $request->price;
                $product->quantity = $request->quantity;
                $product->save();
            }

            return response()->json(
                [
                    'status' => 'success',
                    'price' => $price,
                    'quantity' => $quantity,
                ]
            );
        }

    }
    public function genratelink(Request $request)
    {
        if (!empty($request->name)) {

            $data = ['name' => $request->name];
            $slug = Store::slugs($data);

            $app_url = trim(env('APP_URL'), '/');
            $store_settings['store_url'] = $app_url . '/store/' . $slug;
            $store_settings['slug'] =  $slug;

            return response()->json(
                [
                    'status' => 'success',
                    'data' => $store_settings,
                ]
            );
        } else {
            return response()->json(
                [
                    'status' => 'error',
                ]
            );
        }
    }

    public function getSubCategoryByCategory(Request $request)
    {
        // dd($request->all());
        $categories = ProductSubcategorie::where('store_id', 0)->where('category_id', '=', $request->product_categorie)->pluck('name', 'id');

        // dd($categories);
        return response()->json($categories, 200);
    }
    
    public function store(Request $request)
    {

        // dd($request->all());
        $validator = \Validator::make(
            $request->all(),
            [
                'name' => 'required|string|max:255',
                'email' => 'required|string|email|max:255|unique:users',
                'password' => ['required', 'confirmed', Rules\Password::defaults()],
                'product_categorie' => 'required',
                'product_subcategorie' => 'required',


            ]
        );

        if ($validator->fails()) {
            $messages = $validator->getMessageBag();
            return response()->json(
                [
                    'status' => 'error',
                    'message' => __($messages->first()),

                ]
            );
        }

        $objUser = User::create([
            'name' => $request->name,
            'email' => $request->email,
            'password' => Hash::make($request->password),
            'type' => 'Owner',
            'lang' => !empty($settings['default_language']) ? $settings['default_language'] : 'en',
            'avatar' => 'avatar.png',
            'question_1' => $request->product_categorie,
            'created_by' => 1,
        ]);


        // $logo = $request->question_1 . '_logo';

        $data = DB::table('settings');

        // $app_logo = $data->where('store_id', 0)->where('name', $logo)->first();

        if ($request->logo) {

            $validation = [
                'mimes:' . 'png',
                'max:' . '20480',
            ];

            $logoName     = $objUser->id . '-logo.png';
            $dir = 'uploads/logo';
            $path = Utility::upload_file($request, 'logo', $logoName, $dir, $validation);

            if ($path['flag'] == 1) {
                $logo = $path['url'];
            } else {
                //   return redirect()->back()->with('error', __($path['msg']));
                return response()->json(
                    [
                        'status' => 'falied',
                        'message' => $path['msg'],
                    ]
                );
            }
        }
           




        $objStore = Store::create(
            [
                'created_by' => $objUser->id,
                'name' => $request->store_name,
                'email' => $request->email,
                'logo' => !empty($request->logo) ? $logoName : 'logo-dark.png',
                'invoice_logo' => !empty($request->logo) ? $logoName : 'invoice_logo.png',
                'lang' => !empty($settings['default_language']) ? $settings['default_language'] : 'en',
                'currency_code' => !empty($request->currency) ? $request->currency : 'USD',
                'currency' => !empty($request->currency_symbol) ? $request->currency_symbol : '$',
                'paypal_mode' => 'sandbox',
            ]
        );
        if(!empty($request->logo)){
        \DB::insert(
            'insert into settings (`value`, `name`,`created_by`,`store_id`) values (?, ?, ?, ?) ON DUPLICATE KEY UPDATE `value` = VALUES(`value`) ',
            [
                $logoName,
                $objUser->id . '_logo',
                $objUser->creatorId(),
                $objStore->id
            ]
        );
    }

     


        $objStore->domains = $request->domain_name;
        $objStore->tagline = $request->tagline;
        $objStore->address = $request->address;
        $objStore->city = $request->city;
        $objStore->state = $request->state;
        $objStore->zipcode = $request->zipcode;

        $objStore->enable_storelink = 'on';
        $objStore->content          = 'Hi,
*Welcome to* {store_name},
Your order is confirmed & your order no. is {order_no}
Your order detail is:
Name : {customer_name}
Address : {billing_address} {billing_city} , {shipping_address} {shipping_city}
~~~~~~~~~~~~~~~~
{item_variable}
~~~~~~~~~~~~~~~~
Qty Total : {qty_total}
Sub Total : {sub_total}
Discount Price : {discount_amount}
Shipping Price : {shipping_amount}
Tax : {total_tax}
Total : {final_total}
~~~~~~~~~~~~~~~~~~
To collect the order you need to show the receipt at the counter.
                Thanks {store_name}
                ';

        $objStore->item_variable    = '{sku} : {quantity} x {product_name} - {variant_name} + {item_tax} = {item_total}';
        $objStore->theme_dir        = 'theme1';
        $objStore->store_theme      = 'green-color.css';
        $objStore->save();
        $category = $request->product_categorie;
        $subcategory = $request->product_subcategorie;

        if(!empty($request->new_product_categorie)){
            $category = $request->new_product_categorie;
        }
        if(!empty($request->new_product_subcategorie)){
            $subcategory = $request->new_product_subcategorie;
        }
        $store_id =  $objStore->id;
        $category_details = ProductCategorie::find($category);
        $exist_category         = ProductCategorie::where('store_id', $store_id)->where('name', $category_details->name)->first();
        if (!$exist_category) {
            $newcategory = $category_details->replicate();
            $newcategory->store_id = $store_id;
            $newcategory->created_at = Carbon::now();
            $newcategory->created_by = $objUser->creatorId();
            $newcategory->save();

        }

        $subcategory_details = ProductSubcategorie::find($subcategory);
        $exist_subcategory         = ProductSubcategorie::where('store_id', $store_id)->where('name', $subcategory_details->name)->first();
        if (!$exist_category) {
            $newsubcategory = $subcategory_details->replicate();
            $newsubcategory->store_id = $store_id;
            $newsubcategory->created_at = Carbon::now();
            $newsubcategory->created_by = $objUser->creatorId();
            
            $newsubcategory->save();
        }


           

        if (!empty($request->selected_product)) {

            $selected_products = $request->selected_product;
            $store_id =  $objStore->id;

            foreach ($selected_products as $product) {
                $product_details = Product::find($product);
                $exist_products         = Product::where('store_id', $store_id)->where('name', $product_details->name)->first();
                if (!$exist_products) {

                    $newProduct = $product_details->replicate();
                    $newProduct->store_id = $store_id;
                    $newProduct->product_display = 'on';
                    $newProduct->created_at = Carbon::now();
                    $newProduct->save();

                    $product_images  = Product_images::where('product_id', $product_details->id)->get();
                    foreach ($product_images as $image) {

                        $proImage = Product_images::create(
                            [
                                'product_id' => $newProduct->id,
                                'product_images' => $image->product_images,
                            ]
                        );
                    }

                    if ($product_details->enable_product_variant == 'on') {
                        $newProduct->variants_json = json_decode($product_details->variants_json, true);
                        // dd($newProduct->variants_json[0]['variant_options']);
                        foreach ($newProduct->variants_json[0]['variant_options'] ?? $newProduct->variants_json[0]['variant_options'] as $key => $possibility) {

                            $possibilities = ProductVariantOption::where('name', $possibility)->where('product_id', $product_details->id)->first();
                            if ($possibilities) {
                                $possibilities_row = ProductVariantOption::find($possibilities->id);
                                $newProductVarinat = $possibilities_row->replicate();
                                $newProductVarinat->product_id = $newProduct->id;
                                $newProductVarinat->save();
                            }
                        }
                    }
                }
            }
        }

        if (isset($request->enable_stripe) && $request->enable_stripe == 'on') {
            $request->validate(
                [
                    'stripe_key' => 'required|string|max:255',
                    'stripe_secret' => 'required|string|max:255',
                ]
            );
        } elseif (isset($request->enable_paypal) && $request->enable_paypal == 'on') {
            $request->validate(
                [
                    'paypal_mode' => 'required|string',
                    'paypal_client_id' => 'required|string',
                    'paypal_secret_key' => 'required|string',
                ]
            );
        }


        $objStore->is_stripe_enabled = $request->is_stripe_enabled ?? 'off';
        $objStore->STRIPE_KEY = $request->stripe_key;
        $objStore->STRIPE_SECRET = $request->stripe_secret;
        $objStore->is_paypal_enabled = $request->is_paypal_enabled ?? 'off';
        $objStore->PAYPAL_MODE = $request->paypal_mode;
        $objStore->PAYPAL_CLIENT_ID = $request->paypal_client_id;
        $objStore->PAYPAL_SECRET_KEY = $request->paypal_secret_key;
        $objStore->ENABLE_WHATSAPP = $request->enable_whatsapp ?? 'off';
        $objStore->WHATSAPP_NUMBER = str_replace(' ', '', $request->whatsapp_number);
        $objStore->ENABLE_COD = $request->enable_cod ?? 'off';
        $objStore->ENABLE_BANK = $request->enable_bank ?? 'off';
        $objStore->BANK_NUMBER = $request->bank_number;
        $objStore->enable_telegram = $request->enable_telegram ?? 'off';
        $objStore->telegrambot = str_replace(' ', '', $request->telegrambot);
        $objStore->telegramchatid = str_replace(' ', '', $request->telegramchatid);

        $objStore->save();



        $objUser->current_store = $objStore->id;
        $objUser->plan          = Plan::first()->id;
        $objUser->save();

        self::shopePaymentSettings($request, $objUser);

        UserStore::create(
            [
                'user_id' => $objUser->id,
                'store_id' => $objStore->id,
                'permission' => 'Owner',
            ]
        );
        Auth::login($objUser);
        // dd('here');
        return response()->json(
            [
                'status' => 'success',
                'message' => __('successsfully register'),

            ]
        );
        // return redirect(RouteServiceProvider::HOME);

    }

    public function shopePaymentSettings($request, $objUser)
    {
        $post['custom_field_title_1'] = $request->custom_field_title_1;
        $post['custom_field_title_2'] = $request->custom_field_title_2;
        $post['custom_field_title_3'] = $request->custom_field_title_3;
        $post['custom_field_title_4'] = $request->custom_field_title_4;

        if (isset($request->is_stripe_enabled) && $request->is_stripe_enabled == 'on') {
            $request->validate(
                [
                    'stripe_key' => 'required|string|max:255',
                    'stripe_secret' => 'required|string|max:255',
                ]
            );
            $post['is_stripe_enabled'] = $request->is_stripe_enabled;
            $post['stripe_key'] = $request->stripe_key;
            $post['stripe_secret'] = $request->stripe_secret;
        } else {
            $post['is_stripe_enabled'] = $request->is_stripe_enabled;
        }

        if (isset($request->is_paypal_enabled) && $request->is_paypal_enabled == 'on') {
            $request->validate(
                [
                    'paypal_mode' => 'required|string',
                    'paypal_client_id' => 'required|string',
                    'paypal_secret_key' => 'required|string',
                ]
            );
            $post['is_paypal_enabled'] = $request->is_paypal_enabled;
            $post['paypal_mode'] = $request->paypal_mode;
            $post['paypal_client_id'] = $request->paypal_client_id;
            $post['paypal_secret_key'] = $request->paypal_secret_key;
        } else {
            $post['is_paypal_enabled'] = $request->is_paypal_enabled;
        }

        if (isset($request->is_paystack_enabled) && $request->is_paystack_enabled == 'on') {
            $request->validate(
                [
                    'paystack_public_key' => 'required|string',
                    'paystack_secret_key' => 'required|string',
                ]
            );
            $post['is_paystack_enabled'] = $request->is_paystack_enabled;
            $post['paystack_public_key'] = $request->paystack_public_key;
            $post['paystack_secret_key'] = $request->paystack_secret_key;
        } else {
            $post['is_paystack_enabled'] = $request->is_paystack_enabled;
        }

        if (isset($request->is_flutterwave_enabled) && $request->is_flutterwave_enabled == 'on') {
            $request->validate(
                [
                    'flutterwave_public_key' => 'required|string',
                    'flutterwave_secret_key' => 'required|string',
                ]
            );
            $post['is_flutterwave_enabled'] = $request->is_flutterwave_enabled;
            $post['flutterwave_public_key'] = $request->flutterwave_public_key;
            $post['flutterwave_secret_key'] = $request->flutterwave_secret_key;
        } else {
            $post['is_flutterwave_enabled'] = $request->is_flutterwave_enabled;
        }

        if (isset($request->is_razorpay_enabled) && $request->is_razorpay_enabled == 'on') {
            $request->validate(
                [
                    'razorpay_public_key' => 'required|string',
                    'razorpay_secret_key' => 'required|string',
                ]
            );
            $post['is_razorpay_enabled'] = $request->is_razorpay_enabled;
            $post['razorpay_public_key'] = $request->razorpay_public_key;
            $post['razorpay_secret_key'] = $request->razorpay_secret_key;
        } else {
            $post['is_razorpay_enabled'] = $request->is_razorpay_enabled;
        }

        if (isset($request->is_paytm_enabled) && $request->is_paytm_enabled == 'on') {
            $request->validate(
                [
                    'paytm_mode' => 'required',
                    'paytm_merchant_id' => 'required|string',
                    'paytm_merchant_key' => 'required|string',
                    'paytm_industry_type' => 'required|string',
                ]
            );
            $post['is_paytm_enabled'] = $request->is_paytm_enabled;
            $post['paytm_mode'] = $request->paytm_mode;
            $post['paytm_merchant_id'] = $request->paytm_merchant_id;
            $post['paytm_merchant_key'] = $request->paytm_merchant_key;
            $post['paytm_industry_type'] = $request->paytm_industry_type;
        } else {
            $post['is_paytm_enabled'] = $request->is_paytm_enabled;
        }

        if (isset($request->is_mercado_enabled) && $request->is_mercado_enabled == 'on') {
            $request->validate(
                [
                    'mercado_access_token' => 'required|string',
                ]
            );
            $post['is_mercado_enabled'] = $request->is_mercado_enabled;
            $post['mercado_access_token'] = $request->mercado_access_token;
            $post['mercado_mode'] = $request->mercado_mode;
        } else {
            $post['is_mercado_enabled'] = 'off';
        }

        if (isset($request->is_mollie_enabled) && $request->is_mollie_enabled == 'on') {
            $request->validate(
                [
                    'mollie_api_key' => 'required|string',
                    'mollie_profile_id' => 'required|string',
                    'mollie_partner_id' => 'required',
                ]
            );
            $post['is_mollie_enabled'] = $request->is_mollie_enabled;
            $post['mollie_api_key'] = $request->mollie_api_key;
            $post['mollie_profile_id'] = $request->mollie_profile_id;
            $post['mollie_partner_id'] = $request->mollie_partner_id;
        } else {
            $post['is_mollie_enabled'] = $request->is_mollie_enabled;
        }

        if (isset($request->is_skrill_enabled) && $request->is_skrill_enabled == 'on') {
            $request->validate(
                [
                    'skrill_email' => 'required|email',
                ]
            );
            $post['is_skrill_enabled'] = $request->is_skrill_enabled;
            $post['skrill_email'] = $request->skrill_email;
        } else {
            $post['is_skrill_enabled'] = $request->is_skrill_enabled;
        }

        if (isset($request->is_coingate_enabled) && $request->is_coingate_enabled == 'on') {
            $request->validate(
                [
                    'coingate_mode' => 'required|string',
                    'coingate_auth_token' => 'required|string',
                ]
            );

            $post['is_coingate_enabled'] = $request->is_coingate_enabled;
            $post['coingate_mode'] = $request->coingate_mode;
            $post['coingate_auth_token'] = $request->coingate_auth_token;
        } else {
            $post['is_coingate_enabled'] = $request->is_coingate_enabled;
        }

        if (isset($request->is_paymentwall_enabled) && $request->is_paymentwall_enabled == 'on') {

            $validator = \Validator::make(
                $request->all(),
                [
                    'paymentwall_public_key' => 'required|string',
                    'paymentwall_private_key' => 'required|string',
                ]
            );

            if ($validator->fails()) {
                $messages = $validator->getMessageBag();

                return redirect()->back()->with('error', $messages->first());
            }

            $post['is_paymentwall_enabled'] = $request->is_paymentwall_enabled;
            $post['paymentwall_public_key'] = $request->paymentwall_public_key;
            $post['paymentwall_private_key'] = $request->paymentwall_private_key;
        } else {
            $post['is_paymentwall_enabled'] = 'off';
        }
        // dd($request->all());

        if (isset($request->is_onemoney_enabled) && $request->is_onemoney_enabled == 'on') {

            $validator = \Validator::make(
                $request->all(),
                [
                    'onemony_mode' => 'required|string',
                    'onemoney_public_key' => 'required|string',
                    'onemoney_secret_key' => 'required|string',
                ]
            );

            if ($validator->fails()) {
                $messages = $validator->getMessageBag();

                return redirect()->back()->with('error', $messages->first());
            }

            $post['is_onemoney_enabled'] = $request->is_onemoney_enabled;
            $post['onemony_mode'] = $request->onemony_mode;
            $post['onemoney_public_key'] = $request->onemoney_public_key;
            $post['onemoney_secret_key'] = $request->onemoney_secret_key;
        } else {
            $post['is_onemoney_enabled'] = 'off';
        }

        if (isset($request->enable_telegram) && $request->enable_telegram == 'on') {

            $validator = \Validator::make(
                $request->all(),
                [
                    'telegrambot' => 'required',
                    'telegramchatid' => 'required',
                ]
            );

            if ($validator->fails()) {
                $messages = $validator->getMessageBag();

                return redirect()->back()->with('error', $messages->first());
            }

            $post['enable_telegram'] = $request->enable_telegram;
            $post['telegrambot'] = $request->telegrambot;
            $post['telegramchatid'] = $request->telegramchatid;
        } else {
            $post['enable_telegram'] = 'off';
        }
        

        foreach ($post as $key => $data) {

            $arr = [
                $data,
                $key,
                $objUser->current_store,
                $objUser->creatorId(),
            ];

            \DB::insert(
                'insert into store_payment_settings (`value`, `name`, `store_id`,`created_by`) values (?, ?, ?, ?) ON DUPLICATE KEY UPDATE `value` = VALUES(`value`) ',
                $arr
            );
        }
    }

    public function showRegistrationForm($lang = '')
    {
        if (empty($lang)) {
            $lang = Utility::getValByName('default_language');
        }

        \App::setLocale($lang);
        if (Utility::getValByName('signup_button') == 'on') {
            return view('auth.register', compact('lang'));
        } else {
            dd('here');
            return abort('404', 'Page not found');
        }
    }
}
